#!/usr/bin/env python


VERSION='0.4'
VERSION_DATE='2013-04-23'

GAME_COLORS=['#FD0','#4F4','#080','#0BF','#00F','#F40','#A02','#F0F']

MODEL_SIZES=[['Small', 15, 7],
             ['Medium', 22, 12],
             ['Large', 30, 15]]

MODEL_PLAYERS=[['1 Player',1],
               ['2 Players',2],
               ['3 Players',3],
               ['4 Players',4]]
               
BOARD_HEIGHT=390
BOARD_WIDTH=670
BOARD_OFFSET_Y=2
BOARD_OFFSET_X=4

BUTTON_WIDTH=65
BUTTON_HEIGHT=35
BUTTON_DISTANCE=15

FULLSCREEN=True

import pygtk
pygtk.require('2.0')
import gtk
import gobject
import pango
import operator
import time
import string
import random
import copy
#import code ## only for debug:  code.InteractiveConsole(locals()).interact()
try:
    import hildon
except ImportError:
    FULLSCREEN=False

def group_by(list, keyfn):
    group={}
    for item in list:
        key = keyfn(item)
        if group.has_key(key):
            group[key].append(item)
        else:
            group[key]=[item]
    return group


class Colors:
    def __init__(self, colormap):
        self.bg=colormap.alloc_color(gtk.gdk.color_parse('#666'))
        self.bg2=colormap.alloc_color(gtk.gdk.color_parse('#555'))
        self.label=colormap.alloc_color(gtk.gdk.color_parse('#FFF'))
        self.active=colormap.alloc_color(gtk.gdk.color_parse('#000'))
        self.passive=colormap.alloc_color(gtk.gdk.color_parse('#888'))
        self.game_colors=map(lambda c: colormap.alloc_color(c), GAME_COLORS)

class HexDiggerModel:
    def __init__(self, width, height, count, players=1):
        self.width = width; self.height = height; self.count = count
        assert players <= 4
        assert players >= 1
        self.players=players
        self.init_neighbours()
        self.newgame()
    def newgame(self):
        def randexcept(low, high, exc):
            r=random.randint(low,high-1)
            if r>=exc: r+=1
            return r
        self.board=[[random.randint(0,self.count-1) for x in range(self.width)] for y in range(self.height)]
        self.boardowned=[[None for x in range(self.width)] for y in range(self.height)]
        self.gamedone=False
        self.stats=[1]*self.players
        self.allcount=self.width*self.height
        self.onmove=random.randint(0,self.players-1)
        self.moves=0
        for player in range(self.players):
            pos=self.getstartpos(player)
            neig=self.neighbours(*pos)
            for ne in neig:
                self.board[ne[1]][ne[0]]=randexcept(0, self.count-1, self.board[pos[1]][pos[0]])
        for player in range(self.players):
            pos=self.getstartpos(player)
            self.boardowned[pos[1]][pos[0]]=player
    def isgamedone(self):
        return self.gamedone
    def bestplayer(self):
        return self.stats.index(max(self.stats))
    def getcurrentplayer(self):
        return self.onmove
    def getplayercount(self):
        return self.players
    def getmove(self):
        return self.moves
    def getallstartpos(self):
        return [None,
         [(0,self.height-1)],
         [(0,self.height-1), (self.width-1, 0)],
         [(0,self.height/2), ((self.width-1)*2/3, 0), ((self.width-1)*2/3, self.height-1)],
         [(0,self.height-1), (self.width-1, 0), (0,0), (self.width-1, self.height-1)]
         ][self.players]
    def getstartpos(self, player):
        return self.getallstartpos()[player]
#    def neighbours(self, x, y):
#        return filter(lambda p: 0 <= p[0] < self.width and 0 <= p[1] < self.height,
#                      [(x,y+1), (x,y-1), (x+1,y), (x-1,y), (x+1, y-1+(x&1)*2), (x-1, y-1+(x&1)*2)])
    def neighbours(self, x, y):
        return self.neighbourdata[y][x]
    def init_neighbours(self):
        self.neighbourdata=[[filter(lambda p: 0 <= p[0] < self.width and 0 <= p[1] < self.height,
                                    [(x,y+1), (x,y-1), (x+1,y), (x-1,y), (x+1, y-1+(x&1)*2), (x-1, y-1+(x&1)*2)])
                             for x in range(self.width)]
                            for y in range(self.height)]
    def updatestats(self, player):
        startx,starty=self.getstartpos(player)
        color=self.board[starty][startx]
        stack=[(startx,starty)]
        tmpboard=[[0 for x in range(self.width)] for y in range(self.height)]
        tmpboard[starty][startx]=1
        self.boardowned[starty][startx]=player
        count=1
        while len(stack)>0:
            x,y=stack.pop()
            ne=self.neighbours(x,y)
            for nx,ny in ne:
                if self.board[ny][nx]==color:
                    point=(nx,ny)
                    if tmpboard[ny][nx]==0:
                        self.boardowned[ny][nx]=player
                        tmpboard[ny][nx]=1
                        count+=1
                        stack.append(point)
        self.stats[player]=count
        self.gamedone=sum(self.stats)==self.allcount
    def availablecolors(self):
        if self.gamedone: return []
        colors=range(self.count)
        for player in range(self.players):
            pos=self.getstartpos(player)
            try:
                colors.remove(self.board[pos[1]][pos[0]])
            except:
                pass
        return colors
    def move(self, color):
        startx,starty=self.getstartpos(self.onmove)
        replace=self.board[starty][startx]
        if color==replace: return
        self.board[starty][startx]=color
        stack=[(startx,starty)]
        while len(stack)>0:
            x,y=stack.pop()
            ne=self.neighbours(x,y)
            for nx,ny in ne:
                if self.board[ny][nx]==replace:
                    self.board[ny][nx]=color
                    stack.append((nx,ny))
        self.updatestats(self.onmove)
        self.onmove=(self.onmove+1) % self.players
        self.moves+=1


    def printb(self, board):
        print
        for y in range(len(board)):
            for x in range(len(board[0])):
                cell=board[y][x]
                if cell==None: cell='_'
                print '%2s' % cell,
            print
    def fill(self):
        owned=copy.deepcopy(self.boardowned)
        for y in range(len(owned)):
            for x in range(len(owned[0])):
                if owned[y][x]==None:
                    owned[y][x]=-1
                    blockneigh=set([])
                    stack=[(x,y)]
                    while len(stack)>0:
                        ax,ay=stack.pop()
                        ne=self.neighbours(ax,ay)
                        for nx,ny in ne:
                            cell=owned[ny][nx]
                            if cell==None:
                                owned[ny][nx]=-1
                                stack.append((nx,ny))
                            elif cell>=0:
                                blockneigh.add(cell)
                    if len(blockneigh)==1:
                        filler=blockneigh.pop()
                    else:
                        filler=-2
                    for yy in range(len(owned)):
                        for xx in range(len(owned[0])):
                            if owned[yy][xx]==-1: owned[yy][xx]=filler
        player2color={}
        for player in range(self.players):
            startx,starty=self.getstartpos(player)
            color=self.board[starty][startx]
            player2color[player]=color
        for y in range(len(owned)):
            for x in range(len(owned[0])):
                cell=owned[y][x]
                if cell>=0 and cell!=self.boardowned[y][x]:
                    self.board[y][x]=player2color[cell]
        for player in range(self.players):
            self.updatestats(player)


class HexDiggerRenderer:
    def __init__(self):
        pass
    def draw(self, widget, model):
        gc=widget.window.new_gc()
        gca=widget.window.new_gc(foreground=widget.my_colors.active, line_width=3)
        gcp=widget.window.new_gc(foreground=widget.my_colors.passive)
        gcbut=[]
        #widget.window.draw_rectangle(gc, False, BOARD_OFFSET_X, BOARD_OFFSET_Y, BOARD_WIDTH, BOARD_HEIGHT)
        av=model.availablecolors()
        for coloridx in range(len(widget.color_buttons)):
            gcm=widget.window.new_gc(foreground=widget.my_colors.game_colors[coloridx])
            gcbut.append(gcm)
            cb=widget.color_buttons[coloridx]
            if coloridx in av:
                widget.window.draw_rectangle(gcm, True, cb[0], cb[1], cb[2], cb[3])
        xinc=BOARD_WIDTH/model.width
        yinc=BOARD_HEIGHT/(model.height+1)
        hx=0.57735*xinc
        hxhalf=hx/2
        xinchalf=xinc/2.0
        points=[(x+xinchalf, y+yinc/2.0) for x,y in [(-hxhalf,-xinchalf), (hxhalf,-xinchalf), (hx,0),
                (hxhalf,xinchalf), (-hxhalf,xinchalf), (-hx,0), (-hxhalf,-xinchalf)]]
        allstartpos=model.getallstartpos()
        for y in range(model.height):
            for x in range(model.width):
                px=xinc*x+BOARD_OFFSET_X
                py=yinc*y+BOARD_OFFSET_Y+yinc/2*(x&1)
                drpoints=map(lambda p: (int(p[0]+px),int(p[1]+py)), points)
                widget.window.draw_polygon(gcbut[model.board[y][x]], True, drpoints)
                if model.boardowned[y][x]==model.getcurrentplayer():
                    widget.window.draw_polygon(gca, False, drpoints)
                else:
                    widget.window.draw_polygon(gcp, False, drpoints)
                if (x,y) in allstartpos:
                    idx=allstartpos.index((x,y))
                    layout=widget.create_pango_layout(str(idx+1))
                    layout.set_font_description(pango.FontDescription("sans bold 12"))
                    layout_width, layout_height = layout.get_pixel_size()
                    widget.window.draw_layout(gca,
                                              int(px+xinchalf-layout_width/2.0),
                                              int(py+yinc/2.0-layout_height/2.0), layout)


class HexDiggerGame:
    def radio_callback(self, widget, data=None):
        self.model_size=data

    def __init__(self):
        try:
            self.window = hildon.Window()
        except NameError:
            self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.window.set_title("HexDigger")
        self.window.connect("destroy", lambda w: gtk.main_quit())
        self.area = gtk.DrawingArea()
        self.area.set_size_request(700, 480)
        self.area.connect("expose-event", self.area_expose_cb)
        self.area.set_events(gtk.gdk.BUTTON_PRESS_MASK)
        self.area.connect("button_press_event", self.area_press_event)
        self.renderer = HexDiggerRenderer()
        self.area.my_colors=Colors(self.area.get_colormap())
        self.area.show()
        hbox=gtk.HBox()
        self.window.add(hbox)
        hbox.pack_start(self.area)
        buttonbox=gtk.VBox()
        self.label_info=gtk.Label("\n\n\n")
        self.label_info.set_use_markup(True)
        self.button_new = gtk.Button(label="New")
        #self.button_fill = gtk.Button(label="Fill")
        self.button_about = gtk.Button(label="About")
        #self.button_quit = gtk.Button(label="Quit")
        self.button_new.connect("button_press_event", self.action_new)


        '''
        self.combo_sizes = gtk.combo_box_new_text()
        for model_size in MODEL_SIZES:
            self.combo_sizes.append_text(model_size[0])
        self.combo_sizes.set_active(1)
        '''

        
        self.combo_players = gtk.combo_box_new_text()
        for model_player in MODEL_PLAYERS:
            self.combo_players.append_text(model_player[0])
        self.combo_players.set_active(0)
        
        #self.button_fill.connect("button_press_event", self.action_fill)
        self.button_about.connect("button_press_event", self.action_about)
        #self.button_quit.connect("button_press_event", self.action_quit)
        buttonbox.pack_start(self.label_info, False, False,1)
        buttonbox.pack_start(self.button_new, False, False,1)

        self.radio_sizes = gtk.RadioButton(group=None, label=MODEL_SIZES[0][0])
        self.radio_sizes.connect("toggled", self.radio_callback, MODEL_SIZES[0])
        buttonbox.pack_start(self.radio_sizes, False, False,0)
        self.radio_sizes = gtk.RadioButton(group=self.radio_sizes, label=MODEL_SIZES[1][0])
        self.radio_sizes.connect("toggled", self.radio_callback, MODEL_SIZES[1])
        buttonbox.pack_start(self.radio_sizes, False, False,0)
        self.radio_sizes.set_active(True)
        #self.model_size=MODEL_SIZES[1]
        self.radio_sizes = gtk.RadioButton(group=self.radio_sizes, label=MODEL_SIZES[2][0])
        self.radio_sizes.connect("toggled", self.radio_callback, MODEL_SIZES[2])
        buttonbox.pack_start(self.radio_sizes, False, False,0)



        buttonbox.pack_start(self.combo_players, False, False,1)
        '''
        self.radio_players = gtk.RadioButton(group=None, label=MODEL_PLAYERS[0][0])
        buttonbox.pack_start(self.radio_players, False, False,0)
        self.radio_players = gtk.RadioButton(group=None, label=MODEL_PLAYERS[1][0])
        buttonbox.pack_start(self.radio_players, False, False,0)
        self.radio_players = gtk.RadioButton(group=None, label=MODEL_PLAYERS[2][0])
        buttonbox.pack_start(self.radio_players, False, False,0)
        self.radio_players = gtk.RadioButton(group=None, label=MODEL_PLAYERS[3][0])
        buttonbox.pack_start(self.radio_players, False, False,0)
        self.radio_players.set_active(0)
        '''


        #buttonbox.pack_start(self.button_fill, False, False,1)
        buttonbox.pack_start(self.button_about, False, False,1)
        #buttonbox.pack_start(self.button_quit, False, False,5)
        buttonbox.show()
        buttonbox.set_size_request(120, 480)
        hbox.pack_end(buttonbox, False, False, 0)
        hbox.show_all()
        self.window.modify_bg(gtk.STATE_NORMAL,self.area.my_colors.bg2)
        self.area.modify_bg(gtk.STATE_NORMAL,self.area.my_colors.bg)
        self.label_info.modify_fg(gtk.STATE_NORMAL,self.area.my_colors.label)
        if FULLSCREEN: self.window.fullscreen()
        self.window.show()
        self.single_player_name='Player 1'
        self.reinit_model()
        self.redraw()
    def reinit_model(self):
        colors=len(GAME_COLORS)
        self.players=MODEL_PLAYERS[self.combo_players.get_active()][1]
        #if self.players > 1:
        #    self.button_fill.show()
        #else:
        #    self.button_fill.hide()
        self.model = HexDiggerModel(self.model_size[1],self.model_size[2],colors, self.players)
        w2=colors*BUTTON_WIDTH+(colors-1)*BUTTON_DISTANCE
        x=(self.area.window.get_size()[0]-w2)/2
        self.area.color_buttons=[(x+(BUTTON_WIDTH+BUTTON_DISTANCE)*coloridx, BOARD_HEIGHT+BOARD_OFFSET_Y, BUTTON_WIDTH, BUTTON_HEIGHT) for coloridx in range(colors)]
    def action_new(self, widget, event):
        self.reinit_model()
        self.redraw()
    #def action_fill(self, widget, event):
    #    self.model.fill()
    #    self.testgamedone()
    #    self.redraw()
    def action_about(self,widget,event):
        dialog = gtk.Dialog(title='About HexDigger Game', parent=self.window, flags=gtk.DIALOG_MODAL)
                            #buttons=(gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
        dialog.set_size_request(720,350)
        text1 = """
HexDigger - dig into colored terrain

Copyright (C) 2007 Jakub Travnik, <jtra@seznam.cz>

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE. See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 51 Franklin St, Fifth Floor,
Boston, MA 02110-1301 USA

Full text of the license may also be available at
/usr/share/hexdigger/LICENSE (plain ASCII text file)
"""
        text2 = """
Single player game:

You have to occupy all cells in least steps. You start
with one cell in corner. You can gain new cell regions
that border with your territory by selecting their
color by clicking on colored buttons at the bottom.

Multi player game:

The winner is the player who gains largest territory.
You cannot select color which is currently possessed
by your opponents. If you engulf cells you get them
automatically (as opponents can't take them anymore).
"""
        text3 = """
Version: 0.4
Aapo Rantalainen slightly modified game for Nokia N900/Maemo5.
----------------------
Version: 0.3
Jakub Travnik: I have seen a game like this in about 
1996 available as freeware or shareware for Windows 3.1.

I liked it so here is the version for Maemo environment.

I have written working version of it during a afternoon
while showing my brother how programmers work.
"""
        text4 = "Version "+VERSION+" from "+VERSION_DATE
        notebook = gtk.Notebook()
        notebook.show()
        def add_scrolled_text_view(text, labeltext):
            scroll = gtk.ScrolledWindow()
            scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
            tv = gtk.TextView()
            tv.set_editable(False)
            tb = tv.get_buffer()
            scroll.add(tv)
            scroll.show()
            tv.show()
            tb.set_text(text)
            label = gtk.Label(labeltext)
            label.show()
            notebook.append_page(scroll, label)
        add_scrolled_text_view(text1, 'License')
        add_scrolled_text_view(text2, 'Instructions')
        add_scrolled_text_view(text3, 'History')
        add_scrolled_text_view(text4, 'Version')
        dialog.vbox.pack_start(notebook, True, True, 0)
        dialog.run()
        dialog.destroy()
    #def action_quit(self, widget, event):
    #    gtk.main_quit()
    def area_press_event(self, widget, event):
        ex=event.x; ey=event.y
        av=self.model.availablecolors()
        for i in range(len(self.area.color_buttons)):
            if i in av:
                x,y,w,h=self.area.color_buttons[i]
                if x <= ex <= x+w and y <= ey <= y+h:
                    self.model.move(i)

                    #automatic fill
                    if self.players > 1:
                       self.model.fill()

                    self.testgamedone()
        self.redraw()
    def testgamedone(self):
        if self.model.isgamedone():
            self.redraw()
            if self.model.getplayercount()>1:
                dialog = gtk.MessageDialog(self.window,
                                           gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                           gtk.MESSAGE_INFO, gtk.BUTTONS_OK,
                                           "Congratulations player %d!\nYou are the best!\n"%
                                           (self.model.bestplayer()+1))
                dialog.run()
                dialog.destroy()
            else:
                dialog = gtk.MessageDialog(self.window,
                                           gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                           gtk.MESSAGE_INFO, gtk.BUTTONS_OK,
                                           "Congratulations!\nYou have completed game in %d moves."%
                                           self.model.getmove())
                dialog.run()
                dialog.destroy()
    def area_expose_cb(self, area, event):
        self.renderer.draw(self.area, self.model)
    def redraw(self):
        text1="Moves: %d\n" % self.model.getmove()
        text2="Territory:\n"
        for pl in range(self.model.getplayercount()):
            pre=''; post="\n"
            if self.model.getcurrentplayer()==pl:
                pre='<span foreground="yellow" background="black">'
                post="</span>\n"
            text2+=pre+("P%d: %d" % (pl+1,self.model.stats[pl]))+post
        text=text1+text2[0:-1]
        self.label_info.set_markup(text)
        self.area.queue_draw()



def main():
    gtk.main()
    return 0

if __name__ == "__main__":
    HexDiggerGame()
    main()
