from org.maemo.hermes.engine.linkedin.service import Service
from org.maemo.hermes.engine.linkedin.api import LinkedInApi
from org.maemo.hermes.engine.names import canonical
from org.maemo.hermes.engine.friend import Friend
import unittest
    
class FakeGConf(dict):
    def __init__(self, props=None):
        dict.__init__(self)
        if props:
            for key in props:
                self.set_string(key, props[key])
    def get_string(self, key):
        try: return self.__getitem__(key)
        except: return None
    def set_string(self, key, value):
        self.__setitem__(key, value)

class IntegrationTestLinkedInApi(unittest.TestCase):
    
    def setUp(self):
        self.gconf = FakeGConf({
                '/apps/maemo/hermes/linkedin_key':'1et4G-VtmtqNfY7gF8PHtxMOf0KNWl9ericlTEtdKJeoA4ubk4wEQwf8lSL8AnYE',
                '/apps/maemo/hermes/linkedin_secret':'uk--OtmWcxER-Yh6Py5p0VeLPNlDJSMaXj1xfHILoFzrK7fM9eepNo5RbwGdkRo_'})
        self.testee = LinkedInApi(self.gconf)


    def test_get_request_token(self):
        token = self.testee._get_request_token()
        
        assert token is not None
        assert token.callback_confirmed == "true"
        assert token.key is not None
        assert token.secret is not None
        
        
    def test_get_authorize_url(self):
        request_token = self.testee._get_request_token()
        url = self.testee._get_authorize_url(request_token)
        
        assert url is not None
        assert "linkedin.com" in url
    
    
    def test_verify_verifier_opens_browser(self):
        self.verifier = "IllegalVerifier"
        authenticate_threw_exception = False

        try:
        #if True:
            self.testee.authenticate(self._need_auth_cb, self._block_for_auth)
            assert False # should always go to except clause
        except Exception, e:
            authenticate_threw_exception = True
        
        assert authenticate_threw_exception
        assert self.need_auth_called
        assert self.block_for_auth_called
        assert self.block_for_auth_show_input_field


    def _need_auth_cb(self):
        self.need_auth_called = True


    def _block_for_auth(self, show_input_field, url=None):
        self.block_for_auth_called = True
        self.block_for_auth_show_input_field = show_input_field
        self.block_for_auth_url = url
        return self.verifier

    
if __name__ == '__main__':
    unittest.main()
