import gnome.gconf
import gtk, hildon
import org.maemo.hermes.engine.twitter.service
from org.maemo.hermes.engine.provider_oauth import OAuthProvider
from org.maemo.hermes.engine.twitter.api import TwitterApi

class Provider(OAuthProvider):
    """Twitter provider for Hermes. 

       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""


    # -----------------------------------------------------------------------
    def __init__(self):
        OAuthProvider.__init__(self)
        self._api = TwitterApi(self.make_api_request)


    # -----------------------------------------------------------------------
    def get_name(self):
        """Return the display name of this service. An icon, of with the lower-case,
           all-alphabetic version of this name is expected to be provided."""
           
        return 'Twitter'


    # -----------------------------------------------------------------------
    def get_urls(self):
        """Return the various URLs needed for OAuth."""
           
        return ('https://api.twitter.com/oauth/request_token',
                'https://api.twitter.com/oauth/access_token',
                'https://api.twitter.com/oauth/authorize')
        
    
    # -----------------------------------------------------------------------
    def service(self, gui_callback):
        """Return the service backend. This must be a class which implements the
           following methods:
               * get_friends
               * process_contact
               * finalise
        
           See Service for more details."""
    
        return org.maemo.hermes.engine.twitter.service.Service(self.get_id(), self._api)


    # -----------------------------------------------------------------------
    def verify_verifier(self, access_token):
        return self._api.get_user()
