import urllib, urllib2
import simplejson

class FacebookApi():
    """Facebook backend for Hermes, using the Graph API:
    
          http://developers.facebook.com/docs/reference/api/
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
       
       
    # -----------------------------------------------------------------------
    def __init__(self, oauth):
        self._oauth = oauth


    # -----------------------------------------------------------------------
    def authenticate(self):
        '''Authenticate the user with Facebook.'''
        
        self._oauth.authorise('https://graph.facebook.com/oauth/authorize',
                              'https://graph.facebook.com/oauth/access_token',
                              {'scope': 'user_about_me,friends_about_me,user_birthday,friends_birthday,user_website,friends_website,user_work_history,friends_work_history'})


    # -----------------------------------------------------------------------
    def get_user(self):
        '''Return the name of the authenticated user.'''
        
        data = self._request('https://graph.facebook.com/me')
        return data['name']


    # -----------------------------------------------------------------------
    def get_friends(self):
        '''Return the full list of people being followed by the user.
        
           The result is a list of users:
           http://developers.facebook.com/docs/reference/api/user/'''

        users = self._request('https://graph.facebook.com/me/friends', {'fields': 'id,name,link,birthday,website,picture'})['data']
        for user in users:
            if 'picture' in user:
                user['picture'] = 'https://graph.facebook.com/%s/picture?type=large&access_token=%s' % (user['id'], self._oauth.get_access_token())
        return users
    
    
    # -----------------------------------------------------------------------
    def _request(self, url, args = None):
        """Make an authenticated request to Facebook and check the
           JSON response. Return the dictionary if no errors."""
        
        json = self._oauth.request(url, args)
#        print json
        data = simplejson.loads(json)
        if 'error' in data:
            raise Exception(data['error'])
        
        return data
