import gnome.gconf
import gtk, hildon
import org.maemo.hermes.engine.provider
from org.maemo.hermes.engine.facebook.service import Service
from org.maemo.hermes.engine.facebook.api import FacebookApi
import oauth2

class Provider(org.maemo.hermes.engine.provider.Provider):
    """Facebook provider for Hermes. 

       This requires two gconf paths to contain Facebook application keys:
           /apps/maemo/hermes/facebook_app
           /apps/maemo/hermes/facebook_secret
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""

    # -----------------------------------------------------------------------
    def __init__(self):
        """Initialise the provider, and ensure the environment is going to work."""

        self._gc = gnome.gconf.client_get_default()

        key_app    = self._gc.get_string('/apps/maemo/hermes/facebook_key')
        key_secret = self._gc.get_string('/apps/maemo/hermes/facebook_secret')
        if key_app is None or key_secret is None:
            raise Exception('No Facebook application keys found. Installation error.')
        
        access_token = self._gc.get_string('/apps/maemo/hermes/facebook_access_token')
        self.oauth = oauth2.OAuth2(key_app, key_secret, access_token)
        self.api = FacebookApi(self.oauth)


    # -----------------------------------------------------------------------
    def get_name(self):
        """Return the display name of this service. An icon, of with the lower-case,
           all-alphabetic version of this name is expected to be provided."""
           
        return 'Facebook'

    
    # -----------------------------------------------------------------------
    def get_account_detail(self):
        """Return the email address associated with the user, if available."""
        
        return self._gc.get_string('/apps/maemo/hermes/facebook_user')
    
    
    # -----------------------------------------------------------------------
    def has_preferences(self):
        """Whether or not this provider has any preferences. If it does not,
           open_preferences must NOT be called; as the behaviour is undetermined."""
           
        return True
    
    
    # -----------------------------------------------------------------------
    def open_preferences(self, parent):
        """Open the preferences for this provider as a child of the 'parent' widget."""

        dialog = gtk.Dialog(self.get_name(), parent)
        dialog.add_button(_('Disable'), gtk.RESPONSE_NO)
        enable = dialog.add_button(_('Enable'), gtk.RESPONSE_YES)

        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                               hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self._handle_button(None, button, enable)
        button.connect('clicked', self._handle_button, button, enable)
        dialog.vbox.add(button)
        
        checkbox = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        checkbox.set_label(_('Create birthday-only contacts'))
        checkbox.set_active(self._gc.get_bool('/apps/maemo/hermes/facebook_birthday_only'))
        dialog.vbox.add(checkbox)
        dialog.vbox.add(gtk.Label(""))
        
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        if result == gtk.RESPONSE_CANCEL or result == gtk.RESPONSE_DELETE_EVENT:
            return None
    
        self._gc.set_bool('/apps/maemo/hermes/facebook_birthday_only', checkbox.get_active())
        return result == gtk.RESPONSE_YES


    # -----------------------------------------------------------------------
    def _handle_button(self, e, button, enable):
        """Ensure the button state is correct."""
        
        authenticated = self._gc.get_string('/apps/maemo/hermes/facebook_access_token') is not None
        if e is not None:
            if authenticated:
                self._gc.unset('/apps/maemo/hermes/facebook_access_token')
            else:
                self.api.authenticate()
                self._gc.set_string('/apps/maemo/hermes/facebook_access_token', self.oauth.get_access_token())
                self._gc.set_string('/apps/maemo/hermes/facebook_user', self.api.get_user())
        
            authenticated = self._gc.get_string('/apps/maemo/hermes/facebook_access_token') is not None
        
        button.set_title(authenticated and _("Clear authorisation") or _("Authorise"))
        enable.set_sensitive(authenticated)

    
    # -----------------------------------------------------------------------
    def service(self, gui_callback):
        """Return a service instance."""
        
        self._gui = gui_callback
        return Service(self.get_id(), self.api, self._gc.get_bool('/apps/maemo/hermes/facebook_birthday_only'))
