from org.maemo.hermes.engine.gravatar.service import Service
from org.maemo.hermes.engine.friend import Friend 
import unittest

class FakeContact():
    def __init__(self, addr):
        self.urls = addr
    def get_emails(self):
        return self.urls
    def get_name(self):
        return self.urls[0]

known_address = "maemohermes@wendt.se"
    
class TestGravatarService(unittest.TestCase):
    
    def setUp(self):
        self._setUp('', '')
        
        
    def test_several_things(self):
        contact = FakeContact([known_address])
        self._fake_server_response({known_address: 'http://image.exists.here/',
                                    'extra@here': 'http://nowhere'})
        
        self.testee.pre_process_contact(contact);
        self.testee.process_friends()
        friend = self.testee.process_contact(contact)
        
        assert isinstance(friend, Friend)
        assert len(self.testee.get_friends_to_create_contacts_for()) == 0
        assert len(self.testee.get_unmatched_friends()) == 0 # doesn't matter should always
        
        
    def test_that_process_contact_returns_friend_object_if_contact_is_known(self):
        contact = FakeContact([known_address])
        self._fake_server_response({known_address: 'http://image.exists.here/'})
        
        self.testee.pre_process_contact(contact);
        self.testee.process_friends()
        friend = self.testee.process_contact(contact)
        assert isinstance(friend, Friend)
        
        
    def test_that_process_contact_returns_None_for_unknown_contact(self):
        contact = FakeContact([known_address])
        self._fake_server_response({})
        
        self.testee.pre_process_contact(contact);
        self.testee.process_friends()
        friend = self.testee.process_contact(contact)
        assert friend is None
        
        
    def test_that_a_person_with_two_addresses_and_one_gravatar_works(self):
        self._fake_server_response({self.missing_address: None,
                                    self.existing_address: "http://url.to.img/"})
        
        self.testee.pre_process_contact(self.multiple_contact)
        self.testee.process_friends()
        self.testee.process_contact(self.multiple_contact)
        
        friends = self.testee._get_friends()
        contacts = self.testee._get_contacts_with_match()
        assert len(friends) == 1
        assert len(contacts) == 1
        assert self.multiple_contact in contacts
        assert self.missing_contact not in contacts
        assert self.existing_contact not in contacts.keys()
        assert friends[0].get_name() == self.existing_contact.get_name()
        assert friends[0].get_contact() == self.multiple_contact
        
        
    def _fake_server_response(self, map):
        self.testee._get_hash_info_from_server = self._get_hash_info_from_server
        # in real results the addresses hashed, so we'll add that here, and keep originals for easier debugging/inspection
        for key in map.keys():
            hash = self.testee._get_hash_for_address(key)
            map[hash] = map[key]
        self._server_response = map
    
    def _get_hash_info_from_server(self, args, url):
        self._server_args = args
        self._server_url = url
        return self._server_response

    def _setUp(self, email, key):
        self.testee = Service('gravatar', email, key)
        
        self.existing_address = 'fredrik@wendt.se'
        self.existing_contact = FakeContact([self.existing_address])
        self.existing_friend = Friend("Fredrik Wendt")
        
        self.missing_address = 'will_not_ever_exist_i_truly_hope_at_least@wendt.se'
        self.missing_contact = FakeContact([self.missing_address])
        self.missing_friend = Friend("Unknown Person")
        
        self.multiple_contact = FakeContact([self.existing_address, self.missing_address])
        self.multiple_friend = Friend("Another Person")

    
if __name__ == '__main__':
    unittest.main()
