from org.maemo.hermes.engine.twitter.user import User
import urllib, urllib2
import base64
import simplejson
import urlparse

class TwitterApi():
    """Twitter backend for Hermes. Inspired by
          http://code.google.com/p/python-twitter/source/browse/twitter.py
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
       
       
    # -----------------------------------------------------------------------
    def __init__(self, make_api_request):
        self._make_api_request = make_api_request


    # -----------------------------------------------------------------------
    def get_friends(self):
        '''Return the full list of people being followed by 'username'.'''

        url = 'https://twitter.com/statuses/friends.json?cursor=%d'
        cursor = -1
        users = []
        while True:
            json = self._make_api_request(url % (cursor))
            data = simplejson.loads(json)
            if 'error' in data:
                raise Exception(data['error'])

            for x in data['users']:
                users.append(User.NewFromJsonDict(x))

            cursor = data['next_cursor']
            if cursor <= data['previous_cursor']:
                break

        return users
    
    
    # -----------------------------------------------------------------------
    def get_user(self):
        """Return the name of the authenticated user."""
        
        url = 'https://api.twitter.com/1/account/verify_credentials.json'
        json = self._make_api_request(url)
        user = simplejson.loads(json)
#        if 'name' in user and user['name']:
#            return user['name']
        return user['screen_name']
