import gnome.gconf
import gtk, hildon
import org.maemo.hermes.engine.provider
import org.maemo.hermes.engine.twitter.service
from org.maemo.hermes.engine.twitter.api import TwitterApi

class Provider(org.maemo.hermes.engine.provider.Provider):
    """Twitter provider for Hermes. 

       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""


    # -----------------------------------------------------------------------
    def __init__(self):
        self._gconf  = gnome.gconf.client_get_default()


    # -----------------------------------------------------------------------
    def get_name(self):
        """Return the display name of this service. An icon, of with the lower-case,
           all-alphabetic version of this name is expected to be provided."""
           
        return 'Twitter'
    
    
    # -----------------------------------------------------------------------
    def has_preferences(self):
        """Whether or not this provider has any preferences. If it does not,
           open_preferences must NOT be called; as the behaviour is undetermined."""
           
        return True
    
    
    # -----------------------------------------------------------------------
    def open_preferences(self, parent):
        """Show the username/password dialogue."""
           
        dialog = gtk.Dialog(self.get_name(), parent)
        dialog.add_button(_('Disable'), gtk.RESPONSE_NO)
        enable = dialog.add_button(_('Enable'), gtk.RESPONSE_YES)

        # -- Username...
        #
        hbox = gtk.HBox()
        hbox.pack_start(gtk.Label(_("Username")))
        
        username = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
        username.set_property('is-focus', True)
        username.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)
        username.set_text(self._gconf.get_string("/apps/maemo/hermes/twitter_user") or '')

        hbox.pack_start(username)
        dialog.vbox.add(hbox)
        
        # -- Password...
        #
        hbox = gtk.HBox()
        hbox.pack_start(gtk.Label(_("Password")))
        
        password = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
        password.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL | gtk.HILDON_GTK_INPUT_MODE_INVISIBLE)
        password.set_text(self._gconf.get_string("/apps/maemo/hermes/twitter_pwd") or '')
        hbox.pack_start(password)
        dialog.vbox.add(hbox)

        # -- Enable is only available if both populated...
        #
        def _check_fields(e, p):
            enable.set_sensitive(e.get_text() != '' and p.get_text() != '')
        username.connect('changed', _check_fields, password)
        password.connect('changed', _check_fields, username)
        _check_fields(username, password)

        # -- Run the dialogue...
        #
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        if result == gtk.RESPONSE_CANCEL or result == gtk.RESPONSE_DELETE_EVENT:
            return None
 
        self._gconf.set_string("/apps/maemo/hermes/twitter_user", username.get_text())
        self._gconf.set_string("/apps/maemo/hermes/twitter_pwd", password.get_text())
        return result == gtk.RESPONSE_YES


    # -----------------------------------------------------------------------
    def get_account_detail(self):
        """Return the Twitter username."""
        
        return self._gconf.get_string("/apps/maemo/hermes/twitter_user")
    
    
    # -----------------------------------------------------------------------
    def service(self, gui_callback):
        """Return the service backend. This must be a class which implements the
           following methods:
               * get_friends
               * process_contact
               * finalise
        
           See Service for more details."""
    
        username = self._gconf.get_string("/apps/maemo/hermes/twitter_user") or ''
        password = self._gconf.get_string("/apps/maemo/hermes/twitter_pwd") or ''
        
        api = TwitterApi(username, password)

        return org.maemo.hermes.engine.twitter.service.Service(self.get_id(), api)
