import gnome.gconf
import gobject, gtk, hildon
import time, thread
import webbrowser
import org.maemo.hermes.engine.provider
import org.maemo.hermes.engine.linkedin.service
from org.maemo.hermes.engine.linkedin.api import LinkedInApi

class Provider(org.maemo.hermes.engine.provider.Provider):
    """LinkedIn provider for Hermes. 

       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
       
    # -----------------------------------------------------------------------
    def __init__(self):
        """Initialise the provider, and ensure the environment is going to work."""

        self._gc = gnome.gconf.client_get_default()
        self._api = LinkedInApi(gconf = self._gc) 


    # -----------------------------------------------------------------------
    def get_name(self):
        """Return the display name of this service. An icon, of with the lower-case,
           all-alphabetic version of this name is expected to be provided."""
           
        return 'LinkedIn'
    
    
    # -----------------------------------------------------------------------
    def get_account_detail(self):
        """Return the name of the linked LinkedIn account."""
        
        return self._gc.get_string(LinkedInApi.GCONF_USER)
    
    
    # -----------------------------------------------------------------------
    def has_preferences(self):
        """Whether or not this provider has any preferences. If it does not,
           open_preferences must NOT be called; as the behaviour is undetermined."""
           
        return True
    
    
    # -----------------------------------------------------------------------
    def open_preferences(self, parent):
        """Open the preferences for this provider as a child of the 'parent' widget."""

        self.main_window = parent
        dialog = gtk.Dialog(self.get_name(), parent)
        dialog.add_button(_('Disable'), gtk.RESPONSE_NO)
        enable = dialog.add_button(_('Enable'), gtk.RESPONSE_YES)
    
        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                               hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self._handle_button(None, button, enable)
        button.connect('clicked', self._handle_button, button, enable)
            
        dialog.vbox.add(gtk.Label(""))
        dialog.vbox.add(button)
        dialog.vbox.add(gtk.Label(""))
        
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        if result == gtk.RESPONSE_CANCEL or result == gtk.RESPONSE_DELETE_EVENT:
            return None
    
        return result == gtk.RESPONSE_YES


    # -----------------------------------------------------------------------
    def _handle_button(self, e, button, enable):
        """Ensure the button state is correct."""
        
        authenticated = self._api.get_access_token_from_gconf() is not None
        if e is not None:
            if authenticated:
                self._api.remove_access_token_from_gconf()
            else:
                self._api.authenticate(lambda: None, self.block_for_auth)
        
            authenticated = self._api.get_access_token_from_gconf() is not None
        
        button.set_title(authenticated and _("Clear authorisation") or _("Authorise"))
        enable.set_sensitive(authenticated)

        
    # -----------------------------------------------------------------------
    def block_for_auth(self, url):
        """Part of the GUI callback API."""

        webbrowser.open(url)
        time.sleep(3)
        note = gtk.Dialog(_('Service authorisation'), self.main_window)
        note.add_button(_("Validate"), gtk.RESPONSE_OK)
        input = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
        input.set_property('is-focus', False)
        input.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        note.set_title(_("Verification code from web browser"))
        note.vbox.add(input)

        note.show_all()
        result = note.run()
        note.hide()
        if result == gtk.RESPONSE_OK:
            return input.get_text()
        else:
            return None

    
    # -----------------------------------------------------------------------
    def service(self, gui_callback):
        """Return the service backend."""
           
        return org.maemo.hermes.engine.linkedin.service.Service(self.get_id(), self._api)
