import gtk
import hildon
from ctypes import *
from pygobject import *

class MapContact(hildon.PannableArea):
    """Widget which shows a list of friends from various feeds and allows
       the mapping to a particular contact.
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
       Released under the Artistic Licence."""


    # -----------------------------------------------------------------------
    def __init__(self, friends, contact):
        """Constructor. Passed a list of `friends' and the contact we're mapping."""
        
        hildon.PannableArea.__init__(self)
        self.friends = friends
        self.contact = contact
        self.treestore = gtk.ListStore(gtk.gdk.Pixbuf, str, gtk.gdk.Pixbuf, gobject.TYPE_PYOBJECT)
        
        accounts = {}
        _tick    = gtk.icon_theme_get_default().load_icon('widgets_tickmark_list', 48, 0)
        
        self.contact_mapped = False
        mapped_iter = None
        for key in sorted(self.friends.keys(), cmp = lambda a, b: cmp(a.lower(), b.lower())):
            friend = self.friends[key]
            if friend.get_source() not in accounts:
                try:
                    accounts[friend.get_source()] = gtk.gdk.pixbuf_new_from_file("/opt/hermes/share/account-%s.png" % (friend.get_source()))
                except glib.GError, e:
                    accounts[friend.get_source()] = None
                    print "Couldn't find icon:", e.message
              
            pixbuf = None
            if friend.get_contact() is not None:
                if friend.get_contact() == contact:
                    pixbuf = _tick
                    self.contact_mapped = True
                    mapped_iter = self.treestore.append([accounts[friend.get_source()], friend.get_name(), pixbuf, friend])
                else:
                    continue
            else:
                self.treestore.append([accounts[friend.get_source()], friend.get_name(), pixbuf, friend])
        
        self.treeview = gtk.TreeView(self.treestore)
        hildon.hildon_gtk_tree_view_set_ui_mode(self.treeview, gtk.HILDON_UI_MODE_EDIT)
        
        self.treeview.append_column(gtk.TreeViewColumn('Account', gtk.CellRendererPixbuf(), pixbuf = 0))
        self.treeview.append_column(gtk.TreeViewColumn('Name', gtk.CellRendererText(), text = 1))
        
        cell = gtk.CellRendererPixbuf()
        cell.set_property('xalign', 1.0)
        self.treeview.append_column(gtk.TreeViewColumn('Picture', cell, pixbuf = 2))
        
        if mapped_iter:
            path = self.treestore.get_path(mapped_iter)
            self.treeview.get_selection().select_path(path)
            self.treeview.scroll_to_cell(path)
        else:
            self.treeview.get_selection().unselect_all()
          
        self.add(self.treeview)
        self.set_size_request_policy(hildon.SIZE_REQUEST_CHILDREN)

      
    # -----------------------------------------------------------------------
    def get_selected_friend(self):
        """Return the selected friend, or `None' if none."""
    
        (model, iter) = self.treeview.get_selection().get_selected()
        if not iter:
            return None
             
        return model.get_value(iter, 3)


_account_selected = gobject.signal_new('account-selected', MapContact, gobject.SIGNAL_ACTION, gobject.TYPE_NONE, [gobject.TYPE_PYOBJECT, gobject.TYPE_PYOBJECT])

