import gettext
import gtk, gobject
import traceback
import time
import thread
import urllib2
import hildon
import conic
from org.bleb.wimpworks import WimpWorks
from org.maemo.hermes.gui.contactview import ContactView
from org.maemo.hermes.gui.mapcontact import MapContact
from org.maemo.hermes.gui.accountsdialogue import AccountsDialogue
from org.bleb.wimpworks import HildonMainScreenLayout
from org.maemo.hermes.engine.syncjob import SyncJob
from org.maemo.hermes.engine.hermes import Hermes

class HermesGUI(WimpWorks):
    """Provides the GUI for Hermes, allowing the syncing of Facebook and
       Twitter friends' information with the Evolution contacts' database.
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
       Released under the Artistic Licence."""


    # -----------------------------------------------------------------------
    def __init__(self, providers = None):
        gettext.install('hermes','/opt/hermes/share/locale/')
        WimpWorks.__init__(self, 'Hermes', version = '0.9.0', dbus_name = 'org.maemo.hermes')
        self.set_background('background.png')
        
        layout = HildonMainScreenLayout(offset = 0.8, container = self)
        layout.add_button('Retrieve', _("Get contacts' missing info"))
        layout.add_button('Refresh', _("Update contacts' info"))
        
        self.add_menu_action("Accounts")
        self.menu.show_all()
        
        self.providers = providers
        self.progressnote = None
        connection = conic.Connection()
        gobject.timeout_add(100, connection.request_connection, conic.CONNECT_FLAG_NONE)

  
    # -----------------------------------------------------------------------
    def do_retrieve(self, widget):
        self.sync(widget, False)
    
    
    # -----------------------------------------------------------------------
    def do_refresh(self, widget):
        self.sync(widget, True)


    # -----------------------------------------------------------------------
    def do_accounts(self, widget = None):
        dialog = AccountsDialogue(self.main_window, self.providers)
        dialog.show()
   

    # -----------------------------------------------------------------------
    def sync(self, widget, force, main = True):
        enabled = []
        for provider in self.providers:
            if self.gconf.get_bool('/apps/maemo/hermes/use_%s' % (provider.get_id())):
                enabled.append(provider)
                
        if main and len(enabled) == 0:
            saved = self.do_accounts()
            if saved == gtk.RESPONSE_DELETE_EVENT:
                return
            
        print "doing sync", main
        
        if main:
            self.main_window.set_property('sensitive', False)
            thread.start_new_thread(self.sync, (widget, force, False))
        else:
            try:
                self.progress('', 0, 0)
                services = []
                for provider in enabled:
                    services.append(provider.service(self))
                    
                hermes = Hermes(services, self.progress)
                hermes.run(force)
                gobject.idle_add(self.open_summary, hermes)
        
            except urllib2.HTTPError, e:
                traceback.print_exc()
                if e.code == 401:
                    gobject.idle_add(self.report_error, _('Authentication problem. Check credentials.'), True)
                else:
                    gobject.idle_add(self.report_error, _('Network connection error. Check connectivity.'))
        
            except urllib2.URLError, e:
                traceback.print_exc()
                gobject.idle_add(self.report_error, _('Network connection error. Check connectivity.'))
          
            except Exception, e:
                traceback.print_exc()
                gobject.idle_add(self.report_error, _('Something went wrong: ') + e.message)
    
    
    # -----------------------------------------------------------------------
    def open_summary(self, fb2c):
        gobject.idle_add(self.main_window.set_property, 'sensitive', True)
    
        dialog = gtk.Dialog(_('Summary'), self.main_window)
        dialog.add_button(_('Done'), gtk.RESPONSE_OK)
      
        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                               title = _('Updated %d contacts') % (len(fb2c.updated)))
        button.connect('clicked', self.show_contacts, fb2c, fb2c.updated)
        button.set_property('sensitive', len(fb2c.updated) > 0)
        dialog.vbox.add(button)
        
        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                               title = _('Matched %d contacts') % (len(fb2c.matched)))
        button.connect('clicked', self.show_contacts, fb2c, fb2c.matched)
        button.set_property('sensitive', len(fb2c.matched) > 0)
        dialog.vbox.add(button)
      
        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                               title = _('%d contacts unmatched') % (len(fb2c.unmatched)))
        button.connect('clicked', self.show_contacts, fb2c, fb2c.unmatched)
        button.set_property('sensitive', len(fb2c.unmatched) > 0)
        dialog.vbox.add(button)
      
        dialog.show_all()
        dialog.run()
        dialog.hide()
    
    
    # -----------------------------------------------------------------------
    def show_contacts(self, widget, fb2c, contacts):
        view = ContactView(contacts)
    
        dialog = gtk.Dialog(_('Contacts'), self.main_window)
        view.connect('contact-activated', self.map_contact, fb2c)
        dialog.vbox.add(view)
        dialog.show_all()
      
        dialog.run()
        dialog.hide()
      
      
    # -----------------------------------------------------------------------
    def map_contact(self, widget, contact, fb2c):
        view = MapContact(fb2c.friends, contact)
    
        dialog = gtk.Dialog(contact.get_name(), self.main_window)
        dialog.add_button(_('Update'), gtk.RESPONSE_OK)
        dialog.vbox.add(view)
        dialog.show_all()
      
        result = dialog.run()
        dialog.hide()
        if result == gtk.RESPONSE_OK:
            friend = view.get_selected_friend()
            if friend:
                if friend.get_contact() == contact:
                    hildon.hildon_banner_show_information(self.main_window, '', _("Removing existing mappings is not yet supported"))
                elif view.contact_mapped:
                    if fb2c.update_contact(contact, friend, True):
                        fb2c.addresses.commit_contact(contact)
                else:
                    if fb2c.update_contact(contact, friend, False):
                        fb2c.addresses.commit_contact(contact)
    
                        
    # -----------------------------------------------------------------------
    def need_auth(self, main = False):
        """Part of the GUI callback API."""
        
        if main:
            hildon.hildon_banner_show_information(self.main_window, '', _("Need to authenticate via browser"))
        else:
            gobject.idle_add(self.need_auth, True)
      
    
    # -----------------------------------------------------------------------
    def block_for_auth(self, prompt = False, main = False, lock = None):
        """Part of the GUI callback API."""

        if main:
            note = gtk.Dialog(_('Service authorisation'), self.main_window)
            note.add_button(_("Validate"), gtk.RESPONSE_OK)
            if prompt:
                input = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
                input.set_property('is-focus', False)
                note.set_title(_("Verification code from web browser"))
                note.vbox.add(input)
            else:
                note.vbox.add(gtk.Label(_("\nPress 'Validate' once account has\nbeen authorised in web browser.\n")))
    
            note.show_all()
            result = note.run()
            note.hide()
            lock.release()
            if prompt and result == gtk.RESPONSE_OK:
                print input.get_text()
                return input.get_text()
            else:
                return None
        
        else:
            time.sleep(2)
            lock = thread.allocate_lock()
            lock.acquire()
            gobject.idle_add(self.block_for_auth, prompt, True, lock)
            lock.acquire()
            lock.release()
                      
                        
    # -----------------------------------------------------------------------
    def progress(self, msg, i, j, main = False):
        """Part of the GUI callback API."""

        if main:
            if i == 0:
                self.progressbar = gtk.ProgressBar()
                self.progressnote = gtk.Dialog(_("Initialising connections"), self.main_window)
                self.progressnote.vbox.add(self.progressbar)
                hildon.hildon_gtk_window_set_progress_indicator(self.progressnote, 1)
               
                self.progressnote.show_all()
              
            elif i < j:
                self.progressnote.set_title(_(msg))
                hildon.hildon_gtk_window_set_progress_indicator(self.progressnote, 0)
                
                self.progressbar.set_fraction(float(i) / float(j))
              
            else:
                self.progressnote.destroy()
              
            print msg, i,j
        else:
            gobject.idle_add(self.progress, msg, i, j, True)

       
    # -----------------------------------------------------------------------
    def report_error(self, e, prefs = False):
        if self.progressnote:
            self.main_window.set_property('sensitive', True)
            self.progressnote.destroy()
    
        hildon.hildon_banner_show_information(self.main_window, '', e)
        if prefs:
            self.do_accounts()
