import gtk, glib
import hildon
import gobject
import evolution
from ctypes import *
from pygobject import *

class ContactView(hildon.PannableArea):
    """Widget which shows a list of contacts in a pannable area.
         
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
       Released under the Artistic Licence."""
    
    
    # -----------------------------------------------------------------------
    def __init__(self, contacts):
        """Constructor. Passed a list of Contacts."""
        
        hildon.PannableArea.__init__(self)
        self.contacts = contacts
        
        columns = [gtk.gdk.Pixbuf,         # 0. Photo
                   str,                    # 1. Name
                   # ...                   # x. Services
                   # gobject.TYPE_PYOBJECT # y. Actual contact
                  ]

        # -- Work out which services need to be shown...
        #
        icons    = {}
        services = set([])
        for contact in self.contacts:
            services |= contact.get_mappings()

        for service in sorted(services):
            columns.append(gtk.gdk.Pixbuf)
            try:
                icons[service] = gtk.gdk.pixbuf_new_from_file('/opt/hermes/share/account-%s.png' % (service))
            except glib.GError, e:
                icons[service] = None
                
        columns.append(gobject.TYPE_PYOBJECT)
        self.treestore = gtk.ListStore(*tuple(columns))
        self._contact_index = len(columns) -1

        # -- Build the tree model...
        #
        for contact in sorted(self.contacts, cmp = lambda a, b: cmp(a.get_name(), b.get_name())):
            if not contact.get_name():
                continue
              
            pi = contact.get_photo()
            pixbuf = None
            if pi and pi.contents.data.uri.startswith("image/"):
                data = string_at(pi.contents.data.inlined.data, pi.contents.data.inlined.length)
                pixbuf_loader = gtk.gdk.PixbufLoader()
                pixbuf_loader.write(data)
                pixbuf_loader.close()
                pixbuf = pixbuf_loader.get_pixbuf()
            elif pi and pi.contents.data.uri.startswith("file://"):
                filename = pi.contents.data.uri[7:]
                pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
                  
            if pixbuf:
                size = min(pixbuf.get_width(), pixbuf.get_height())
                pixbuf = pixbuf.subpixbuf(0, 0, size, size).scale_simple(48, 48, gtk.gdk.INTERP_BILINEAR)
                
            row = [pixbuf, contact.get_name(), ]
            for service in services:
                row.append(service in contact.get_mappings() and icons[service] or None)
                
            row.append(contact)
            self.treestore.append(row)
        
        self.treeview = gtk.TreeView(self.treestore)
        self.treeview.append_column(gtk.TreeViewColumn('Picture', gtk.CellRendererPixbuf(), pixbuf = 0))

        tvcolumn = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text = 1)
        tvcolumn.set_expand(True)
        self.treeview.append_column(tvcolumn)

        i = 2
        for service in services:
            self.treeview.append_column(gtk.TreeViewColumn('Service', gtk.CellRendererPixbuf(), pixbuf = i))
            i = i + 1
        
        self.treeview.connect('row-activated', self._activated)
        self.add(self.treeview)
        self.set_size_request_policy(hildon.SIZE_REQUEST_CHILDREN)

      
    # -----------------------------------------------------------------------
    def _activated(self, treeview, path, column):
        """Used to emit the `contact-activated' signal once a row has been
           selected."""
        
        iter    = treeview.get_model().get_iter(path)
        contact = treeview.get_model().get_value(iter, self._contact_index)
        self.emit('contact-activated', contact)


_contact_activated = gobject.signal_new('contact-activated', ContactView, gobject.SIGNAL_ACTION, gobject.TYPE_NONE, [gobject.TYPE_PYOBJECT])



