from org.maemo.hermes.engine.names import canonical
from org.maemo.hermes.engine.friend import Friend
import org.maemo.hermes.engine.service

class Service(org.maemo.hermes.engine.service.Service):
    """Twitter backend for Hermes.
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Copyright (c) Fredrik Wendt <fredrik@wendt.se> 2010.
       Released under the Artistic Licence."""
       
       
    # -----------------------------------------------------------------------
    def __init__(self, service_id, twitterApi):
        org.maemo.hermes.engine.service.Service.__init__(self, service_id)

        self._twitter = twitterApi
        
        self._friends_by_name = {}
        self._friends_by_url = {}
        self._friends_by_contact = {}
        self._friends = []
        self._known_urls = set()
    
    
    # -----------------------------------------------------------------------
    def pre_process_contact(self, contact):
        """Registers URLs of all previous mappings, and makes sure that any Friends with those
           URLs don't get match by name."""
        for url in contact.get_urls():
            self._known_urls.add(url)


    # -----------------------------------------------------------------------
    def process_friends(self):
        tweeters = self._get_tweeters()
        #print "got ", len(tweeters), " tweeters from twitter"
        for tweeter in tweeters:
            key = canonical(tweeter.name)
            url = 'http://twitter.com/%s' % (tweeter.screen_name)
            friend = Friend(tweeter.name)
            friend.set_nickname(tweeter.screen_name)
            friend.add_url(url)
            friend.add_url(tweeter.url)
            if '/default_profile' not in tweeter.profile_image_url:
                friend.set_photo_url(tweeter.profile_image_url)
          
            self._friends.append(friend)
            self._friends_by_url[url] = friend
            if url not in self._known_urls:
                self._friends_by_name[key] = friend

    
    # -----------------------------------------------------------------------
    def process_contact(self, contact):
        if self._friends_by_contact.has_key(contact) or \
            self._match_contact_to_friend_by_urls(contact) or \
            self._match_contact_to_friend_by_identifiers(contact):
            return self._get_friend_by_contact(contact)
        
        return None
    
    
    # -----------------------------------------------------------------------
    def finalise(self, updated, overwrite=False):
        pass


    # -----------------------------------------------------------------------
    def get_contacts_with_match(self):
        return self._friends_by_contact
    

    # -----------------------------------------------------------------------
    def get_unmatched_friends(self):
        return self._friends
    

    # -----------------------------------------------------------------------
    def _get_tweeters(self):
        return self._twitter.GetFriends()
    
    
    # -----------------------------------------------------------------------
    def _get_friend_by_contact(self, contact):
        return self._friends_by_contact[contact]


    def _match_contact_to_friend_by_urls(self, contact):
        for url in contact.get_urls():
            if url in self._friends_by_url:
                matched_friend = self._friends_by_url[url]
                self._register_match(contact, matched_friend)
                return True
            
        return False


    def _match_contact_to_friend_by_identifiers(self, contact):
        for id in contact.get_identifiers():
            if id in self._friends_by_name:
                matched_friend = self._friends_by_name[id]
                self._register_match(contact, matched_friend)
                return True
            
        return False


    def _register_match(self, contact, friend):
        friend.set_contact(contact)
        self._friends_by_contact[contact] = friend
        self._friends.remove(friend)

