import os
import os.path
import urllib
import Image
import ImageOps

class ContactStore:
  """Provide an API for changing contact data. Abstracts limitations
     in the evolution-python bindings.

     Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
     Released under the Artistic Licence."""


  # -----------------------------------------------------------------------
  def __init__(self, book):
    """Create a new contact store for modifying contacts in the given
       EBook."""

    self.temp_file = os.tmpnam()
    self.book = book

 
  # -----------------------------------------------------------------------
  def close(self):
    """Close the store and tidy-up any resources."""

    if (os.path.isfile(self.temp_file)):
      os.unlink(self.temp_file)


  # -----------------------------------------------------------------------
  def set_photo(self, contact, url):
    """Set the given contact's photo to the picture found at the URL. If the
       photo is wider than it is tall, it will be cropped with a bias towards
       the top of the photo."""

    urllib.urlretrieve(url, self.temp_file)
    im = Image.open(self.temp_file)
    (w, h) = im.size
    if (h > w):
      print "Shrinking photo for %s as it's %d x %d" % (contact.get_name(), w, h)
      im = ImageOps.fit(im, (w, w), Image.NEAREST, 0, (0, 0.1))
      im.save(self.temp_file, "JPEG")
      
    print "Updating photo for %s" % (contact.get_name())
    os.spawnl(os.P_WAIT, '/opt/hermes/bin/contact-update', 'contact-update', contact.get_name(), '--photo', 'image/jpeg', self.temp_file)
