import gtk
import hildon

class ContactView(hildon.PannableArea):
  """Widget which shows a list of contacts in a pannable area.
       
     Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
     Released under the Artistic Licence."""


  # -----------------------------------------------------------------------
  def __init__(self, contacts):
    """Constructor. Passed a list of EContacts."""
    
    hildon.PannableArea.__init__(self)
    self.contacts = contacts
    self.treestore = gtk.ListStore(str, gtk.gdk.Pixbuf)
    for contact in self.contacts:
      self.treestore.append(row = [contact.get_name(), contact.get_photo(48)])

    self.treeview = gtk.TreeView(self.treestore)
    tvcolumn = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text = 0)
    self.treeview.append_column(tvcolumn)

    cell = gtk.CellRendererPixbuf()
    cell.set_property('xalign', 1.0)
    tvcolumn = gtk.TreeViewColumn('Picture', cell, pixbuf = 1)
    self.treeview.append_column(tvcolumn)

    self.add(self.treeview)
    self.set_size_request(600, 380)

