/*
 * This file is part of hercui
 *
 * Copyright (C) 2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#include "config.h"

#include <sys/types.h>
#include <sys/wait.h>
#include <glib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <vte/vte.h>
#include <hildon/hildon.h>
#include <libosso.h>

#include "he-about-dialog.h"

typedef struct _Hercui Hercui;
struct _Hercui {
	HildonProgram *program;
	HildonWindow *window;
	osso_context_t *osso;
	GtkWidget *vt;
	GtkWidget *about_button;
	GtkWidget *start_button;
	GtkWidget *paste_button;
	GtkWidget *ipl_button;
	pid_t hpid;
	gint res;
};

Hercui app;

#define HERCULES_BIN "/opt/bin/hercules"
#define HERCULES_HOME "/home/user/MyDocs/Hercules"
#define HERCULES_CONF "/home/user/MyDocs/Hercules/hercules.cnf"

gchar *hargv[]={HERCULES_BIN, "-f", HERCULES_CONF, NULL};

static pid_t
hui_fork_hercules(void)
{
return vte_terminal_fork_command(VTE_TERMINAL(app.vt), HERCULES_BIN, hargv, NULL, HERCULES_HOME, FALSE, FALSE, FALSE);
}

static void
hui_child_closed(VteTerminal *vt, gpointer user_data)
{
gint status;

/* For fucks sake, use new version of software.. disable as vte in maemo is OOOOOOOOOOOOLD */
#if 0
status=vte_terminal_get_child_exit_status(vt);
if (WIFEXITED(status)) {
	app.res=WEXITSTATUS(status);
	app.hpid=0;
	g_debug("Hercules exited with code: %d", app.res);
	return;
}
g_warning("Huh???");
#else
app.hpid=0;
g_debug("Hercules exited");
#endif
}

static gboolean
hui_quit(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
if (app.hpid>0) {
	hildon_banner_show_information(GTK_WIDGET(app.window), "", "Hercules is running, shutdown first.");
	g_debug("Hercules is running");
	return TRUE;
}

return FALSE;
}

#define URL_HERCUI "http://maemo.tal.org/"
#define URL_BUGS "http://bugzilla.tal.org/"

static gboolean
hui_about_cb()
{
he_about_dialog_present(GTK_WINDOW(app.window),
    "HercUI",
    "hercui",
    VERSION,
    "A simple UI for Hercules emulator.",
    "HercUI is free software, GPLv2\n"
    "Copyright 2010 Kaj-Michael Lang <milang@tal.org>",
    URL_HERCUI,
    URL_BUGS,
    NULL);
return TRUE;
}

static gboolean
hui_start_cb()
{
if (app.hpid==0)
	app.hpid=hui_fork_hercules();
else
	hildon_banner_show_information(GTK_WIDGET(app.window), "", "Hercules is already started.");
return TRUE;
}

static gboolean
hui_paste_cb()
{
if (app.hpid>0)
	vte_terminal_paste_clipboard(VTE_TERMINAL(app.vt));
return TRUE;
}

static HildonAppMenu *
hui_menu(void)
{
HildonAppMenu *menu;

menu=HILDON_APP_MENU(hildon_app_menu_new());

app.start_button=hildon_gtk_button_new(HILDON_SIZE_AUTO);
gtk_button_set_label(GTK_BUTTON(app.start_button), "Start Hercules");
g_signal_connect_after(app.start_button, "clicked", G_CALLBACK(hui_start_cb), NULL);
hildon_app_menu_append(menu, GTK_BUTTON(app.start_button));

app.paste_button=hildon_gtk_button_new(HILDON_SIZE_AUTO);
gtk_button_set_label(GTK_BUTTON(app.paste_button), "Paste");
g_signal_connect_after(app.paste_button, "clicked", G_CALLBACK(hui_paste_cb), NULL);
hildon_app_menu_append(menu, GTK_BUTTON(app.paste_button));

app.about_button=hildon_gtk_button_new(HILDON_SIZE_AUTO);
gtk_button_set_label(GTK_BUTTON(app.about_button), "About");
hildon_app_menu_append(menu, GTK_BUTTON(app.about_button));
g_signal_connect(G_OBJECT(app.about_button), "clicked", G_CALLBACK(hui_about_cb), NULL);

gtk_widget_show_all(GTK_WIDGET(menu));
return menu;
}

static gint
hui_dbus_req_handler(const gchar *interface, const gchar *method, GArray *arguments, gpointer data, osso_rpc_t *retval)
{
return OSSO_OK;
}

gint
main(gint argc, gchar *argv[])
{
osso_return_t result;

g_thread_init(NULL);
g_type_init();
#if HILDON_CHECK_VERSION(2,2,0)
hildon_gtk_init(&argc, &argv);
#else
gtk_init(&argc, &argv);
#endif
g_set_application_name("HerculesUI");
gtk_window_set_default_icon_name("hercules");

app.program=HILDON_PROGRAM(hildon_program_get_instance());

#if HILDON_CHECK_VERSION(2,2,0)
app.window=HILDON_WINDOW(hildon_stackable_window_new());
hildon_window_set_app_menu(HILDON_WINDOW(app.window), hui_menu());
#else
app.window=HILDON_WINDOW(hildon_window_new());
hildon_window_set_menu(HILDON_WINDOW(app.window), hui_menu());
#endif
g_signal_connect(G_OBJECT(app.window), "delete-event", hui_quit, NULL);
g_signal_connect(G_OBJECT(app.window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

app.hpid=0;
app.vt=vte_terminal_new();
vte_terminal_set_font_from_string(VTE_TERMINAL(app.vt), "monospace 8");
g_signal_connect(G_OBJECT(app.vt), "child-exited", hui_child_closed, NULL);

gtk_container_add(app.window, app.vt);
hildon_program_add_window(app.program, app.window);

app.osso=osso_initialize("org.tal.hercui", VERSION, FALSE, NULL);
if (!app.osso)
	return FALSE;

result=osso_rpc_set_cb_f(app.osso, "org.tal.hercui", "/org/tal/hercui", "org.tal.hercui", hui_dbus_req_handler, NULL);
if (result!=OSSO_OK)
	return FALSE;

gtk_widget_show_all(GTK_WIDGET(app.window));
gtk_main();

return 0;
}
