#include "hcmainwindow.h"
#include "ui_hcmainwindow.h"
#include <qmobilityglobal.h>
#include "myswipegesture.h"
#include "explorer.h"
#include "audiodevices.h"


#include <QEvent>
#include <QMouseEvent>




hcMainWindow::hcMainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::hcMainWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    //connect(ui->comboBox, SIGNAL(activated(int)),ui->stackedWidget, SLOT(setCurrentIndex(int)));
    setupGeneral();

    _swipeGesture = new MySwipeGesture(this);
    connect(_swipeGesture,SIGNAL(handleSwipe(MySwipeGesture::SwipeDirection)),this,SLOT(swipe(MySwipeGesture::SwipeDirection)));
}

hcMainWindow::~hcMainWindow()
{
    delete ui;
}




void hcMainWindow::on_stackedWidget_currentChanged(int index )
{
    switch (index) {
        case 0:
        {
            qDebug() << "Select General";
            setupGeneral();
            break;
        }
        case 1:
        {
            qDebug() << "Select SystemInformation";
            setupSysInfo();
            break;
        }
        case 2:
        {

                        ui->tableWidget_2->clearContents();
                        ui->tableWidget_2->setRowCount(1);
                        QString program = "ash";
                        QStringList arguments;
                        arguments << "-c";
                        arguments << "df -h";
                        arguments << " | sed 's/$/\\<br\\>/'";

                        QProcess *myProcess = new QProcess(this);
                        myProcess->setReadChannelMode(QProcess::MergedChannels);
                        myProcess->start(program, arguments);

                         if (!myProcess->waitForFinished())
                        {
                              qDebug() << "Make failed:" << myProcess->errorString();
                          }
                          else
                         {
                             //QString output = myProcess->readAllStandardOutput();

                              //qDebug() << "Make output:" << myProcess->readAll();

                              QString output = QString(myProcess->readAllStandardOutput());

                              QStringList outputLines = output.split("\n", QString::SkipEmptyParts);
                              int irow = 0;
                              int icol = -1;
                              QStringListIterator listIter(outputLines);
                              listIter.next();
                              while (listIter.hasNext()) {
                                  QString line = listIter.next();
                                  qDebug() << "-> Line: " << line;
                                  //ui->textBrowser->append(line);
                                  QStringList lineFields = line.split(" ", QString::SkipEmptyParts);

                                  QStringListIterator fieldIter(lineFields);
                                  while (fieldIter.hasNext()) {

                                      icol ++;
                                      QString field = fieldIter.next();
                                      qDebug() << "--> Field: " << field;
                                      ui->tableWidget_2->setItem(irow, icol,new QTableWidgetItem(field));
                                      qDebug() << "Row: " << irow;
                                      qDebug() << "Col: " << icol;

                                      if (icol == 5) {
                                          ui->tableWidget_2->setRowCount(ui->tableWidget_2->rowCount() +1);
                                          irow ++;
                                          icol = -1;

                                             }

                                  }
                //QString outp = listIter;
                //ui->textBrowser->setText(outp);
         }
                              ui->tableWidget_2->resizeRowsToContents();
                              ui->tableWidget_2->resizeColumnsToContents();
                              ui->tableWidget_2->horizontalHeader()->setVisible(true);
                          }
             //qDebug() << myProcess->readAllStandardOutput();
            // ui->textBrowser->setText(result_all);
           // qDebug() << myProcess->exitCode();
        //ui->tableWidget_2->resizeRowsToContents();
        //ui->tableWidget_2->resizeColumnsToContents();
        //ui->tableWidget_2->repaint();
        QFontMetrics fm(ui->tableWidget_2->font());
        int h = fm.height() + 2;
        ui->tableWidget_2->verticalHeader()->setDefaultSectionSize( h );

        break;
        }
        case 3:
        {
        ui->listWidget->clear();
        QFile file10("/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies");
        if (!file10.open(QIODevice::ReadOnly | QIODevice::Text))
        return;
        QTextStream in10(&file10);
        QString data10 = in10.readAll();
        qDebug() << "CPU Freqs: "<< data10.trimmed();
        //ui->label_12->setText(data10.trimmed());
              QStringList outputLines2 = data10.split(" ", QString::SkipEmptyParts);

              QStringListIterator listIter2(outputLines2);
              //listIter2.next();
              while (listIter2.hasNext()) {

                  QString line2 = listIter2.next();
                  qDebug() << "-> Line: " << line2;
                  int mhz;

                  mhz = line2.toInt();
                  mhz = mhz / 1000;

                  qDebug() << mhz;
                  QString numstring;
                  numstring.setNum(mhz);
                  numstring.append(" Mhz");
                  if (numstring.trimmed() != "0 Mhz"){
                      ui->listWidget->addItem(numstring);
                  }
                             }
              delete ui->listWidget->item(ui->listWidget->count());

              ui->listWidget_2->clear();
              QFile file11("/sys/devices/system/cpu/cpu0/cpufreq/ondemand/avoid_frequencies");
              if (!file11.open(QIODevice::ReadOnly | QIODevice::Text))
              return;
              QTextStream in11(&file11);
              QString data11 = in11.readAll();
              qDebug() << "AVOID CPU Freqs: "<< data11.trimmed();
              //ui->label_12->setText(data11.trimmed());




                    QStringList outputLines3 = data11.split(" ", QString::SkipEmptyParts);
                    QStringListIterator listIter3(outputLines3);
                    //listIter2.next();
                    while (listIter3.hasNext()) {

                        QString line3 = listIter3.next();
                        qDebug() << "-> Line: " << line3;
                        int mhz;

                        mhz = line3.toInt();
                        mhz = mhz / 1000;

                        qDebug() << mhz;
                        QString numstring;
                        numstring.setNum(mhz);
                        numstring.append(" Mhz");
                        if (numstring.trimmed() != "0 Mhz"){
                            ui->listWidget_2->addItem(numstring);
                        }
                                   }
                    delete ui->listWidget->item(ui->listWidget_2->count());

                    QFile file7("/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq");
                    if (!file7.open(QIODevice::ReadOnly | QIODevice::Text))
                    return;
                    QTextStream in7(&file7);
                    QString data7 = in7.readAll();
                    qDebug() << "CPU Current: " << data7.trimmed();
                    ui->label_64->setText(data7.trimmed());

                    QFile file8("/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq");
                    if (!file8.open(QIODevice::ReadOnly | QIODevice::Text))
                    return;
                    QTextStream in8(&file8);
                    QString data8 = in8.readAll();
                    qDebug() << "CPU Max: " << data8.trimmed();
                    ui->label_62->setText(data8.trimmed());

                    QFile file9("/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq");
                    if (!file9.open(QIODevice::ReadOnly | QIODevice::Text))
                    return;
                    QTextStream in9(&file9);
                    QString data9 = in9.readAll();
                    qDebug() << "CPU Min: " << data9.trimmed();
                    ui->label_2->setText(data9.trimmed());

                    QString program = "ash";
                    QStringList arguments;
                    arguments << "-c";
                    arguments << "uname -r";
                    QProcess *myProcess = new QProcess(this);
                    myProcess->setReadChannelMode(QProcess::MergedChannels);
                    myProcess->start(program, arguments);

                    if (!myProcess->waitForFinished())
                   {
                         qDebug() << "Make failed:" << myProcess->errorString();
                     }
                     else
                    {
                         QString output = QString(myProcess->readAllStandardOutput());
                         qDebug() << "uname - a :" << output;
                         ui->label_65->setText(output.trimmed());

                     }



                     QFontMetrics fm(ui->listWidget->font());
                     int h = fm.height() + 20;
                     ui->listWidget->setGridSize(QSize(0,h));

                     QFontMetrics fm2(ui->listWidget_2->font());
                     int h2 = fm2.height() + 20;
                     ui->listWidget_2->setGridSize(QSize(0,h2));


        break;
          }
    case 4:
    {
        setupNetwork();
        updateSimStatus();
        ui->netStatusComboBox->setCurrentIndex(1);
        break;
    }
    case 5:
        {
    break;
    }
    case 6:
        {




    break;
    }
        }




}







void hcMainWindow::setupGeneral()
{


    systemInfo = new QSystemInfo(this);
    ui->curLanguageLineEdit->setText( systemInfo->currentLanguage());
    ui->countryCodeLabel->setText(systemInfo->currentCountryCode());

    di = new QSystemDeviceInfo(this);
    ui->batteryLabel->setText(QString::number(di->batteryLevel()) + "%");
    ui->batteryLabel2->setText(QString::number(di->batteryLevel()));

         connect(di,SIGNAL(batteryLevelChanged(int)),
                 this,SLOT(updateBatteryStatus(int)));

        // connect(di,SIGNAL(batteryStatusChanged(QSystemDeviceInfo::BatteryStatus)),
          //       this,SLOT(displayBatteryStatus(QSystemDeviceInfo::BatteryStatus)));

         connect(di,SIGNAL(powerStateChanged(QSystemDeviceInfo::PowerState)),
                 this,SLOT(updatePowerState(QSystemDeviceInfo::PowerState)));
         updateProfile();



            QString program = "ash";
            QStringList arguments;
            arguments << "-c";
            arguments << "uname -r";
            QProcess *myProcess = new QProcess(this);
            myProcess->setReadChannelMode(QProcess::MergedChannels);
            myProcess->start(program, arguments);

            if (!myProcess->waitForFinished())
           {
                 qDebug() << "Make failed:" << myProcess->errorString();
             }
             else
            {
                 QString output = QString(myProcess->readAllStandardOutput());
                 qDebug() << "uname - a :" << output;
                 ui->kernelVersion->setText(output.trimmed());

             }

}

void hcMainWindow::setupSysInfo()
{
    qDebug() << "Run";

    QFile file("/sys/class/backlight/acx565akm/brightness");
    //file.open(QIODevice::ReadOnly | QIODevice::Text);

    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    return;

    QTextStream in(&file);
    QString data = in.readAll();
    QFile file2("/sys/class/backlight/acx565akm/max_brightness");
    if (!file2.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in2(&file2);
    QString data2 = in2.readAll();
    qDebug() << "backlight: " << data2.trimmed();
    QStringList brightness;
    brightness.append( data.trimmed() );
    brightness.append( "/");
    brightness.append( data2.trimmed() );
    QString actd = brightness.join( " " );
    ui->label_10->setText(actd);
    file.close();
    file2.close();

    QFile file3("/var/lib/dsme/boot_count");
    if (!file3.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in3(&file3);
    QString data3 = in3.readAll();
    qDebug() << "boot count: " << data3.trimmed();
    ui->label_24->setText(data3.trimmed());

    QFile file4("/proc/bootreason");
    if (!file4.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in4(&file4);
    QString data4 = in4.readAll();
    qDebug() << "boot reason: " << data4.trimmed();
    ui->label_17->setText(data4.trimmed());

    QFile file5("/sys/devices/platform/gpio-switch/slide/state");
    if (!file5.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in5(&file5);
    QString data5 = in5.readAll();
    qDebug() << "keyb slider: " << data5.trimmed();
    ui->label_27->setText(data5.trimmed());

    QFile file6("/sys/class/mmc_host/mmc0/cover_switch");
    if (!file6.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in6(&file6);
    QString data6 = in6.readAll();
    qDebug() << "mmc cover: " << data6.trimmed();
    ui->label_28->setText(data6.trimmed());

    QFile file7("/sys/devices/platform/gpio-switch/proximity/state");
    if (!file7.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in7(&file7);
    QString data7 = in7.readAll();
    qDebug() << "proxi sensor: " << data7.trimmed();
    ui->label_22->setText(data7.trimmed());

    QFile file8("/sys/class/power_supply/bq27200-0/capacity");
    if (!file8.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        qDebug() << "Battery Temp: FAIL ";
        ui->label_11->setText("Unavailable");

    }
    else
    {
        QTextStream in8(&file8);
        QString data8 = in8.readAll();
        qDebug() << "Battery Temp: " << data8.trimmed();

        data8.trimmed().append( "%");
        ui->label_11->setText(data8.trimmed());

    }

    QFile file9("/sys/devices/platform/gpio-switch/cam_shutter/state");
    if (!file9.open(QIODevice::ReadOnly | QIODevice::Text))
    return;
    QTextStream in9(&file9);
    QString data9 = in9.readAll();
    qDebug() << "Cam Shutter: "<< data9.trimmed();
    ui->label_12->setText(data9.trimmed());


           QString program = "ash";
            QStringList arguments;
            arguments << "-c";
            arguments << "uptime | sed -e 's/.*p *//' -e 's/, l.*//' -e 's/  / /'";
        // arguments << "";

         QProcess *myProcess = new QProcess(this);
         myProcess->setReadChannelMode(QProcess::MergedChannels);
         myProcess->start(program, arguments);


         if (!myProcess->waitForFinished())
        {
              qDebug() << "Make failed:" << myProcess->errorString();
          }
          else
         {
              QString output = QString(myProcess->readAllStandardOutput());
              qDebug() << output;
              ui->label_15->setText(output.trimmed());
          }
    //qDebug() << myProcess->readAllStandardOutput();
   // QString myVal = myProcess->readAllStandardOutput().trimmed();
   // qDebug() << myProcess->exitCode();

    //dpkg -l "mp-fremantle-*" | grep ii
        QString program2 = "ash";
        QStringList arguments2;
        arguments2 << "-c";
        arguments2 << "osso-product-info -q OSSO_PRODUCT_RELEASE_VERSION";

        QProcess *myProcess2 = new QProcess(this);
        myProcess2->setReadChannelMode(QProcess::MergedChannels);
        myProcess2->start(program2, arguments2);


        if (!myProcess2->waitForFinished())
       {
             qDebug() << "Make failed:" << myProcess2->errorString();
         }
         else
        {
             QString output2 = QString(myProcess2->readAllStandardOutput());
             qDebug() << output2;
             ui->label_25->setText(output2.trimmed());
         }

         QString programnn = "ash";
         QStringList argumentsnn;
         argumentsnn << "-c";
         argumentsnn << "uname -n";

         QProcess *myProcessnn = new QProcess(this);
         myProcessnn->setReadChannelMode(QProcess::MergedChannels);
         myProcessnn->start(programnn, argumentsnn);


         if (!myProcessnn->waitForFinished())
        {
              qDebug() << "Make failed:" << myProcessnn->errorString();
          }
          else
         {
              QString output2 = QString(myProcessnn->readAllStandardOutput());
              qDebug() << output2;
              ui->labelNodeName->setText(output2.trimmed());
          }

          QString programos = "ash";
          QStringList argumentsos;
          argumentsos << "-c";
          argumentsos << "uname -s";

          QProcess *myProcessos = new QProcess(this);
          myProcessos->setReadChannelMode(QProcess::MergedChannels);
          myProcessos->start(programos, argumentsos);


          if (!myProcessos->waitForFinished())
         {
               qDebug() << "Make failed:" << myProcessos->errorString();
           }
           else
          {
               QString output2 = QString(myProcessos->readAllStandardOutput());
               qDebug() << output2;
               ui->labelOS->setText(output2.trimmed());
           }

           QString programhc = "ash";
           QStringList argumentshc;
           argumentshc << "-c";
           argumentshc << "uname -m";

           QProcess *myProcesshc = new QProcess(this);
           myProcesshc->setReadChannelMode(QProcess::MergedChannels);
           myProcesshc->start(programhc, argumentshc);


           if (!myProcesshc->waitForFinished())
          {
                qDebug() << "Make failed:" << myProcesshc->errorString();
            }
            else
           {
                QString output2 = QString(myProcesshc->readAllStandardOutput());
                qDebug() << output2;
                ui->labelHC->setText(output2.trimmed());
            }

            QString programload = "ash";
             QStringList argumentsload;
             argumentsload << "-c";
             argumentsload << "uptime | sed \'s/.*e: //\'";


          QProcess *myProcessload = new QProcess(this);
          myProcessload->setReadChannelMode(QProcess::MergedChannels);
          myProcessload->start(programload, argumentsload);


          if (!myProcessload->waitForFinished())
         {
               qDebug() << "Make failed:" << myProcessload->errorString();
           }
           else
          {
               QString output = QString(myProcessload->readAllStandardOutput());
               qDebug() << output;
               ui->labelLoad->setText(output.trimmed());
           }

           QDBusInterface interface(SIM_DBUS_SERVICE, SIM_DBUS_PATH, SIM_DBUS_IFACE,
                   QDBusConnection::systemBus());

               QDBusMessage reply = interface.call(SIM_IMEI_REQ);
               if (reply.type() == QDBusMessage::ErrorMessage)
                   qDebug() << reply.errorMessage();
               else {
                   QList<QVariant> args = reply.arguments();
                   qDebug() << args;
                   ui->phoneIMEI->setText(QString("%1").arg(args.at(0).toString()));
               }


               QDBusInterface interface2(SIM_DBUS_SERVICE2, SIM_DBUS_PATH2, SIM_DBUS_IFACE2,
                       QDBusConnection::systemBus());

                   QDBusMessage reply2 = interface2.call(SIM_IMSI_REQ);
                   if (reply2.type() == QDBusMessage::ErrorMessage)
                       qDebug() << reply2.errorMessage();
                   else {
                       QList<QVariant> args2 = reply2.arguments();
                       qDebug() << args2;
                       ui->phoneISSI->setText(QString("%1").arg(args2.at(0).toString()));
                   }

                   QSystemInfo s;
                   ui->labelQT->setText(s.version(QSystemInfo::QtCore));


}


void hcMainWindow::setupNetwork()
 {

     ni = new QSystemNetworkInfo(this);


     connect(ui->netStatusComboBox,SIGNAL(activated(int)),
            this, SLOT(netStatusComboActivated(int)));

     connect(ni,SIGNAL(networkSignalStrengthChanged(QSystemNetworkInfo::NetworkMode, int)),
             this,SLOT(networkSignalStrengthChanged(QSystemNetworkInfo::NetworkMode,int)));

     connect(ni,SIGNAL(networkNameChanged(QSystemNetworkInfo::NetworkMode,QString)),
             this,SLOT(networkNameChanged(QSystemNetworkInfo::NetworkMode,QString)));

     connect(ni,SIGNAL(networkStatusChanged(QSystemNetworkInfo::NetworkMode,QSystemNetworkInfo::NetworkStatus)),
             this,SLOT(networkStatusChanged(QSystemNetworkInfo::NetworkMode,QSystemNetworkInfo::NetworkStatus)));





     ui->cellIdLabel->setText(QString::number(ni->cellId()));
     ui->locationAreaCodeLabel->setText(QString::number(ni->locationAreaCode()));
     ui->currentMMCLabel->setText(ni->currentMobileCountryCode());
     ui->currentMNCLabel->setText(ni->currentMobileNetworkCode());

     ui->homeMMCLabel->setText(ni->homeMobileCountryCode());
     ui->homeMNCLabel->setText(ni->homeMobileNetworkCode());

   //  networkModeChanged(ni->currentMode());



 }

void hcMainWindow::netStatusComboActivated(int index)
{
    QString status;
    int reIndex = index;

    displayNetworkStatus(ni->networkStatus((QSystemNetworkInfo::NetworkMode)reIndex));

    ui->macAddressLabel->setText(ni->macAddress((QSystemNetworkInfo::NetworkMode)reIndex));

    int strength = ni->networkSignalStrength((QSystemNetworkInfo::NetworkMode)reIndex);
    if(strength < 0)
        strength = 0;
   ui->signalLevelProgressBar->setValue(strength);

    ui->InterfaceLabel->setText(ni->interfaceForMode((QSystemNetworkInfo::NetworkMode)reIndex).humanReadableName());

    ui->operatorNameLabel->setText(ni->networkName((QSystemNetworkInfo::NetworkMode)reIndex));
}

void hcMainWindow::displayNetworkStatus(QSystemNetworkInfo::NetworkStatus status)
 {
     QString stat;
     switch(status) {
     case QSystemNetworkInfo::UndefinedStatus:
         stat = "Undefined";
         break;
     case QSystemNetworkInfo::NoNetworkAvailable:
         stat = "Unavailable";
         break;
     case QSystemNetworkInfo::EmergencyOnly:
         stat = "Emergency Only";
         break;
     case QSystemNetworkInfo::Searching:
         stat = "Searching/Connecting";
         break;
     case QSystemNetworkInfo::Busy:
         stat = "Busy";
         break;
     case QSystemNetworkInfo::Connected:
         stat = "Connected";
         break;
     case QSystemNetworkInfo::HomeNetwork:
         stat = "Home Network";
         break;
     case QSystemNetworkInfo::Denied:
         stat = "Denied";
         break;
     case QSystemNetworkInfo::Roaming:
         stat = "Roaming";
         break;
     };
     ui->cellNetworkStatusLabel->setText(stat);
 }


void hcMainWindow::networkStatusChanged(QSystemNetworkInfo::NetworkMode mode , QSystemNetworkInfo::NetworkStatus status)
{
    if(mode == QSystemNetworkInfo::WlanMode) {
        if(ui->netStatusComboBox->currentText() == "Wlan") {
           displayNetworkStatus(status);
        }
    }

    if(mode == QSystemNetworkInfo::EthernetMode) {
        if(ui->netStatusComboBox->currentText() == "Ethernet") {
           displayNetworkStatus(status);
        }
    }

    if(mode == QSystemNetworkInfo::GsmMode) {
        if(ui->netStatusComboBox->currentText() == "Gsm") {
            displayNetworkStatus(status);
        }
    }

    if(mode == QSystemNetworkInfo::CdmaMode) {
        if(ui->netStatusComboBox->currentText() == "Cdma") {
            displayNetworkStatus(status);
        }
    }

    if(mode == QSystemNetworkInfo::WcdmaMode) {
        if(ui->netStatusComboBox->currentText() == "Wcdma") {
            displayNetworkStatus(status);
        }
    }

}
void hcMainWindow::networkSignalStrengthChanged(QSystemNetworkInfo::NetworkMode mode , int strength)
{
    if(mode == QSystemNetworkInfo::WlanMode) {
        if(ui->netStatusComboBox->currentText() == "Wlan") {
            ui->signalLevelProgressBar->setValue(strength);
        }
    }

    if(mode == QSystemNetworkInfo::EthernetMode) {
        if(ui->netStatusComboBox->currentText() == "Ethernet") {
            ui->signalLevelProgressBar->setValue(strength);
        }
    }

    if(mode == QSystemNetworkInfo::GsmMode) {
        if(ui->netStatusComboBox->currentText() == "Gsm") {
            ui->signalLevelProgressBar->setValue(strength);
        }
    }

    if(mode == QSystemNetworkInfo::CdmaMode) {
        if(ui->netStatusComboBox->currentText() == "Cdma") {
            ui->signalLevelProgressBar->setValue(strength);
        }
    }

    if(mode == QSystemNetworkInfo::WcdmaMode) {
        if(ui->netStatusComboBox->currentText() == "Wcdma") {
           ui->signalLevelProgressBar->setValue(strength);
        }
    }

}

void hcMainWindow::networkNameChanged(QSystemNetworkInfo::NetworkMode mode,const QString &text)
 {
     if(mode == QSystemNetworkInfo::WlanMode) {
         if(ui->netStatusComboBox->currentText() == "Wlan") {
             ui->operatorNameLabel->setText(text);
         }
     }

     if(mode == QSystemNetworkInfo::EthernetMode) {
         if(ui->netStatusComboBox->currentText() == "Ethernet") {
             ui->operatorNameLabel->setText(text);
         }
     }

     if(mode == QSystemNetworkInfo::GsmMode) {
         if(ui->netStatusComboBox->currentText() == "Gsm") {
             ui->operatorNameLabel->setText(text);
         }
     }

     if(mode == QSystemNetworkInfo::CdmaMode) {
         if(ui->netStatusComboBox->currentText() == "Cdma") {
             ui->operatorNameLabel->setText(text);
         }
     }

     if(mode == QSystemNetworkInfo::WcdmaMode) {
         if(ui->netStatusComboBox->currentText() == "Wcdma") {
             ui->operatorNameLabel->setText(text);
         }
     }

 }

void hcMainWindow::updateSimStatus()
 {
     if(di) {
         QString simstring;
         switch(di->simStatus()) {
         case QSystemDeviceInfo::SimLocked:
             {
                 simstring = "Sim Locked";
             }
             break;
         case QSystemDeviceInfo::SimNotAvailable:
             {
                 simstring = "Sim Unavailable";
             }
             break;
         case QSystemDeviceInfo::SingleSimAvailable:
             {
                 simstring = "Single Sim";

             }
             break;
         case QSystemDeviceInfo::DualSimAvailable:
             {
                 simstring = "Dual Sim";
             }
             break;

         };
         ui->simStatusLabel->setText(simstring);
     }
 }

void hcMainWindow::updatePowerState(QSystemDeviceInfo::PowerState newState)
{


    switch (newState) {
    case QSystemDeviceInfo::BatteryPower:
        {
            ui->batteryStatus->setText("Battery Power");
        }
        break;
    case QSystemDeviceInfo::WallPower:
        {

            ui->batteryStatus->setText("Wall Power");
        }
        break;
    case QSystemDeviceInfo::WallPowerChargingBattery:
        {
            ui->batteryStatus->setText("Charging");
        }
        break;
    case QSystemDeviceInfo::NoBatteryLevel:
        {
            ui->batteryStatus->setText("Unknown");
        }
        break;
    };
}

void hcMainWindow::updateProfile()
 {
     if(di) {
         QString profilestring;
         switch(di->currentProfile()) {
             case QSystemDeviceInfo::UnknownProfile:
             {
                 profilestring = "Unknown";
             }
             break;
             case QSystemDeviceInfo::SilentProfile:
             {
                 profilestring = "Silent";
             }
             break;
             case QSystemDeviceInfo::NormalProfile:
             {
                 profilestring = "Normal";
             }
             break;
             case QSystemDeviceInfo::LoudProfile:
             {
                 profilestring = "General";
             }
             break;
             case QSystemDeviceInfo::VibProfile:
             {
                 profilestring = "Silent";
             }
             break;
             case QSystemDeviceInfo::OfflineProfile:
             {
                 profilestring = "Offline";
             }
             break;
             case QSystemDeviceInfo::PowersaveProfile:
             {
                 profilestring = "Powersave";
             }
             break;
             case QSystemDeviceInfo::CustomProfile:
                 {
                     profilestring = "custom";
                 }
                 break;
         };
         ui->profileLabel->setText(profilestring);
     }
 }

void hcMainWindow::updateBatteryStatus(int level)
{
    ui->batteryLabel2->setText(QString::number(level) + "%");
}



 bool hcMainWindow::event(QEvent *event)
 {

     _swipeGesture->handleEvent(event);
     return QWidget::event(event);
 }

 void hcMainWindow::swipe(MySwipeGesture::SwipeDirection direction)
 {
     qDebug() << "swipe" << direction;
     qDebug() << ui->stackedWidget->currentIndex();
     if(direction == 1){
         if(ui->stackedWidget->currentIndex() == 0)
            {
                ui->stackedWidget->setCurrentIndex(8);
             }
         else {
             ui->stackedWidget->setCurrentIndex(ui->stackedWidget->currentIndex() -1);
         }
     }
     else {
         if(ui->stackedWidget->currentIndex() == 8)
            {
             ui->stackedWidget->setCurrentIndex(0);
         }
         else
         {
         ui->stackedWidget->setCurrentIndex(ui->stackedWidget->currentIndex() +1);
     }
     }

 }


void hcMainWindow::on_pushButton_clicked()
{
    setWindowFlags(windowFlags() | Qt::Window);
    screenColour *myscreenColour = new screenColour(this);
    myscreenColour->showFullScreen();



}

void hcMainWindow::on_pushButton_2_clicked()
{
    setWindowFlags(windowFlags() | Qt::Window);
    pixelWindow *mypixelWindow = new pixelWindow(this);
    mypixelWindow->showFullScreen();
}



void hcMainWindow::on_pushButton_3_clicked()
{
    setWindowFlags(windowFlags() | Qt::Window);
    Explorer *myExplorer = new Explorer(this);
    myExplorer ->showFullScreen();
}

void hcMainWindow::on_pushButton_4_clicked()
{
    setWindowFlags(windowFlags() | Qt::Window);
    AudioTest *myAudio = new AudioTest(this);
    myAudio ->showFullScreen();
}
