#ifndef HCMAINWINDOW_H
#define HCMAINWINDOW_H
#include <QMainWindow>
#include <QtGui>
#include <QFile>
#include <QString>
#include <QIODevice>
#include <QTextStream>
#include <QProcess>
#include <QStringList>
#include <QSystemDeviceInfo>
#include <QtDBus/QtDBus>
#include <QSensor>
#include <QAccelerometer>
#include <QMediaControl>
#include <QPoint>
#include <QSystemInfo>
#include "myswipegesture.h"
#include "screencolour.h"
#include "pixelwindow.h"


//#include <qsystemdeviceinfo.h>
//#include <qsysteminfo.h>
//#include "qsensor.h"
//#include "qaccelerometer.h"
//#include <qmediacontrol.h>




QTM_USE_NAMESPACE

#define SIM_DBUS_SERVICE  "com.nokia.phone.SIM"
#define SIM_DBUS_PATH     "/com/nokia/phone/SIM/security"
#define SIM_DBUS_IFACE    "Phone.Sim.Security"
#define SIM_IMEI_REQ      "get_imei"

#define SIM_DBUS_SERVICE2  "com.nokia.phone.SIM"
#define SIM_DBUS_PATH2     "/com/nokia/phone/SIM"
#define SIM_DBUS_IFACE2    "Phone.Sim"
#define SIM_IMSI_REQ       "get_imsi"



namespace Ui {
    class hcMainWindow;
}

class hcMainWindow : public QMainWindow
{
    Q_OBJECT

public:

    explicit hcMainWindow(QWidget *parent = 0);
    ~hcMainWindow();
    bool event(QEvent *event);





private:
    Ui::hcMainWindow *ui;
    QSystemDeviceInfo *di;
    QSystemInfo *systemInfo;
    QSystemNetworkInfo *ni;
    QSystemStorageInfo *sti;



    MySwipeGesture *_swipeGesture;


    void setupGeneral();
    void setupSysInfo();
    void setupNetwork();
    //void setupStorage();
    //void updateStorage();


private slots:

    void on_pushButton_4_clicked();
    void on_pushButton_3_clicked();
    void on_pushButton_2_clicked();
    void on_pushButton_clicked();
    void on_stackedWidget_currentChanged(int );
    void netStatusComboActivated(int);
    void updateSimStatus();
    void updateProfile();
    void updateBatteryStatus(int level);
    void swipe(MySwipeGesture::SwipeDirection direction);


    void displayNetworkStatus(QSystemNetworkInfo::NetworkStatus);
    void networkStatusChanged(QSystemNetworkInfo::NetworkMode, QSystemNetworkInfo::NetworkStatus);
    void networkSignalStrengthChanged(QSystemNetworkInfo::NetworkMode, int);
    void networkNameChanged(QSystemNetworkInfo::NetworkMode,const QString &);
    void updatePowerState(QSystemDeviceInfo::PowerState newState);
    //void networkModeChanged(QSystemNetworkInfo::NetworkMode);
   // void storageChanged(bool added,const QString &vol);



};


#endif // HCMAINWINDOW_H
