#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Application Name - Health Check V1.2.1-3
# Date 17 February 2010
# Author - Greg Roberts (Noobmonkey @ Maemo Talk)
# Contact - Me@Greg-roberts.com
#
# Developed using QT Designer, Eric4, Python GUI and the Nokia N900
# Designed to be used on Maemo 5 (Nokia N900)
#
# This is my first ever N900 application, so please excuse the poor coding!
#
#
# Talk/Bugs : http://talk.maemo.org/showthread.php?t=45453
#
# Import the libraries needed in this program
# import PyQt4 & sys
print "***** Start Imports *****"
try:
        print "** Importing qtcore & gui **"
	from PyQt4 import QtCore, QtGui
        from PyQt4 import *
        print "** Importing ui.touchstub - accuracy tool **"
	from ui.touchstub import aMainWindow
        print "** Importing sys **"
	import sys
	print "** Importing commands **"
	import commands
	print "** Importing os **"  
	import os
	print "** Importing os.path **"
	import os.path
	print "** Importing subprocess **"
	import subprocess
        print "** Importing dbus.glib **"
	import dbus.glib
        print "** Importing Start location**"
	import location
        print "** Importing Cellinfo **"
	import gn_cellinfo
        print "** Importing Hildon **"
	import hildon
	print "** Importing Functions **"
	import gn_functions
	print "** Importing Time **"
	import time
	print "** Importing GTK **"
	import gtk
        print "** Initialize Threads(GTK) **"
	gtk.gdk.threads_init()
        print "** Importing Gobject **"
	import gobject
	print "***** Finish Imports *****"
	
except ImportError, err:
        print "** ERROR : couldn't load module. %s - **" % (err)
        sys.exit(2)

# Set a global variable - used to send the GPS info from a function back onto its label in the GUI. I'm sure there is a much better way returning
# the variable in a function, but this works.... Example: http://www.wellho.net/resources/ex.php4?item=y105/locvar.py
# Setting it to "location" for now.
# Location of the DPKG files
dpkg_dir = '/var/lib/dpkg'
# Global variables
print "** Seting global variables **"
var_g_GPS = "No GPS lock"
bname = "Move R"
name_lookup = {}
rootfs_id = ''

class camerasClass(QtGui.QMainWindow):

	def __init__(self, *args):
		apply(QtGui.QMainWindow.__init__, (self,) + args)
		self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
		self.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
		print "** Set basic color on rectangle **"
		self.color = QtGui.QColor(0, 0, 0) 
		print "** Setting window details and loading form**"
		self.setGeometry(0, 0, 800, 480)
		self.setWindowTitle('Front Camera Image')
		self.lblCameraImage = QtGui.QLabel(self)
		self.lblCameraImage.setGeometry(QtCore.QRect(160, 10, 455, 341))
		self.lblCameraImage.setFrameShape(QtGui.QFrame.Panel)
		self.lblCameraImage.setFrameShadow(QtGui.QFrame.Raised)
		self.lblCameraImage.setLineWidth(2)
		self.lblCameraImage.setMidLineWidth(1)
		self.lblCameraImage.setScaledContents(True)
		self.lblCameraImage.setObjectName("lblCameraImage")
		# Setup and draw the button
		self.pushButton_cam = QtGui.QPushButton(self)
		self.pushButton_cam.setGeometry(QtCore.QRect(0, 380, 331, 71))
		self.pushButton_cam.setObjectName("pushButton_cam")
		self.pushButton_cam.setText("Front camera")
		# Tell the button what to do when it is clicked.
		QtCore.QObject.connect(self.pushButton_cam, QtCore.SIGNAL('clicked()'), self.funcFrontCamTest)
		# Setup and draw the button
		self.pushButton_cam2 = QtGui.QPushButton(self)
		self.pushButton_cam2.setGeometry(QtCore.QRect(300, 380, 331, 71))
		self.pushButton_cam2.setObjectName("pushButton_cam2")
		self.pushButton_cam2.setText("Back camera")
		# Tell the button what to do when it is clicked.
		QtCore.QObject.connect(self.pushButton_cam2, QtCore.SIGNAL('clicked()'), self.funcBackCamTest)
		self.exitb = QtGui.QPushButton('X', self)
		self.exitb.setGeometry(QtCore.QRect(600, 380, 101, 71))
		self.connect(self.exitb, QtCore.SIGNAL('clicked()'), self.close)
		
	def funcFrontCamTest(self):
		print " ** Starting update3**"
		self.pushButton_cam.setEnabled(False)
		self.pushButton_cam.setText("....")
		self.funcFrontCamCapture()
		self.pushButton_cam.setText("Front camera")
		self.pushButton_cam.setEnabled(True)

	def funcBackCamTest(self):
		print " ** Starting update3a**"
		self.pushButton_cam2.setEnabled(False)
		self.pushButton_cam2.setText("....")
		self.funcBackCamCapture()
		self.pushButton_cam2.setText("Back Camera")
		self.pushButton_cam2.setEnabled(True)

	# Funtion - update the front camera image
	def funcFrontCamCapture(self):
		print "** Starting front camera function **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Front Camera', 'Point your screen camera at a light.', [], {}, 3000)
		b = None
		b = os.popen('gst-launch v4l2camsrc device=/dev/video1 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
		b.close ()
		image_file = "/home/user/MyDocs/fcamtest.jpg"
		image = QtGui.QPixmap(image_file)
		# Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
		self.lblCameraImage.setPixmap(image)
		print " ** Finished front camera function **"

	def funcBackCamCapture(self):
		print " ** Starting back camera function **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Back Camera', 'Checking Lens Cover and taking photo', [], {}, 3000)
		gl = os.popen('cat /sys/devices/platform/gpio-switch/cam_shutter/state').read()
		gl = gl.strip()

		if str(gl) == "closed":
			self.CloseDialog = QtGui.QMessageBox.question(None,"WARNING - Camera Shutter is Closed"," Please open the shutter and click yes when ready. \n Click no to cancel", QtGui.QMessageBox.Yes|QtGui.QMessageBox.No,QtGui.QMessageBox.No)
			if self.CloseDialog == QtGui.QMessageBox.Yes:
				print "** Please open the shutter and click yes when ready ** \n Click no to cancel"
				# Close b - the greatly named variable - as i want to use it again! (Well close or declare it!)
				b = None
				# X-term - grab 10 buffered front camera images, and throw them into an image file.
				# Everyone recommends 1.... but 10 gave more light! - so i used it :D
				b = os.popen('gst-launch v4l2camsrc device=/dev/video0 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
				b.close ()
				# Declare and set the image file name
				image_file = "/home/user/MyDocs/fcamtest.jpg"
				image = QtGui.QPixmap(image_file)
				# Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
				self.lblCameraImage.setPixmap(image)
				print " ** Finished Back camera function **"
			elif self.CloseDialog == QtGui.QMessageBox.No:
				print "** User pressed 'No' button - returning **"
		else:
			# Close b - the greatly named variable - as i want to use it again! (Well close or declare it!)
			b = None
			# X-term - grab 10 buffered front camera images, and throw them into an image file.
			# Everyone recommends 1.... but 10 gave more light! - so i used it :D
			b = os.popen('gst-launch v4l2camsrc device=/dev/video0 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
			b.close ()
			# Declare and set the image file name
			image_file = "/home/user/MyDocs/fcamtest.jpg"
			image = QtGui.QPixmap(image_file)
			# Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
			self.lblCameraImage.setPixmap(image)
			print " ** Finished Back camera function **"

class healthcheckWindow(QtGui.QMainWindow):

	def __init__(self, *args):
		apply(QtGui.QMainWindow.__init__, (self,) + args)
		self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
		print "** Starting healthcheckWindow Class **"
		#checkpkgs()
		global bname
		#self.Qt::WA_Maemo5StackedWindow 
		print "** Set basic color on rectangle **"
		self.color = QtGui.QColor(0, 0, 0) 
		print "** Setting window details and loading form**"
		self.setGeometry(0, 0, 800, 480)
		self.setWindowTitle('Dead Pixel Test')
		self.square = QtGui.QWidget(self)
		self.square.setGeometry(0, 0, 800, 480)
		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
		self.red = QtGui.QPushButton('Red', self)
		self.red.setCheckable(True)
		self.red.move(10, 10)
		self.connect(self.red, QtCore.SIGNAL('clicked()'), self.setRed)
		self.green = QtGui.QPushButton('Green', self)
		self.green.setCheckable(True)
		self.green.move(10, 60)
		self.connect(self.green, QtCore.SIGNAL('clicked()'), self.setGreen)
		self.blue = QtGui.QPushButton('Blue', self)
		self.blue.setCheckable(True)
		self.blue.move(10, 110)
		self.connect(self.blue, QtCore.SIGNAL('clicked()'), self.setBlue)
		self.moveb = QtGui.QPushButton('Move R', self)
		self.moveb.move(10, 160)
		self.connect(self.moveb, QtCore.SIGNAL('clicked()'), self.moveB)
		self.exitb = QtGui.QPushButton('Exit', self)
		self.exitb.move(10, 210)
		self.connect(self.exitb, QtCore.SIGNAL('clicked()'), self.exitB)
		print "** Completed healthcheckWindow Class load **"
 
	def moveB(self):
		print "** moving buttons **"
		global bname
		if bname == "Move R":
			bname = "Move L"
			self.moveb.setText("Move L")
			self.red.move(500, 10)
			self.green.move(500, 60)
			self.blue.move(500, 110)
			self.moveb.move(500, 160)
			self.exitb.move(500, 210)
		else:
			self.moveb.setText("Move R")
			bname = "Move R"
			self.red.move(10, 10)
			self.green.move(10, 60)
			self.blue.move(10, 110)
			self.moveb.move(10, 160)
			self.exitb.move(10, 210)
		print "** moved buttons**"
		

	def exitB(self):
		print "** Exiting healthcheckWindow Class - closing window **"
		self.connect(self.exitb, QtCore.SIGNAL('clicked()'), self.close)
		
  
	def setRed(self):
		if self.red.isChecked():
			self.color.setRed(255)
			self.red.setStyleSheet("QWidget { background-color: #339933 }")
		else:
                        self.color.setRed(0)
                        self.red.setStyleSheet("QWidget { background-color: #006633 }")
                        
		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
		
	def setGreen(self):
		if self.green.isChecked():
			self.color.setGreen(255)
			self.green.setStyleSheet("QWidget { background-color: #339933 }")
		else:
                        self.color.setGreen(0)
                        self.green.setStyleSheet("QWidget { background-color: #006633 }")

		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

	def setBlue(self):
		if self.blue.isChecked():
			self.color.setBlue(255)
			self.blue.setStyleSheet("QWidget { background-color: #339933 }")
		else:
                        self.color.setBlue(0)
                        self.blue.setStyleSheet("QWidget { background-color: #006633 }")

		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())
		
class Ui_MainWindow(QtGui.QMainWindow):
	def setupUi(self, MainWindow):
                self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
                
		print "** start SetupUi**"
		# declaring the previous var_g_GPS location as a global in here, this allows it to be read in here.
		global var_g_GPS
		# Set the window / form name
		MainWindow.setObjectName("MainWindow")
		# Set the window size to W800 * H420 - the size of an N900's screen!
		MainWindow.resize(800, 420)
		# Set the current font to Arial 12
		font = QtGui.QFont()
		font.setFamily("Arial")
		font.setPointSize(20)
		# Set the Mainwindow to use this font
		MainWindow.setFont(font)
                # Not sure - QTDesigner did this bit - assuming it's loading up the form and a widget
		self.centralwidget = QtGui.QWidget(MainWindow)
		self.centralwidget.setObjectName("centralwidget")
                app.setFont(font)
                app.setStyleSheet("QPushButton {\
                    /* Let's make the size of the button 1,5 times of font size. */\
                    min-height: 1.5em;\
                   min-width: 7em;\
                    /* Font size just 1.*/\
                    font: 1em;\
                    /* Margins so that we get a little space on the left and right. */\
                    margin: 0 10px 0 10px;\
                    /* The font color */ \
                    color: white;\
                    /* Here's the background gradient with start point, end point, \
                       stop percentage and color, stop percentage and color. */\
                    background-color: #006633;\
                    /* We'll round the borders. */\
                    border-style: outset;\
                    /* Round radius will be 3px */\
                    border-radius: 3px;\
                    /* Border is only one pixel */\
                    border-width: 1px;\
                    /* Border color is now set */\
                    border-color: #C4C4C3;\
                        }\2010-04-12-Running.gpx\
                        /* This is style when button is pressed */\
                        QPushButton:pressed {\
                    /* We'll just invert the gradient by changing the colors around. */\
                    background-color: #339933; }")

		# Draw the Menubar
		fremantle = MainWindow.menuBar().addMenu("Update");
		act = fremantle.addAction("Update All")
		QtCore.QObject.connect(act, QtCore.SIGNAL("triggered()"), self.funcUpdateAll)
		#actb = fremantle.addAction("System")
		#QtCore.QObject.connect(actb, QtCore.SIGNAL("triggered()"), self.updateTab1)
		#actc = fremantle.addAction("Comms")
		#QtCore.QObject.connect(actc, QtCore.SIGNAL("triggered()"), self.updateTab2)

		# Creating the tab that i need for my application, and set it's size
		self.tabWidget = QtGui.QTabWidget(self.centralwidget)
		self.tabWidget.setGeometry(QtCore.QRect(0, 0, 800, 429))
		self.tabWidget.setStyleSheet("QTabWidget::pane { /* The tab widget frame */\
                     border-top: 0px solid #006633;\
                     position: absolute;\
                     top: 0.1em;\
                 }\
                \
                 QTabWidget::tab-bar {\
                     alignment: center;\
                     background-color: #FFFFFF;\
                 }\
                \
                 /* Style the tab using the tab sub-control. Note that\
                     it reads QTabBar _not_ QTabWidget */\
                 QTabBar::tab {\
                        top: -0.0em;\
                     background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,\
                                                 stop: 0 #006633, stop: 0.4 #006633,\
                                                 stop: 0.5 #006633, stop: 1.0 #006633);\
                     border: 2px solid #C4C4C3;\
                     border-bottom-color: #C2C7CB; /* same as the pane color */\
                     border-top-left-radius: 28px;\
                     border-top-right-radius: 28px;\
                     border-bottom-left-radius: 28px;\
                     border-bottom-right-radius: 28px;\
                     min-width: 8px;\
                     padding: 10px;\
                     height:36px;\
                     margin-right:25px;\
                     padding-left:25px;\
                 }\
                \
                 QTabBar::tab:selected, QTabBar::tab:hover {\
                     background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,\
                                                 stop: 0 #339933, stop: 0.4 #339933,\
                                                 stop: 0.5 #339933, stop: 1.0 #339933);\
                 }\
                \
                 QTabBar::tab:selected {\
                     border-color: #006633;\
                     border-bottom-color: #006633; /* same as pane color */\
                \
                 QTabBar::scroller { /* the width of the scroll buttons */\
                         width: 50px;\
                     }")
		# Set the font size. I've gone for big... very big - so they are finger friendly.
		font = QtGui.QFont()
		font.setPointSize(24)
		self.tabWidget.setFont(font)
		self.tabWidget.setObjectName("tabWidget")
		self.tab = QtGui.QWidget()
		self.tab.setObjectName("tab")

		#Reset the Fontsize - decided to go with Arial 18 for all objects on tab 1
		font = QtGui.QFont()
		font.setPointSize(18)

		self.listWidget = QtGui.QListWidget(self.tab)
		self.listWidget.setGeometry(QtCore.QRect(1, 0, 799, 361))
		self.listWidget.setObjectName("listWidget")
		self.listWidget.setFont(font)
		self.listWidget.setAlternatingRowColors(True)
		self.listWidget.setSizePolicy(QtGui.QSizePolicy.Minimum,QtGui.QSizePolicy.Minimum)
		self.listWidget.setResizeMode(QtGui.QListView.Adjust)
		QtCore.QObject.connect(self.listWidget, QtCore.SIGNAL("itemClicked(QListWidgetItem *)"), self.lclicked) 
                self.listWidget.setStyleSheet("QListView {\
                     show-decoration-selected: 1; /* make the selection span the entire width of the view */\
                 }\
                 QListView::item:selected:!active {\
                     background-color: #339933; }\
                     QListView::item:selected:active {\
                     background-color: #339933;}\
                 QListView {\
                     background-color: #339933;\
                 }")

                #QListView::item:selected:active {background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,stop: 0 #000000, stop: 1 #FFFFFF); }\		
		# Draw the Tab Contents
		self.tabWidget.addTab(self.tab, "")

		# Start on tab 2!
		self.tab_2 = QtGui.QWidget()
		self.tab_2.setObjectName("tab_2")

		self.listWidget2 = QtGui.QListWidget(self.tab_2)
		self.listWidget2.setGeometry(QtCore.QRect(1, 0, 799, 361))
		self.listWidget2.setObjectName("listWidget2")
		self.listWidget2.setFont(font)
		self.listWidget2.setAlternatingRowColors(True)
		self.listWidget2.setResizeMode(QtGui.QListView.Adjust)
		self.listWidget2.setStyleSheet("QListView {\
                     show-decoration-selected: 1; /* make the selection span the entire width of the view */\
                 }\
                 QListView::item:selected:!active {\
                     background-color: #339933; }\
                     QListView::item:selected:active {\
                     background-color: #339933;}\
                 QListView {\
                     background-color: #339933;\
                 }")

		# Show the tab and draw contents
		self.tabWidget.addTab(self.tab_2, "")
		
		# Start on tab 3!
		self.tab_3 = QtGui.QWidget()
		self.tab_3.setObjectName("tab_3")

		self.pushButton_snd1 = QtGui.QPushButton(self.tab_3)
		self.pushButton_snd1.setGeometry(QtCore.QRect(10, 10, 391, 51))
		self.pushButton_snd1.setObjectName("pushButton_snd1")
		self.pushButton_snd1.setText("Test Sound")
		QtCore.QObject.connect(self.pushButton_snd1, QtCore.SIGNAL('clicked()'), self.updatesound)

		self.pushButton_led = QtGui.QPushButton(self.tab_3)
		self.pushButton_led.setGeometry(QtCore.QRect(10, 70, 391, 51))
		self.pushButton_led.setObjectName("pushButton_led")
		self.pushButton_led.setText("Test LEDs")
		QtCore.QObject.connect(self.pushButton_led, QtCore.SIGNAL('clicked()'), self.funcLEDTest)

		self.pushButton_von = QtGui.QPushButton(self.tab_3)
		self.pushButton_von.setGeometry(QtCore.QRect(10, 130, 391, 51))
		self.pushButton_von.setObjectName("pushButton_von")
		self.pushButton_von.setText("Test Vibrate")
		QtCore.QObject.connect(self.pushButton_von, QtCore.SIGNAL('clicked()'), self.funcVibrateTest)

		self.xyscreen = QtGui.QPushButton(self.tab_3)
		self.xyscreen.setGeometry(QtCore.QRect(10, 190, 391, 51))
		self.xyscreen.setObjectName("xyscreen")
		self.xyscreen.setText("Accuracy Test")
		QtCore.QObject.connect(self.xyscreen, QtCore.SIGNAL('clicked()'), self.show_new_window2)

		self.pushButton_cama = QtGui.QPushButton(self.tab_3)
		self.pushButton_cama.setGeometry(QtCore.QRect(10, 250, 391, 51))
		self.pushButton_cama.setObjectName("pushButton_cama")
		self.pushButton_cama.setText("Camera Tests")
		QtCore.QObject.connect(self.pushButton_cama, QtCore.SIGNAL('clicked()'), self.funcFrontCamCapture)
		
		self.pushButton_reboot = QtGui.QPushButton(self.tab_3)
		self.pushButton_reboot.setGeometry(QtCore.QRect(10, 310, 391, 51))
		self.pushButton_reboot.setObjectName("pushButton_reboot")
		self.pushButton_reboot.setText("System Reboot")
		QtCore.QObject.connect(self.pushButton_reboot, QtCore.SIGNAL('clicked()'), self.reboot_sys)

		self.sound_lst = QtGui.QComboBox(self.tab_3)
		self.sound_lst.setGeometry(QtCore.QRect(400, 10, 391, 51))
		self.sound_lst.setObjectName("sound_lst")
		for f in os.listdir("/usr/share/sounds/"):
			#print f[-3:]
			if f[-3:] == "wav":
				self.sound_lst.addItem(f)

		self.combo_led = QtGui.QComboBox(self.tab_3)
		self.combo_led.setGeometry(QtCore.QRect(400, 70, 391, 51))
		self.combo_led.setObjectName("combo_led")
		self.combo_led.addItem("PatternError")
		self.combo_led.addItem("PatternPowerOn")
		self.combo_led.addItem("PatternPowerOff")
		self.combo_led.addItem("PatternCommunicationCall")
		self.combo_led.addItem("PatternCommunicationSMS")

		self.vibra_led = QtGui.QComboBox(self.tab_3)
		self.vibra_led.setGeometry(QtCore.QRect(400, 130, 391, 51))
		self.vibra_led.setObjectName("vibra_led")
		self.vibra_led.addItem("PatternIncomingCall")
		self.vibra_led.addItem("PatternIncomingMessage")
		self.vibra_led.addItem("PatternChatAndEmail")

		self.color_test = QtGui.QPushButton(self.tab_3)
		self.color_test.setGeometry(QtCore.QRect(400, 190, 391, 51))
		self.color_test.setObjectName("color_test")
		self.color_test.setText("Dead Pixel Test")
		QtCore.QObject.connect(self.color_test, QtCore.SIGNAL('clicked()'), self.show_new_window)
		self.tabWidget.addTab(self.tab_3, "")

		# Start on tab 4!
		self.tab_4 = QtGui.QWidget()
		self.tab_4.setObjectName("tab_4")

		# Create the text browser to show the large console input
		# I have used this to show i could get the information in to begin with... I will eventually parse this information and put it into a list
		# box of some sort
		self.textBrowser = QtGui.QTextBrowser(self.tab_4)
		self.textBrowser.setGeometry(QtCore.QRect(0, 10, 781, 301))
		self.textBrowser.setOpenExternalLinks(True)
		fsock = os.popen('cat /home/opt/healthcheck/about.txt').read()
		self.textBrowser.setHtml(fsock)
		# self.textBrowser.setText (fsock)
		# Make the font small!!!
		font = QtGui.QFont()
		font.setPointSize(20)
		self.textBrowser.setFont(font)
		self.tabWidget.addTab(self.tab_4, "")

		# Draw the main Window
		MainWindow.setCentralWidget(self.centralwidget)
		# Run the translate UI - Added by QT Designer - i have removed alot of setText's and placed them above.
		print "** Run retranslateUi **"
		self.retranslateUi(MainWindow)
		#self.updateTab1()
		self.listWidget.setCurrentRow(1)
		self.listWidget2.setCurrentRow(1)
		
		# Set which tab you want showing on program load
		print "** Show tab1 (0) **"
		

		self.tabWidget.setCurrentIndex(0)
		QtCore.QMetaObject.connectSlotsByName(MainWindow)



	def lclicked(self):
                selected_items = ", ".join([str(item.text()) for item in self.listWidget.selectedItems()])
                sela = selected_items.split('\t')
                print "selected:", sela[0].strip()

                if sela[0].strip() == "Accelerometer":
                        jaccel = gn_functions.funcAccel()
                        self.listWidget.currentItem().setText("Accelerometer \t\t" + jaccel)
                elif sela[0].strip() == "Battery Charge":
                        gl = gn_functions.funcBatchrg()
                        self.listWidget.currentItem().setText("Battery Charge \t\t" + gl.strip())
                elif sela[0].strip() == "Battery Current":
                        gl = gn_functions.funcBattcurr()
                        self.listWidget.currentItem().setText("Battery Current \t\t" + gl.strip())
                elif sela[0].strip() == "Camera Shutter State":
                        gl = gn_functions.funcCamState()
                        self.listWidget.currentItem().setText("Camera Shutter State \t" + gl.strip())
                elif sela[0].strip() == "FM Trans Strength":
                        ge = gn_functions.funcFMTrans()
                        self.listWidget.currentItem().setText("FM Trans Strength \t\t" + ge.strip())
                elif sela[0].strip() == "Headphone State":
                        gl = gn_functions.funcHeadphoneState()
                        self.listWidget.currentItem().setText("Headphone State \t\t" + gl.strip())
                elif sela[0].strip() == "Keyboard Slider State":
                        gl = gn_functions.funcKeySlider()
                        self.listWidget.currentItem().setText("Keyboard Slider State \t" + gl.strip())
                elif sela[0].strip() == "Proximity Sensor State":
                        gl = gn_functions.funcProxState()
                        self.listWidget.currentItem().setText("Proximity Sensor State \t" + gl.strip())
                elif sela[0].strip() == "System Uptime":
                        ge = gn_functions.funcSysUptime()
                        self.listWidget.currentItem().setText("System Uptime \t\t" + ge.strip())
                elif sela[0].strip() == "CPU Current Freq":
                        gl = gn_functions.funcCurrentCPUFreq()
                        self.listWidget.currentItem().setText("CPU Current Freq \t\t" + gl.strip())
                elif sela[0].strip() == "App/Home % Used":
                        gl = gn_functions.funcAppUsed()
                        self.listWidget.currentItem().setText("App/Home % Used \t\t" + gl.strip())
                elif sela[0].strip() == "App/Home Free":
                        gl = gn_functions.funcAppFree()
                        self.listWidget.currentItem().setText("App/Home Free \t\t" + gl.strip())
                elif sela[0].strip() == "Backlight Actual Level":
                        gl = gn_functions.funcBacklightAct()
                        self.listWidget.currentItem().setText("Backlight Actual Level \t" + gl.strip())
                elif sela[0].strip() == "Backlight Max Level":
                        gl = gn_functions.funcBacklightMax()
                        self.listWidget.currentItem().setText("Backlight Max Level \t\t" + gl.strip())
                elif sela[0].strip() == "Battery Last Charge":
                        gl = gn_functions.funcBatLastChrg()
                        self.listWidget.currentItem().setText("Battery Last Charge \t\t" + gl.strip())
                elif sela[0].strip() == "Boot Count":
                        gd = gn_functions.funcBootCount()
                        self.listWidget.currentItem().setText("Boot Count \t\t\t" + gd.strip())
                elif sela[0].strip() == "Boot Reason":
                        gl = gn_functions.funcBootReason()	
                        self.listWidget.currentItem().setText("Boot Reason \t\t\t" + gl.strip())
                elif sela[0].strip() == "MMC Cover State":
                        gl = gn_functions.funcMMCState()
                        self.listWidget.currentItem().setText("MMC Cover State \t\t" + gl.strip())
                elif sela[0].strip() == "Memory Card % Used":
                        gl = gn_functions.funcMemoryCUsed()
                        self.listWidget.currentItem().setText("Memory Card % Used \t" + gl.strip())
                elif sela[0].strip() == "Memory Card Free":
                        gl = gn_functions.funcMemoryCFree()
                        self.listWidget.currentItem().setText("Memory Card Free \t\t" + gl.strip())
                elif sela[0].strip() == "MyDocs % Used":
                        gl = gn_functions.funcMyDocsUsed()
                        self.listWidget.currentItem().setText("MyDocs % Used \t\t" + gl.strip())
                elif sela[0].strip() == "MyDocs Free":
                        gl = gn_functions.funcMyDocsFree()
                        self.listWidget.currentItem().setText("MyDocs Free \t\t\t" + gl.strip())
                elif sela[0].strip() == "Rootfs % Used":
                        gl = gn_functions.funcRootUsed()
                        self.listWidget.currentItem().setText("Rootfs % Used \t\t" + gl.strip())
                elif sela[0].strip() == "Rootfs Free":
                        gl = gn_functions.funcRootFree()
                        self.listWidget.currentItem().setText("Rootfs Free \t\t\t" + gl.strip())
                elif sela[0].strip() == "System Load":
                        ge = gn_functions.funcSysLoad()
                        self.listWidget.currentItem().setText("System Load \t\t\t" + ge.strip())
                elif sela[0].strip() == "Device Orientation":
                        orientation = gn_functions.funcDevOri()
                        self.listWidget.currentItem().setText("Device Orientation \t\t" + orientation)
                elif sela[0].strip() == "FM Trans State":
                        g = gn_functions.FMTxState()
                        self.listWidget.currentItem().setText("FM Trans State \t\t" + g)
                elif sela[0].strip() == "FM Trans Frequency":      
                        g = gn_functions.FMTxFrequency()
                        self.listWidget.currentItem().setText("FM Trans Frequency \t\t" + str(g))
                elif sela[0].strip() == "FM Trans Startable?":       
                        g = gn_functions.FMTxStartable()
                        self.listWidget.currentItem().setText("FM Trans Startable? \t\t" + g)
                else:
                        print "else", sela[0].strip()

	def show_new_window(self):           
		win.show()
		win.showFullScreen()

	def show_new_window2(self):  
		aui.show()
		aui.showFullScreen()
		
	def funcFrontCamCapture(self):  
		imagewin.show()
		imagewin.showFullScreen()
		                                	
	def reboot_sys(self):
		print "** reboot function running**"
		self.CloseDialog = QtGui.QMessageBox.question(None, "Time for a Reboot!","Do you really want to reboot?",QtGui.QMessageBox.Yes|QtGui.QMessageBox.No,QtGui.QMessageBox.No)
		if self.CloseDialog == QtGui.QMessageBox.Yes:
			print "** You pressed yes, rebooting **"
			b = None
			b = os.popen('run-standalone.sh dbus-send --system --type=method_call --dest="com.nokia.dsme" --print-reply "/com/nokia/dsme/request" com.nokia.dsme.request.req_reboot')
			b.close ()
		elif self.CloseDialog == QtGui.QMessageBox.No:
			print "** User pressed 'No' button - returning **"

	def updatesound(self):
		print "** Testing sounds! **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Sound Test', 'Testing Stereo/Mono Sound', [], {}, 3000)
		print "** Starting Stereo Test **"
		bb = 'pacat --channels=2 ' + '/usr/share/sounds/' + self.sound_lst.currentText()
		bb = str(bb)
		#print bb
		b = os.popen(bb)
		b.close ()
		print "** Starting Mono Test**"
		bb = 'pacat --channels=1 ' + '/usr/share/sounds/' + self.sound_lst.currentText()
		bb = str(bb)
		#print bb
		b = os.popen(bb)
		b.close ()
 
	def funcCommsInfo(self):
		g = gn_functions.funcHostName()
		self.listWidget2.addItem("Device Hostname \t" + g.strip())

                g = gn_functions.funcIMEI()
		self.listWidget2.addItem("Device IMEI \t\t" + g.strip())

		g = gn_functions.funcInternalIP()
		self.listWidget2.addItem("IP Internal \t\t" + g.strip())

		g = gn_functions.funcWifiLinkQ()
		self.listWidget2.addItem("WIFI Link Quality \t" + g.strip())

		g = gn_functions.funcWifiRSSI()
		self.listWidget2.addItem("WIFI RSSI \t\t" + g.strip())
		
		g = gn_functions.funcWifiNoise()
		self.listWidget2.addItem("WIFI Noise \t\t" + g.strip())

		g = gn_functions.funcMacAddress()
		self.listWidget2.addItem("MAC Address \t\t" + g.strip())

		g = gn_functions.funcBluetooth()
		self.listWidget2.addItem("Bluetooth Name \t" + g.strip())

		g = gn_functions.funcBluetoothMAC()
                self.listWidget2.addItem("Bluetooth MAC \t" + g.strip())


	def funcVibrateTest(self):
                
		print " ** testing vibrations**"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Vibration TEST', 'Testing Vibrations', [], {}, 3000)		
		bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'" + self.vibra_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
		bb = 'run-standalone.sh sleep 5'
		b = os.popen(bb)
		b.close()
		bb= 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_deactivate string:' + "\'" + self.vibra_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
		print " ** finished vibrations**"
		
	def funcLEDTest(self):
		print " ** Starting LED Patterns**"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'LED TEST', 'Starting LED Test', [], {}, 3000)
		bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:' + "\'" + self.combo_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
		bb = 'run-standalone.sh sleep 4'
		b = os.popen(bb)
		b.close()
		bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:' + "\'" + self.combo_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
 
		b.close()
		print " ** Finished LED Patterns **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'LED TEST', 'Completed LED Test', [], {}, 3000)

	def funcSystemTab(self):
		g = gn_functions.funcRootUsed()
		self.listWidget.addItem("Rootfs % Used \t\t" + g.strip())

		g = gn_functions.funcRootFree()
		self.listWidget.addItem("Rootfs Free \t\t\t" + g.strip())

		g = gn_functions.funcMyDocsUsed()
		self.listWidget.addItem("MyDocs % Used \t\t" + g.strip())

                g = gn_functions.funcMyDocsFree()
		self.listWidget.addItem("MyDocs Free \t\t\t" + g.strip())

		g = gn_functions.funcAppUsed()
		self.listWidget.addItem("App/Home % Used \t\t" + g.strip())

                g = gn_functions.funcAppFree()
		self.listWidget.addItem("App/Home Free \t\t" + g.strip())

		g = gn_functions.funcMemoryCUsed()
		self.listWidget.addItem("Memory Card % Used \t" + g.strip())

		g = gn_functions.funcMemoryCFree()
		self.listWidget.addItem("Memory Card Free \t\t" + g.strip())

		g = gn_functions.funcCurrentCPUFreq()
		self.listWidget.addItem("CPU Current Freq \t\t" + g.strip())

		g = gn_functions.funcBacklightAct()
		self.listWidget.addItem("Backlight Actual Level \t" + g.strip())

		g = gn_functions.funcBacklightMax()
		self.listWidget.addItem("Backlight Max Level \t\t" + g.strip())

		g = gn_functions.funcKernelInfo()
		self.listWidget.addItem("Kernel Core Info \t\t" + g.strip())

		g = gn_functions.funcMMCState()
		self.listWidget.addItem("MMC Cover State \t\t" + g.strip())

		g = gn_functions.funcCPUfreq()
                self.listWidget.addItem("CPU Available Frequencies\t" + g.strip())

                g = gn_functions.funcProcInfo()
		self.listWidget.addItem("Processor Information \t" + g.strip())
				
		g = gn_functions.funcN900Board()
		self.listWidget.addItem("N900 Board \t\t\t" + g.strip())
		
		g = gn_functions.funcBoardVer()
		self.listWidget.addItem("N900 Board Ver \t\t" + g.strip())

		g = gn_functions.funcSysLocale()
		self.listWidget.addItem("System Locale \t\t" + g.strip())

		g = gn_functions.funcBootCount()
		self.listWidget.addItem("Boot Count \t\t\t" + g.strip())

		g = gn_functions.funcFMTrans()
		self.listWidget.addItem("FM Trans Strength \t\t" + g.strip())

		g = gn_functions.funcBootReason()
		self.listWidget.addItem("Boot Reason \t\t\t" + g.strip())

		g = gn_functions.funcCamState()
		self.listWidget.addItem("Camera Shutter State \t" + g.strip())

		g = gn_functions.funcKeySlider()
		self.listWidget.addItem("Keyboard Slider State \t" + g.strip())

		g = gn_functions.funcProxState()
		self.listWidget.addItem("Proximity Sensor State \t" + g.strip())

		g = gn_functions.funcHeadphoneState()
		self.listWidget.addItem("Headphone State \t\t" + g.strip())

		g = gn_functions.funcBattcurr()
		self.listWidget.addItem("Battery Current \t\t" + g.strip())
		
		g = gn_functions.funcBatLastChrg()
		self.listWidget.addItem("Battery Last Charge \t\t" + g.strip())

		g = gn_functions.funcBatchrg()  
		self.listWidget.addItem("Battery Charge \t\t" + g.strip())

		g = gn_functions.funcSysUptime()
		self.listWidget.addItem("System Uptime \t\t" + g.strip())

		g = gn_functions.funcSysLoad()
		self.listWidget.addItem("System Load \t\t\t" + g.strip())

		g = gn_functions.funcMaemoVersion()
		self.listWidget.addItem("Firmware Version \t\t" + str(g))

		g = gn_functions.funcAccel()
		self.listWidget.addItem("Accelerometer \t\t" + g)

                g = gn_functions.funcDevOri()
                self.listWidget.addItem("Device Orientation \t\t" + g)

                g = gn_functions.funcCPUMinMax()
                self.listWidget.addItem("CPU Min / Max Frequencies \t" + g)
                
                g = gn_functions.FMTxState()
                self.listWidget.addItem("FM Trans State \t\t" + g)
                g = gn_functions.FMTxFrequency()
                self.listWidget.addItem("FM Trans Frequency \t\t" + str(g))
                g = gn_functions.FMTxStartable()
                self.listWidget.addItem("FM Trans Startable? \t\t" + g)
                

	def funcUpdateAll(self):
		print " ** Running Update ALL**"
		progress = QtGui.QProgressDialog("Please Wait", "Cancel", 0, 100, MainWindow)
		progress.setWindowModality(QtCore.Qt.WindowModal)
		progress.setAutoReset(True)
		progress.setAutoClose(True)
		progress.setMinimum(0)
		progress.setMaximum(100)
		progress.resize(800,220)
		progress.setWindowTitle("Loading Healthcheck")
		progress.show()
		progress.setFont(QtGui.QFont('OldEnglish', 24,QtGui.QFont.Bold,QtGui.QFont.AllUppercase))

		QtGui.QApplication.processEvents()
		time.sleep(0.1)
                progress.setValue(0)

                print " ** Running tab1 update ** "
                self.listWidget.clear()
                progress.setValue(33)
                progress.setWindowTitle("Loading Healthcheck - System Tab")
                QtGui.QApplication.processEvents()
                self.funcSystemTab()
                time.sleep(0.1)
                progress.setValue(45)
                QtGui.QApplication.processEvents()
                time.sleep(0.1)
                self.listWidget.sortItems()
                print " ** Finished tab 1 update **"

                print " ** Starting tab 2 update**"
		self.listWidget2.clear()
		self.updateGPS(MainWindow)
		progress.setWindowTitle("Loading Healthcheck - GPS")
		QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(66)
		self.Cellular(MainWindow)
		progress.setWindowTitle("Loading Healthcheck - Cell/Phone")
		QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(90)
		self.funcCommsInfo()
		QtGui.QApplication.processEvents()
		progress.setWindowTitle("Loading Healthcheck - Networks")
		progress.setValue(95)
                QtGui.QApplication.processEvents()
                time.sleep(0.3)
                self.listWidget2.sortItems()
                QtGui.QApplication.processEvents()
                progress.setValue(100)
                time.sleep(0.1)
                progress.hide()
                print " ** Finished tab 2 update **"

	
	# This is the start of the QT Designer translation function - not using the translation function, but left it in, to show it is part of the class   
	def retranslateUi(self, MainWindow):
		MainWindow.setWindowTitle(QtGui.QApplication.translate("MainWindow", "HealthCheck", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab), QtGui.QApplication.translate("MainWindow", "System ", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_2), QtGui.QApplication.translate("MainWindow", "Comms ", None, QtGui.QApplication.UnicodeUTF8))
		#self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), QtGui.QApplication.translate("MainWindow", "Apps", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), QtGui.QApplication.translate("MainWindow", "Tools ", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_4), QtGui.QApplication.translate("MainWindow", "About ", None, QtGui.QApplication.UnicodeUTF8))
		
                # Cell_info - Taken from netmon code. Need to figure out the author so i can give proper thanks!
                # can be found here - http://repository.maemo.org/extras-devel/pool/fremantle/free/source/n/netmon/
	def Cellular(self,MainWindow):
		print " ** Starting Cellular*"
		regstatus = gn_cellinfo.RegStatus()
		signalstrength = gn_cellinfo.SignalStrength()

		if (regstatus[0] == 0): status = 'home'
		elif (regstatus[0] == 1): status = 'roam'
		elif (regstatus[0] == 2): status = 'roam_blink'
		elif (regstatus[0] == 3): status = 'no serv.'
		elif (regstatus[0] == 4): status = 'no serv. search'
		elif (regstatus[0] == 5): status = 'no serv. no search'
		elif (regstatus[0] == 6): status = 'no sim'
		elif (regstatus[0] == 8): status = 'power off'
		elif (regstatus[0] == 9): status = 'nsps'
		elif (regstatus[0] == 10): status = 'nsps no cover.'
		elif (regstatus[0] == 10): status = 'sim rejected'
		else: status = 'unknown'

		if (regstatus[5] == 0): network_type = 'home'
		elif (regstatus[5] == 1): network_type = 'preferred'
		elif (regstatus[5] == 2): network_type = 'forbidden'
		elif (regstatus[5] == 2): network_type = 'other'
		else: network_type = 'no network'

		services = ""
		if (regstatus[6] & 0x02): services += 'CS '
		if (regstatus[6] & 0x01): services += 'GPRS '
		if (regstatus[6] & 0x04): services += 'EGPRS '
		if (regstatus[6] & 0x08): services += 'HSDPA '
		if (regstatus[6] & 0x10): services += 'HSUPA'
		fraction = 1.0 / 100 * signalstrength[0]
		text = " - %d dBm" % signalstrength[1]

		self.listWidget2.addItem("Phone Signal \t\t" + text.strip())
		cell_id = regstatus[2] & 65535
		cell_rnc = regstatus[2] >> 16
		   
		self.listWidget2.addItem("Cell RNC \t\t" + str(cell_rnc).strip())
		self.listWidget2.addItem("Cell Status \t\t" + status)
		self.listWidget2.addItem("Cell ID \t\t" + str(cell_id).strip())
		self.listWidget2.addItem("Cell Services \t\t" + services)
		print " ** Finishing Cellular **"

                # This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
                # Moved out of the class by me
                # Funtion - update GPS - Using lib-location
	def updateGPS(self, MainWindow):
		print "** Updating GPS Info**"
		global var_g_GPS
		# Start of the GPS Location information
		# Please visit here for more information and code on PyMaemo GPS API - http://wiki.maemo.org/PyMaemo/Using_Location_API
		loop = gobject.MainLoop()
		control = location.GPSDControl.get_default()
		device = location.GPSDevice()
                #control.set_properties(preferred_method=location.METHOD_GNSS|location.METHOD_AGNSS,preferred_interval=location.INTERVAL_DEFAULT)
		control.set_properties(preferred_method=location.METHOD_USER_SELECTED,preferred_interval=location.INTERVAL_DEFAULT)
		control.connect("error-verbose", on_error, loop)
		device.connect("changed", on_changed, control)
		control.connect("gpsd-stopped", on_stop, loop)
		gobject.idle_add(start_location, control)
		loop.run()
		self.listWidget2.addItem("GPS Position \t\t" + var_g_GPS.strip())
		
def on_error(control, error, user_data):
	print " ** Starting on error cellular function **"
	if error == location.ERROR_USER_REJECTED_DIALOG:
		print "User didn't enable requested methods"
	elif error == location.ERROR_USER_REJECTED_SETTINGS:
		print "User changed settings, which disabled location"
	elif error == location.ERROR_BT_GPS_NOT_AVAILABLE:
		print "Problems with BT GPS"
	elif error == location.ERROR_METHOD_NOT_ALLOWED_IN_OFFLINE_MODE:
		print "Requested method is not allowed in offline mode"
	elif error == location.ERROR_SYSTEM:
		print "System error"
	control.stop()
	user_data.quit()
        #data.quit()
		
# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, partially commented by me
# Moved out of the class by me
def on_changed(device, data):
	print " ** GPS On Changed function"
	global var_g_GPS
	if not device:
		var_g_GPS = "No GPS Found"
		return
        for i in range(1, 10):
                if device.fix:
                        if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                                #Set our global variable as the location information! - scroll backup to see where it was used
                                var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
                                #Seems to struggle with doing it once.... so do it 5 times to warm it up!
                        
                                if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                                        var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
                                print var_g_GPS
	data.stop()
	print " ** Stopped GPS Fix **"

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def on_stop(control, data):
	print " ** Quitting data fix **"
	data.quit()

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def start_location(data):
	print " ** Starting data fix**"
	data.start()
	return False


# Start the main program/function
if __name__ == "__main__":
	print " ** Starting Main **"
	print " ** app = QtGui App** - Running app = QtGui.QApplication(sys.argv) **"
	app = QtGui.QApplication(sys.argv)
	print " ** Setting Main Window**"
	MainWindow = QtGui.QMainWindow()
	print "** Setting tool window #1**"
	win = healthcheckWindow(MainWindow)
	win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
	win.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
	print "** Setting tool window #2**"
	aui = aMainWindow(MainWindow)
	aui.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
	aui.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
	print "** Setting Video window**"
	imagewin = camerasClass(MainWindow)
	imagewin.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
	imagewin.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)

	print " ** Declare the UI**"
	ui = Ui_MainWindow()
	print " ** Draw everything and start the main function**"
	ui.setupUi(MainWindow)
	print " ** Show everything**"
	MainWindow.show()
	print " ** Waiting for quit signal - healthcheck loaded **"
	ui.funcUpdateAll()
	sys.exit(app.exec_())
	print " ** sys.exit called**"

