#!/usr/bin/python
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
import pypackager
import os

if __name__ == "__main__":
    try:
        os.chdir(os.path.dirname(sys.argv[0]))
    except:
        pass

    p=pypackager.PyPackager("healthcheck")
    p.version='1.2.0'
    p.buildversion='3'
    p.display_name='HealthCheck'
    p.description=" Health Check, A system information viewer and testing tools, such as dead pixel, accuracy, sound, LED, vibrate and camera tests. \n The Comms tab shows GPS, device, bluetooth and WIFI information. \n Developed for the Nokia N900 & Maemo 5 \n"
    p.author="Greg Roberts"
    p.maintainer="Noobmonkey"
    p.email="me@Greg-Roberts.com"
    p.depends = "python2.5, python2.5-qt4-gui, python2.5-qt4-core, python-dbus, python2.5-gtk2, python-location, gstreamer-tools, pulseaudio-utils,  python-hildon, pyside-qt4-core, pyside-qt4-gui"
    p.section="user/utilities"
    p.arch="all"
    p.urgency="low"
    p.bugtracker='https://bugs.maemo.org/describecomponents.cgi?product=Healthcheck'
    p.distribution="fremantle"
    p.repository="extras-devel"
    p.icon='/home/user/MyDocs/healthcheck/healthcheck.png'
    p.changelog="fixed version release reading \n\n" 

    dir_name = "src"            #Name of the subfolder containing your package source files (e.g. usr\share\icons\hicolor\scalable\myappicon.svg, usr\lib\myapp\somelib.py). We suggest to leave it named src in all projects and will refer to that in the wiki article on maemo.org
    #Thanks to DareTheHair from talk.maemo.org for this snippet that recursively builds the file list 
    for root, dirs, files in os.walk(dir_name):
        real_dir = root[len(dir_name):]
        fake_file = []
        for f in files:
            fake_file.append(root + os.sep + f + "|" + f)
        if len(fake_file) > 0:
            p[real_dir] = fake_file

    

    print p.generate(build_binary=False,build_src=True)
    #print p.generate(build_binary=True,build_src=False
