#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Application Name - Health Check V1.1.1-0
# Date 17 February 2010
# Author - Greg Roberts (Noobmonkey @ Maemo Talk)
# Contact - Me@Greg-roberts.com
#
# Developed using QT Designer, Eric4, Python GUI and the Nokia N900
# Designed to be used on Maemo 5 (Nokia N900)
#
# This is my first ever N900 application, so please excuse the poor coding!
#
#
# Talk/Bugs : http://talk.maemo.org/showthread.php?t=45453
#
# Import the libraries needed in this program
# import PyQt4 & sys
print "***** Start Imports *****"
try:
        print "** Importing qtcore & gui **"
	from PyQt4 import QtCore, QtGui
        print "** Importing ui.touchstub - accuracy tool **"
	from ui.touchstub import aMainWindow
        print "** Importing sys **"
	import sys
	print "** Importing commands **"
	import commands
	print "** Importing os **"  
	import os
	print "** Importing os.path **"
	import os.path
	print "** Importing subprocess **"
	import subprocess
        print "** Importing dbus.glib **"
	import dbus.glib
        print "** Importing Start location**"
	import location
        print "** Importing Cellinfo **"
	import gn_cellinfo
        print "** Importing Hildon **"
	import hildon
	print "** Importing Threading **"
	from threading import Thread
	print "** Importing Time **"
	import time
	print "** Importing GTK **"
	import gtk
        print "** Initialize Threads(GTK) **"
	gtk.gdk.threads_init()
        print "** Importing Gobject **"
	import gobject
	print "***** Finish Imports *****"
except ImportError, err:
        print "couldn't load module. %s" % (err)
        sys.exit(2)



# Set a global variable - used to send the GPS info from a function back onto its label in the GUI. I'm sure there is a much better way returning
# the variable in a function, but this works.... Example: http://www.wellho.net/resources/ex.php4?item=y105/locvar.py
# Setting it to "location" for now.

# Location of the DPKG files
dpkg_dir = '/var/lib/dpkg'

# Global variables
print "** Seting global variables **"
var_g_GPS = "No GPS lock"
bname = "Move R"
name_lookup = {}
rootfs_id = ''


class camerasClass(QtGui.QMainWindow):

	def __init__(self, *args):
		
		apply(QtGui.QMainWindow.__init__, (self,) + args)
		print "** Set basic color on rectangle **"
		self.color = QtGui.QColor(0, 0, 0) 
		print "** Setting window details and loading form**"
		self.setGeometry(0, 0, 800, 480)
		self.setWindowTitle('Front Camera Image')
		self.lblCameraImage = QtGui.QLabel(self)
		self.lblCameraImage.setGeometry(QtCore.QRect(160, 10, 455, 341))
		self.lblCameraImage.setFrameShape(QtGui.QFrame.Panel)
		self.lblCameraImage.setFrameShadow(QtGui.QFrame.Raised)
		self.lblCameraImage.setLineWidth(2)
		self.lblCameraImage.setMidLineWidth(1)
		self.lblCameraImage.setScaledContents(True)
		self.lblCameraImage.setObjectName("lblCameraImage")

		
		# Setup and draw the button
		self.pushButton_cam = QtGui.QPushButton(self)
		self.pushButton_cam.setGeometry(QtCore.QRect(10, 380, 331, 71))
		self.pushButton_cam.setObjectName("pushButton_cam")
		self.pushButton_cam.setText("Front camera")
		# Tell the button what to do when it is clicked.
		QtCore.QObject.connect(self.pushButton_cam, QtCore.SIGNAL('clicked()'), self.updateTab3)

		# Setup and draw the button
		self.pushButton_cam2 = QtGui.QPushButton(self)
		self.pushButton_cam2.setGeometry(QtCore.QRect(350, 380, 331, 71))
		self.pushButton_cam2.setObjectName("pushButton_cam2")
		self.pushButton_cam2.setText("Back camera")
		# Tell the button what to do when it is clicked.
		QtCore.QObject.connect(self.pushButton_cam2, QtCore.SIGNAL('clicked()'), self.updateTab3a)

		self.exitb = QtGui.QPushButton('X', self)
		self.exitb.setGeometry(QtCore.QRect(690, 380, 101, 71))
		self.connect(self.exitb, QtCore.SIGNAL('clicked()'), self.close)


	def updateTab3(self):
		print " ** Starting update3**"
		self.pushButton_cam.setEnabled(False)
		self.pushButton_cam.setText("....")
		self.updateImage()
		self.pushButton_cam.setText("Front camera")
		self.pushButton_cam.setEnabled(True)

	def updateTab3a(self):
		print " ** Starting update3a**"
		self.pushButton_cam2.setEnabled(False)
		self.pushButton_cam2.setText("....")
		self.updateImage2()
		self.pushButton_cam2.setText("Back Camera")
		self.pushButton_cam2.setEnabled(True)

	# Funtion - update the front camera image
	def updateImage(self):
		print "** Starting front camera function **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Front Camera', 'Point your screen camera at a light.', [], {}, 3000)
		b = None
		b = os.popen('gst-launch v4l2camsrc device=/dev/video1 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
		b.close ()
		image_file = "/home/user/MyDocs/fcamtest.jpg"
		image = QtGui.QPixmap(image_file)
		# Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
		self.lblCameraImage.setPixmap(image)
		print " ** Finished front camera function **"

	def updateImage2(self):
		print " ** Starting back camera function **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Back Camera', 'Checking Lens Cover and taking photo', [], {}, 3000)

		gl = os.popen('cat /sys/devices/platform/gpio-switch/cam_shutter/state').read()
		gl = gl.strip()

		if str(gl) == "closed":
			self.CloseDialog = QtGui.QMessageBox.question(None,"WARNING - Camera Shutter is Closed"," Please open the shutter and click yes when ready. \n Click no to cancel", QtGui.QMessageBox.Yes|QtGui.QMessageBox.No,QtGui.QMessageBox.No)
			if self.CloseDialog == QtGui.QMessageBox.Yes:
				print "** Please open the shutter and click yes when ready ** \n Click no to cancel"
				# Close b - the greatly named variable - as i want to use it again! (Well close or declare it!)
				b = None
				# X-term - grab 10 buffered front camera images, and throw them into an image file.
				# Everyone recommends 1.... but 10 gave more light! - so i used it :D
				b = os.popen('gst-launch v4l2camsrc device=/dev/video0 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
				b.close ()
				# Declare and set the image file name
				image_file = "/home/user/MyDocs/fcamtest.jpg"
				image = QtGui.QPixmap(image_file)
				# Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
				self.lblCameraImage.setPixmap(image)
				print " ** Finished Back camera function **"
			elif self.CloseDialog == QtGui.QMessageBox.No:
				print "** User pressed 'No' button - returning **"
		else:
			# Close b - the greatly named variable - as i want to use it again! (Well close or declare it!)
			b = None
			# X-term - grab 10 buffered front camera images, and throw them into an image file.
			# Everyone recommends 1.... but 10 gave more light! - so i used it :D
			b = os.popen('gst-launch v4l2camsrc device=/dev/video0 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
			b.close ()
			# Declare and set the image file name
			image_file = "/home/user/MyDocs/fcamtest.jpg"
			image = QtGui.QPixmap(image_file)
			# Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
			self.lblCameraImage.setPixmap(image)
			print " ** Finished Back camera function **"



		

class HelloWindow(QtGui.QMainWindow):

	def __init__(self, *args):
		apply(QtGui.QMainWindow.__init__, (self,) + args)
		print "** Starting Hellowindow Class **"
		#checkpkgs()
		global bname
		#self.Qt::WA_Maemo5StackedWindow 
		print "** Set basic color on rectangle **"
		self.color = QtGui.QColor(0, 0, 0) 
		print "** Setting window details and loading form**"
		self.setGeometry(0, 0, 800, 480)
		self.setWindowTitle('Dead Pixel Test')


		self.square = QtGui.QWidget(self)
		self.square.setGeometry(0, 0, 800, 480)
		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

		
		self.red = QtGui.QPushButton('Red', self)
		self.red.setCheckable(True)
		self.red.move(10, 10)
		self.connect(self.red, QtCore.SIGNAL('clicked()'), self.setRed)

		self.green = QtGui.QPushButton('Green', self)
		self.green.setCheckable(True)
		self.green.move(10, 60)
		self.connect(self.green, QtCore.SIGNAL('clicked()'), self.setGreen)

		self.blue = QtGui.QPushButton('Blue', self)
		self.blue.setCheckable(True)
		self.blue.move(10, 110)
		self.connect(self.blue, QtCore.SIGNAL('clicked()'), self.setBlue)

		self.moveb = QtGui.QPushButton('Move R', self)
		self.moveb.move(10, 160)
		self.connect(self.moveb, QtCore.SIGNAL('clicked()'), self.moveB)

		self.exitb = QtGui.QPushButton('Exit', self)
		self.exitb.move(10, 210)
		self.connect(self.exitb, QtCore.SIGNAL('clicked()'), self.exitB)
		print "** Completed Hellowindow Class load **"
 

	def moveB(self):
		print "** moving buttons **"
		global bname
		if bname == "Move R":
			bname = "Move L"
			self.moveb.setText("Move L")
			self.red.move(600, 10)
			self.green.move(600, 50)
			self.blue.move(600, 90)
			self.moveb.move(600, 130)
			self.exitb.move(600, 170)
		else:
			self.moveb.setText("Move R")
			bname = "Move R"
			self.red.move(10, 10)
			self.green.move(10, 50)
			self.blue.move(10, 90)
			self.moveb.move(10, 130)
			self.exitb.move(10, 170)
		print "** moved buttons**"
		

	def exitB(self):
		print "** Exiting Hellowindow Class - closing window **"
		self.connect(self.exitb, QtCore.SIGNAL('clicked()'), self.close)
		#MainWindow.show()
  
		
		

	def setRed(self):
		if self.red.isChecked():
			self.color.setRed(255)
		else: self.color.setRed(0)

		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

	def setGreen(self):
		if self.green.isChecked():
			self.color.setGreen(255)
		else: self.color.setGreen(0)

		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())

	def setBlue(self):
		if self.blue.isChecked():
			self.color.setBlue(255)
		else: self.color.setBlue(0)

		self.square.setStyleSheet("QWidget { background-color: %s }" % self.color.name())


		
class Ui_MainWindow(object):
	def setupUi(self, MainWindow):

		print "** start SetupUi**"
		# declaring the previous var_g_GPS location as a global in here, this allows it to be read in here.
		global var_g_GPS

		# Set the window / form name
		MainWindow.setObjectName("MainWindow")

		# Set the window size to W800 * H420 - the size of an N900's screen!
		MainWindow.resize(800, 420)

		# Set the current font to Arial 12
		font = QtGui.QFont()
		font.setFamily("Arial")
		font.setPointSize(12)
		# Set the Mainwindow to use this font
		MainWindow.setFont(font)

		



		
		# Not sure - QTDesigner did this bit - assuming it's loading up the form and a widget
		self.centralwidget = QtGui.QWidget(MainWindow)
		self.centralwidget.setObjectName("centralwidget")


		# Draw the Menubar
		fremantle = MainWindow.menuBar().addMenu("Update");
		act = fremantle.addAction("All")
		QtCore.QObject.connect(act, QtCore.SIGNAL("triggered()"), self.updateAll)
		actb = fremantle.addAction("System")
		QtCore.QObject.connect(actb, QtCore.SIGNAL("triggered()"), self.updateTab1)
		actc = fremantle.addAction("Comms")
		QtCore.QObject.connect(actc, QtCore.SIGNAL("triggered()"), self.updateTab2)
		#fremantle = MainWindow.menuBar().addMenu("Applications");
		#MainWindow.menuBar().addSeparator()
		#actd = fremantle.addAction("Apps")
		#QtCore.QObject.connect(actd, QtCore.SIGNAL("triggered()"), self.listpackages)
                

		# Creating the tab that i need for my application, and set it's size
		self.tabWidget = QtGui.QTabWidget(self.centralwidget)
		self.tabWidget.setGeometry(QtCore.QRect(0, 0, 800, 429))
		self.tabWidget.setStyleSheet("QTabWidget::pane { /* The tab widget frame */\
     border-top: 0px solid #C2C7CB;\
     position: absolute;\
     top: -0.2em;\
 }\
\
 QTabWidget::tab-bar {\
     alignment: center;\
 }\
\
 /* Style the tab using the tab sub-control. Note that\
     it reads QTabBar _not_ QTabWidget */\
 QTabBar::tab {\
     background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,\
                                 stop: 0 #006633, stop: 0.4 #006633,\
                                 stop: 0.5 ##006633, stop: 1.0 #006633);\
     border: 0px solid #C4C4C3;\
     border-bottom-color: #C2C7CB; /* same as the pane color */\
     border-top-left-radius: 2px;\
     border-top-right-radius: 2px;\
     min-width: 8ex;\
     padding: 0px;\
 }\
\
 QTabBar::tab:selected, QTabBar::tab:hover {\
     background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,\
                                 stop: 0 #fafafa, stop: 0.4 #f4f4f4,\
                                 stop: 0.5 #e7e7e7, stop: 1.0 #fafafa);\
 }\
\
 QTabBar::tab:selected {\
     border-color: #9B9B9B;\
     border-bottom-color: #C2C7CB; /* same as pane color */")
		# Set the font size. I've gone for big... very big - so they are finger friendly.
		font = QtGui.QFont()
		font.setPointSize(24)
		self.tabWidget.setFont(font)
		self.tabWidget.setObjectName("tabWidget")
		self.tab = QtGui.QWidget()
		self.tab.setObjectName("tab")

		#Reset the Fontsize - decided to go with Arial 18 for all objects on tab 1
		font = QtGui.QFont()
		font.setPointSize(18)

		self.listWidget = QtGui.QListWidget(self.tab)
		self.listWidget.setGeometry(QtCore.QRect(1, 0, 799, 361))
		self.listWidget.setObjectName("listWidget")
		self.listWidget.setFont(font)
		self.listWidget.setAlternatingRowColors(True)
		self.listWidget.setSizePolicy(QtGui.QSizePolicy.Minimum,QtGui.QSizePolicy.Minimum)
		self.listWidget.setResizeMode(QtGui.QListView.Adjust)
		QtCore.QObject.connect(self.listWidget, QtCore.SIGNAL("itemClicked(QListWidgetItem *)"), self.lclicked) 

               
		
		#QListView::item:selected:active {background: qlineargradient(x1: 0, y1: 0, x2: 0, y2: 1,stop: 0 #000000, stop: 1 #FFFFFF); }\		
		# Draw the Tab Contents
		self.tabWidget.addTab(self.tab, "")


		# Start on tab 2!
		self.tab_2 = QtGui.QWidget()
		self.tab_2.setObjectName("tab_2")

		self.listWidget2 = QtGui.QListWidget(self.tab_2)
		self.listWidget2.setGeometry(QtCore.QRect(1, 0, 799, 361))
		self.listWidget2.setObjectName("listWidget2")
		self.listWidget2.setFont(font)
		self.listWidget2.setAlternatingRowColors(True)
		self.listWidget2.setResizeMode(QtGui.QListView.Adjust)

		# Show the tab and draw contents
		self.tabWidget.addTab(self.tab_2, "")
		

		# Show the tab and draw contents
		#self.tabWidget.addTab(self.tab_3, "")

		# Start on tab 4!
		self.tab_3 = QtGui.QWidget()
		self.tab_3.setObjectName("tab_3")

		self.pushButton_snd1 = QtGui.QPushButton(self.tab_3)
		self.pushButton_snd1.setGeometry(QtCore.QRect(10, 10, 391, 51))
		self.pushButton_snd1.setObjectName("pushButton_snd1")
		self.pushButton_snd1.setText("Test Sound")
		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		QtCore.QObject.connect(self.pushButton_snd1, QtCore.SIGNAL('clicked()'), self.updatesound)

		self.pushButton_led = QtGui.QPushButton(self.tab_3)
		self.pushButton_led.setGeometry(QtCore.QRect(10, 70, 391, 51))
		self.pushButton_led.setObjectName("pushButton_led")
		self.pushButton_led.setText("Test LEDs")
		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		QtCore.QObject.connect(self.pushButton_led, QtCore.SIGNAL('clicked()'), self.updateLED)

		self.pushButton_von = QtGui.QPushButton(self.tab_3)
		self.pushButton_von.setGeometry(QtCore.QRect(10, 130, 391, 51))
		self.pushButton_von.setObjectName("pushButton_von")
		self.pushButton_von.setText("Test Vibrate")
		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		QtCore.QObject.connect(self.pushButton_von, QtCore.SIGNAL('clicked()'), self.vibrateon)

		self.xyscreen = QtGui.QPushButton(self.tab_3)
		self.xyscreen.setGeometry(QtCore.QRect(10, 190, 391, 51))
		self.xyscreen.setObjectName("xyscreen")
		self.xyscreen.setText("Accuracy Test")
		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		QtCore.QObject.connect(self.xyscreen, QtCore.SIGNAL('clicked()'), self.show_new_window2)

		# Setup and draw the button
		self.pushButton_cama = QtGui.QPushButton(self.tab_3)
		self.pushButton_cama.setGeometry(QtCore.QRect(10, 250, 391, 51))
		self.pushButton_cama.setObjectName("pushButton_cama")
		self.pushButton_cama.setText("Camera Tests")
		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		QtCore.QObject.connect(self.pushButton_cama, QtCore.SIGNAL('clicked()'), self.updateimage)
		
		# Setup and draw the button
		self.pushButton_reboot = QtGui.QPushButton(self.tab_3)
		self.pushButton_reboot.setGeometry(QtCore.QRect(10, 310, 391, 51))
		self.pushButton_reboot.setObjectName("pushButton_reboot")
		self.pushButton_reboot.setText("System Reboot")
		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		QtCore.QObject.connect(self.pushButton_reboot, QtCore.SIGNAL('clicked()'), self.reboot_sys)


		self.sound_lst = QtGui.QComboBox(self.tab_3)
		self.sound_lst.setGeometry(QtCore.QRect(400, 10, 391, 51))
		self.sound_lst.setObjectName("sound_lst")
		for f in os.listdir("/usr/share/sounds/"):
			#print f[-3:]
			if f[-3:] == "wav":
				self.sound_lst.addItem(f)
		#self.sound_lst.addItem("PatternIncomingCall")

		self.combo_led = QtGui.QComboBox(self.tab_3)
		self.combo_led.setGeometry(QtCore.QRect(400, 70, 391, 51))
		self.combo_led.setObjectName("combo_led")
		self.combo_led.addItem("PatternError")
		self.combo_led.addItem("PatternPowerOn")
		self.combo_led.addItem("PatternPowerOff")
		self.combo_led.addItem("PatternCommunicationCall")
		self.combo_led.addItem("PatternCommunicationSMS")

		self.vibra_led = QtGui.QComboBox(self.tab_3)
		self.vibra_led.setGeometry(QtCore.QRect(400, 130, 391, 51))
		self.vibra_led.setObjectName("vibra_led")
		self.vibra_led.addItem("PatternIncomingCall")
		self.vibra_led.addItem("PatternIncomingMessage")
		#self.vibra_led.addItem("PatternPowerKeyPress")
		#self.vibra_led.addItem("PatternTouchScreen")
		self.vibra_led.addItem("PatternChatAndEmail")

		self.color_test = QtGui.QPushButton(self.tab_3)
		self.color_test.setGeometry(QtCore.QRect(400, 190, 391, 51))
		self.color_test.setObjectName("color_test")
		self.color_test.setText("Dead Pixel Test")
		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		QtCore.QObject.connect(self.color_test, QtCore.SIGNAL('clicked()'), self.show_new_window)


		# Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
		#QtCore.QObject.connect(self.pushButton_von, QtCore.SIGNAL('clicked()'), self.vibrateon)

		self.tabWidget.addTab(self.tab_3, "")

		# Start on tab 5!
		self.tab_4 = QtGui.QWidget()
		self.tab_4.setObjectName("tab_4")

		# Create the text browser to show the large console input
		# I have used this to show i could get the information in to begin with... I will eventually parse this information and put it into a list
		# box of some sort
		self.textBrowser = QtGui.QTextBrowser(self.tab_4)
		self.textBrowser.setGeometry(QtCore.QRect(0, 10, 781, 301))
		self.textBrowser.setText (" Health Check V1.1.1-0 \n Greg Roberts (Maemo.org - Noobmonkey) \n me@greg-roberts.com \n \n For Bugs and Feature requests: \n http://talk.maemo.org/showthread.php?p=541457 \n\n Thanks to: Mikec, Rob1n, Lcuk, W00t_ & MohammadAG.\n Many more people have helped by testing and offering support, so Thank You. \n \n April 2010.")
		# Make the font small!!!
		font = QtGui.QFont()
		font.setPointSize(20)
		self.textBrowser.setFont(font)
		self.tabWidget.addTab(self.tab_4, "")

		# Draw the main Window
		MainWindow.setCentralWidget(self.centralwidget)
		
		# Run the translate UI - Added by QT Designer - i have removed alot of setText's and placed them above.
		print "** Run retranslateUi **"
		self.retranslateUi(MainWindow)
		#self.updateTab1()
		
		# Set which tab you want showing on program load
		print "** Show tab1 (0) **"
		self.tabWidget.setCurrentIndex(0)
		QtCore.QMetaObject.connectSlotsByName(MainWindow)

	def lclicked(self):
                #print self.listWidget.currentRow()
                #print self.listWidget.selectedItems()
                selected_items = ", ".join([str(item.text()) for item in self.listWidget.selectedItems()])
                sela = selected_items.split('\t')
                print "selected:", sela[0].strip()

                if sela[0].strip() == "Accelerometer":
                        print " ** Getting accel co-ords**"
                        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r')
                        coords = [int(w) for w in f.readline().split()]
                        f.close()
                        print " ** Getting orientation**"
                        b = None
                        b = os.popen('run-standalone.sh dbus-send --system --type=signal /com/nokia/mce/signal com.nokia.mce.signal.sig_device_orientation_ind').read()
                        coords = str(coords)
                        jaccel = str(coords) + str(b)
                        self.listWidget.currentItem().setText("Accelerometer \t\t\t" + jaccel)
                elif sela[0].strip() == "Battery Charge":
                        print " ** Getting battery charge**"
                        gl = os.popen('hal-device bme | awk \'/l.p/ {perc = $3}; /s_c/ {isch = $3} END if (isch == "false") {print perc" %"} else {print "Charging"}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Battery Charge \t\t" + gl.strip())
                elif sela[0].strip() == "Battery Current":
                        print " ** Getting battery mAh info**"
                        gl = os.popen('hal-device bme | awk \'/g.c/ {print $3" mAh"}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Battery Current \t\t" + gl.strip())
                elif sela[0].strip() == "Camera Shutter State":
                        print " ** Getting Cam Shutter State**"
                        gl = os.popen('cat /sys/devices/platform/gpio-switch/cam_shutter/state').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Camera Shutter State \t\t" + gl.strip())
                elif sela[0].strip() == "FM Trans Strength":
                        print " ** Getting FM Transmitter power level **"
                        ge = os.popen('cat /sys/class/i2c-adapter/i2c-2/2-0063/power_level').read()
                        ge = ge.strip()
                        self.listWidget.currentItem().setText("FM Trans Strength \t\t" + ge.strip())
                elif sela[0].strip() == "Headphone State":
                        print " ** Getting headphone state**"
                        gl = os.popen('cat /sys/devices/platform/gpio-switch/headphone/state').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Headphone State \t\t" + gl.strip())
                elif sela[0].strip() == "Keyboard Slider State":
                        print " ** Getting Keyboard Slider State**"
                        gl = os.popen('cat /sys/devices/platform/gpio-switch/slide/state').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Keyboard Slider State \t\t" + gl.strip())
                elif sela[0].strip() == "Proximity Sensor State":
                        print " ** Getting proximity sensor state**"
                        gl = os.popen('cat /sys/devices/platform/gpio-switch/proximity/state').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Proximity Sensor State \t" + gl.strip())
                elif sela[0].strip() == "System Uptime":
                        print " ** Getting system uptime**"
                        ge = os.popen('uptime | sed -e \'s/.*p *//\' -e \'s/, l.*//\' -e \'s/  / /\'').read()
                        self.listWidget.currentItem().setText("System Uptime \t\t" + ge.strip())
                elif sela[0].strip() == "CPU Current Freq":
                        print " ** Getting CPU Frequency **"
                        QtGui.QApplication.processEvents()
                        time.sleep(0.2)
                        gl = os.popen('echo $((`cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq`/1000)) MHz').read()
                        QtGui.QApplication.processEvents()
                        time.sleep(0.2)
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("CPU Current Freq \t\t" + gl.strip())
                elif sela[0].strip() == "App/Home % Used":
                        print " ** Getting App Space **"
                        gl = os.popen('df /home | awk \'/ho/ {print $5}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("App/Home % Used \t\t" + gl.strip())
                elif sela[0].strip() == "App/Home Free":
                        print " ** Getting App MB Free **"
                        gl = os.popen('df -h /home | awk \'/ho/ {print $4}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("App/Home Free \t\t" + gl.strip())
                elif sela[0].strip() == "Backlight Actual Level":
                        print " ** Getting Backlight Info **"
                        gl = os.popen('cat /sys/class/backlight/acx565akm/brightness').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Backlight Actual Level \t\t" + gl.strip())
                elif sela[0].strip() == "Backlight Max Level":
                        print " ** Getting Backlight Info MAX **"
                        gl = os.popen('cat /sys/class/backlight/acx565akm/max_brightness').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Backlight Max Level \t\t" + gl.strip())
                elif sela[0].strip() == "Battery Last Charge":
                        print " ** Getting battery mAh info2**"
                        gl = os.popen('hal-device bme | awk \'/g.la/ {print $3" mAh"}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Battery Last Charge \t\t" + gl.strip())
                elif sela[0].strip() == "Boot Count":
                        print " ** Getting boot count**"
                        gd = os.popen('cat /var/lib/dsme/boot_count').read()
                        gd = gd.strip()
                        self.listWidget.currentItem().setText("Boot Count \t\t\t" + gd.strip())
                elif sela[0].strip() == "Boot Reason":
                        print " ** Getting Boot Reason**"
                        gl = os.popen('cat /proc/bootreason').read()
                        gl = gl.strip()	
                        self.listWidget.currentItem().setText("Boot Reason \t\t\t" + gl.strip())
                elif sela[0].strip() == "MMC Cover State":
                        print " ** Getting MMC Cover/latch **"
                        gl = os.popen('cat /sys/class/mmc_host/mmc0/cover_switch').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("MMC Cover State \t\t" + gl.strip())
                elif sela[0].strip() == "Memory Card % Used":
                        print " ** Getting MMC Space **"
                        gl = os.popen('df /media/mmc1 | awk \'/mm/ {print $5}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Memory Card % Used \t\t" + gl.strip())
                elif sela[0].strip() == "Memory Card Free":
                        print " ** Getting MMC MB Free **"
                        gl = os.popen('df -h /media/mmc1 | awk \'/mm/ {print $4}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Memory Card Free \t\t" + gl.strip())
                elif sela[0].strip() == "MyDocs % Used":
                        print " ** Getting myDocs % Used **"
                        gl = os.popen('df /home/user/MyDocs | awk \'/My/ {print $5}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("MyDocs % Used \t\t" + gl.strip())
                elif sela[0].strip() == "MyDocs Free":
                        print " ** Getting myDocs MB Free **"
                        gl = os.popen('df -h /home/user/MyDocs | awk \'/My/ {print $4}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("MyDocs Free \t\t\t" + gl.strip())
                elif sela[0].strip() == "Rootfs % Used":
                        print " ** Getting rootfs % used **"
                        gl = os.popen('df | awk \'$1 == "rootfs" {print $5}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Rootfs % Used \t\t\t" + gl.strip())
                elif sela[0].strip() == "Rootfs Free":
                        print " ** Getting rootfs free MB **"
                        gl = os.popen('df -h | awk \'$1 == "rootfs" {print $4}\'').read()
                        gl = gl.strip()
                        self.listWidget.currentItem().setText("Rootfs Free \t\t\t" + gl.strip())
                elif sela[0].strip() == "System Load":
                        print " ** Getting load from uptime**"
                        ge = os.popen('uptime | sed \'s/.*e: //\'').read()
                        self.listWidget.currentItem().setText("System Load \t\t\t" + ge.strip())
                else:
                        print "else", sela[0].strip()
                

        


	def show_new_window(self):           
		win.show()
		win.showFullScreen()

	def show_new_window2(self):  
		aui.show()
		aui.showFullScreen()
		
	def updateimage(self):  
		imagewin.show()
		imagewin.showFullScreen()

	def listpackages(self):

		self.listApps.clear()
		self.checkpkgs()
		self.listApps.sortItems()

	def cpufreq(self):
		print " ** Opening CPU Frequency File**"
		fh = open("/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies","r")
		igot = fh.readlines()
		print " ** Adding CPUQ Frequencies **"
		aa = ""
		counter = 0
		for line in igot:
                        s = line.split()
                        for words in s:
                                counter = counter +1
                                if counter == 5:
                                        aa = str(aa) +"\n \t\t\t\t"
                                if counter == 9:
                                        aa = str(aa) +"\n \t\t\t\t"

                                print words
                                aa = str(aa) + str((int(words)/1000)) + "MHz, "

                print aa
                aa = aa.strip()[:-1]
                print "**",aa,"**"
                self.listWidget.addItem("CPU Frequencies \t\t" + aa)
                                	
		
		
# Funtion - update GPS - Using lib-location
	def updateGPS(self, MainWindow):
		print "** Updating GPS Info**"
		global var_g_GPS
		global var_g_ALT
		
		# Start of the GPS Location information
		# Please visit here for more information and code on PyMaemo GPS API - http://wiki.maemo.org/PyMaemo/Using_Location_API

		loop = gobject.MainLoop()
		control = location.GPSDControl.get_default()
		device = location.GPSDevice()
		control.set_properties(preferred_method=location.METHOD_USER_SELECTED,preferred_interval=location.INTERVAL_DEFAULT)
		control.connect("error-verbose", on_error, loop)
		device.connect("changed", on_changed, control)
		control.connect("gpsd-stopped", on_stop, loop)
		gobject.idle_add(start_location, control)
		loop.run()

		# Set the GPS tabel text       
		#self.lbl_Alt_Info.setText(var_g_ALT)
		self.listWidget2.addItem("GPS Position \t\t" + var_g_GPS.strip())
		al = '/sbin/ifconfig | grep inet | grep -v 127.0.0.1 | awk \'{split($2,a,":");print a[2]}\''



	def reboot_sys(self):
		print "** reboot function running**"
		self.CloseDialog = QtGui.QMessageBox.question(None, "Time for a Reboot!","Do you really want to reboot?",QtGui.QMessageBox.Yes|QtGui.QMessageBox.No,QtGui.QMessageBox.No)
		if self.CloseDialog == QtGui.QMessageBox.Yes:
			print "** You pressed yes, rebooting **"
			b = None
			b = os.popen('run-standalone.sh dbus-send --system --type=method_call --dest="com.nokia.dsme" --print-reply "/com/nokia/dsme/request" com.nokia.dsme.request.req_reboot')
			b.close ()
		elif self.CloseDialog == QtGui.QMessageBox.No:
			print "** User pressed 'No' button - returning **"

	def updatesound(self):
		print "** Testing sounds! **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Sound Test', 'Testing Stero/Mono Sound', [], {}, 3000)
		print "** Starting Stereo Test **"
		bb = 'pacat --channels=2 ' + '/usr/share/sounds/' + self.sound_lst.currentText()
		bb = str(bb)
		print bb
		b = os.popen(bb)
		b.close ()
		print "** Starting Mono Test**"
		bb = 'pacat --channels=1 ' + '/usr/share/sounds/' + self.sound_lst.currentText()
		bb = str(bb)
		print bb
		b = os.popen(bb)
		b.close ()
			  

  
# Funtion - update Firmware version label
	def updateMaemoV(self):
		print " ** Getting firmware version **"
		# This one reads fremantle version number (Firmware)
		g = os.popen('dpkg -l "mp-fremantle-*"').read()

		g = g.strip()[-15:]
		g = str(g)
		g.strip()
		g.lstrip()
		g.rstrip()
		
		if g.strip() == "3.2010.02-8":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1.1")
		elif g.strip() == "3.2010.02-8.002":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1.1")
		elif g.strip() == "3.2010.02-8.001":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1.1")
		elif g.strip() == "2.2009.51-1":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1")
		elif g.strip() == "2009.51-1.203.2":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1 UK Generic Version")
		elif g.strip() == "2009.51-1.203.1":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1 UK Generic Version")
		elif g.strip() == "2009.51-1.205.1":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1 UK Vodafone Version")
		elif g.strip() == "2009.51-1.205.2":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1 UK Vodafone Version")
		elif g.strip() == "1.2009.44-1":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.01")
		elif g.strip() == "1.2009.42-11":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 - Initial public release ")
		elif g.strip() == "1.2009.42-11.002":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 USA Version")
		elif g.strip() == "1.2009.42-11.003":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 Mid-East/N-Africa Version")
		elif g.strip() == "1.2009.42-11.203":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
		elif g.strip() == "1.2009.42-11.203.0":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
		elif g.strip() == "1.2009.42-11.203.1":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
		elif g.strip() == "1.2009.42-11.203.2":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
		elif g.strip() == "1.2009.42-11.205":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
		elif g.strip() == "1.2009.42-11.205.0":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
		elif g.strip() == "1.2009.42-11.205.1":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
		elif g.strip() == "1.2009.42-11.205.2":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
		elif g.strip() == "1.2009.41-1":
			self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - Early Release Vanilla Variant")
		else:
		   self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " ")
		   print " ** Finished Maemo Version**"

# Funtion - update CPU Information
	def updateCPU(self):
		print " ** Getting CPU Info **"
		# This one reads fremantle version number (Firmware)
		ga = os.popen('cat /proc/cpuinfo | grep Processor').read()
		ga = ga.strip()[11:]		
		self.listWidget.addItem("Processor Information \t\t" + ga.strip())
				
		print " ** Getting board info**"
		gb = os.popen('cat /proc/cpuinfo | grep Hardware').read()
		gb = gb.strip()[11:]		
		self.listWidget.addItem("N900 Board \t\t\t" + gb.strip())
		
		print " ** Getting board info revision **"
		gj = os.popen('cat /proc/cpuinfo | grep Revision').read()
		gj = gj.strip()[11:]
		self.listWidget.addItem("N900 Board Revision \t\t" + gj.strip())

		print " ** Getting system locale**"
		gc = os.popen('locale | grep LANG').read()
		gc = gc.strip()[5:]
		self.listWidget.addItem("System Locale \t\t\t" + gc.strip())

		print " ** Getting boot count**"
		gd = os.popen('cat /var/lib/dsme/boot_count').read()
		gd = gd.strip()
		self.listWidget.addItem("Boot Count \t\t\t" + gd.strip())

		print " ** Getting FM Transmitter power level **"
		ge = os.popen('cat /sys/class/i2c-adapter/i2c-2/2-0063/power_level').read()
		ge = ge.strip()
		self.listWidget.addItem("FM Trans Strength \t\t" + ge.strip())

		print " ** Getting Boot Reason**"
		gl = os.popen('cat /proc/bootreason').read()
		gl = gl.strip()	
		self.listWidget.addItem("Boot Reason \t\t\t" + gl.strip())

		print " ** Getting Cam Shutter State**"
		gl = os.popen('cat /sys/devices/platform/gpio-switch/cam_shutter/state').read()
		gl = gl.strip()
		self.listWidget.addItem("Camera Shutter State \t\t" + gl.strip())

		print " ** Getting Keyboard Slider State**"
		gl = os.popen('cat /sys/devices/platform/gpio-switch/slide/state').read()
		gl = gl.strip()
		self.listWidget.addItem("Keyboard Slider State \t\t" + gl.strip())

		print " ** Getting proximity sensor state**"
		gl = os.popen('cat /sys/devices/platform/gpio-switch/proximity/state').read()
		gl = gl.strip()
		self.listWidget.addItem("Proximity Sensor State \t" + gl.strip())

		print " ** Getting headphone state**"
		gl = os.popen('cat /sys/devices/platform/gpio-switch/headphone/state').read()
		gl = gl.strip()
		self.listWidget.addItem("Headphone State \t\t" + gl.strip())

		print " ** Getting battery mAh info**"
		gl = os.popen('hal-device bme | awk \'/g.c/ {print $3" mAh"}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("Battery Current \t\t" + gl.strip())
		
		print " ** Getting battery mAh info2**"
		gl = os.popen('hal-device bme | awk \'/g.la/ {print $3" mAh"}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("Battery Last Charge \t\t" + gl.strip())

		print " ** Getting system uptime**"
		ge = os.popen('uptime | sed -e \'s/.*p *//\' -e \'s/, l.*//\' -e \'s/  / /\'').read()
		self.listWidget.addItem("System Uptime \t\t" + ge.strip())

		print " ** Getting load from uptime**"
		ge = os.popen('uptime | sed \'s/.*e: //\'').read()
		self.listWidget.addItem("System Load \t\t\t" + ge.strip())

 
		
	def updatenetname(self):
		print " ** Getting host name**"
		ga = os.popen('cat /etc/hostname').read()
		ga = ga.strip()
		self.listWidget2.addItem("Device Hostname \t" + ga.strip())

		#print " ** Getting IMEI**"
		#bb = 'run-standalone.sh dbus-send --system --print-reply --type=method_call --dest=com.nokia.phone.SIM /com/nokia/phone/SIM/security Phone.Sim.Security.get_imei'
		b = os.popen('run-standalone.sh dbus-send --system --print-reply --type=method_call --dest=com.nokia.phone.SIM /com/nokia/phone/SIM/security Phone.Sim.Security.get_imei').read()
		
		b = str(b)
		b = b.strip()
		#b = str(b)[:-15]
		b = str(b)[-27:]
		b = b.strip()
		b = str(b)[:-12]
		print b + "*"
		self.listWidget2.addItem("Device IMEI \t\t" + b.strip())
		#b.close()

		#b = os.popen('run-standalone.sh dbus-send --system --type=method_call --print-reply --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.get_registration_status').read()
		#b=str(b)
		#self.listWidget.addItem("Phone Registration \t" + b.strip())

		print " ** Getting IP INFO*"
		ga = os.popen('/sbin/ifconfig | awk \'/Bc/ {print $2}\' | cut -c6-').read()
		ga = ga.strip()
		self.listWidget2.addItem("IP Internal \t\t" + ga.strip())

		print " ** Getting Wireless Info*"
		ga = os.popen('cat /proc/net/wireless | awk \'/0/ {print $3}\' | awk -F. \'/./ {print $1" %"}\'').read()
		ga = ga.strip()
		self.listWidget2.addItem("WIFI Link Quality \t" + ga.strip())

		print " ** Getting Wireless Info RSSI*"
		ga = os.popen('cat /proc/net/wireless | awk \'/0/ {print $4" dBm"}\'').read()
		ga = ga.strip()
		self.listWidget2.addItem("WIFI RSSI \t\t" + ga.strip())
		
		print " ** Getting Wireless Info Noise*"
		ga = os.popen('cat /proc/net/wireless | awk \'/0/ {print $5}\' | awk -F. \'/./ {print $1" dBm"}\'').read()
		ga = ga.strip()
		self.listWidget2.addItem("WIFI Noise \t\t" + ga.strip())

		print " ** Getting MAC Address **"
		gl = os.popen('cat /sys/class/ieee80211/phy0/macaddress').read()
		gl = gl.strip()
		self.listWidget2.addItem("MAC Address \t\t" + gl.strip())

		print " ** Getting Bluetooth name **"
		gl = os.popen('grep \'^Name =\' /etc/bluetooth/main.conf').read()
		gl = gl.strip()[7:]
		self.listWidget2.addItem("Bluetooth Name \t" + gl.strip())

                #print " ****************************************************"
		#print " ** Getting external IP**"
		#ge = os.popen('wget -q -O - api.myiptest.com | awk -F"\"" \'{print $4}\'').read()
		#QtGui.QApplication.processEvents()
                #time.sleep(2.5)
		#self.listWidget2.addItem("External IP \t\t\t" + ge.strip())
                

	 

# Funtion - update battery information
	def updateBatt(self):

		print " ** Getting battery charge**"
		gl = os.popen('hal-device bme | awk \'/l.p/ {perc = $3}; /s_c/ {isch = $3} END if (isch == "false") {print perc" %"} else {print "Charging"}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("Battery Charge \t\t" + gl.strip())

# Funtion - update Accelerator information
	def updateAccel(self):
		#print " ** Importing dbus.glib **"
		#import dbus.glib
		#print " ** Glib done**"

		# set f to = the accellerometer co-ordinates
		# the co-ords need to be pulled out and split for easy reading
		# Close down the co-ord file once used (Only displaying static info, not updating yet)
		print " ** Getting accel co-ords**"
		f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r')
		coords = [int(w) for w in f.readline().split()]
		f.close()
		print " ** Getting orientation**"
		b = None
		b = os.popen('run-standalone.sh dbus-send --system --type=signal /com/nokia/mce/signal com.nokia.mce.signal.sig_device_orientation_ind').read()
		
		coords = str(coords)
		jaccel = str(coords) + str(b)
		
		self.listWidget.addItem("Accelerometer \t\t\t" + jaccel)
		
		#Bluetooth
		#print "performing inquiry..."
		#nearby_devices = bluetooth.discover_devices(lookup_names = True)
		#print "found %d devices" % len(nearby_devices)
		#for name, addr in nearby_devices:
			#print "  %s - %s" % (addr, name)

	def vibrateon(self):
		#print " ** importing dbus.glib**"
		#import dbus.glib
		#print " ** got dbus.glib**"

		print " ** testing vibrations**"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'Vibration TEST', 'Testing Vibrations', [], {}, 3000)
		# set f to = the accellerometer co-ordinates
		# the co-ords need to be pulled out and split for easy reading
		# Close down the co-ord file once used (Only displaying static info, not updating yet)
		
		bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'" + self.vibra_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
		bb = 'run-standalone.sh sleep 5'
		b = os.popen(bb)
		b.close()
		bb= 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_deactivate string:' + "\'" + self.vibra_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
		print " ** finished vibrations**"
		
	def updateLED(self):
		print " ** Starting LED Patterns**"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'LED TEST', 'Starting LED Test', [], {}, 3000)
		

		bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:' + "\'" + self.combo_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
		bb = 'run-standalone.sh sleep 4'
		b = os.popen(bb)
		b.close()
		bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:' + "\'" + self.combo_led.currentText() + "\'"
		bb = str(bb)
		b = os.popen(bb)
		b.close()
 
		b.close()
		print " ** Finished LED Patterns **"
		bus = dbus.SessionBus()
		proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
		interface.Notify('HealthCheck', 0, 'general_refresh', 'LED TEST', 'Completed LED Test', [], {}, 3000)


	def updaterootfs(self):
		print " ** Getting rootfs % used **"
		gl = os.popen('df | awk \'$1 == "rootfs" {print $5}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("Rootfs % Used \t\t\t" + gl.strip())

		print " ** Getting rootfs free MB **"
		gl = os.popen('df -h | awk \'$1 == "rootfs" {print $4}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("Rootfs Free \t\t\t" + gl.strip())

		print " ** Getting myDocs % Used **"
		gl = os.popen('df /home/user/MyDocs | awk \'/My/ {print $5}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("MyDocs % Used \t\t" + gl.strip())

		print " ** Getting myDocs MB Free **"
		gl = os.popen('df -h /home/user/MyDocs | awk \'/My/ {print $4}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("MyDocs Free \t\t\t" + gl.strip())

		print " ** Getting App Space **"
		gl = os.popen('df /home | awk \'/ho/ {print $5}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("App/Home % Used \t\t" + gl.strip())

		print " ** Getting App MB Free **"
		gl = os.popen('df -h /home | awk \'/ho/ {print $4}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("App/Home Free \t\t" + gl.strip())

		print " ** Getting MMC Space **"
		gl = os.popen('df /media/mmc1 | awk \'/mm/ {print $5}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("Memory Card % Used \t\t" + gl.strip())

		print " ** Getting MMC MB Free **"
		gl = os.popen('df -h /media/mmc1 | awk \'/mm/ {print $4}\'').read()
		gl = gl.strip()
		self.listWidget.addItem("Memory Card Free \t\t" + gl.strip())

		print " ** Getting CPU Frequency **"
		gl = os.popen('echo $((`cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq`/1000)) MHz').read()
		gl = gl.strip()
		self.listWidget.addItem("CPU Current Freq \t\t" + gl.strip())

		print " ** Getting Backlight Info **"
		gl = os.popen('cat /sys/class/backlight/acx565akm/brightness').read()
		gl = gl.strip()
		self.listWidget.addItem("Backlight Actual Level \t\t" + gl.strip())

		print " ** Getting Backlight Info MAX **"
		gl = os.popen('cat /sys/class/backlight/acx565akm/max_brightness').read()
		gl = gl.strip()
		self.listWidget.addItem("Backlight Max Level \t\t" + gl.strip())

		print " ** Getting Kernel Info **"
		gl = os.popen('cat /sys/kernel/vmcoreinfo').read()
		gl = gl.strip()
		self.listWidget.addItem("Kernel Core Info \t\t" + gl.strip())

		print " ** Getting MMC Cover/latch **"
		gl = os.popen('cat /sys/class/mmc_host/mmc0/cover_switch').read()
		gl = gl.strip()
		self.listWidget.addItem("MMC Cover State \t\t" + gl.strip())

		self.cpufreq()

	def updateAll(self):
                
		print " ** Running Update ALL**"
		progress = QtGui.QProgressDialog("Please Wait", "Cancel", 0, 100, MainWindow)
		progress.setWindowModality(QtCore.Qt.WindowModal)
		progress.setAutoReset(True)
		progress.setAutoClose(True)
		progress.setMinimum(0)
		progress.setMaximum(100)
		progress.resize(800,220)
		progress.setWindowTitle("Loading Healthcheck")
		progress.show()

                #progress.setlabel(QLabel*)
		
                #pbar = QtGui.QProgressBar(progress)
                #progress.setBar(pbar)
                #pbar.setMinimum(0)
		#pbar.setMaximum(100)
		#pbar.setValue(0)
		
                #fonta = QtGui.QFont()
		#fonta.setPointSize(24)
		#progress.setFont(fonta)
		progress.setFont(QtGui.QFont('OldEnglish', 24,QtGui.QFont.Bold,QtGui.QFont.AllUppercase))

		QtGui.QApplication.processEvents()
		time.sleep(0.1)
                progress.setValue(0)

                print " ** Running tab1 update ** "
                self.listWidget.clear()
                self.updaterootfs()
                progress.setWindowTitle("Loading Healthcheck - Rootfs")
                QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(15)
                self.updateAccel()
                progress.setWindowTitle("Loading Healthcheck - Accelerometer")
                QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(30)
                self.updateCPU()
                progress.setWindowTitle("Loading Healthcheck - CPU")
                QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(45)
                self.updateMaemoV()
                progress.setWindowTitle("Loading Healthcheck - Firmware")
                QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(60)
                QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(70)
                self.updateBatt()
                progress.setWindowTitle("Loading Healthcheck - Battery")
                QtGui.QApplication.processEvents()
                time.sleep(0.1)
                self.listWidget.sortItems()
                print " ** Finished tab 1 update **"

                print " ** Starting tab 2 update**"
		self.listWidget2.clear()
		self.updateGPS(MainWindow)
		progress.setWindowTitle("Loading Healthcheck - GPS")
		QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(80)
		self.Cellular(MainWindow)
		progress.setWindowTitle("Loading Healthcheck - Cell/Phone")
		QtGui.QApplication.processEvents()
                time.sleep(0.1)
                progress.setValue(90)
		self.updatenetname()
		progress.setWindowTitle("Loading Healthcheck - Networks")
		self.listWidget2.sortItems()
                progress.setValue(100)
                time.sleep(0.1)
                print " ** Finished tab 2 update **"
                print " ** Finished ALL Update **"
		print 'done'
                progress.hide()

	
	def updateTab1(self):
		print " ** Running tab1 - load progress**"
		progress = QtGui.QProgressDialog("Please Wait", "Cancel", 0, 100, MainWindow)
		progress.setWindowModality(QtCore.Qt.WindowModal)
		progress.setAutoReset(True)
		progress.setAutoClose(True)
		progress.setMinimum(0)
		progress.setMaximum(100)
		progress.resize(800,200)
		progress.setWindowTitle("Loading System")

		progress.show()
		QtGui.QApplication.processEvents()
		time.sleep(0.5)
                progress.setValue(0)

                print " ** Running tab1 update ** "
                self.listWidget.clear()
                self.updaterootfs()
                progress.setWindowTitle("Loading System - Rootfs")
                QtGui.QApplication.processEvents()
                time.sleep(0.3)
                progress.setValue(20)
                self.updateAccel()
                progress.setWindowTitle("Loading System - Accelerometer")
                QtGui.QApplication.processEvents()
                time.sleep(0.3)
                progress.setValue(40)
                self.updateCPU()
                progress.setWindowTitle("Loading System - CPU")
                QtGui.QApplication.processEvents()
                time.sleep(0.3)
                progress.setValue(60)
                self.updateMaemoV()
                progress.setWindowTitle("Loading System - Firmware")
                QtGui.QApplication.processEvents()
                time.sleep(0.3)
                progress.setValue(80)
                #self.updateUptime()
                progress.setWindowTitle("Loading System - Uptime")
                QtGui.QApplication.processEvents()
                time.sleep(0.3)
                progress.setValue(90)
                self.updateBatt()
                progress.setWindowTitle("Loading System - Battery")
                QtGui.QApplication.processEvents()
                time.sleep(0.3)
                self.listWidget.sortItems()
                print " ** Finished tab 1 update **"

                progress.setValue(100)
                time.sleep(0.3)
		print 'done'
                progress.hide()

	def updateTab2(self):
		print " ** Running tab 2 progress**"
		progress = QtGui.QProgressDialog("Please Wait", "Cancel", 0, 100, MainWindow)
		progress.setWindowModality(QtCore.Qt.WindowModal)
		progress.setAutoReset(True)
		progress.setAutoClose(True)
		progress.setMinimum(0)
		progress.setMaximum(100)
		progress.resize(800,200)
		progress.setWindowTitle("Loading Comms")
		progress.show()
		QtGui.QApplication.processEvents()
		time.sleep(0.5)
                progress.setValue(0)

                print " ** Starting tab 2 update**"
		self.listWidget2.clear()
		progress.setValue(20)
		self.updateGPS(MainWindow)
		progress.setWindowTitle("Loading Comms - GPS")
		QtGui.QApplication.processEvents()
                time.sleep(0.3)
                progress.setValue(40)
		self.Cellular(MainWindow)
		progress.setWindowTitle("Loading Comms- Cell/Phone")
		QtGui.QApplication.processEvents()
                time.sleep(0.3)
                progress.setValue(80)
		self.updatenetname()
		progress.setWindowTitle("Loading Comms - Networks")
		self.listWidget2.sortItems()
                progress.setValue(100)
                time.sleep(0.3)
                print " ** Finished tab 2 update **"

		print 'done'
                progress.hide()

  
		
	# This is the start of the QT Designer translation function - not using the translation function, but left it in, to show it is part of the class   
	def retranslateUi(self, MainWindow):
		MainWindow.setWindowTitle(QtGui.QApplication.translate("MainWindow", "Health Check V1.1.1-0", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab), QtGui.QApplication.translate("MainWindow", "System", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_2), QtGui.QApplication.translate("MainWindow", "Comms", None, QtGui.QApplication.UnicodeUTF8))
		#self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), QtGui.QApplication.translate("MainWindow", "Apps", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), QtGui.QApplication.translate("MainWindow", "Tools", None, QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_4), QtGui.QApplication.translate("MainWindow", "About", None, QtGui.QApplication.UnicodeUTF8))
		
# Cell_info - Taken from netmon code. Need to figure out the author so i can give proper thanks!
# can be found here - http://repository.maemo.org/extras-devel/pool/fremantle/free/source/n/netmon/
	def Cellular(self,MainWindow):
		print " ** Starting Cellular*"
		#import dbus
	
		regstatus = gn_cellinfo.RegStatus()
		signalstrength = gn_cellinfo.SignalStrength()

		if (regstatus[0] == 0): status = 'home'
		elif (regstatus[0] == 1): status = 'roam'
		elif (regstatus[0] == 2): status = 'roam_blink'
		elif (regstatus[0] == 3): status = 'no serv.'
		elif (regstatus[0] == 4): status = 'no serv. search'
		elif (regstatus[0] == 5): status = 'no serv. no search'
		elif (regstatus[0] == 6): status = 'no sim'
		elif (regstatus[0] == 8): status = 'power off'
		elif (regstatus[0] == 9): status = 'nsps'
		elif (regstatus[0] == 10): status = 'nsps no cover.'
		elif (regstatus[0] == 10): status = 'sim rejected'
		else: status = 'unknown'

		if (regstatus[5] == 0): network_type = 'home'
		elif (regstatus[5] == 1): network_type = 'preferred'
		elif (regstatus[5] == 2): network_type = 'forbidden'
		elif (regstatus[5] == 2): network_type = 'other'
		else: network_type = 'no network'

		services = ""
		if (regstatus[6] & 0x02): services += 'CS '
		if (regstatus[6] & 0x01): services += 'GPRS '
		if (regstatus[6] & 0x04): services += 'EGPRS '
		if (regstatus[6] & 0x08): services += 'HSDPA '
		if (regstatus[6] & 0x10): services += 'HSUPA'
		fraction = 1.0 / 100 * signalstrength[0]
		text = " - %d dBm" % signalstrength[1]

		self.listWidget2.addItem("Phone Signal \t\t" + text.strip())
		#self.lbl_pSignal_Info.setText(text)

		cell_id = regstatus[2] & 65535
		cell_rnc = regstatus[2] >> 16
		   
		self.listWidget2.addItem("Cell RNC \t\t" + str(cell_rnc).strip())
		##
		self.listWidget2.addItem("Cell Status \t\t" + status)
		#self.lbl_pRNC_Info.setText(status)
		self.listWidget2.addItem("Cell ID \t\t\t" + str(cell_id).strip())
		#self.lbl_CellID_Info.setText(str(cell_id))

		self.listWidget2.addItem("Cell Services \t\t" + services)
		#self.lbl_pServices_Info.setText(services)
		print " ** Finishing Cellular **"

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def on_error(control, error, user_data):
	print " ** Starting on error cellular function **"
	if error == location.ERROR_USER_REJECTED_DIALOG:
		print "User didn't enable requested methods"
	elif error == location.ERROR_USER_REJECTED_SETTINGS:
		print "User changed settings, which disabled location"
	elif error == location.ERROR_BT_GPS_NOT_AVAILABLE:
		print "Problems with BT GPS"
	elif error == location.ERROR_METHOD_NOT_ALLOWED_IN_OFFLINE_MODE:
		print "Requested method is not allowed in offline mode"
	elif error == location.ERROR_SYSTEM:
		print "System error"
		

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, partially commented by me
# Moved out of the class by me
def on_changed(device, data):
	print " ** GPS On Changed function"
	global var_g_GPS
	global var_g_ALT
	if not device:
		var_g_GPS = "No GPS Found"
		var_g_ALT = ""
		return
	if device.fix:
		if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
			#Set our global variable as the location information! - scroll backup to see where it was used
			var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
			#print "altitude = %f" % device.fix[7]
			print " ** GPS Fix **"
			print device.fix
			#print device.fix[4:6]
			#Seems to struggle with doing it once.... so do it 5 times to warm it up!
		for i in range(1, 5):
			if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
				print " ** Looping GPS Fix **"
				print "lat = %f, long = %f" % device.fix[4:6]
				print device.fix
				var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
				#print "horizontal accuracy: %f meters" % (device.fix[6] / 100)
			#if device.fix[1] & location.GPS_DEVICE_ALTITUDE_SET:
				#var_g_ALT = "altitude = %f" % device.fix[7]
				#print "altitude = %f" % device.fix[7]

			data.stop()
			print " ** Stopped GPS Fix **"

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def on_stop(control, data):
	print " ** Quitting data fix **"
	data.quit()

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def start_location(data):
	print " ** Starting data fix**"
	data.start()
	return False

# Start the main program/function
if __name__ == "__main__":
	print " ** Starting Main **"
	print " ** app = QtGui App** - Running app = QtGui.QApplication(sys.argv) **"
	app = QtGui.QApplication(sys.argv)
	print " ** Setting Main Window**"
	MainWindow = QtGui.QMainWindow()
	print "** Setting tool window #1**"
	win = HelloWindow(MainWindow)
	print "** Setting tool window #2**"
	aui = aMainWindow(MainWindow)
	print "** Setting Video window**"
	imagewin = camerasClass(MainWindow)
	print " ** Declare the UI**"
	ui = Ui_MainWindow()
	print " ** Draw everything and start the main function**"
	ui.setupUi(MainWindow)
	print " ** Show everything**"
	MainWindow.show()
	print " ** Waiting for quit signal - healthcheck loaded **"
	ui.updateAll()
	sys.exit(app.exec_())
	print " ** sys.exit called**"

