#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Application Name - Health Check V0.5.2-4
# Date 17 February 2010
# Author - Greg Roberts (Noobmonkey @ Maemo Talk)
# Contact - Me@Greg-roberts.com
#
# Developed using QT Designer, Eric4, Python GUI and the Nokia N900
# Designed to be used on Maemo 5 (Nokia N900)
#
# This is my first ever N900 application, so please excuse the poor coding!
#
# If you are running this in python directly you will need the following packages.
# In terminal run these commands:
# sudo gainroot
# apt-get install python2.5-qt4-gui
# apt-get install python-location
#
# files: Ensure that gn_cellinfo is in the same folder as the healthcheck.py file.
#
#
# Import the libraries needed in this program
# Basic ones
# import PyQt4 
from PyQt4 import QtCore, QtGui
import sys
# import osso
# To allow os.popen ('<<Terminal command>>').read() commands
import os

# To allow os.popen() to work
import subprocess

# GPS ones
import location
import gobject

# Cell_info - Taken from netmon code. Need to figure out the author so i can give proper thanks!
# can be found here - http://repository.maemo.org/extras-devel/pool/fremantle/free/source/n/netmon/
import gn_cellinfo
import gtk
import hildon

#for phone orientation call
import dbus.glib

#For bluetooth - apt-get install python-bluetooth
#import bluetooth

# osso_c = osso.Context("healthcheck", "666", True)

#Threading imports!
from threading import Thread
import time
gtk.gdk.threads_init()

import pygtk


# Set a global variable - used to send the GPS info from a function back onto its label in the GUI. I'm sure there is a much better way returning
# the variable in a function, but this works.... Example: http://www.wellho.net/resources/ex.php4?item=y105/locvar.py
# Setting it to "location" for now.
var_g_GPS = "location"
var_g_ALT = "altitude"

class Ui_MainWindow(object):
    def setupUi(self, MainWindow):
        # declaring the previous var_g_GPS location as a global in here, this allows it to be read in here.
        global var_g_GPS

        # Set the window / form name
        MainWindow.setObjectName("MainWindow")

        # Set the window size to W800 * H420 - the size of an N900's screen!
        MainWindow.resize(800, 420)

        # Set the current font to Arial 12
        font = QtGui.QFont()
        font.setFamily("Arial")
        font.setPointSize(12)
        # Set the Mainwindow to use this font
        MainWindow.setFont(font)

        # Not sure - QTDesigner did this bit - assuming it's loading up the form and a widget
        self.centralwidget = QtGui.QWidget(MainWindow)
        self.centralwidget.setObjectName("centralwidget")

        # Creating the tab that i need for my application, and set it's size
        self.tabWidget = QtGui.QTabWidget(self.centralwidget)
        self.tabWidget.setGeometry(QtCore.QRect(0, 0, 800, 420))
        # Set the font size. I've gone for big... very big - so they are finger friendly.
        font = QtGui.QFont()
        font.setPointSize(28)
        self.tabWidget.setFont(font)
        self.tabWidget.setObjectName("tabWidget")
        self.tab = QtGui.QWidget()
        self.tab.setObjectName("tab")

        #Reset the Fontsize - decided to go with Arial 18 for all objects on tab 1
        font = QtGui.QFont()
        font.setPointSize(18)

        self.listWidget = QtGui.QListWidget(self.tab)
        self.listWidget.setGeometry(QtCore.QRect(10, 0, 791, 301))
        self.listWidget.setObjectName("listWidget")
        self.listWidget.setFont(font)
        self.listWidget.setAlternatingRowColors(True)
        self.listWidget.setResizeMode(QtGui.QListView.Adjust)
        
        # Setup and draw the button
        self.pushButton_hw = QtGui.QPushButton(self.tab)
        self.pushButton_hw.setGeometry(QtCore.QRect(0, 310, 500, 51))
        self.pushButton_hw.setObjectName("pushButton_hw")
        self.pushButton_hw.setText("Update Tab")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_hw, QtCore.SIGNAL('clicked()'), self.updateTab1)

        # Setup and draw the button
        self.pushButton_a1 = QtGui.QPushButton(self.tab)
        self.pushButton_a1.setGeometry(QtCore.QRect(500, 310, 300, 51))
        self.pushButton_a1.setObjectName("pushButton_a1")
        self.pushButton_a1.setText("Update All")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_a1, QtCore.SIGNAL('clicked()'), self.updateAll)
                
        # Draw the Tab Contents
        self.tabWidget.addTab(self.tab, "")


        # Start on tab 2!
        self.tab_2 = QtGui.QWidget()
        self.tab_2.setObjectName("tab_2")

        self.listWidget2 = QtGui.QListWidget(self.tab_2)
        self.listWidget2.setGeometry(QtCore.QRect(10, 0, 791, 301))
        self.listWidget2.setObjectName("listWidget2")
        self.listWidget2.setFont(font)
        self.listWidget2.setAlternatingRowColors(True)
        self.listWidget2.setResizeMode(QtGui.QListView.Adjust)

        # Setup and draw the button
        self.pushButton_com = QtGui.QPushButton(self.tab_2)
        self.pushButton_com.setGeometry(QtCore.QRect(0, 310, 500, 51))
        self.pushButton_com.setObjectName("pushButton_com")
        self.pushButton_com.setText("Update Tab")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_com, QtCore.SIGNAL('clicked()'), self.updateTab2)

        # Setup and draw the button
        self.pushButton_a2 = QtGui.QPushButton(self.tab_2)
        self.pushButton_a2.setGeometry(QtCore.QRect(500, 310, 300, 51))
        self.pushButton_a2.setObjectName("pushButton_a2_2")
        self.pushButton_a2.setText("Update All")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_a2, QtCore.SIGNAL('clicked()'), self.updateAll)

        # Show the tab and draw contents
        self.tabWidget.addTab(self.tab_2, "")

        # Start on tab 3!
        self.tab_3 = QtGui.QWidget()
        self.tab_3.setObjectName("tab_3")

        font = QtGui.QFont()
        font.setPointSize(12)
        # Set up the Front Camera label

        # This label is used to show the Front Camera widget
        self.lbl_CameraShow = QtGui.QLabel(self.tab_3)
        self.lbl_CameraShow.setGeometry(QtCore.QRect(0, 10, 455, 341))
        self.lbl_CameraShow.setFrameShape(QtGui.QFrame.Panel)
        self.lbl_CameraShow.setFrameShadow(QtGui.QFrame.Raised)
        self.lbl_CameraShow.setLineWidth(2)
        self.lbl_CameraShow.setMidLineWidth(1)
        self.lbl_CameraShow.setScaledContents(True)
        self.lbl_CameraShow.setObjectName("lbl_CameraShow")
        
        # Setup and draw the button
        self.pushButton_cam = QtGui.QPushButton(self.tab_3)
        self.pushButton_cam.setGeometry(QtCore.QRect(450, 250, 340, 51))
        self.pushButton_cam.setObjectName("pushButton_cam")
        self.pushButton_cam.setText("Front camera")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_cam, QtCore.SIGNAL('clicked()'), self.updateTab3)

        # Setup and draw the button
        self.pushButton_cam2 = QtGui.QPushButton(self.tab_3)
        self.pushButton_cam2.setGeometry(QtCore.QRect(450, 310, 340, 51))
        self.pushButton_cam2.setObjectName("pushButton_cam2")
        self.pushButton_cam2.setText("Back camera")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_cam2, QtCore.SIGNAL('clicked()'), self.updateTab3a)

        # Show the tab and draw contents
        self.tabWidget.addTab(self.tab_3, "")

        # Start on tab 4!
        self.tab_4 = QtGui.QWidget()
        self.tab_4.setObjectName("tab_4")

        # Setup and draw the button
        self.pushButton_reboot = QtGui.QPushButton(self.tab_4)
        self.pushButton_reboot.setGeometry(QtCore.QRect(10, 280, 391, 71))
        self.pushButton_reboot.setObjectName("pushButton_reboot")
        self.pushButton_reboot.setText("System Reboot")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_reboot, QtCore.SIGNAL('clicked()'), self.reboot_sys)

        self.pushButton_von = QtGui.QPushButton(self.tab_4)
        self.pushButton_von.setGeometry(QtCore.QRect(10, 200, 391, 71))
        self.pushButton_von.setObjectName("pushButton_von")
        self.pushButton_von.setText("Test Vibrate")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_von, QtCore.SIGNAL('clicked()'), self.vibrateon)

        self.pushButton_led = QtGui.QPushButton(self.tab_4)
        self.pushButton_led.setGeometry(QtCore.QRect(10, 120, 391, 71))
        self.pushButton_led.setObjectName("pushButton_led")
        self.pushButton_led.setText("Test LED's")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_led, QtCore.SIGNAL('clicked()'), self.updateLED)

        self.pushButton_snd1 = QtGui.QPushButton(self.tab_4)
        self.pushButton_snd1.setGeometry(QtCore.QRect(10, 40, 391, 71))
        self.pushButton_snd1.setObjectName("pushButton_snd1")
        self.pushButton_snd1.setText("Test Sound")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_snd1, QtCore.SIGNAL('clicked()'), self.updatesound)
    
        self.tabWidget.addTab(self.tab_4, "")

        # Start on tab 5!
        self.tab_5 = QtGui.QWidget()
        self.tab_5.setObjectName("tab_5")

        # Create the text browser to show the large console input
        # I have used this to show i could get the information in to begin with... I will eventually parse this information and put it into a list
        # box of some sort
        self.textBrowser = QtGui.QTextBrowser(self.tab_5)
        self.textBrowser.setGeometry(QtCore.QRect(0, 10, 781, 301))
        self.textBrowser.setText (" Health Check V 0.5.2-4 \n Greg Roberts (Maemo.org - Noobmonkey) \n me@greg-roberts.com \n \n For Bugs and Feature requests: \n http://talk.maemo.org/showthread.php?p=541457")
        # Make the font small!!!
        font = QtGui.QFont()
        font.setPointSize(20)
        self.textBrowser.setFont(font)
        self.tabWidget.addTab(self.tab_5, "")

        # Draw the main Window
        MainWindow.setCentralWidget(self.centralwidget)
        # Draw the Menubar
        self.menubar = QtGui.QMenuBar(MainWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 800, 21))
        self.menubar.setObjectName("menubar")
        MainWindow.setMenuBar(self.menubar)
        # Draw the Status bar
        self.addemptylist1()
        self.addemptylist2()
        # Run the translate UI - Added by QT Designer - i have removed alot of setText's and placed them above.
        self.retranslateUi(MainWindow)
        #self.updateTab1()
 
        # Set which tab you want showing on program load
        self.tabWidget.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(MainWindow)
  

    def addemptylist1(self):
        self.listWidget.clear()
        self.listWidget.addItem("Firmware Version")
        self.listWidget.addItem("Processor Information")
        self.listWidget.addItem("N900 Board")
        self.listWidget.addItem("System Locale")   
        self.listWidget.addItem("Boot Count")
        self.listWidget.addItem("FM Trans Strength")
        self.listWidget.addItem("System Uptime")
        self.listWidget.addItem("Battery")
        self.listWidget.addItem("Accelerometer")
        self.listWidget.addItem("MyDocs")
        self.listWidget.addItem("Rootfs Free")
        self.listWidget.sortItems()

    def addemptylist2(self):
        self.listWidget2.clear()
        self.listWidget2.addItem("Cell ID")
        self.listWidget2.addItem("Cell RNC")
        self.listWidget2.addItem("Cell Services")
        self.listWidget2.addItem("Cell Status")   
        self.listWidget2.addItem("GPS Position")
        self.listWidget2.addItem("Internal IP")
        self.listWidget2.addItem("Phone signal")
        self.listWidget2.sortItems()
        
# Funtion - update GPS - Using lib-location
    def updateGPS(self):
        global var_g_GPS
        global var_g_ALT
        
        # Start of the GPS Location information
        # Please visit here for more information and code on PyMaemo GPS API - http://wiki.maemo.org/PyMaemo/Using_Location_API

        loop = gobject.MainLoop()
        control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        control.set_properties(preferred_method=location.METHOD_USER_SELECTED,preferred_interval=location.INTERVAL_DEFAULT)
        control.connect("error-verbose", on_error, loop)
        device.connect("changed", on_changed, control)
        control.connect("gpsd-stopped", on_stop, loop)
        gobject.idle_add(start_location, control)

        loop.run()

        # Set the GPS tabel text       
        #self.lbl_Alt_Info.setText(var_g_ALT)
        self.listWidget2.addItem("GPS Position \t\t" + var_g_GPS.strip())
        al = '/sbin/ifconfig | grep inet | grep -v 127.0.0.1 | awk \'{split($2,a,":");print a[2]}\''
        l = None
        l = os.popen(al).read()
        self.listWidget2.addItem("Internal IP \t\t" + l.strip())


    def reboot_sys(self):
        import gtk
        self.CloseDialog = QtGui.QMessageBox.question(None, "Time for a Reboot!","Do you really want to reboot?",QtGui.QMessageBox.Yes|QtGui.QMessageBox.No,QtGui.QMessageBox.No)
        if self.CloseDialog == QtGui.QMessageBox.Yes:
            
            b = None
            b = os.popen('run-standalone.sh dbus-send --system --type=method_call --dest="com.nokia.dsme" --print-reply "/com/nokia/dsme/request" com.nokia.dsme.request.req_reboot')
            b.close ()
        elif self.CloseDialog == QtGui.QMessageBox.No:
            print "User pressed 'No' button"

    def updatesound(self):

        bus = dbus.SessionBus()
        proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
        interface.Notify('HealthCheck', 0, './healthcheck.png', 'Sound Test', 'Stereo then Mono Test', [], {}, 3000)
        
        b = None
        b = os.popen('pacat --channels=2 /usr/share/sounds/ui-wake_up_tune.wav')
        b.close ()

        b = None
        b = os.popen('pacat --channels=1 /usr/share/sounds/ui-wake_up_tune.wav')
        b.close ()
              
        
        
        
# Funtion - update the front camera image
    def updateImage(self):
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
        interface.Notify('HealthCheck', 0, './healthcheck.png', 'Front Camera', 'Point your screen camera at a light.', [], {}, 3000)
        # Close b - the greatly named variable - as i want to use it again! (Well close or declare it!)
        b = None
        # X-term - grab 10 buffered front camera images, and throw them into an image file.
        # Everyone recommends 1.... but 10 gave more light! - so i used it :D
        b = os.popen('gst-launch v4l2camsrc device=/dev/video1 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
        b.close ()
        # Declare and set the image file name
        image_file = "/home/user/MyDocs/fcamtest.jpg"
        image = QtGui.QPixmap(image_file)
        # Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
        self.lbl_CameraShow.setPixmap(image)

    def updateImage2(self):
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
        interface.Notify('HealthCheck', 0, './healthcheck.png', 'Back Camera', 'Open your Lens Cover!!.', [], {}, 3000)
        
        # Close b - the greatly named variable - as i want to use it again! (Well close or declare it!)
        b = None
        # X-term - grab 10 buffered front camera images, and throw them into an image file.
        # Everyone recommends 1.... but 10 gave more light! - so i used it :D
        b = os.popen('gst-launch v4l2camsrc device=/dev/video0 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
        b.close ()
        # Declare and set the image file name
        image_file = "/home/user/MyDocs/fcamtest.jpg"
        image = QtGui.QPixmap(image_file)
        # Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
        self.lbl_CameraShow.setPixmap(image)
  
# Funtion - update Firmware version label
    def updateMaemoV(self):
        # This one reads fremantle version number (Firmware)
        g = os.popen('dpkg -l "mp-fremantle-*"').read()
        g = g.strip()[-15:]
        g = str(g)
        g.strip()
        g.lstrip()
        g.rstrip()
        
        if g.strip() == "3.2010.02-8":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1.1")
        elif g.strip() == "3.2010.02-8.002":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1.1")
        elif g.strip() == "3.2010.02-8.001":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1.1")
        elif g.strip() == "2.2009.51-1":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1")
        elif g.strip() == "2009.51-1.203.2":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1 UK Generic Version")
        elif g.strip() == "2009.51-1.203.1":
            self.listWidget.addItem("FirmwareVersion \t\t" + g.strip() + " - PR 1.1 UK Generic Version")
        elif g.strip() == "2009.51-1.205.1":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1 UK Vodafone Version")
        elif g.strip() == "2009.51-1.205.2":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.1 UK Vodafone Version")
        elif g.strip() == "1.2009.44-1":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1.01")
        elif g.strip() == "1.2009.42-11":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 - Initial public release ")
        elif g.strip() == "1.2009.42-11.002":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 USA Version")
        elif g.strip() == "1.2009.42-11.003":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 Mid-East/N-Africa Version")
        elif g.strip() == "1.2009.42-11.203":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
        elif g.strip() == "1.2009.42-11.203.0":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
        elif g.strip() == "1.2009.42-11.203.1":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
        elif g.strip() == "1.2009.42-11.203.2":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Generic Version")
        elif g.strip() == "1.2009.42-11.205":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
        elif g.strip() == "1.2009.42-11.205.0":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
        elif g.strip() == "1.2009.42-11.205.1":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
        elif g.strip() == "1.2009.42-11.205.2":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - PR 1 UK Vodafone Version")
        elif g.strip() == "1.2009.41-1":
            self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - Early Release Vanilla Variant")
        else:
           self.listWidget.addItem("Firmware Version \t\t" + g.strip() + " - Varient unknown")

# Funtion - update CPU Information
    def updateCPU(self):
        # This one reads fremantle version number (Firmware)
        ga = os.popen('cat /proc/cpuinfo | grep Processor').read()
        ga = ga.strip()[11:]
        
        self.listWidget.addItem("Processor Information \t" + ga.strip())
        
        gb = os.popen('cat /proc/cpuinfo | grep Hardware').read()
        gb = gb.strip()[11:]
        
        self.listWidget.addItem("N900 Board \t\t\t" + gb.strip())

        gc = os.popen('locale | grep LANG').read()
        gc = gc.strip()[5:]
        
        self.listWidget.addItem("System Locale \t\t" + gc.strip())

        gd = os.popen('cat /var/lib/dsme/boot_count').read()
        gd = gd.strip()

        ge = os.popen('cat /sys/class/i2c-adapter/i2c-2/2-0063/power_level').read()
        ge = ge.strip()
    
        self.listWidget.addItem("FM Trans Strength \t\t" + ge.strip())
        
    def updateUptime(self):
        # This one reads fremantle version number (Firmware)
        ge = os.popen('uptime|cut -d" " -f4-|cut -d"," -f-1').read()
        self.listWidget.addItem("System Uptime \t\t" + ge.strip())
     

# Funtion - update battery information
    def updateBatt(self):
        # This one pulls out the battery percentage
        bg = os.popen('lshal|grep percen').read()
        # This one reads the applications list from dpkg
        # Do some string functions to find/remove messy parts of the battery pulled text.
        # Please excuse the poorly labeled variables here!
        C_a = str(bg)[:-15]
        C_b = str(C_a)[-4:]
        barxval = str.strip(C_b)
        
        #self.lbl_Battery_Bar.setRange(0,100)
        #self.lbl_Battery_Bar.setProperty("value", barxval)
        self.listWidget.addItem("Battery  \t\t\t" + barxval + "%")

# Funtion - update Accelerator information
    def updateAccel(self):
        import dbus.glib

        # set f to = the accellerometer co-ordinates
        # the co-ords need to be pulled out and split for easy reading
        # Close down the co-ord file once used (Only displaying static info, not updating yet)
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r')
        coords = [int(w) for w in f.readline().split()]
        f.close()

        b = None
        b = os.popen('run-standalone.sh dbus-send --system --type=signal /com/nokia/mce/signal com.nokia.mce.signal.sig_device_orientation_ind').read()
        
        coords = str(coords)
        jaccel = str(coords) + str(b)
        
        self.listWidget.addItem("Accelerometer \t\t" + jaccel)
        
        #Bluetooth
        #print "performing inquiry..."
        #nearby_devices = bluetooth.discover_devices(lookup_names = True)
        #print "found %d devices" % len(nearby_devices)
        #for name, addr in nearby_devices:
            #print "  %s - %s" % (addr, name)

    def vibrateon(self):
        import dbus.glib

        bus = dbus.SessionBus()
        proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
        interface.Notify('HealthCheck', 0, './healthcheck.png', 'Vibration TEST', 'Testing Vibrations', [], {}, 3000)
        # set f to = the accellerometer co-ordinates
        # the co-ords need to be pulled out and split for easy reading
        # Close down the co-ord file once used (Only displaying static info, not updating yet)
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_activate string:' + "\'PatternTouchscreen\'"
        b = os.popen(bb)
        b.close()
        
        b.close()
        bb= 'run-standalone.sh dbus-send --print-reply --system --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_vibrator_pattern_deactivate string:' + "\'PatternIncomingCall\'"
        b = os.popen(bb)
        b.close()
        
       
        
        #Bluetooth
        #print "performing inquiry..."
        #nearby_devices = bluetooth.discover_devices(lookup_names = True)
        #print "found %d devices" % len(nearby_devices)
        #for name, addr in nearby_devices:
            #print "  %s - %s" % (addr, name)

    def updateLED(self):
        import dbus.glib
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
        interface.Notify('HealthCheck', 0, './healthcheck.png', 'LED TEST', 'Testing Power on, then SMS LED Patterns ', [], {}, 3000)

        bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:' + "\'PatternPowerOn\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh sleep 1'
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:' + "\'PatternPowerOn\'"
        b = os.popen(bb)
        b.close()

        bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:' + "\'PatternCommunicationSMS\'"
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh sleep 1'
        b = os.popen(bb)
        b.close()
        bb = 'run-standalone.sh dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:' + "\'PatternCommunicationSMS\'"
        b = os.popen(bb)
        b.close()

      


# Funtion - update rootfs, currently shows free MB and used %.
    def updaterootfs(self):
        # Call the x-terminal command to read the rootfs free space
        gr = os.popen('df -h /').read()
        # Remove some of the faffy bits. I've left the total free and percentage used at the moment, is a little confusing
        gx = str(gr)[-14:]
        gx = gx[:-7]
        
        self.listWidget.addItem("Rootfs \t\t\t" + gx.strip() + " free")

    def updatemydocs(self):
        # Call the x-terminal command to read the rootfs free space
        ge = os.popen('df -h /home/user/MyDocs').read()
        # Remove some of the faffy bits. I've left the total free and percentage used at the moment, is a little confusing
        gf = str(ge)[-34:]
        
        gf = gf[:-24]
        
        
        self.listWidget.addItem("MyDocs \t\t\t" + gf.strip() + " free")
        
# Funtion - update tab.... Originally to update tab1, but using it to collate the functions
# It has the commented out message boxes, will work on this later
    def updateAll(self):
        self.updateTab1()
        self.updateTab2()
    
    def updateTab1(self):
        import hildon
        self.listWidget.clear()
        self.pushButton_hw.setEnabled(False)
        self.pushButton_a1.setEnabled(False)
        self.pushButton_hw.setText(".")  
        Thread(target=self.updaterootfs()).start()
        self.pushButton_hw.setText("..")
        Thread(target=self.updateAccel()).start()
        self.pushButton_hw.setText("...")
        Thread(target=self.updateCPU()).start()
        self.pushButton_hw.setText("....")
        Thread(target=self.updatemydocs()).start()
        self.pushButton_hw.setText(".....")
        Thread(target=self.updateMaemoV()).start()
        self.pushButton_hw.setText("......")
        Thread(target=self.updateUptime()).start()
        self.pushButton_hw.setText(".......")
        Thread(target=self.updateBatt()).start()
        self.pushButton_hw.setText("........")
        self.pushButton_hw.setText("Update Tab")
        self.pushButton_hw.setEnabled(True)
        self.pushButton_a1.setEnabled(True)
        self.listWidget.sortItems()
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
        interface.Notify('HealthCheck', 0, './healthcheck.png', 'System Tab', 'Finished Loading', [], {}, 2000)



    def updateTab2(self):
        self.listWidget2.clear()
        self.pushButton_com.setEnabled(False)
        self.pushButton_a2.setEnabled(False)
        self.pushButton_com.setText("...")
        Thread(target=self.updateGPS()).start()
        self.pushButton_com.setText(".....")
        Thread(target=self.Cellular()).start()
        self.pushButton_com.setText("......")
        
        self.pushButton_com.setText("Update Tab")
        self.pushButton_com.setEnabled(True)
        self.pushButton_a2.setEnabled(True)
        self.listWidget2.sortItems()
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        interface = dbus.Interface(proxy,dbus_interface='org.freedesktop.Notifications')
        interface.Notify('HealthCheck', 0, './healthcheck.png', 'Comms Tab', 'Finished Loading', [], {}, 2000)

    def updateTab3(self):
        self.pushButton_cam.setEnabled(False)
        self.pushButton_cam.setText("....")
        Thread(target=self.updateImage()).start()
        self.pushButton_cam.setText("Front camera")
        self.pushButton_cam.setEnabled(True)

    def updateTab3a(self):
        self.pushButton_cam2.setEnabled(False)
        self.pushButton_cam2.setText("....")
        Thread(target=self.updateImage2()).start()
        self.pushButton_cam2.setText("Back Camera")
        self.pushButton_cam2.setEnabled(True)
        
    # This is the start of the QT Designer translation function - not using the translation function, but left it in, to show it is part of the class   
    def retranslateUi(self, MainWindow):
        MainWindow.setWindowTitle(QtGui.QApplication.translate("MainWindow", "Health Check 0.5.2-4", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab), QtGui.QApplication.translate("MainWindow", "System", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_2), QtGui.QApplication.translate("MainWindow", "Comms", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), QtGui.QApplication.translate("MainWindow", "Camera", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_4), QtGui.QApplication.translate("MainWindow", "Tools", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_5), QtGui.QApplication.translate("MainWindow", "About", None, QtGui.QApplication.UnicodeUTF8))
        
# Cell_info - Taken from netmon code. Need to figure out the author so i can give proper thanks!
# can be found here - http://repository.maemo.org/extras-devel/pool/fremantle/free/source/n/netmon/
    def Cellular(self):
        import dbus
	regstatus = gn_cellinfo.RegStatus()
	signalstrength = gn_cellinfo.SignalStrength()

	if (regstatus[0] == 0): status = 'home'
        elif (regstatus[0] == 1): status = 'roam'
        elif (regstatus[0] == 2): status = 'roam_blink'
	elif (regstatus[0] == 3): status = 'no serv.'
	elif (regstatus[0] == 4): status = 'no serv. search'
	elif (regstatus[0] == 5): status = 'no serv. no search'
	elif (regstatus[0] == 6): status = 'no sim'
	elif (regstatus[0] == 8): status = 'power off'
	elif (regstatus[0] == 9): status = 'nsps'
	elif (regstatus[0] == 10): status = 'nsps no cover.'
	elif (regstatus[0] == 10): status = 'sim rejected'
        else: status = 'unknown'

	if (regstatus[5] == 0): network_type = 'home'
	elif (regstatus[5] == 1): network_type = 'preferred'
	elif (regstatus[5] == 2): network_type = 'forbidden'
	elif (regstatus[5] == 2): network_type = 'other'
	else: network_type = 'no network'
        services = ""
        if (regstatus[6] & 0x02): services += 'CS '
	if (regstatus[6] & 0x01): services += 'GPRS '
	if (regstatus[6] & 0x04): services += 'EGPRS '
	if (regstatus[6] & 0x08): services += 'HSDPA '
	if (regstatus[6] & 0x10): services += 'HSUPA'

	fraction = 1.0 / 100 * signalstrength[0]
	text = " - %d dBm" % signalstrength[1]

        self.listWidget2.addItem("Phone Signal \t\t" + text.strip())
        #self.lbl_pSignal_Info.setText(text)


	#print "reg 1 %i" % regstatus[4]
	#print "reg 3 %i" % regstatus[3]
	#print "reg 1 %i" % regstatus[1]
	cell_id = regstatus[2] & 65535
	cell_rnc = regstatus[2] >> 16
		
	self.listWidget2.addItem("Cell RNC \t\t" + str(cell_rnc).strip())
        ##
        self.listWidget2.addItem("Cell Status \t\t" + status)
	#self.lbl_pRNC_Info.setText(status)
        self.listWidget2.addItem("Cell ID \t\t" + str(cell_id).strip())
	#self.lbl_CellID_Info.setText(str(cell_id))

	#print status
	#print network_type
	#print "regstatus %i" % regstatus[7]

        ##
        self.listWidget2.addItem("Cell Services \t\t" + services)
	#self.lbl_pServices_Info.setText(services)

	##dbus-send --system --print-reply --type=method_call --dest=com.nokia.phone.SIM /com/nokia/phone/SIM/security Phone.Sim.Security.get_imei
        #bus = dbus.SystemBus()
        #dbus_object = bus.get_object('com.nokia.phone.SIM', '/com/nokia/phone/SIM/security')
        #dbus_interface = dbus.Interface(dbus_object, 'Phone.Sim.Security')

        #print "imei"
        #ia = dbus_interface.get_imei()
        #ib = ia[15:]
        #ic = ib[:15]
        #print ic
                


# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def on_error(control, error, user_data):
    if error == location.ERROR_USER_REJECTED_DIALOG:
        print "User didn't enable requested methods"
    elif error == location.ERROR_USER_REJECTED_SETTINGS:
        print "User changed settings, which disabled location"
    elif error == location.ERROR_BT_GPS_NOT_AVAILABLE:
        print "Problems with BT GPS"
    elif error == location.ERROR_METHOD_NOT_ALLOWED_IN_OFFLINE_MODE:
        print "Requested method is not allowed in offline mode"
    elif error == location.ERROR_SYSTEM:
        print "System error"
        

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, partially commented by me
# Moved out of the class by me
def on_changed(device, data):
    global var_g_GPS
    global var_g_ALT
    if not device:
        var_g_GPS = "No GPS Found"
        var_g_ALT = ""
        return
    if device.fix:
        if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
            #Set our global variable as the location information! - scroll backup to see where it was used
            var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
            #print "altitude = %f" % device.fix[7]
            #print device.fix
            #print device.fix[4:6]
            #Seems to struggle with doing it once.... so do it 5 times to warm it up!
        for i in range(1, 4):
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
                #print "horizontal accuracy: %f meters" % (device.fix[6] / 100)
            if device.fix[1] & location.GPS_DEVICE_ALTITUDE_SET:
                var_g_ALT = "altitude = %f" % device.fix[7]
                #print "altitude = %f" % device.fix[7]

            data.stop()

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def on_stop(control, data):
    data.quit()

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def start_location(data):
    data.start()
    return False


# Start the main program/function
if __name__ == "__main__":
    
    app = QtGui.QApplication(sys.argv)
    MainWindow = QtGui.QMainWindow()
    ui = Ui_MainWindow()
    ui.setupUi(MainWindow)
    MainWindow.show()

    sys.exit(app.exec_())

