#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Application Name - Health Check V0.5.0-4
# Date 17 February 2010
# Author - Greg Roberts (Noobmonkey @ Maemo Talk)
# Contact - Me@Greg-roberts.com
#
# Developed using QT Designer, Eric4, Python GUI and the Nokia N900
# Designed to be used on Maemo 5 (Nokia N900)
#
# This is my first ever N900 application, so please excuse the poor coding!
#
# If you are running this in python directly you will need the following packages.
# In terminal run these commands:
# sudo gainroot
# apt-get install python2.5-qt4-gui
# apt-get install python-location
#
# files: Ensure that gn_cellinfo is in the same folder as the healthcheck.py file.
#
#
# Import the libraries needed in this program
# Basic ones
# import PyQt4 
from PyQt4 import QtCore, QtGui
import sys
# import osso
# To allow os.popen ('<<Terminal command>>').read() commands
import os

# To allow os.popen() to work
import subprocess

# GPS ones
import location
import gobject

# Cell_info - Taken from netmon code. Need to figure out the author so i can give proper thanks!
# can be found here - http://repository.maemo.org/extras-devel/pool/fremantle/free/source/n/netmon/
import gn_cellinfo
import gtk

# osso_c = osso.Context("healthcheck", "666", True)

#Threading imports!
from threading import Thread
import time
gtk.gdk.threads_init()



# Set a global variable - used to send the GPS info from a function back onto its label in the GUI. I'm sure there is a much better way returning
# the variable in a function, but this works.... Example: http://www.wellho.net/resources/ex.php4?item=y105/locvar.py
# Setting it to "location" for now.
var_g_GPS = "location"

class Ui_MainWindow(object):
    def setupUi(self, MainWindow):
        # declaring the previous var_g_GPS location as a global in here, this allows it to be read in here.
        global var_g_GPS

        # Set the window / form name
        MainWindow.setObjectName("MainWindow")

        # Set the window size to W800 * H420 - the size of an N900's screen!
        MainWindow.resize(800, 420)

        # Set the current font to Arial 12
        font = QtGui.QFont()
        font.setFamily("Arial")
        font.setPointSize(12)
        # Set the Mainwindow to use this font
        MainWindow.setFont(font)

        # Not sure - QTDesigner did this bit - assuming it's loading up the form and a widget
        self.centralwidget = QtGui.QWidget(MainWindow)
        self.centralwidget.setObjectName("centralwidget")

        # Creating the tab that i need for my application, and set it's size
        self.tabWidget = QtGui.QTabWidget(self.centralwidget)
        self.tabWidget.setGeometry(QtCore.QRect(0, 0, 800, 420))
        # Set the font size. I've gone for big... very big - so they are finger friendly.
        font = QtGui.QFont()
        font.setPointSize(30)
        self.tabWidget.setFont(font)
        self.tabWidget.setObjectName("tabWidget")
        self.tab = QtGui.QWidget()
        self.tab.setObjectName("tab")

        #Reset the Fontsize - decided to go with Arial 14 for all objects on tab 1
        font = QtGui.QFont()
        font.setPointSize(14)

        # Set up the Battery label
        self.lbl_Battery = QtGui.QLabel(self.tab)
        self.lbl_Battery.setGeometry(QtCore.QRect(10, 0, 141, 20))
        self.lbl_Battery.setFont(font)
        self.lbl_Battery.setObjectName("lbl_Battery")
        self.lbl_Battery.setText("Battery")

        # Set up the Accelerator label
        self.lbl_Accel = QtGui.QLabel(self.tab)
        self.lbl_Accel.setGeometry(QtCore.QRect(10, 30, 141, 20))
        self.lbl_Accel.setFont(font)
        self.lbl_Accel.setObjectName("lbl_Accel")
        self.lbl_Accel.setText("Accelerometer")

        # This label will be used to show the Maemo Firmware version currently installed
        self.lbl_Maemo_Version = QtGui.QLabel(self.tab)
        self.lbl_Maemo_Version.setGeometry(QtCore.QRect(10, 60, 141, 21))
        self.lbl_Maemo_Version.setFont(font)
        self.lbl_Maemo_Version.setObjectName("lbl_Maemo_Version")
        self.lbl_Maemo_Version.setText("Firmware Ver")

        # This label is for the Rootfs Free space (Label only)
        self.lbl_rootfs = QtGui.QLabel(self.tab)
        self.lbl_rootfs.setGeometry(QtCore.QRect(10, 90, 151, 21))
        self.lbl_rootfs.setFont(font)
        self.lbl_rootfs.setObjectName("lbl_rootfs")
        self.lbl_rootfs.setText("Rootfs Free")

        # This label is for the Rootfs Free space (Label only)
        self.lbl_mydocs = QtGui.QLabel(self.tab)
        self.lbl_mydocs.setGeometry(QtCore.QRect(10, 120, 151, 21))
        self.lbl_mydocs.setFont(font)
        self.lbl_mydocs.setObjectName("lbl_mydocs")
        self.lbl_mydocs.setText("MyDocs Free")

        

        # This label is for the CPU Info Label only)
        self.lbl_Processor = QtGui.QLabel(self.tab)
        self.lbl_Processor.setGeometry(QtCore.QRect(10, 150, 151, 21))
        self.lbl_Processor.setFont(font)
        self.lbl_Processor.setObjectName("lbl_Processor")
        self.lbl_Processor.setText("CPU Info")

        # This label is for the N900 Board info(Label only)
        self.lbl_BoardInfol = QtGui.QLabel(self.tab)
        self.lbl_BoardInfol.setGeometry(QtCore.QRect(10, 180, 151, 21))
        self.lbl_BoardInfol.setFont(font)
        self.lbl_BoardInfol.setObjectName("lbl_BoardInfol")
        self.lbl_BoardInfol.setText("N900 Board")

        # This label is for the system locale (Label only)
        self.lbl_SysLocale = QtGui.QLabel(self.tab)
        self.lbl_SysLocale.setGeometry(QtCore.QRect(10, 210, 151, 21))
        self.lbl_SysLocale.setFont(font)
        self.lbl_SysLocale.setObjectName("lbl_SysLocale")
        self.lbl_SysLocale.setText("System Locale")

       
        
        

        # Start showing the Information fields - these fields i have labelled with Info(mostly!), but only because it makes sense to me!

        #Set the font again
        font = QtGui.QFont()
        font.setPointSize(12)

        #Battery Percentage bar - is acting a bit strange and being thin at the moment.
        self.lbl_Battery_Bar = QtGui.QProgressBar(self.tab)
        self.lbl_Battery_Bar.setGeometry(QtCore.QRect(160,-10,331,53))
        self.lbl_Battery_Bar.setFont(font)
        self.lbl_Battery_Bar.setProperty("value", 50)
        self.lbl_Battery_Bar.setObjectName("lbl_Battery_Bar")
        
        #Accelorator information
        self.lbl_Accel_Info = QtGui.QLabel(self.tab)
        self.lbl_Accel_Info.setGeometry(QtCore.QRect(160, 30, 331, 20))
        self.lbl_Accel_Info.setFont(font)
        self.lbl_Accel_Info.setObjectName("lbl_Accel_Info")

        # Label to show the maemo firmware version Information
        self.lbl_Maemo_Ver_Info = QtGui.QLabel(self.tab)
        self.lbl_Maemo_Ver_Info.setGeometry(QtCore.QRect(160, 60, 331, 21))
        self.lbl_Maemo_Ver_Info.setFont(font)
        self.lbl_Maemo_Ver_Info.setObjectName("lbl_Maemo_Ver_Info")

        # Rootfs Info - label to show the rootfs free space (data)
        self.lbl_rootfd_info = QtGui.QLabel(self.tab)
        self.lbl_rootfd_info.setGeometry(QtCore.QRect(160, 90, 331, 21))
        self.lbl_rootfd_info.setFont(font)
        self.lbl_rootfd_info.setObjectName("lbl_rootfd_info")

        # Rootfs Info - label to show the rootfs free space (data)
        self.lbl_mydocsd_info = QtGui.QLabel(self.tab)
        self.lbl_mydocsd_info.setGeometry(QtCore.QRect(160, 120, 331, 21))
        self.lbl_mydocsd_info.setFont(font)
        self.lbl_mydocsd_info.setObjectName("lbl_mydocsd_info")

        # This label is for the CPU Information(Label only)
        self.lbl_ProcessorInfo = QtGui.QLabel(self.tab)
        self.lbl_ProcessorInfo.setGeometry(QtCore.QRect(160, 150, 331, 21))
        self.lbl_ProcessorInfo.setFont(font)
        self.lbl_ProcessorInfo.setObjectName("lbl_ProcessorInfo")
        self.lbl_ProcessorInfo.setText("CPU Info")

        # This label is for the N900 Motherboard/mainboard info(Label only)
        self.lbl_BoardInfo = QtGui.QLabel(self.tab)
        self.lbl_BoardInfo.setGeometry(QtCore.QRect(160, 180, 331, 21))
        self.lbl_BoardInfo.setFont(font)
        self.lbl_BoardInfo.setObjectName("lbl_BoardInfo")
        self.lbl_BoardInfo.setText("Board Info")
        
        # This label is for the system locale info (Label only)
        self.lbl_SysLocaleInfo = QtGui.QLabel(self.tab)
        self.lbl_SysLocaleInfo.setGeometry(QtCore.QRect(160, 210, 331, 21))
        self.lbl_SysLocaleInfo.setFont(font)
        self.lbl_SysLocaleInfo.setObjectName("lbl_SysLocaleInfo")
        self.lbl_SysLocaleInfo.setText("Sys Locale Info")

        
        
        # Setup and draw the button
        self.pushButton_hw = QtGui.QPushButton(self.tab)
        self.pushButton_hw.setGeometry(QtCore.QRect(580, 310, 211, 51))
        self.pushButton_hw.setObjectName("pushButton_hw")
        self.pushButton_hw.setText("Update")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_hw, QtCore.SIGNAL('clicked()'), self.updateTab1)
                
        # Draw the Tab Contents
        self.tabWidget.addTab(self.tab, "")

        
        # Start on tab 2!
        self.tab_2 = QtGui.QWidget()
        self.tab_2.setObjectName("tab_2")

        # Set up the GPS Info label
        self.lbl_GpsPos = QtGui.QLabel(self.tab_2)
        self.lbl_GpsPos.setGeometry(QtCore.QRect(10, 60, 141, 20))
        self.lbl_GpsPos.setFont(font)
        self.lbl_GpsPos.setObjectName("lbl_GpsPos")
        self.lbl_GpsPos.setText("GPS Position")
        
        # GPS Info Field
        self.lbl_Gps_Info = QtGui.QLabel(self.tab_2)
        self.lbl_Gps_Info.setGeometry(QtCore.QRect(160, 60, 381, 20))
        self.lbl_Gps_Info.setObjectName("lbl_Gps_Info")
        self.lbl_Gps_Info.setFont(font)

        # This label is for the phone signal (Label only)
        self.lbl_Psignal = QtGui.QLabel(self.tab_2)
        self.lbl_Psignal.setGeometry(QtCore.QRect(10, 240, 151, 21))
        self.lbl_Psignal.setFont(font)
        self.lbl_Psignal.setObjectName("lbl_Psignal")
        self.lbl_Psignal.setText("Phone Signal")

        # This label is for the phone RNC (Label only)
        self.lbl_PRNC = QtGui.QLabel(self.tab_2)
        self.lbl_PRNC.setGeometry(QtCore.QRect(10, 270, 151, 21))
        self.lbl_PRNC.setFont(font)
        self.lbl_PRNC.setObjectName("lbl_PRNC")
        self.lbl_PRNC.setText("Network Status")
        
        # This label is for the Phone Services (Label only)
        self.lbl_PhoneServices = QtGui.QLabel(self.tab_2)
        self.lbl_PhoneServices.setGeometry(QtCore.QRect(10, 300, 151, 21))
        self.lbl_PhoneServices.setFont(font)
        self.lbl_PhoneServices.setObjectName("lbl_PhoneServices")
        self.lbl_PhoneServices.setText("Phone Services")

        # This label is for the Cell ID(Label only)
        self.lbl_Cell_ID = QtGui.QLabel(self.tab_2)
        self.lbl_Cell_ID.setGeometry(QtCore.QRect(10, 330, 151, 21))
        self.lbl_Cell_ID.setFont(font)
        self.lbl_Cell_ID.setObjectName("lbl_Cell_ID")
        self.lbl_Cell_ID.setText("Phone Cell_ID")
        
        # This label is for the Phone Signal info (Label only)
        self.lbl_pSignal_Info = QtGui.QLabel(self.tab_2)
        self.lbl_pSignal_Info.setGeometry(QtCore.QRect(160, 240, 331, 21))
        self.lbl_pSignal_Info.setFont(font)
        self.lbl_pSignal_Info.setObjectName("lbl_pSignal_Info")
        #self.lbl_pSignal_Info.setText("Phone Signal")

        # This label was Phone RNC info now net status (Label only)
        self.lbl_pRNC_Info = QtGui.QLabel(self.tab_2)
        self.lbl_pRNC_Info.setGeometry(QtCore.QRect(160, 270, 331, 21))
        self.lbl_pRNC_Info.setFont(font)
        self.lbl_pRNC_Info.setObjectName("lbl_pRNC_Info")
        #self.lbl_pRNC_Info.setText("Network Status")

        # This label is for the Phone services info (Label only)
        self.lbl_pServices_Info = QtGui.QLabel(self.tab_2)
        self.lbl_pServices_Info.setGeometry(QtCore.QRect(160, 300, 331, 21))
        self.lbl_pServices_Info.setFont(font)
        self.lbl_pServices_Info.setObjectName("lbl_pServices_Info")
        #self.lbl_pServices_Info.setText("Phone Services")

        # This label is for the Cell ID info (Label only)
        self.lbl_CellID_Info = QtGui.QLabel(self.tab_2)
        self.lbl_CellID_Info.setGeometry(QtCore.QRect(160, 330, 331, 21))
        self.lbl_CellID_Info.setFont(font)
        self.lbl_CellID_Info.setObjectName("lbl_CellID_Info")
        #self.lbl_CellID_Info.setText("Cell ID")

        # Setup and draw the button
        self.pushButton_com = QtGui.QPushButton(self.tab_2)
        self.pushButton_com.setGeometry(QtCore.QRect(580, 310, 211, 51))
        self.pushButton_com.setObjectName("pushButton_com")
        self.pushButton_com.setText("Update")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_com, QtCore.SIGNAL('clicked()'), self.updateTab2)

        # Show the tab and draw contents
        self.tabWidget.addTab(self.tab_2, "")

        # Start on tab 3!
        self.tab_3 = QtGui.QWidget()
        self.tab_3.setObjectName("tab_3")

        # Set up the Front Camera label
        self.lbl_FrontCam = QtGui.QLabel(self.tab_3)
        self.lbl_FrontCam.setGeometry(QtCore.QRect(10, 130, 131, 21))
        self.lbl_FrontCam.setFont(font)
        self.lbl_FrontCam.setObjectName("lbl_FrontCam")
        self.lbl_FrontCam.setText("Front Camera")

        # This label is used to show the Front Camera widget
        self.lbl_CameraShow = QtGui.QLabel(self.tab_3)
        self.lbl_CameraShow.setGeometry(QtCore.QRect(150, 10, 631, 341))
        self.lbl_CameraShow.setFrameShape(QtGui.QFrame.Panel)
        self.lbl_CameraShow.setFrameShadow(QtGui.QFrame.Raised)
        self.lbl_CameraShow.setLineWidth(2)
        self.lbl_CameraShow.setMidLineWidth(1)
        self.lbl_CameraShow.setScaledContents(True)
        self.lbl_CameraShow.setObjectName("lbl_CameraShow")
        
        # Setup and draw the button
        self.pushButton_cam = QtGui.QPushButton(self.tab_3)
        self.pushButton_cam.setGeometry(QtCore.QRect(0, 300, 151, 51))
        self.pushButton_cam.setObjectName("pushButton_cam")
        self.pushButton_cam.setText("Update")
        # Tell the button what to do when it is clicked. In this case i want it to run the updateTab1 function below
        QtCore.QObject.connect(self.pushButton_cam, QtCore.SIGNAL('clicked()'), self.updateTab3)

        # Show the tab and draw contents
        self.tabWidget.addTab(self.tab_3, "")

        # Start on tab 4!
        self.tab_4 = QtGui.QWidget()
        self.tab_4.setObjectName("tab_4")



    
        self.tabWidget.addTab(self.tab_4, "")

        # Start on tab 5!
        self.tab_5 = QtGui.QWidget()
        self.tab_5.setObjectName("tab_5")

        # Create the text browser to show the large console input
        # I have used this to show i could get the information in to begin with... I will eventually parse this information and put it into a list
        # box of some sort
        self.textBrowser = QtGui.QTextBrowser(self.tab_5)
        self.textBrowser.setGeometry(QtCore.QRect(0, 10, 781, 301))
        self.textBrowser.setText (" Health Check V 0.5.0-4 \n Greg Roberts (Maemo.org - Noobmonkey) \n me@greg-roberts.com \n \n For Bugs and Feature requests: \n http://talk.maemo.org/showthread.php?p=541457")
        # Make the font small!!!
        font = QtGui.QFont()
        font.setPointSize(20)
        self.textBrowser.setFont(font)
        self.tabWidget.addTab(self.tab_5, "")

        # Draw the main Window
        MainWindow.setCentralWidget(self.centralwidget)
        # Draw the Menubar
        self.menubar = QtGui.QMenuBar(MainWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 800, 21))
        self.menubar.setObjectName("menubar")
        MainWindow.setMenuBar(self.menubar)
        # Draw the Status bar
        #self.statusbar = QtGui.QStatusBar(MainWindow)

        # Run the translate UI - Added by QT Designer - i have removed alot of setText's and placed them above.
        self.retranslateUi(MainWindow)
        #self.updateTab1()
        Thread(target=self.updateTab1()).start()

        # Set which tab you want showing on program load
        self.tabWidget.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(MainWindow)

        
# Funtion - update GPS - Using lib-location
    def updateGPS(self):
        global var_g_GPS
        # Start of the GPS Location information
        # Please visit here for more information and code on PyMaemo GPS API - http://wiki.maemo.org/PyMaemo/Using_Location_API

        #control = location.GPSDControl.get_default()
        #device = location.GPSDevice()
        
        loop = gobject.MainLoop()
        control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        control.set_properties(preferred_method=location.METHOD_USER_SELECTED,preferred_interval=location.INTERVAL_DEFAULT)

        control.connect("error-verbose", on_error, loop)
        device.connect("changed", on_changed, control)
        control.connect("gpsd-stopped", on_stop, loop)

        gobject.idle_add(start_location, control)

        loop.run()
        
        # Set the GPS tabel text       
        self.lbl_Gps_Info.setText(var_g_GPS)


# Funtion - update the front camera image
    def updateImage(self):
       
        # Close b - the greatly named variable - as i want to use it again! (Well close or declare it!)
        b = None
        # X-term - grab 10 buffered front camera images, and throw them into an image file.
        # Everyone recommends 1.... but 10 gave more light! - so i used it :D
        b = os.popen('gst-launch v4l2camsrc device=/dev/video1 num-buffers=10 ! dspjpegenc ! filesink location=/home/user/MyDocs/fcamtest.jpg')
        b.close ()
        # Declare and set the image file name
        image_file = "/home/user/MyDocs/fcamtest.jpg"
        image = QtGui.QPixmap(image_file)
        # Declare image, and tell it, that it is a pixmap, and it will be a pixmap of the file we have just set.
        self.lbl_CameraShow.setPixmap(image)
  
# Funtion - update Firmware version label
    def updateMaemoV(self):
        # This one reads fremantle version number (Firmware)
        g = os.popen('dpkg -l "mp-fremantle-*"').read()
        g = g.strip()[-15:]
        self.lbl_Maemo_Ver_Info.setText(g.strip())

# Funtion - update CPU Information
    def updateCPU(self):
        # This one reads fremantle version number (Firmware)
        ga = os.popen('cat /proc/cpuinfo | grep Processor').read()
        ga = ga.strip()[11:]
        self.lbl_ProcessorInfo.setText(ga.strip())
        
        gb = os.popen('cat /proc/cpuinfo | grep Hardware').read()
        gb = gb.strip()[11:]
        self.lbl_BoardInfo.setText(gb.strip())

        gc = os.popen('locale | grep LANG').read()
        gc = gc.strip()[5:]
        self.lbl_SysLocaleInfo.setText(gc.strip())

# Funtion - update battery information
    def updateBatt(self):
        # This one pulls out the battery percentage
        bg = os.popen('lshal|grep percen').read()
        # This one reads the applications list from dpkg
        # Do some string functions to find/remove messy parts of the battery pulled text.
        # Please excuse the poorly labeled variables here!
        C_a = str(bg)[:-15]
        print C_a
        C_b = str(C_a)[-4:]
        print C_b
        barxval = str.strip(C_b)
        print barxval
        self.lbl_Battery_Bar.setRange(0,100)
        self.lbl_Battery_Bar.setProperty("value", barxval)

# Funtion - update Accelerator information
    def updateAccel(self):
        # set f to = the accellerometer co-ordinates
        # the co-ords need to be pulled out and split for easy reading
        # Close down the co-ord file once used (Only displaying static info, not updating yet)
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r')
        coords = [int(w) for w in f.readline().split()]
        f.close()
        self.lbl_Accel_Info.setText(str(coords))

# Funtion - update rootfs, currently shows free MB and used %.
    def updaterootfs(self):
        # Call the x-terminal command to read the rootfs free space
        gr = os.popen('df -h /').read()
        # Remove some of the faffy bits. I've left the total free and percentage used at the moment, is a little confusing
        gx = str(gr)[-14:]
        gx = gx[:-7]
        self.lbl_rootfd_info.setText(gx.strip())

    def updatemydocs(self):
        # Call the x-terminal command to read the rootfs free space
        ge = os.popen('df -h /home/user/MyDocs').read()
        # Remove some of the faffy bits. I've left the total free and percentage used at the moment, is a little confusing
        gf = str(ge)[-34:]
        
        gf = gf[:-24]
        
        self.lbl_mydocsd_info.setText(gf.strip())
        
# Funtion - update tab.... Originally to update tab1, but using it to collate the functions
# It has the commented out message boxes, will work on this later
    def updateTab1(self):
        
        self.pushButton_hw.setEnabled(False)
        self.pushButton_hw.setText(".")
        
        Thread(target=self.updaterootfs()).start()
        self.pushButton_hw.setText("..")
        Thread(target=self.updateAccel()).start()
        self.pushButton_hw.setText("...")
        Thread(target=self.updateCPU()).start()
        self.pushButton_hw.setText("....")
        Thread(target=self.updatemydocs()).start()
        self.pushButton_hw.setText(".....")
        Thread(target=self.updateMaemoV()).start()
        self.pushButton_hw.setText("......")
        
        self.pushButton_hw.setText(".......")
        Thread(target=self.updateBatt()).start()
        self.pushButton_hw.setText("........")
        
        self.pushButton_hw.setText("Update")
        self.pushButton_hw.setEnabled(True)

    def updateTab2(self):
        self.pushButton_com.setEnabled(False)
        self.pushButton_com.setText("...")
        Thread(target=self.updateGPS()).start()
        self.pushButton_com.setText(".....")
        Thread(target=self.Cellular()).start()
        self.pushButton_com.setText("Update")
        self.pushButton_com.setEnabled(True)

    def updateTab3(self):
        self.pushButton_cam.setEnabled(False)
        self.pushButton_cam.setText("....")
        Thread(target=self.updateImage()).start()
        self.pushButton_cam.setText("Update")
        self.pushButton_cam.setEnabled(True)
        
    # This is the start of the QT Designer translation function - not using the translation function, but left it in, to show it is part of the class   
    def retranslateUi(self, MainWindow):
        MainWindow.setWindowTitle(QtGui.QApplication.translate("MainWindow", "Health Check 0.5.0-4", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab), QtGui.QApplication.translate("MainWindow", "System", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_2), QtGui.QApplication.translate("MainWindow", "Comms", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), QtGui.QApplication.translate("MainWindow", "Camera", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_4), QtGui.QApplication.translate("MainWindow", "Tools", None, QtGui.QApplication.UnicodeUTF8))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_5), QtGui.QApplication.translate("MainWindow", "About", None, QtGui.QApplication.UnicodeUTF8))
        
# Cell_info - Taken from netmon code. Need to figure out the author so i can give proper thanks!
# can be found here - http://repository.maemo.org/extras-devel/pool/fremantle/free/source/n/netmon/
    def Cellular(self):
        import dbus
	regstatus = gn_cellinfo.RegStatus()
	signalstrength = gn_cellinfo.SignalStrength()

	if (regstatus[0] == 0): status = 'home'
        elif (regstatus[0] == 1): status = 'roam'
        elif (regstatus[0] == 2): status = 'roam_blink'
	elif (regstatus[0] == 3): status = 'no serv.'
	elif (regstatus[0] == 4): status = 'no serv. search'
	elif (regstatus[0] == 5): status = 'no serv. no search'
	elif (regstatus[0] == 6): status = 'no sim'
	elif (regstatus[0] == 8): status = 'power off'
	elif (regstatus[0] == 9): status = 'nsps'
	elif (regstatus[0] == 10): status = 'nsps no cover.'
	elif (regstatus[0] == 10): status = 'sim rejected'
        else: status = 'unknown'

	if (regstatus[5] == 0): network_type = 'home'
	elif (regstatus[5] == 1): network_type = 'preferred'
	elif (regstatus[5] == 2): network_type = 'forbidden'
	elif (regstatus[5] == 2): network_type = 'other'
	else: network_type = 'no network'
        services = ""
        if (regstatus[6] & 0x02): services += 'CS '
	if (regstatus[6] & 0x01): services += 'GPRS '
	if (regstatus[6] & 0x04): services += 'EGPRS '
	if (regstatus[6] & 0x08): services += 'HSDPA '
	if (regstatus[6] & 0x10): services += 'HSUPA'

	fraction = 1.0 / 100 * signalstrength[0]
	text = " - %d dBm" % signalstrength[1]
        self.lbl_pSignal_Info.setText(text)


	#print "reg 1 %i" % regstatus[4]
	#print "reg 3 %i" % regstatus[3]
	#print "reg 1 %i" % regstatus[1]
	cell_id = regstatus[2] & 65535
	cell_rnc = regstatus[2] >> 16
		
	#if (cell_rnc): self.lbl_pRNC_Info.setText(cell_rnc)
	#else: print " "
	self.lbl_pRNC_Info.setText(status)
	self.lbl_CellID_Info.setText(str(cell_id))
	#print status
	#print network_type
	#print "regstatus %i" % regstatus[7]
	self.lbl_pServices_Info.setText(services)

	##dbus-send --system --print-reply --type=method_call --dest=com.nokia.phone.SIM /com/nokia/phone/SIM/security Phone.Sim.Security.get_imei
        #bus = dbus.SystemBus()
        #dbus_object = bus.get_object('com.nokia.phone.SIM', '/com/nokia/phone/SIM/security')
        #dbus_interface = dbus.Interface(dbus_object, 'Phone.Sim.Security')
        #print "imei"
        #ia = dbus_interface.get_imei()
        #ib = ia[15:]
        #ic = ib[:15]
        #print ic
                


# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def on_error(control, error, user_data):
    if error == location.ERROR_USER_REJECTED_DIALOG:
        print "User didn't enable requested methods"
    elif error == location.ERROR_USER_REJECTED_SETTINGS:
        print "User changed settings, which disabled location"
    elif error == location.ERROR_BT_GPS_NOT_AVAILABLE:
        print "Problems with BT GPS"
    elif error == location.ERROR_METHOD_NOT_ALLOWED_IN_OFFLINE_MODE:
        print "Requested method is not allowed in offline mode"
    elif error == location.ERROR_SYSTEM:
        print "System error"
        

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, partially commented by me
# Moved out of the class by me
def on_changed(device, data):
    global var_g_GPS
    if not device:
        var_g_GPS = "No GPS Found"
        return
    if device.fix:
        if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
            #Set our global variable as the location information! - scroll backup to see where it was used
            var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
            #print device.fix[4:6]
            #Seems to struggle with doing it once.... so do it 5 times to warm it up!
        for i in range(1, 4):
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                var_g_GPS = "lat = %f, long = %f" % device.fix[4:6]
        #if device.fix[1] & location.GPS_DEVICE_ALTITUDE_SET:
            #print "alt = %f" % device.fix[7]

            data.stop()

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def on_stop(control, data):
    data.quit()

# This is part of the Location api - link http://wiki.maemo.org/PyMaemo/Using_Location_API, uncommented by me
# Moved out of the class by me
def start_location(data):
    data.start()
    return False


# Start the main program/function
if __name__ == "__main__":
    
    app = QtGui.QApplication(sys.argv)
    MainWindow = QtGui.QMainWindow()
    ui = Ui_MainWindow()
    ui.setupUi(MainWindow)
    MainWindow.show()

    sys.exit(app.exec_())

