// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "ConfigurationXML.hpp"

namespace cxml
{
  // ConfigurationXML
  // 

  const ConfigurationXML::language_type& ConfigurationXML::
  language () const
  {
    return this->language_.get ();
  }

  ConfigurationXML::language_type& ConfigurationXML::
  language ()
  {
    return this->language_.get ();
  }

  void ConfigurationXML::
  language (const language_type& language)
  {
    this->language_.set (language);
  }

  void ConfigurationXML::
  language (::std::auto_ptr< language_type > language)
  {
    this->language_.set (language);
  }

  const ConfigurationXML::keyboard_type& ConfigurationXML::
  keyboard () const
  {
    return this->keyboard_.get ();
  }

  ConfigurationXML::keyboard_type& ConfigurationXML::
  keyboard ()
  {
    return this->keyboard_.get ();
  }

  void ConfigurationXML::
  keyboard (const keyboard_type& keyboard)
  {
    this->keyboard_.set (keyboard);
  }

  void ConfigurationXML::
  keyboard (::std::auto_ptr< keyboard_type > keyboard)
  {
    this->keyboard_.set (keyboard);
  }

  const ConfigurationXML::volume_type& ConfigurationXML::
  volume () const
  {
    return this->volume_.get ();
  }

  ConfigurationXML::volume_type& ConfigurationXML::
  volume ()
  {
    return this->volume_.get ();
  }

  void ConfigurationXML::
  volume (const volume_type& volume)
  {
    this->volume_.set (volume);
  }

  void ConfigurationXML::
  volume (::std::auto_ptr< volume_type > volume)
  {
    this->volume_.set (volume);
  }


  // keyboard
  // 

  const keyboard::left_type& keyboard::
  left () const
  {
    return this->left_.get ();
  }

  keyboard::left_type& keyboard::
  left ()
  {
    return this->left_.get ();
  }

  void keyboard::
  left (const left_type& left)
  {
    this->left_.set (left);
  }

  const keyboard::right_type& keyboard::
  right () const
  {
    return this->right_.get ();
  }

  keyboard::right_type& keyboard::
  right ()
  {
    return this->right_.get ();
  }

  void keyboard::
  right (const right_type& right)
  {
    this->right_.set (right);
  }

  const keyboard::up_type& keyboard::
  up () const
  {
    return this->up_.get ();
  }

  keyboard::up_type& keyboard::
  up ()
  {
    return this->up_.get ();
  }

  void keyboard::
  up (const up_type& up)
  {
    this->up_.set (up);
  }

  const keyboard::down_type& keyboard::
  down () const
  {
    return this->down_.get ();
  }

  keyboard::down_type& keyboard::
  down ()
  {
    return this->down_.get ();
  }

  void keyboard::
  down (const down_type& down)
  {
    this->down_.set (down);
  }

  const keyboard::take_type& keyboard::
  take () const
  {
    return this->take_.get ();
  }

  keyboard::take_type& keyboard::
  take ()
  {
    return this->take_.get ();
  }

  void keyboard::
  take (const take_type& take)
  {
    this->take_.set (take);
  }

  const keyboard::jump_type& keyboard::
  jump () const
  {
    return this->jump_.get ();
  }

  keyboard::jump_type& keyboard::
  jump ()
  {
    return this->jump_.get ();
  }

  void keyboard::
  jump (const jump_type& jump)
  {
    this->jump_.set (jump);
  }

  const keyboard::shoot_type& keyboard::
  shoot () const
  {
    return this->shoot_.get ();
  }

  keyboard::shoot_type& keyboard::
  shoot ()
  {
    return this->shoot_.get ();
  }

  void keyboard::
  shoot (const shoot_type& shoot)
  {
    this->shoot_.set (shoot);
  }

  const keyboard::takeandjump_type& keyboard::
  takeandjump () const
  {
    return this->takeandjump_.get ();
  }

  keyboard::takeandjump_type& keyboard::
  takeandjump ()
  {
    return this->takeandjump_.get ();
  }

  void keyboard::
  takeandjump (const takeandjump_type& takeandjump)
  {
    this->takeandjump_.set (takeandjump);
  }

  const keyboard::swap_type& keyboard::
  swap () const
  {
    return this->swap_.get ();
  }

  keyboard::swap_type& keyboard::
  swap ()
  {
    return this->swap_.get ();
  }

  void keyboard::
  swap (const swap_type& swap)
  {
    this->swap_.set (swap);
  }

  const keyboard::halt_type& keyboard::
  halt () const
  {
    return this->halt_.get ();
  }

  keyboard::halt_type& keyboard::
  halt ()
  {
    return this->halt_.get ();
  }

  void keyboard::
  halt (const halt_type& halt)
  {
    this->halt_.set (halt);
  }


  // volume
  // 

  const volume::fx_type& volume::
  fx () const
  {
    return this->fx_.get ();
  }

  volume::fx_type& volume::
  fx ()
  {
    return this->fx_.get ();
  }

  void volume::
  fx (const fx_type& fx)
  {
    this->fx_.set (fx);
  }

  const volume::music_type& volume::
  music () const
  {
    return this->music_.get ();
  }

  volume::music_type& volume::
  music ()
  {
    return this->music_.get ();
  }

  void volume::
  music (const music_type& music)
  {
    this->music_.set (music);
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

namespace cxml
{
  // ConfigurationXML
  //

  ConfigurationXML::
  ConfigurationXML (const language_type& language,
                    const keyboard_type& keyboard,
                    const volume_type& volume)
  : ::xml_schema::type (),
    language_ (language, ::xml_schema::flags (), this),
    keyboard_ (keyboard, ::xml_schema::flags (), this),
    volume_ (volume, ::xml_schema::flags (), this)
  {
  }

  ConfigurationXML::
  ConfigurationXML (const ConfigurationXML& x,
                    ::xml_schema::flags f,
                    ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    language_ (x.language_, f, this),
    keyboard_ (x.keyboard_, f, this),
    volume_ (x.volume_, f, this)
  {
  }

  ConfigurationXML::
  ConfigurationXML (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    language_ (f, this),
    keyboard_ (f, this),
    volume_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void ConfigurationXML::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // language
      //
      if (n.name () == "language" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< language_type > r (
          language_traits::create (i, f, this));

        if (!language_.present ())
        {
          this->language (r);
          continue;
        }
      }

      // keyboard
      //
      if (n.name () == "keyboard" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< keyboard_type > r (
          keyboard_traits::create (i, f, this));

        if (!keyboard_.present ())
        {
          this->keyboard (r);
          continue;
        }
      }

      // volume
      //
      if (n.name () == "volume" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< volume_type > r (
          volume_traits::create (i, f, this));

        if (!volume_.present ())
        {
          this->volume (r);
          continue;
        }
      }

      break;
    }

    if (!language_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "language",
        "");
    }

    if (!keyboard_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "keyboard",
        "");
    }

    if (!volume_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "volume",
        "");
    }
  }

  ConfigurationXML* ConfigurationXML::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new ConfigurationXML (*this, f, c);
  }

  // keyboard
  //

  keyboard::
  keyboard (const left_type& left,
            const right_type& right,
            const up_type& up,
            const down_type& down,
            const take_type& take,
            const jump_type& jump,
            const shoot_type& shoot,
            const takeandjump_type& takeandjump,
            const swap_type& swap,
            const halt_type& halt)
  : ::xml_schema::type (),
    left_ (left, ::xml_schema::flags (), this),
    right_ (right, ::xml_schema::flags (), this),
    up_ (up, ::xml_schema::flags (), this),
    down_ (down, ::xml_schema::flags (), this),
    take_ (take, ::xml_schema::flags (), this),
    jump_ (jump, ::xml_schema::flags (), this),
    shoot_ (shoot, ::xml_schema::flags (), this),
    takeandjump_ (takeandjump, ::xml_schema::flags (), this),
    swap_ (swap, ::xml_schema::flags (), this),
    halt_ (halt, ::xml_schema::flags (), this)
  {
  }

  keyboard::
  keyboard (const keyboard& x,
            ::xml_schema::flags f,
            ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    left_ (x.left_, f, this),
    right_ (x.right_, f, this),
    up_ (x.up_, f, this),
    down_ (x.down_, f, this),
    take_ (x.take_, f, this),
    jump_ (x.jump_, f, this),
    shoot_ (x.shoot_, f, this),
    takeandjump_ (x.takeandjump_, f, this),
    swap_ (x.swap_, f, this),
    halt_ (x.halt_, f, this)
  {
  }

  keyboard::
  keyboard (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    left_ (f, this),
    right_ (f, this),
    up_ (f, this),
    down_ (f, this),
    take_ (f, this),
    jump_ (f, this),
    shoot_ (f, this),
    takeandjump_ (f, this),
    swap_ (f, this),
    halt_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void keyboard::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // left
      //
      if (n.name () == "left" && n.namespace_ ().empty ())
      {
        if (!left_.present ())
        {
          this->left (left_traits::create (i, f, this));
          continue;
        }
      }

      // right
      //
      if (n.name () == "right" && n.namespace_ ().empty ())
      {
        if (!right_.present ())
        {
          this->right (right_traits::create (i, f, this));
          continue;
        }
      }

      // up
      //
      if (n.name () == "up" && n.namespace_ ().empty ())
      {
        if (!up_.present ())
        {
          this->up (up_traits::create (i, f, this));
          continue;
        }
      }

      // down
      //
      if (n.name () == "down" && n.namespace_ ().empty ())
      {
        if (!down_.present ())
        {
          this->down (down_traits::create (i, f, this));
          continue;
        }
      }

      // take
      //
      if (n.name () == "take" && n.namespace_ ().empty ())
      {
        if (!take_.present ())
        {
          this->take (take_traits::create (i, f, this));
          continue;
        }
      }

      // jump
      //
      if (n.name () == "jump" && n.namespace_ ().empty ())
      {
        if (!jump_.present ())
        {
          this->jump (jump_traits::create (i, f, this));
          continue;
        }
      }

      // shoot
      //
      if (n.name () == "shoot" && n.namespace_ ().empty ())
      {
        if (!shoot_.present ())
        {
          this->shoot (shoot_traits::create (i, f, this));
          continue;
        }
      }

      // takeandjump
      //
      if (n.name () == "takeandjump" && n.namespace_ ().empty ())
      {
        if (!takeandjump_.present ())
        {
          this->takeandjump (takeandjump_traits::create (i, f, this));
          continue;
        }
      }

      // swap
      //
      if (n.name () == "swap" && n.namespace_ ().empty ())
      {
        if (!swap_.present ())
        {
          this->swap (swap_traits::create (i, f, this));
          continue;
        }
      }

      // halt
      //
      if (n.name () == "halt" && n.namespace_ ().empty ())
      {
        if (!halt_.present ())
        {
          this->halt (halt_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!left_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "left",
        "");
    }

    if (!right_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "right",
        "");
    }

    if (!up_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "up",
        "");
    }

    if (!down_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "down",
        "");
    }

    if (!take_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "take",
        "");
    }

    if (!jump_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "jump",
        "");
    }

    if (!shoot_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "shoot",
        "");
    }

    if (!takeandjump_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "takeandjump",
        "");
    }

    if (!swap_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "swap",
        "");
    }

    if (!halt_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "halt",
        "");
    }
  }

  keyboard* keyboard::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new keyboard (*this, f, c);
  }

  // volume
  //

  volume::
  volume (const fx_type& fx,
          const music_type& music)
  : ::xml_schema::type (),
    fx_ (fx, ::xml_schema::flags (), this),
    music_ (music, ::xml_schema::flags (), this)
  {
  }

  volume::
  volume (const volume& x,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    fx_ (x.fx_, f, this),
    music_ (x.music_, f, this)
  {
  }

  volume::
  volume (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    fx_ (f, this),
    music_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void volume::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // fx
      //
      if (n.name () == "fx" && n.namespace_ ().empty ())
      {
        if (!fx_.present ())
        {
          this->fx (fx_traits::create (i, f, this));
          continue;
        }
      }

      // music
      //
      if (n.name () == "music" && n.namespace_ ().empty ())
      {
        if (!music_.present ())
        {
          this->music (music_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!fx_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "fx",
        "");
    }

    if (!music_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "music",
        "");
    }
  }

  volume* volume::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new volume (*this, f, c);
  }
}

#include <istream>
#include <xercesc/framework/Wrapper4InputSource.hpp>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace cxml
{
  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (const ::std::string& u,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    ::std::auto_ptr< ::cxml::ConfigurationXML > r (
      ::cxml::configuration (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (const ::std::string& u,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::cxml::ConfigurationXML > r (
      ::cxml::configuration (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (const ::std::string& u,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::cxml::ConfigurationXML > r (
      ::cxml::configuration (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (::std::istream& is,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::cxml::configuration (wrap, f, p);
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (::std::istream& is,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::cxml::configuration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (::std::istream& is,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::cxml::configuration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (::std::istream& is,
                 const ::std::string& sid,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::cxml::configuration (wrap, f, p);
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (::std::istream& is,
                 const ::std::string& sid,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::cxml::configuration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (::std::istream& is,
                 const ::std::string& sid,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::cxml::configuration (wrap, h, f, p);
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (const ::xercesc::DOMInputSource& i,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    ::std::auto_ptr< ::cxml::ConfigurationXML > r (
      ::cxml::configuration (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (const ::xercesc::DOMInputSource& i,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::cxml::ConfigurationXML > r (
      ::cxml::configuration (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (const ::xercesc::DOMInputSource& i,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::cxml::ConfigurationXML > r (
      ::cxml::configuration (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (const ::xercesc::DOMDocument& d,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
        static_cast< ::xercesc::DOMDocument* > (d.cloneNode (true)));

      ::std::auto_ptr< ::cxml::ConfigurationXML > r (
        ::cxml::configuration (
          c.get (), f | ::xml_schema::flags::own_dom, p));

      c.release ();
      return r;
    }

    const ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "configuration" &&
        n.namespace_ () == "")
    {
      ::std::auto_ptr< ::cxml::ConfigurationXML > r (
        ::xsd::cxx::tree::traits< ::cxml::ConfigurationXML, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "configuration",
      "");
  }

  ::std::auto_ptr< ::cxml::ConfigurationXML >
  configuration (::xercesc::DOMDocument* d,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties&)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    const ::xercesc::DOMElement& e (
      c.get ()
      ? *c->getDocumentElement ()
      : *d->getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "configuration" &&
        n.namespace_ () == "")
    {
      ::std::auto_ptr< ::cxml::ConfigurationXML > r (
        ::xsd::cxx::tree::traits< ::cxml::ConfigurationXML, char >::create (
          e, f, 0));
      c.release ();
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "configuration",
      "");
  }
}

#include <ostream>
#include <xsd/cxx/xml/dom/serialization-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace cxml
{
  void
  configuration (::std::ostream& o,
                 const ::cxml::ConfigurationXML& s,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::cxml::configuration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  configuration (::std::ostream& o,
                 const ::cxml::ConfigurationXML& s,
                 const ::xml_schema::namespace_infomap& m,
                 ::xml_schema::error_handler& h,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::cxml::configuration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::std::ostream& o,
                 const ::cxml::ConfigurationXML& s,
                 const ::xml_schema::namespace_infomap& m,
                 ::xercesc::DOMErrorHandler& h,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::cxml::configuration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::xercesc::XMLFormatTarget& t,
                 const ::cxml::ConfigurationXML& s,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::cxml::configuration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  configuration (::xercesc::XMLFormatTarget& t,
                 const ::cxml::ConfigurationXML& s,
                 const ::xml_schema::namespace_infomap& m,
                 ::xml_schema::error_handler& h,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::cxml::configuration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::xercesc::XMLFormatTarget& t,
                 const ::cxml::ConfigurationXML& s,
                 const ::xml_schema::namespace_infomap& m,
                 ::xercesc::DOMErrorHandler& h,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::cxml::configuration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::xercesc::DOMDocument& d,
                 const ::cxml::ConfigurationXML& s,
                 ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "configuration" &&
        n.namespace_ () == "")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "configuration",
        "");
    }
  }

  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  configuration (const ::cxml::ConfigurationXML& s,
                 const ::xml_schema::namespace_infomap& m,
                 ::xml_schema::flags f)
  {
    try
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::serialize< char > (
          "configuration",
          "",
          m, f));

      ::cxml::configuration (*d, s, f);
      return d;
    }
    catch (const ::xsd::cxx::xml::dom::mapping< char >& e)
    {
      throw ::xsd::cxx::tree::no_namespace_mapping< char > (e.name ());
    }
    catch (const ::xsd::cxx::xml::dom::xsi_already_in_use&)
    {
      throw ::xsd::cxx::tree::xsi_already_in_use< char > ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const ConfigurationXML& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // language
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "language",
          e));

      s << i.language ();
    }

    // keyboard
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "keyboard",
          e));

      s << i.keyboard ();
    }

    // volume
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "volume",
          e));

      s << i.volume ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const keyboard& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // left
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "left",
          e));

      s << i.left ();
    }

    // right
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "right",
          e));

      s << i.right ();
    }

    // up
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "up",
          e));

      s << i.up ();
    }

    // down
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "down",
          e));

      s << i.down ();
    }

    // take
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "take",
          e));

      s << i.take ();
    }

    // jump
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "jump",
          e));

      s << i.jump ();
    }

    // shoot
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "shoot",
          e));

      s << i.shoot ();
    }

    // takeandjump
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "takeandjump",
          e));

      s << i.takeandjump ();
    }

    // swap
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "swap",
          e));

      s << i.swap ();
    }

    // halt
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "halt",
          e));

      s << i.halt ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const volume& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // fx
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "fx",
          e));

      s << i.fx ();
    }

    // music
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "music",
          e));

      s << i.music ();
    }
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

