import os
import sys
import time
from PySide.QtCore import *
from PySide.QtGui import *

# Some global variables
HandyGuiVersion = "0.0.1-1"
CommentChar = '#'
OptionChar =  ' '
Home = os.path.expanduser("~")
Handy_KeyCfgFile = Home + '/.config/handy/handy.conf'
HandyGui_CfgFile = Home + '/.config/handy-gui/handy-gui.cfg'
LastPlayed_File = Home + '/.config/handy-gui/last_played.txt'
P1buttons = ""
BiosPath = ""
RomPath = ""
ExecPath = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if OptionChar in line:
                 # split on option char:
                 option, value = line.split(OptionChar, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options



class Ui_MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self, None)
        self.setWindowTitle("Handy-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	'''
	Check for required files
	'''
	# Load config
        self.gui_opts = parse_config(self,HandyGui_CfgFile)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + HandyGui_CfgFile + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/handy_sdl"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/handy_sdl' not found!")
        	widget = pathWindow(self)
		widget.show()
	try:
	        open(Handy_KeyCfgFile ,"r")
	except:
		QMessageBox.critical(self, "Critical", "Config file '" + Handy_KeyCfgFile + "' not readable!")
    		sys.exit()
	if not os.path.isdir(self.gui_opts["rom_path"]):
		QMessageBox.critical(self, "Critical",  "rom_path" + " '" + self.gui_opts["rom_path"] + "' not found!")
       		widget = pathWindow(self)
		widget.show()

	if not os.path.isfile(self.gui_opts["exec_path"] + "/lynxboot.img"):
		QMessageBox.critical(self, "Critical",  "Bios " + " '" + self.gui_opts["exec_path"] + "/lynxboot.img" + "' not found!")
    		sys.exit()

	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/handy-gui/lynx.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(backgroundLabel)
        # Get Gametitles from rom_path
	ListCmd = "cd '" + self.gui_opts["rom_path"] + "' 2>/dev/null;ls -1 *.zip *.ZIP *.LNX *.lnx 2>/dev/null|sort -f" 
        fin,fout = os.popen4(ListCmd)
        romList = fout.read()
        fin.close()
        romList = romList.split('\n')
        romList = romList[:-1]
        if not romList:
                romList = ['No roms found']


        self.combo = QComboBox(self)
        self.combo.setStyleSheet( \
	"QComboBox { color: gray; \
	 border: 6px solid #045FB4; \
	 border-radius: 3px; \
	 min-width: 6em; \
	 }" )
	self.combo.setGeometry(QRect(20, 25, 750, 60))
        # Read last started file
        try:
                playedFile = open(LastPlayed_File,"r")
        except:
                last_game = "dummy"
        else:
                last_game = playedFile.readlines()
        maxLength=63
        for Game in romList:
                space=""
                spacecount=maxLength-len(Game)
                for x in range(0,spacecount):
                        space=space+" "
                self.combo.addItem(space+Game)
        self.GameFile=[[t] for t in romList if t]
        # Set last file as current
        if last_game[0] in romList:
                self.combo.setCurrentIndex(romList.index(last_game[0]))

	# Define menubar
	aboutAction = QAction( '&About', self)
        aboutAction.triggered.connect(self.slotAbout)
	configAction = QAction( '&Config', self)
        configAction.triggered.connect(self.slotConfig)

        menubar = self.menuBar()
        fileMenu = menubar.addMenu('&MainMenu')
        fileMenu.addAction(configAction)
        fileMenu.addAction(aboutAction)

        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.onesmutePushButton = QPushButton("Mute",self)
	self.onesmutePushButton.setCheckable(True)
        self.onesmutePushButton.setGeometry(QRect(400, 370, 400, 55))
        self.onesmutePushButton.setFont(font)
	if self.gui_opts["sound"] == "true":
           self.onesmutePushButton.setChecked(False)
	else:
            self.onesmutePushButton.setChecked(True)


    def on_start_clicked(self):
        gameNbr = self.combo.currentIndex()
        self.gameFile = str(self.GameFile[gameNbr]).strip("['']")

	# Add all the options
	# but first, re-read all settings
        self.gui_opts = parse_config(self,HandyGui_CfgFile)
        if self.onesmutePushButton.isChecked():
		ALL_OPTS="-nosound "
        else:  ALL_OPTS="-sound "
        if self.gui_opts["lcd"] == "false":
		ALL_OPTS = ALL_OPTS + "-nolcd "
        else:  ALL_OPTS = ALL_OPTS + "-lcd "
        if self.gui_opts["fullscreen"] == "false":
		ALL_OPTS = ALL_OPTS + "-nofullscreen "
        else:  ALL_OPTS = ALL_OPTS + "-fullscreen "

        if not (self.gameFile == "No roms found" ):
                # Write as last played game
                playedFile = open(LastPlayed_File,"w")
                playedFile.write(self.gameFile)
                playedFile.close()
                # Start emulator with parameters
		os.chdir(self.gui_opts["exec_path"])
		print self.gui_opts["exec_path"] + "/handy_sdl " + '"' + self.gui_opts["rom_path"] + "/" + self.gameFile + '" ' + ALL_OPTS
		QProcess.startDetached(self.gui_opts["exec_path"] + "/handy_sdl " + '"' + self.gui_opts["rom_path"] + "/" + self.gameFile + '" ' + ALL_OPTS)

		if (self.gui_opts["exit_after_launch"] == "true"):
			time.sleep(5)
			os._exit(0)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About Handy-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.label = QLabel(self)
	AboutTxt = "<h3>Handy-gui " + HandyGuiVersion + "</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/handy_gui.png /><br>" \
                   "Handy-gui is a Graphical User Interface for Handy/SDL<p> " \
                   "Handy/SDL emulates the Atari Lynx &#174; handheld</p>" \
                   "<p>Handy-gui is written in PySide by <i>Arno Dekker</i> 2012<p>" %dict()
        self.label.setText(AboutTxt)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self,parent):
        QMainWindow.__init__(self,parent)
        self.setWindowTitle("Configuration Handy-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
	area = QScrollArea()
	lay = QVBoxLayout()
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	self.setCentralWidget(area)
	wg.resize(794,400);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
        self.gui_opts = parse_config(self,HandyGui_CfgFile)
        font = QFont()
        font.setPointSize(20)
	self.setLayout(grid)
	# lcd
        self.lcdPushButton = QPushButton("LCD display",self)
	self.lcdPushButton.setCheckable(True)
        grid.addWidget(self.lcdPushButton,0,0)
        self.lcdPushButton.setFont(font)
	if self.gui_opts["lcd"] == "true":
            self.lcdPushButton.setChecked(True)
	# sound
        self.soundPushButton = QPushButton("sound",self)
	self.soundPushButton.setCheckable(True)
        grid.addWidget(self.soundPushButton,0,1)
        self.soundPushButton.setFont(font)
	if self.gui_opts["sound"] == "true":
            self.soundPushButton.setChecked(True)
        # Exit on start button
        self.exitPushButton = QPushButton("exit after start game",self)
	self.exitPushButton.setCheckable(True)
        grid.addWidget(self.exitPushButton,0,2)
	if self.gui_opts["exit_after_launch"] == "true":
		self.exitPushButton.setChecked(True)
	# Path button
        self.pathButton = QPushButton("paths def",self)
        self.pathButton.setFont(font)
        grid.addWidget(self.pathButton,5,0)
	QObject.connect(self.pathButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Keys button
        self.keysButton = QPushButton("key def",self)
        self.keysButton.setFont(font)
        grid.addWidget(self.keysButton,5,1)
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# fullscreen
        self.fullscreenPushButton = QPushButton("fullscreen",self)
	self.fullscreenPushButton.setCheckable(True)
        grid.addWidget(self.fullscreenPushButton,5,2)
        self.fullscreenPushButton.setFont(font)
	if self.gui_opts["fullscreen"] == "true":
            self.fullscreenPushButton.setChecked(True)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setFont(font)
        grid.addWidget(self.saveButton,6,0,1,3)
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
        if self.soundPushButton.isChecked():
           self.gui_opts["sound"] = "true"
        else: self.gui_opts["sound"] = "false" 
        if self.lcdPushButton.isChecked():
           self.gui_opts["lcd"] = "true"
        else: self.gui_opts["lcd"] = "false" 
        if self.fullscreenPushButton.isChecked():
           self.gui_opts["fullscreen"] = "true"
        else: self.gui_opts["fullscreen"] = "false" 
        if self.exitPushButton.isChecked():
           self.gui_opts["exit_after_launch"] = "true"
        else: self.gui_opts["exit_after_launch"] = "false" 
        if RomPath != "":
           self.gui_opts["rom_path"] = RomPath
	

        orgConfigFile = open(HandyGui_CfgFile,"r")
	try:
	        copyFile = open(HandyGui_CfgFile + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + HandyGui_CfgFile + ".old")
	else:
		# Write the copy (.old)
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(HandyGui_CfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + HandyGui_CfgFile)
		else:
			newConfigFile.write("# Generated by handy-gui\n")
			for option in self.gui_opts:
				newConfigFile.write(option + " " + self.gui_opts[option] + "\n")
			newConfigFile.close()
			os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
			           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
			           string:"Configuration is succesfully saved"')


    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.gui_opts[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
        widget = keyWindow(self)
        widget.show()

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	
class keyWindow(QDialog):
    def __init__(self, parent=None):
        super(keyWindow, self).__init__(parent)
        self.setWindowTitle("Handy-gui button config")
	LineNbr=1
        self.options = parse_config(self,Handy_KeyCfgFile)
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,850);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=1
	maxKeyValue=313
        self.saveKeyButton = QPushButton("SAVE",self)
        self.saveKeyButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
	grid.addWidget(QLabel("<font color=red>Save below!</font>"), 1, 0)
        grid.addWidget(self.saveKeyButton,12,0,1,3)
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
	# Add button list
	cntr=2
	for pButton in ['UP','DOWN','LEFT','RIGHT','BUTTONA','BUTTONB','OPTION1','OPTION2'\
                        ,'PAUSE','EXIT']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# UP
        self.P1UpkeySpinBox = QDoubleSpinBox()
        self.P1UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1UpkeySpinBox.setValue(float(self.options["UP"]))
        self.P1UpkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1UpkeySpinBox, 2, 1)
        self.P1UpButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1UpButton, 2, 2)
	# DOWN
        self.P1DownkeySpinBox = QDoubleSpinBox()
        self.P1DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1DownkeySpinBox.setValue(float(self.options["DOWN"]))
        self.P1DownkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1DownkeySpinBox, 3, 1)
        self.P1DownButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1DownButton, 3, 2)

	# LEFT
        self.P1LeftkeySpinBox = QDoubleSpinBox()
        self.P1LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1LeftkeySpinBox.setValue(float(self.options["LEFT"]))
        self.P1LeftkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1LeftkeySpinBox, 4, 1)
        self.P1LeftButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1LeftButton, 4, 2)
	# RIGHT
        self.P1RightkeySpinBox = QDoubleSpinBox()
        self.P1RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1RightkeySpinBox.setValue(float(self.options["RIGHT"]))
        self.P1RightkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1RightkeySpinBox, 5, 1)
        self.P1RightButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1RightButton, 5, 2)
	# BUTTONA
        self.P1ButtonAkeySpinBox = QDoubleSpinBox()
        self.P1ButtonAkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1ButtonAkeySpinBox.setValue(float(self.options["BUTTONA"]))
        self.P1ButtonAkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1ButtonAkeySpinBox, 6, 1)
        self.P1ButtonAButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1ButtonAButton, 6, 2)
	# BUTTONB
        self.P1ButtonBkeySpinBox = QDoubleSpinBox()
        self.P1ButtonBkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1ButtonBkeySpinBox.setValue(float(self.options["BUTTONB"]))
        self.P1ButtonBkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1ButtonBkeySpinBox, 7, 1)
        self.P1ButtonBButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1ButtonBButton, 7, 2)
	# OPTION1
        self.P1Option1keySpinBox = QDoubleSpinBox()
        self.P1Option1keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Option1keySpinBox.setValue(float(self.options["OPTION1"]))
        self.P1Option1keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Option1keySpinBox, 8, 1)
        self.P1Option1Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Option1Button, 8, 2)
	# OPTION2
        self.P1Option2keySpinBox = QDoubleSpinBox()
        self.P1Option2keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Option2keySpinBox.setValue(float(self.options["OPTION2"]))
        self.P1Option2keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Option2keySpinBox, 9, 1)
        self.P1Option2Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Option2Button, 9, 2)
	# PAUSE
        self.P1PausekeySpinBox = QDoubleSpinBox()
        self.P1PausekeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1PausekeySpinBox.setValue(float(self.options["PAUSE"]))
        self.P1PausekeySpinBox.setDecimals(0)
        grid.addWidget(self.P1PausekeySpinBox, 10, 1)
        self.P1PauseButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1PauseButton, 10, 2)
	# EXIT
        self.P1ExitkeySpinBox = QDoubleSpinBox()
        self.P1ExitkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1ExitkeySpinBox.setValue(float(self.options["EXIT"]))
        self.P1ExitkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1ExitkeySpinBox, 11, 1)
        self.P1ExitButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1ExitButton, 11, 2)

	self.setLayout(grid)

        self.connect(self.P1UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1ButtonAkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1ButtonBkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Option1keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Option2keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1PausekeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1ExitkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1UpButton, SIGNAL("keyPressed"),self.P1updateUp)
	self.connect(self.P1DownButton, SIGNAL("keyPressed"),self.P1updateDown)
	self.connect(self.P1RightButton, SIGNAL("keyPressed"),self.P1updateRight)
	self.connect(self.P1LeftButton, SIGNAL("keyPressed"),self.P1updateLeft)
	self.connect(self.P1ButtonAButton, SIGNAL("keyPressed"),self.P1updateButtonA)
	self.connect(self.P1ButtonBButton, SIGNAL("keyPressed"),self.P1updateButtonB)
	self.connect(self.P1Option1Button, SIGNAL("keyPressed"),self.P1updateOption1)
	self.connect(self.P1Option2Button, SIGNAL("keyPressed"),self.P1updateOption2)
	self.connect(self.P1PauseButton, SIGNAL("keyPressed"),self.P1updatePause)
	self.connect(self.P1ExitButton, SIGNAL("keyPressed"),self.P1updateExit)
	self.connect(self.saveKeyButton, SIGNAL("clicked()"),self.SaveKeys)

    def P1updateRight(self):
        self.P1RightkeySpinBox.setValue(float(AsciiVal))

    def P1updateLeft(self):
        self.P1LeftkeySpinBox.setValue(float(AsciiVal))

    def P1updateUp(self):
        self.P1UpkeySpinBox.setValue(float(AsciiVal))

    def P1updateDown(self):
        self.P1DownkeySpinBox.setValue(float(AsciiVal))

    def P1updateButtonA(self):
        self.P1ButtonAkeySpinBox.setValue(float(AsciiVal))

    def P1updateButtonB(self):
        self.P1ButtonBkeySpinBox.setValue(float(AsciiVal))

    def P1updateOption1(self):
        self.P1Option1keySpinBox.setValue(float(AsciiVal))

    def P1updateOption2(self):
        self.P1Option2keySpinBox.setValue(float(AsciiVal))

    def P1updatePause(self):
        self.P1PausekeySpinBox.setValue(float(AsciiVal))

    def P1updateExit(self):
        self.P1ExitkeySpinBox.setValue(float(AsciiVal))


    def change_value(self,event):
        # P1
        self.options["UP"] = "%.0f" % self.P1UpkeySpinBox.value()
        self.options["DOWN"] = "%.0f" % self.P1DownkeySpinBox.value()
        self.options["RIGHT"] = "%.0f" % self.P1RightkeySpinBox.value()
        self.options["LEFT"] = "%.0f" % self.P1LeftkeySpinBox.value()
        self.options["BUTTONA"] = "%.0f" % self.P1ButtonAkeySpinBox.value()
        self.options["BUTTONB"] = "%.0f" % self.P1ButtonBkeySpinBox.value()
        self.options["OPTION1"] = "%.0f" % self.P1Option1keySpinBox.value()
        self.options["OPTION2"] = "%.0f" % self.P1Option2keySpinBox.value()
        self.options["PAUSE"] = "%.0f" % self.P1PausekeySpinBox.value()
        self.options["EXIT"] = "%.0f" % self.P1ExitkeySpinBox.value()

    def SaveKeys(self):
	tmpList=[]
	for item in self.options:
		tmpList.append(self.options[item])

	for item in set(tmpList):
		if tmpList.count(item) > 1:
			QMessageBox.critical(self, "Warning",  "Value [" + item + "] is used more than once")
        orgConfigFile = open(Handy_KeyCfgFile,"r")
	try:
	        copyFile = open(Handy_KeyCfgFile + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + Handy_KeyCfgFile + ".old")
	else:
		# Write the copy (.old)
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(Handy_KeyCfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + Handy_KeyCfgFile)
		else:
			newConfigFile.write("# Generated by handy-gui\n")
			for option in self.options:
				newConfigFile.write(option + " " + self.options[option] + "\n")
			newConfigFile.close()
			os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
			           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
			           string:"Key Configuration is succesfully saved"')

class MyKeyPressed(QPushButton):
    def __init__(self, *args):
        QPushButton.__init__(self, *args)

    def event(self, event):
        if (event.type()==QEvent.KeyPress):
            # we have to get the SDL keysym
            global AsciiVal
            if (event.key() < 256):
                AsciiVal = ord(str.lower(chr(event.key())))
            if (event.key() == 16777236):
                # right
                AsciiVal = 275;
            if (event.key() == 16777234):
                # left
                AsciiVal = 276;
            if (event.key() == 16777235):
                # up
                AsciiVal = 273;
            if (event.key() == 16777237):
                # down
                AsciiVal = 274;
            if (event.key() == 16777219):
                # BS
                AsciiVal = 8;
            if (event.key() == 16777221):
                # Return
                AsciiVal = 271;
            if (event.key() == 16777248):
                # L-Shift
                AsciiVal = 304;
            if (event.key() == 16777249):
                # L-Control
                AsciiVal = 306;
            if (event.key() == 16781571):
                # L-Alt
                AsciiVal = 313;
            self.emit(SIGNAL("keyPressed"))

        return QPushButton.event(self, event)

 
class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("Handy-gui path configuration")
        self.gui_opts = parse_config(self,HandyGui_CfgFile)
	if RomPath == "":
		self.romPath=self.gui_opts["rom_path"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,300);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms"), 3, 0)
	grid.addWidget(self.pushRomButton, 3, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("handy_sdl"), 4, 0)
	grid.addWidget(self.pushExecButton, 4, 1)

	self.setLayout(grid)

	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_rom_button_clicked(self):
	d = QDialog(self)
 
	vbox = QVBoxLayout()
	#Add Layouts
	horizontalLayout = QHBoxLayout() 

	# Now create your buttons.
	homeButton = QPushButton("internal")
	rootButton = QPushButton("SD card")
	closeButton = QPushButton("Close")
	# Add buttons to your layouts, they'll show up in the order given.
	horizontalLayout.addWidget(homeButton)
	horizontalLayout.addWidget(rootButton)
	horizontalLayout.addWidget(closeButton)
	# Add layouts to your main Layout
	vbox.addLayout (horizontalLayout)
	d.setLayout(vbox)
        d.setWindowTitle("Choose roms location...")
 
	# Show the window!
	d.show()
	QObject.connect(homeButton
		, SIGNAL("clicked()")
		, self.on_rom_homebutton_clicked)
	QObject.connect(rootButton
		, SIGNAL("clicked()")
		, self.on_rom_rootbutton_clicked)
	QObject.connect(closeButton
		, SIGNAL("clicked()")
		, d.close)

    def on_rom_homebutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button to save it!"')

    def on_rom_rootbutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/media')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button to save it!"')

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/handy_sdl")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/handy_sdl")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())
