#include "settingswindow.h"

SettingsWindow::SettingsWindow(QString currentPath, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setAttribute(Qt::WA_DeleteOnClose);

    this->currentPath = currentPath;
    connect(ui->startingLocationButton, SIGNAL(clicked()), this, SLOT(setStartingLocation()));

    connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));

    load();
}

SettingsWindow::~SettingsWindow()
{
    save();

    delete ui;
}

void SettingsWindow::load()
{
    ui->startingLocationButton->setValueText(QSettings().value("Main/StartingLocation", DEFAULT_StartingLocation).toString());

    ui->startInBookmarksBox->setChecked(QSettings().value("Main/StartInBookmarks", DEFAULT_StartInBookmarks).toBool());
    ui->runAsRootBox->setChecked(QSettings().value("Main/RunAsRoot", DEFAULT_RunAsRoot).toBool());

    ui->showThumbnailsBox->setChecked(QSettings().value("Browser/ShowThumbnails", DEFAULT_ShowThumbnails).toBool());

    ui->selectNewItemsBox->setChecked(QSettings().value("Clipboard/SelectNewItems", DEFAULT_SelectNewItems).toBool());
    ui->addingClearsSelectionBox->setChecked(QSettings().value("Clipboard/AddingClearsSelection", DEFAULT_AddingClearsSelection).toBool());
    ui->queryingClearsSelectionBox->setChecked(QSettings().value("Clipboard/QueryingClearsSelection", DEFAULT_QueryingClearsSelection).toBool());
    ui->saveOnExitBox->setChecked(QSettings().value("Clipboard/SaveOnExit", DEFAULT_SaveOnExit).toBool());

    ui->archiveSizeBox->setValue(QSettings().value("Operations/ArchiveSize", DEFAULT_ArchiveSize).toInt());

    QMaemo5ListPickSelector *selector;
    QStandardItemModel *model;
    QString value;

    selector = new QMaemo5ListPickSelector;
    model = new QStandardItemModel(0, 1, selector);
    model->appendRow(new QStandardItem(tr("Automatic")));
    model->appendRow(new QStandardItem(tr("Landscape")));
    model->appendRow(new QStandardItem(tr("Portrait")));
    selector->setModel(model);

    value = QSettings().value("Main/Orientation", DEFAULT_Orientation).toString();
    selector->setCurrentIndex(value == "automatic" ? 0 :
                              value == "landscape" ? 1 :
                              value == "portrait"  ? 2 : 0);
    ui->orientationButton->setPickSelector(selector);

    {
        int value;

        selector = new QMaemo5ListPickSelector;
        model = new QStandardItemModel(0, 1, selector);
        model->appendRow(new QStandardItem(tr("Size")));
        model->appendRow(new QStandardItem(tr("Modification date")));
        selector->setModel(model);

        value = QSettings().value("Browser/FirstDetail", DEFAULT_FirstDetail).toInt();
        selector->setCurrentIndex(value == FileSystemModel::Size ? 0 :
                                  value == FileSystemModel::Date ? 1 : 0);
        ui->firstDetailButton->setPickSelector(selector);

        selector = new QMaemo5ListPickSelector;
        model = new QStandardItemModel(0, 1, selector);
        model->appendRow(new QStandardItem(tr("Size")));
        model->appendRow(new QStandardItem(tr("Modification date")));
        selector->setModel(model);

        value = QSettings().value("Browser/SecondDetail", DEFAULT_SecondDetail).toInt();
        selector->setCurrentIndex(value == FileSystemModel::Size ? 0 :
                                  value == FileSystemModel::Date ? 1 : 0);
        ui->secondDetailButton->setPickSelector(selector);
    }
}

void SettingsWindow::save()
{
    QSettings().setValue("Main/StartingLocation", ui->startingLocationButton->valueText());

    QSettings().setValue("Main/StartInBookmarks", ui->startInBookmarksBox->isChecked());
    QSettings().setValue("Main/RunAsRoot", ui->runAsRootBox->isChecked());

    QSettings().setValue("Browser/ShowThumbnails", ui->showThumbnailsBox->isChecked());

    QSettings().setValue("Clipboard/SelectNewItems", ui->selectNewItemsBox->isChecked());
    QSettings().setValue("Clipboard/AddingClearsSelection", ui->addingClearsSelectionBox->isChecked());
    QSettings().setValue("Clipboard/QueryingClearsSelection", ui->queryingClearsSelectionBox->isChecked());
    QSettings().setValue("Clipboard/SaveOnExit", ui->saveOnExitBox->isChecked());

    QSettings().setValue("Operations/ArchiveSize", ui->archiveSizeBox->value());

    switch (static_cast<QMaemo5ListPickSelector*>(ui->orientationButton->pickSelector())->currentIndex()) {
        case 0: QSettings().setValue("Main/Orientation", "automatic"); break;
        case 1: QSettings().setValue("Main/Orientation", "landscape"); break;
        case 2: QSettings().setValue("Main/Orientation", "portrait"); break;
    }

    switch (static_cast<QMaemo5ListPickSelector*>(ui->firstDetailButton->pickSelector())->currentIndex()) {
        case 0: QSettings().setValue("Browser/FirstDetail", FileSystemModel::Size); break;
        case 1: QSettings().setValue("Browser/FirstDetail", FileSystemModel::Date); break;
    }

    switch (static_cast<QMaemo5ListPickSelector*>(ui->secondDetailButton->pickSelector())->currentIndex()) {
        case 0: QSettings().setValue("Browser/SecondDetail", FileSystemModel::Size); break;
        case 1: QSettings().setValue("Browser/SecondDetail", FileSystemModel::Date); break;
    }
}

void SettingsWindow::setStartingLocation()
{
    ui->startingLocationButton->setValueText(currentPath.isNull() ? DEFAULT_StartingLocation : currentPath);
}