#ifndef LOCATIONWIDGET_H
#define LOCATIONWIDGET_H

#include <QDebug>

#include <QScrollArea>
#include <QScrollBar>
#include <QAbstractKineticScroller>
#include <QVariant>
#include <QAbstractButton>
#include <QPushButton>
#include <QToolButton>
#include <QLineEdit>
#include <QCompleter>
#include <QFileSystemModel>
#include <QApplication>
#include <QHBoxLayout>
#include <QStringList>

class LocationWidget : public QScrollArea
{
    Q_OBJECT

public:
    LocationWidget(QWidget *parent);
    ~LocationWidget();

    void setLocation(QString path);
    bool isEditorEnabled();

public slots:
    void enableEditor();
    void disableEditor();
    void emitLocationFromEditor();

signals:
    void locationSelected(QString path);

private:
    void resizeEvent(QResizeEvent *e);

    QAbstractButton* createButton(QString name);
    QAbstractButton *checkedButton;
    void centerCheckedButton();

    QWidget *buttonWidget;
    QWidget *editorWidget;
    QLineEdit *locationEdit;

    QString currentPath;

private slots:
    void onButtonClicked();
};

#endif // LOCATIONWIDGET_H
