#!/usr/bin/python

from gvoice import *
from gvSMS import Ui_MainWindow
from gvAccount import *
import sys
import os
import ConfigParser
import copy
#from PySide.QtCore import *
#from PySide.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *

def octify(str):
    '''     
    Returns a list of octet bytes representing
    each char of the input str.               
    '''                                       

    bytes = map(ord, str)
    bitsconsumed = 0     
    referencebit = 7     
    octets = []          

    while len(bytes):
            byte = bytes.pop(0)
            byte = byte >> bitsconsumed
                                       
            try:
                    nextbyte = bytes[0]
                    bitstocopy = (nextbyte & (0xff >> referencebit)) << referencebit
                    octet = (byte | bitstocopy)

            except:
                    octet = (byte | 0x00)

            if bitsconsumed != 7:
                    octets.append(byte | bitstocopy)
                    bitsconsumed += 1
                    referencebit -= 1
            else:
                    bitsconsumed = 0
                    referencebit = 7

    return octets

def semi_octify(str):
    '''
    Expects a string containing two digits.
    Returns an octet -
    first nibble in the octect is the first
    digit and the second nibble represents
    the second digit.
    '''
    try:
            digit_1 = int(str[0])
            digit_2 = int(str[1])
            octet = (digit_2 << 4) | digit_1
    except:
            octet = (1 << 4) | digit_1

    return octet

def resetnumber(number):
        '''
        Adds trailing F to number if length is
        odd.
        '''
        length = len(number)
        if (length % 2) != 0:
            number = number + 'F'
        return number

def createPDUstring(number, msg):
    '''
    Returns a list of bytes to represent a valid PDU message
    '''
    octifiedmsg = octify(msg)
    number = resetnumber(number)
    octifiednumber = [ semi_octify(number[i:i+2]) for i in range(0, len(number), 2) ]
        
    HEADER = 1
    FIRSTOCTETOFSMSDELIVERMSG = 10
    ADDR_TYPE = 129 #unknown format
    number_length = len(number)
    msg_length = len(msg)
    pdu_message = [HEADER, FIRSTOCTETOFSMSDELIVERMSG, number_length, ADDR_TYPE]
    pdu_message.extend(octifiednumber)
    pdu_message.append(0)
    pdu_message.append(0)
    pdu_message.append(msg_length)
    pdu_message.extend(octifiedmsg)
    return pdu_message

class SMS(object):
    '''
    Sends sms messages
    '''
    
    def __init__(self, msg, number):
        self.pdustring = createPDUstring(number, msg)
        
    def send(self):
        self.__dbus_send(self.pdustring)

    def __dbus_send(self, pdu_string):
        import dbus
        bus = dbus.SystemBus()
        smsobject = bus.get_object('com.nokia.phone.SMS', '/com/nokia/phone/SMS/ba212ae1')
        smsiface = dbus.Interface(smsobject, 'com.nokia.csd.SMS.Outgoing')
        arr = dbus.Array(pdu_string)
        msgdeliver = dbus.Array([arr]) 
        smsiface.Send(msgdeliver,'')
        self.response = True

    def print_pdustring(self):
        print self.pdustring
        self.response = True

class MainWindow(QMainWindow, Ui_MainWindow):

    def __init__(self, parent=None):
        super(MainWindow, self).__init__(parent)
        self.setupUi(self)
        self.plainTextEditMessage.setEnabled(False)
        self.plainTextEditStatus.setReadOnly(True)
        self.radioButtonPhone.setChecked(True)
        self.email = ""
        self.password = ""
        # fix up the LCD color
	palette = self.lcdNumberCharacterCount.palette();
	palette.setColor(QPalette.Normal, QPalette.Foreground, Qt.red);
	palette.setColor(QPalette.Normal, QPalette.Background, Qt.black);
	palette.setColor(QPalette.Normal, QPalette.Light, Qt.white);
	palette.setColor(QPalette.Normal, QPalette.Dark, Qt.lightGray);
	self.lcdNumberCharacterCount.setPalette(palette);

        #pyside 0.2.2 bug? auto-connect of signals is not working
        #self.connect(self.pushButtonSend, SIGNAL("released()"), self.on_pushButtonSend_released)

    def load_config(self):
        try:
            config = ConfigParser.ConfigParser()
            config.readfp(open(os.path.expanduser('~') + '/.gvSMS'))
            try:
                email = config.get("credentials", "email")
                #self.email = base64.b64decode(email)
                self.email = email
                password = config.get("credentials", "password")
                #self.password = base64.b64decode(password)
                self.password = password
            except ConfigParser.NoSectionError:
                   self.prompt()
            except ConfigParser.NoOptionError:
                   self.prompt()
        except IOError:
            # couldn't find the file set uid so we can prompt info
            self.prompt()
        if len(self.email) > 0 and len(self.password) > 0:
            self.plainTextEditStatus.appendPlainText("Logging in...")
            QTimer.singleShot(40, self.login)

    def save_config(self):
        try:
            f = open(os.path.expanduser('~') + '/.gvSMS', 'w')
            f.write("[credentials]\n")
            #f.write("email = " + base64.b64encode(self.email) + "\n")
            #f.write("password = " + base64.b64encode(self.password) + "\n")
            f.write(str("email = " + self.email + "\n"))
            f.write(str("password = " + self.password + "\n"))
    	except IOError, e:
    		self.plainTextEditStatus.appendPlainText('failed to write config file')

    def prompt(self):
        if len(self.email) == 0 or len(self.password) == 0:
            mydialog = QtGui.QDialog(self)
            uidialog = Ui_Dialog()
            uidialog.setupUi(mydialog)
            uidialog.lineEditPassword.setEchoMode(QLineEdit.Password)
            mydialog.show()
            if mydialog.exec_():
                dialogaccount = uidialog.lineEditAccount.text()
                dialogpassword = uidialog.lineEditPassword.text()
                if len(dialogaccount) > 0 and len(dialogpassword) > 0:
                    self.email = dialogaccount
                    self.password = dialogpassword
                    if uidialog.checkBox.isChecked():
                        self.save_config()
                    else:
                        try:
                            f = open(os.path.expanduser('~') + '/.gvSMS', 'w')
                        except IOError, e:
                            self.plainTextEditStatus.appendPlainText('failed to remove config file')

        if len(self.email) == 0 or len(self.password) == 0:
            self.plainTextEditStatus.appendPlainText("No credentials supplied")

    def login(self):
        self.gv = GoogleVoiceLogin(self.email, self.password)
        if not self.gv.logged_in:
           self.plainTextEditStatus.appendPlainText("Could not log in with provided credentials")
        else:
             self.plainTextEditStatus.appendPlainText("Login successful!")
             # Use the ContactLoader to download Google Contacts
             contact_loader = ContactLoader(self.gv.opener)
             # Use the ContactSelector to select the group and
             # final list of contacts to contact
             self.contact_selector = ContactSelector(contact_loader.contacts_by_group_list)
             # save a copy to reload after any deletes
             self.save_contacts_by_group_list = copy.deepcopy(contact_loader.contacts_by_group_list)
             group_list = self.contact_selector.get_group_list()
             for group_item in group_list:
                 self.listWidgetGroups.addItem(group_item[1])

    def on_pushButtonSend_released(self):
        text_sender = TextSender(self.gv.opener, self.gv.key)
        text_sender.text = self.plainTextEditMessage.toPlainText()
        for contact in self.contact_selector.get_contacts_list():
            number = contact[1].mobile
            if number == '':
               self.plainTextEditStatus.appendPlainText('%s does not have a mobile number' % contact[1])
            else:
                 message = 'Sending message to %s at %s...' % (contact[1], contact[1].mobile)
                 if self.radioButtonPhone.isChecked():
                    sms = SMS(text_sender.text.toAscii(), contact[1].mobile)
                    sms.send()
                    #sms.print_pdustring()
                    sending_result = sms.response
                 else: #send via Google
                      text_sender.send_text(contact[1].mobile)
                      sending_result = text_sender.response
                 if sending_result:
                    self.plainTextEditStatus.appendPlainText(message + "Success!")
                 else:
                      self.plainTextEditStatus.appendPlainText(message + "Failed!!")

    def on_listWidgetGroups_itemClicked(self, item):
        # reload original list in case user has deleted any
        local_contacts_by_group_list = copy.deepcopy(self.save_contacts_by_group_list)
        self.contact_selector = ContactSelector(local_contacts_by_group_list)
        selected_group = self.listWidgetGroups.row(item) + 1
        self.contact_selector.set_selected_group(selected_group)
        self.listWidgetPeople.clear()
        for contact_item in self.contact_selector.get_contacts_list():
            self.listWidgetPeople.addItem('%s' % contact_item[1])
        if self.listWidgetPeople.count() > 0:
           self.plainTextEditMessage.setEnabled(True)
        else:
             self.plainTextEditMessage.setEnabled(False)

    def on_listWidgetPeople_itemClicked(self, item):
        reply = QtGui.QMessageBox.question(self, 'Remove?',
        "Remove " + '%s' % item.text() + " from list?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.Yes:
           index = self.listWidgetPeople.row(item)
           self.listWidgetPeople.takeItem(index)
           contact_list = [index+1]
           self.contact_selector.remove_from_contact_list(contact_list)
           if self.listWidgetPeople.count() > 0:
              self.plainTextEditMessage.setEnabled(True)
           else:
              self.plainTextEditMessage.setEnabled(False)

    def on_plainTextEditMessage_textChanged(self):
        message = self.plainTextEditMessage.toPlainText()
        self.lcdNumberCharacterCount.display(message.length())

    @QtCore.pyqtSlot()
    def on_actionLog_In_triggered(self):
        self.load_config()

if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    ui = MainWindow()
    ui.show()
    QTimer.singleShot(50, ui.load_config)
    sys.exit(app.exec_())
