#!/usr/bin/python

from gvoice import *
from gvSMS import Ui_MainWindow
from gvAccount import *
import sys
import os
import ConfigParser
import copy
#from PySide.QtCore import *
#from PySide.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *

class MainWindow(QMainWindow, Ui_MainWindow):

    def __init__(self, parent=None):
        super(MainWindow, self).__init__(parent)
        self.setupUi(self)
        self.plainTextEditMessage.setEnabled(False)
        self.plainTextEditStatus.setReadOnly(True)
        self.email = ""
        self.password = ""
        # fix up the LCD color
	palette = self.lcdNumberCharacterCount.palette();
	palette.setColor(QPalette.Normal, QPalette.Foreground, Qt.red);
	palette.setColor(QPalette.Normal, QPalette.Background, Qt.black);
	palette.setColor(QPalette.Normal, QPalette.Light, Qt.white);
	palette.setColor(QPalette.Normal, QPalette.Dark, Qt.lightGray);
	self.lcdNumberCharacterCount.setPalette(palette);

        #pyside 0.2.2 bug? auto-connect of signals is not working
        #self.connect(self.pushButtonSend, SIGNAL("released()"), self.on_pushButtonSend_released)

    def load_config(self):
        try:
            config = ConfigParser.ConfigParser()
            config.readfp(open(os.path.expanduser('~') + '/.gvSMS'))
            try:
                email = config.get("credentials", "email")
                #self.email = base64.b64decode(email)
                self.email = email
                password = config.get("credentials", "password")
                #self.password = base64.b64decode(password)
                self.password = password
            except ConfigParser.NoSectionError:
                   self.prompt()
            except ConfigParser.NoOptionError:
                   self.prompt()
        except IOError:
            # couldn't find the file set uid so we can prompt info
            self.prompt()
        if len(self.email) > 0 and len(self.password) > 0:
            self.plainTextEditStatus.appendPlainText("Logging in...")
            QTimer.singleShot(40, self.login)

    def save_config(self):
        try:
            f = open(os.path.expanduser('~') + '/.gvSMS', 'w')
            f.write("[credentials]\n")
            #f.write("email = " + base64.b64encode(self.email) + "\n")
            #f.write("password = " + base64.b64encode(self.password) + "\n")
            f.write(str("email = " + self.email + "\n"))
            f.write(str("password = " + self.password + "\n"))
    	except IOError, e:
    		self.plainTextEditStatus.appendPlainText('failed to write config file')

    def prompt(self):
        if len(self.email) == 0 or len(self.password) == 0:
            mydialog = QtGui.QDialog(self)
            uidialog = Ui_Dialog()
            uidialog.setupUi(mydialog)
            uidialog.lineEditPassword.setEchoMode(QLineEdit.Password)
            mydialog.show()
            if mydialog.exec_():
                dialogaccount = uidialog.lineEditAccount.text()
                dialogpassword = uidialog.lineEditPassword.text()
                if len(dialogaccount) > 0 and len(dialogpassword) > 0:
                    self.email = dialogaccount
                    self.password = dialogpassword
                    if uidialog.checkBox.isChecked():
                        self.save_config()
                    else:
                        try:
                            f = open(os.path.expanduser('~') + '/.gvSMS', 'w')
                        except IOError, e:
                            self.plainTextEditStatus.appendPlainText('failed to remove config file')

        if len(self.email) == 0 or len(self.password) == 0:
            self.plainTextEditStatus.appendPlainText("No credentials supplied")

    def login(self):
        self.gv = GoogleVoiceLogin(self.email, self.password)
        if not self.gv.logged_in:
           self.plainTextEditStatus.appendPlainText("Could not log in with provided credentials")
        else:
             self.plainTextEditStatus.appendPlainText("Login successful!")
             # Use the ContactLoader to download Google Contacts
             contact_loader = ContactLoader(self.gv.opener)
             # Use the ContactSelector to select the group and
             # final list of contacts to contact
             self.contact_selector = ContactSelector(contact_loader.contacts_by_group_list)
             # save a copy to reload after any deletes
             self.save_contacts_by_group_list = copy.deepcopy(contact_loader.contacts_by_group_list)
             group_list = self.contact_selector.get_group_list()
             for group_item in group_list:
                 self.listWidgetGroups.addItem(group_item[1])

    def on_pushButtonSend_released(self):
        text_sender = TextSender(self.gv.opener, self.gv.key)
        text_sender.text = self.plainTextEditMessage.toPlainText()
        for contact in self.contact_selector.get_contacts_list():
            number = contact[1].mobile
            if number == '':
               self.plainTextEditStatus.appendPlainText('%s does not have a mobile number' % contact[1])
            else:
                 message = 'Sending message to %s at %s...' % (contact[1], contact[1].mobile)
                 #self.plainTextEditStatus.appendPlainText('Sending message to %s at %s...' % (contact[1], contact[1].mobile))
                 text_sender.send_text(contact[1].mobile)
                 if text_sender.response:
                    self.plainTextEditStatus.appendPlainText(message + "Success!")
                 else:
                      self.plainTextEditStatus.appendPlainText(message + "Failed!!")

    def on_listWidgetGroups_itemClicked(self, item):
        # reload original list in case user has deleted any
        local_contacts_by_group_list = copy.deepcopy(self.save_contacts_by_group_list)
        self.contact_selector = ContactSelector(local_contacts_by_group_list)
        selected_group = self.listWidgetGroups.row(item) + 1
        self.contact_selector.set_selected_group(selected_group)
        self.listWidgetPeople.clear()
        for contact_item in self.contact_selector.get_contacts_list():
            self.listWidgetPeople.addItem('%s' % contact_item[1])
        if self.listWidgetPeople.count() > 0:
           self.plainTextEditMessage.setEnabled(True)
        else:
             self.plainTextEditMessage.setEnabled(False)

    def on_listWidgetPeople_itemClicked(self, item):
        reply = QtGui.QMessageBox.question(self, 'Remove?',
        "Remove " + '%s' % item.text() + " from list?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.Yes:
           index = self.listWidgetPeople.row(item)
           self.listWidgetPeople.takeItem(index)
           contact_list = [index+1]
           self.contact_selector.remove_from_contact_list(contact_list)
           if self.listWidgetPeople.count() > 0:
              self.plainTextEditMessage.setEnabled(True)
           else:
              self.plainTextEditMessage.setEnabled(False)

    def on_plainTextEditMessage_textChanged(self):
        message = self.plainTextEditMessage.toPlainText()
        self.lcdNumberCharacterCount.display(message.length())

    @QtCore.pyqtSlot()
    def on_actionLog_In_triggered(self):
        self.load_config()

if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    ui = MainWindow()
    ui.show()
    QTimer.singleShot(50, ui.load_config)
    sys.exit(app.exec_())
