#include <hildon/hildon.h>
#include <stdlib.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "config.h"

GtkWidget* window;
GKeyFile* chords = NULL;

GtkWidget* selector_root;
GtkWidget* selector_chord;
GtkWidget* selector_variant;

GtkWidget* fretboard = NULL;
GtkWidget* image_bg  = NULL;
GtkWidget* image_finger[6] = { NULL };

GdkPixbuf* finger;
GdkPixbuf* open;
GdkPixbuf* no;

GtkWidget* first_fret_num = NULL;

gchar* current_root  = NULL;
gchar* current_chord = NULL;
gint   current_variant = 0;

gint i;

//12 roots
//23 chords
//XX variants

void load_chords()
{
	chords = g_key_file_new();
	g_key_file_load_from_file(chords, DATAPREFIX"/chords", G_KEY_FILE_KEEP_COMMENTS, NULL);
	g_print(DATAPREFIX"/chords\n");
}

void free_chords()
{
	g_key_file_free(chords);
}

gint get_variant_count(gchar* root, gchar* chord)
{
	GError* error = NULL;
	gchar** variants = g_key_file_get_string_list(chords, root, chord, NULL, &error);
	
	if (error)
	{
		return -1;
	}
	else
	{
		return g_strv_length(variants);
	}
}

gchar* get_chord(gchar* root, gchar* chord, gint variant)
{
	GError* error = NULL;
	gchar** variants = g_key_file_get_string_list(chords, root, chord, NULL, &error);
	
	if (error || variants[variant] == NULL)
	{
		return "-1 -1 -1 -1 -1";
	}
	else
	{
		return variants[variant];
	}
}

void set_chord()
{
	//g_debug("%s\n", get_chord(current_root, current_chord, current_variant));
	
	gint pos[6] = { 0 };
	
	sscanf(get_chord(current_root, current_chord, current_variant), "%d %d %d %d %d %d", &pos[0], &pos[1], &pos[2], &pos[3], &pos[4], &pos[5]);
	
	gint smallest = 100;
	gint biggest = 0;
	
	for (i = 0; i < 6; i++)
	{
		if (pos[i] != -1 && pos[i] != 0)
		{
			if (pos[i] < smallest)
			{
				smallest = pos[i];
			}
		}
		if (pos[i] > biggest)
		{
			biggest = pos[i];
		}
	}
	
	//g_debug("smallest = %d\n", smallest);
	
	gchar* label;
	
	if (biggest > 4)
	{
		label = g_strdup_printf("%d ", smallest);
	}
	else
	{
		label = g_strdup_printf("  ");
	}
	
	gtk_label_set_text(GTK_LABEL(first_fret_num), label);
	g_free(label);
	
	gint y_extra;
	
	for (i = 0; i < 6; i++)
	{
		if (pos[i] == -1)
		{
			gtk_image_set_from_pixbuf(GTK_IMAGE(image_finger[i]), no);
			pos[i] = 0;
		}
		else if (pos[i] == 0)
		{
			gtk_image_set_from_pixbuf(GTK_IMAGE(image_finger[i]), open);
		}
		else
		{
			gtk_image_set_from_pixbuf(GTK_IMAGE(image_finger[i]), finger);
			if (biggest > 4)
			{
				pos[i] -= smallest - 1;
			}
		}
		
		if (pos[i] == 0 || pos[i] == -1)
		{
			y_extra = 10;
		}
		else
		{
			y_extra = 20;
		}
		
		gtk_fixed_move(GTK_FIXED(fretboard), image_finger[i], 10+i*38.5, y_extra+77*pos[i]);
	}
}

void chord_changed(HildonTouchSelector* widget, gint column, gpointer user_data)
{
	current_root  = hildon_touch_selector_get_current_text(HILDON_TOUCH_SELECTOR(selector_root));
	current_chord = hildon_touch_selector_get_current_text(HILDON_TOUCH_SELECTOR(selector_chord));
	
	//g_debug("Variants: %d", get_variant_count(current_root, current_chord));
	
	hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(selector_variant), 0, -1);
	GtkTreeModel* model;
	model = hildon_touch_selector_get_model(HILDON_TOUCH_SELECTOR(selector_variant), 0);
	gtk_list_store_clear(GTK_LIST_STORE(model));
	//hildon_touch_selector_set_model(HILDON_TOUCH_SELECTOR(selector_variant), 0, model);
	
	for (i = 0; i < get_variant_count(current_root, current_chord); i++)
	{
		gchar* label = g_strdup_printf("%d", i+1);
		
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector_variant), label);
		
		g_free(label);
	}
	
	hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(selector_variant), 0, 0);
	
	current_variant = 0;
	
	set_chord();
}

void variant_changed(HildonTouchSelector* widget, gint column, gpointer user_data)
{
	current_variant = hildon_touch_selector_get_active(HILDON_TOUCH_SELECTOR(selector_variant), 0);
	//g_debug("var = %d\n", current_variant);
	if (current_variant != -1)
		set_chord();
}

void show_about(GtkWidget* widget, gpointer data)
{
	GtkWidget* about_dialog;
	about_dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(about_dialog), "About Guitar Chords "PACKAGE_VERSION);
	gtk_window_set_transient_for(GTK_WINDOW(about_dialog), GTK_WINDOW(window));
	
	GtkWidget* text = hildon_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(text), FALSE);
	
	GtkTextBuffer* buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	
	GtkTextIter iter;
	gtk_text_buffer_get_end_iter(buffer, &iter);
	
	gtk_text_buffer_insert(buffer, &iter, "Programming:\n  TomppaS\n\nGraphics:\n  joppu\n\nChord data from Rosegarden", -1);
	
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(about_dialog)->vbox), text);
	
	gtk_widget_show_all(about_dialog);
}

int main(int argc, char **argv)
{
	/* Init GTK+ and hildon */
	hildon_gtk_init(&argc, &argv);
	
	load_chords();
	
	g_set_application_name("Guitar Chords");
	
	/*g_print("C variants = %d\n", get_variant_count("C", "m7"));
	g_print("C = %s\n", get_chord("C", "-", 1));*/
	
	window = hildon_window_new();
	g_signal_connect(window, "destroy", G_CALLBACK(gtk_main_quit), NULL);
	
	/*GdkColor color;
	gdk_color_parse("white", &color);*/
	
	fretboard = gtk_fixed_new();
	gtk_widget_set_size_request(fretboard, 285, -1);
	//GTK_WIDGET_UNSET_FLAGS(fretboard, GTK_NO_WINDOW);
	//gtk_widget_modify_bg(fretboard, GTK_STATE_NORMAL, &color);
	
	image_bg = gtk_image_new_from_file(DATAPREFIX"/fretboard.png");
	g_print(DATAPREFIX"/fretboard.png\n");
	gtk_fixed_put(GTK_FIXED(fretboard), image_bg, 16, 52);
	
	finger = gdk_pixbuf_new_from_file(DATAPREFIX"/finger.png", NULL);
	open = gdk_pixbuf_new_from_file(DATAPREFIX"/open.png", NULL);
	no = gdk_pixbuf_new_from_file(DATAPREFIX"/no.png", NULL);
	
	first_fret_num = gtk_label_new("10");
	//gdk_color_parse("black", &color);
	//gtk_widget_modify_fg(first_fret_num, GTK_STATE_NORMAL, &color);
	gtk_widget_modify_font(first_fret_num, pango_font_description_from_string("Sans 24"));
	gtk_fixed_put(GTK_FIXED(fretboard), first_fret_num, 250, 90);
	
	for (i = 0; i < 6; i++)
	{
		image_finger[i] = gtk_image_new_from_pixbuf(finger);
		gtk_fixed_put(GTK_FIXED(fretboard), image_finger[i], i*44, 52);
	}
	
	selector_root = hildon_touch_selector_new_text();
	g_signal_connect(G_OBJECT(selector_root), "changed", G_CALLBACK(chord_changed), NULL);
	gchar* tmp_roots[]  = { "C", "C#/Db", "D", "D#/Eb", "E", "F", "F#/Gb", "G", "G#/Ab", "A", "A#/Bb", "B" };
	
	for (i = 0; i < sizeof(tmp_roots)/sizeof(tmp_roots[0]); i++)
	{
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector_root), tmp_roots[i]);
	}
	
	selector_chord = hildon_touch_selector_new_text();
	g_signal_connect(G_OBJECT(selector_chord), "changed", G_CALLBACK(chord_changed), NULL);
	gchar* tmp_chords[]  = { "maj", "7", "m", "m7", "maj7", "sus4", "7sus4", "6", "m6", "9", "m9", "maj9", "6/9",
								"7+9", "7maj9", "aug", "7+5", "dim", "maj5", "7maj5", "9maj5", "11", "13", };
				
	for (i = 0; i < sizeof(tmp_chords)/sizeof(tmp_chords[0]); i++)
	{
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector_chord), tmp_chords[i]);
	}
	
	selector_variant = hildon_touch_selector_new_text();
	g_signal_connect(G_OBJECT(selector_variant), "changed", G_CALLBACK(variant_changed), NULL);
	hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector_variant), "1");
	
	GtkWidget* vbox_root = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_root), gtk_label_new("Root note:"), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_root), selector_root,               TRUE,  TRUE, 0);
	
	GtkWidget* vbox_chord = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_chord), gtk_label_new("Chord:"), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_chord), selector_chord,          TRUE,  TRUE, 0);
	
	GtkWidget* vbox_variant = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_variant), gtk_label_new("Variant:"), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_variant), selector_variant,          TRUE,  TRUE, 0);
	
	GtkWidget* hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), fretboard,    FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox_root,    TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox_chord,   TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox_variant, TRUE, TRUE, 0);

	gtk_container_add(GTK_CONTAINER(window), hbox);
	
	/* Create a menu */
	HildonAppMenu* menu = HILDON_APP_MENU(hildon_app_menu_new());
	
	GtkWidget* button;
	
	button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
	gtk_button_set_label(GTK_BUTTON(button), "About");
	g_signal_connect_after(G_OBJECT(button), "clicked", G_CALLBACK(show_about), NULL);
	hildon_app_menu_append(menu, GTK_BUTTON(button));
	
	gtk_widget_show_all(GTK_WIDGET(menu));
	
	hildon_window_set_app_menu(HILDON_WINDOW(window), menu);
	
	gtk_widget_show_all(window);
	
	chord_changed(NULL, 0, NULL);

	gtk_main();
	
	return 0;
}
