#ifndef _MAIN_H_
#define _MAIN_H_

#include <stdlib.h>
#include <string.h>

#include <hildon/hildon.h>
#include <libsoup/soup.h>
#include <conic.h>

#include <json-glib/json-glib.h>

#include <espeak/speak_lib.h>

/* global variables */
HildonProgram* program;
GtkWidget* window;

GtkWidget* hbox_top;
GtkWidget* button_src_lang;
GtkWidget* button_tar_lang;
GtkWidget* button_swap;

GtkWidget* hbox_center;
GtkTextBuffer* buffer_source;
GtkTextBuffer* buffer_translated;
GtkWidget* textview_source;
GtkWidget* textview_target;

GtkWidget* hbox_bottom;
GtkWidget* button_paste;
GtkWidget* button_translate;
GtkWidget* button_copy;
GtkWidget* button_clear1;
GtkWidget* button_clear2;
GtkWidget* button_say1;
GtkWidget* button_say2;

GtkWidget* vbox_main;

gint index_src_lang;
gint index_tar_lang;

GtkWidget* dialog;

GtkClipboard* clipboard;

/* settings.c */
extern void settings_init();
extern void settings_free();

extern void settings_int_set(gchar* group, gchar* key, gint value);
extern gint settings_int_get(gchar* group, gchar* key, gint default_value);

/* ui.c */
extern void create_window();

/* callbacks.c */
extern void connect_internet(GtkWidget* widget, gpointer data);
extern void translate();
extern void change_language(GtkWidget* button, gpointer data);
extern void show_alert(gchar* text);
extern void show_about(GtkWidget* widget, gpointer data);
extern void swap_languages(GtkWidget* widget, gpointer data);
extern void paste_text(GtkWidget* widget, gpointer data);
extern void copy_text(GtkWidget* widget, gpointer data);
extern void clear_text(GtkWidget* widget, gint data);
extern void say_text(GtkWidget* widget, gint data);

typedef struct
{
	char* str_short;
	char* str_long;
	gboolean espeak;
} language;

extern language languages[52];
GdkPixbuf* flags[52];

#endif // _MAIN_H_
