#include "main.h"

language languages[51] = {
	{ "af", "Afrikaans" },
	{ "sq", "Albanian" },
	{ "ar", "Arabic" },
	{ "be", "Belarusian" },
	{ "bg", "Bulgarian" },
	{ "ca", "Catalan" },
	{ "zh-CN", "Chinese" },
	{ "hr", "Croatian" },
	{ "cs", "Czech" },
	{ "da", "Danish" },
	{ "nl", "Dutch" },
	{ "en", "English" },
	{ "et", "Estonia" },
	{ "tl", "Filipino" },
	{ "fi", "Finnish" },
	{ "fr", "French" },
	{ "gl", "Galician" },
	{ "de", "German" },
	{ "el", "Greek" },
	{ "iw", "Hebrew" },
	{ "hi", "Hindi" },
	{ "hu", "Hungarian" },
	{ "is", "Icelandic" },
	{ "id", "Indonesian" },
	{ "ga", "Irish" },
	{ "it", "Italian" },
	{ "ja", "Japanese" },
	{ "ko", "Korean" },
	{ "lv", "Latvian" },
	{ "lt", "Lithuanian" },
	{ "mk", "Mecedonian" },
	{ "ms", "Malay" },
	{ "mt", "Maltese" },
	{ "no", "Norwegian" },
	{ "fa", "Persian" },
	{ "pl", "Polish" },
	{ "pt", "Portuguese" },
	{ "ro", "Romanian" },
	{ "ru", "Russian" },
	{ "sr", "Serbian" },
	{ "sk", "Slovak" },
	{ "sl", "Slovenian" },
	{ "es", "Spanish" },
	{ "sw", "Swahili" },
	{ "sv", "Swedish" },
	{ "th", "Thai" },
	{ "tr", "Turkish" },
	{ "uk", "Ukrainian" },
	{ "vi", "Vietnamese" },
	{ "cy", "Welsh" },
	{ "yi", "Yiddish" }
};

int main(int argc, char **argv)
{
	g_thread_init(NULL);
	hildon_gtk_init(&argc, &argv);
	g_set_application_name("gTranslate");
	
	settings_init();
	
	clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_can_store(clipboard, NULL, 0);
	
	int i;
	for (i = 0; i < 51; i++)
	{
		gchar* filename = g_strdup_printf(DATAPREFIX"/%s.png", languages[i].str_short);
		GError *error = NULL;
		
		flags[i] = gdk_pixbuf_new_from_file(filename, &error);
		
		if (error)
		{
			g_critical("Could not load pixbuf: %s\n", error->message);
			g_error_free(error);
		}
		
		g_free(filename);
	}
	
	create_window();
	
	gtk_main();
	
	settings_free();

	return 0;
}
