from gtk import *#ScrolledWindow, TreeView , POLICY_NEVER , TreeViewColumn , CellRendererText , CellRendererPixbuf
from gtk.gdk import threads_enter , threads_leave , threads_init , Pixbuf
import threading
import sys
import math
from time import time as now

threads_init()

def translate(a,x):
    if a == -1:
        return x
    else:
        return a
    
def get_all_children(widget,ret=[]):
    for w in widget.get_children():
        try:
            get_all_children(w,ret)
        except:
            pass
        ret.append(w)
    return ret

def lock(self):
    self.lock.acquire()
    
def unlock(self):
    try:
        self.lock.release_lock()
    except:
        pass

def attach_to_window(window,widget,position,packed=False):
    #selecting box type to use
    if position in (POS_LEFT, POS_RIGHT):
        box = HBox
    else:
        box = VBox
    #remember window son if any
    son = window.get_child()
    #recycle son if possible
    if son and isinstance(son, box):
        main_box = son
    else:
        main_box = box()
    #deattach window son
    if son and son != main_box:
        window.remove(son)
    #rebuild in correct order and in packed mode if packed is True
    if position in (POS_LEFT,POS_TOP):
        if packed:
            main_box.pack_start(widget,False,False)
        else:
            main_box.add(widget)
        if son and son != main_box:
            main_box.add(son)
        main_box.reorder_child(widget,0)
    else:
        if son and son != main_box:
            main_box.add(son)
        if packed:
            main_box.pack_start(widget,False,False)
        else:
            main_box.add(widget)
    #reattach new son (main box)
    if son and son != main_box:
        window.add(main_box)
    window.show_all()    


class Waiter(threading.Thread):
    """
    Simple Class to manage deferred calls
    """
    def __init__(self,function=None,params=(),delay=1):
        """
        Constructor with defaults
        params:
            function    default function to call when time triggers.
            params      default parameters to call function with.
            delay       dalaytime in seconds (can be a fraction)
        """
        #inherited constructor
        threading.Thread.__init__(self)
        #defining instance variables
        self.lock = threading.Lock()
        self.live = True
        self.default_delay = delay
        self.default_function = function
        self.default_params = params
        #start thread
        self.start()
        
    def destroy(self):
        """
        destroyer
        """
        #close thread
        self.live = False
        unlock(self)
        
    def __call__(self,function=None,params=None,delay=None):
        """
        defining a call. If parameters are not supplied defatults will be used
        params:
            function    default function to call when time triggers.
            params      default parameters to call function with.
            delay       dalaytime in seconds (can be a fraction)
        """
        #getting params ro defaulting it
        if delay:
            self.delay = delay
        else:
            self.delay = self.default_delay
        if function:
            self.function = function
        else:
            self.function = self.default_function
        if params:
            self.params = params
        else:
            self.params = self.default_params
        #setting up end time
        self.time = now() + self.delay
        #calling by thread
        unlock(self)
        
    def run(self):
        #lock thread
        lock(self)
        lock(self)
        #main loop
        while self.live:
            #wait until call timeout will be triggered
            while True:
                #wait
                threading._sleep(self.delay)
                #getting current time
                _now = now()
                #update time to wait
                if _now >= self.time:
                    break
                else:
                    self.delay = self.time - _now
            #calling function
            if self.function:
                self.function(*self.params)
            #wait next call
            lock(self)

class Buffer:
    """
    Simple fixed size buffer implementation
    initialize it with foo = Buffer(size)
    then append data with foo.append(someting)
    or fill all buffer with same element foo.fill(same_element)
    if this buffer represens only number youn can get average with foo.average()
    """
    
    def __init__(self,size):
        self.index = 0
        self.buff = []
        self.size = size
        for a in range(size):
            self.buff.append(0)
    
    def append(self,a):
        """
        Insert data in Buffer return None
        """
        self.index = (self.index + 1) % self.size
        self.buff[self.index] = a
    
    def average(self):
        """
        return number contaned in buffer average
        """
        ret = 0
        for a in self.buff:
            ret += a
        return float(ret) / self.size
    
    def fill(self,b):
        """
        fill buffer with an object
        """
        for a in range(self.size):
            self.buff[a] = b
                      
class TreeViewTouch(ScrolledWindow,threading.Thread):
    """
    ScrolledTreeView is inherited from gtk.TreeView within a gtk.ScrolledWindow.
    It also has a Thread running to implement autoscrolling whene you release
    mouse button.
    
    You can call the TreeView with treeview attribute.
    
    store = ListStore()
    scroll = TreeViewTouch(store)
    treeView = scroll.treeview
    """
    def __init__(self,store,left=None,right=None, autocolumns=True,  attrito=0.05, left_right_wide_extension=100,fps=25,motion_buffer_size=3):
        """
        Constructor
        Initialize class with proper attributes:
        TreeViewTouch(store,callback_left,callback_right, autocolumns,  attrito, left_right_wide_extension,fps,motion_buffer_size)
        params:
            store                 gtk.ListStore    containing data to represent.
            left         function to call when mouse will be moved to left
                                  this callback takes a path representing selection in selected 
                                  TreeView.
            right        same as callback_left but right mouse motion.
            autocolumns           Create Automatically TreeViewColumn s in the TreeView.
            attrito               float representation of speed decayment
            fps                   Number of freame per sencond is intend to allow to thread for automotion
            motion_buffer_size    Buffer size for calculating mouse speed average
            
        """
        #initialize hinerited
        threading.Thread.__init__(self)
        ScrolledWindow.__init__(self)
        #set static attribues
        self.lrwide = left_right_wide_extension
        self.store = store
        self.lock = threading.Lock()
        self.time = 1.0 / fps
        self.buff = Buffer(motion_buffer_size)
        self.treeview = TreeView(store)
        self.va = self.get_vadjustment()
        self.left = left
        self.right = right
        self.attrito = 1 - attrito
        self.grabbed = False
        self.oy = 0
        self.limit = 0
        self.my = 0
        #connecting gtk events
        self.connect('screen-changed', self.update_limit)
        self.connect('size-allocate', self.update_limit)
        self.connect('size-request', self.update_limit)
        store.connect('row-changed', self.update_limit)
        store.connect('row-deleted', self.update_limit)
        store.connect('row-inserted', self.update_limit)
        self.treeview.connect('button_press_event' , self.grab)
        self.treeview.connect('motion_notify_event', self.move)
        self.treeview.connect('button_release_event',self.ungrab)
        self.connect('destroy', self.destroy)
        #creating graphics
        self.add(self.treeview)
        self.set_policy(POLICY_NEVER,POLICY_NEVER)
        #generating columns
        if autocolumns:
            self.autocolumns()
        #initialize threads
        self.start()
        threads_init()
        #show
        self.show()
        
    def update_limit(self, *a):
        """
        internal use
        """
        self.limit = self.va.upper - self.get_allocation().height
    
    def autocolumns(self):
        """
        internal use
        """
        #for each column
        for a in range(self.store.get_n_columns()):
        #get type
            tipe = self.store.get_column_type(a)
        #and add a new column associated with right CellRenderer
            if tipe.is_a(int) or tipe.is_a(str):
                self.treeview.append_column(TreeViewColumn('',CellRendererText(),text=a))
            elif tipe.is_a(Pixbuf):
                self.treeview.append_column(TreeViewColumn('',CellRendererPixbuf(),pixbuf=a))
    
    def destroy(self,e):
        """
        internal use
        """
        #ensure thread exit from loop
        self.grabbed = True
        self.live = False
        unlock(self)

    def grab(self,o,e):
        """
        internal use
        """
        self.grabbed = True
        #clear buffer
        self.buff.fill(0)
        #set grabbed vertical alignment
        self.gva = self.va.get_value()
        #get coordinates from cursor
        self.gx,  self.gy = e.get_coords()
        #tricky : set "moving Y" to "grabbed Y"
        self.my = self.gy
        
    def ungrab(self,o,e):
        """
        internal use
        """
        #when mouse button is released
        #set grabbed
        self.grabbed = False
        #get coordinates
        ux ,  self.uy = e.get_coords()
        #launch callbacks
        if self.left and ux < self.gx - self.lrwide:
            self.left(self.store.get_path(self.treeview.get_selection().get_selected()[1]))
        elif self.right and ux > self.gx + self.lrwide:
            self.right(self.store.get_path(self.treeview.get_selection().get_selected()[1]))
        else:
        #continue motion thread execution if no callback is called
            try:
                self.lock.release_lock()
            except:
                print sys.exc_info()[1]
        
    def move(self,o,e):
        """
        internal use
        """
        #when mouse is clicked and moving
        if self.grabbed:
            #get mouse coordinates
            my = e.get_coords()[1]
            #updating motion buffer
            self.buff.append(self.my - my)
            #update old coordinates
            self.my = my
            #move scroller
            self.move_wrap(self.gy - self.my + self.gva)

    def move_wrap(self,to):
        """
        internal use
        """
        #move scroller if it's respepecting limits
        if to > 1 and to < self.limit:
            self.va.set_value(to)
        elif to < 1:
            self.va.set_value(0)
        else:
            self.va.set_value(self.limit)
                
    def run(self):
        """
        internal use
        """
        #initalize
        self.lock.acquire_lock()
        self.live = True
        #main loop with self.live for exit
        while self.live:
            p = True
            if self.grabbed:
                self.lock.acquire_lock()
            #getting average speed
            vy = self.buff.average()
            #getting vertical alignement
            va = self.va.get_value()
            #while mouse button is not reclicked
            while not self.grabbed and p:
                #move
                if abs(vy) > 1 :
                    #move vertical alignment
                    va += vy
                    #get braking
                    vy *= self.attrito
                    #enter gtk thread
                    threads_enter()
                    #move graphic
                    self.move_wrap(va)
                    #exit gtk thread
                    threads_leave()
                    #waiting for next iteration
                    threading._sleep(self.time)
                #break if limit is reached or if speed is over
                if (abs(vy) < 1 or va >= self.limit or va <= 1):
                    p = False
                    self.lock.acquire_lock()

class PagerTouch(ScrolledWindow,threading.Thread):
    """
    PagerTouch allows you to show widgets (usually frames) within motion pager
    it can be fixed or dynamic.
    If you want fixed size pager you have build it by an array of widgets in first
    parameter.
    If You want a dynamic pager you have to build it by a single widget as first parameter
    so if you want to add labels to pages you have to provide a string array in second parameter
    according to widgets order
    myFrame = Frame()
    ...
    myPager = PagerTouch(myFrame)

    # and then you can go forward and backward frame by frame simply calling
    # go_backward and go_forward
    
    myPager.go_forward(anotherFrame)
    myPager.go_backward()
    
    or if you prefer you can create a fixed pager
    
    myPager = PagerTouch([Frame(),Button('button'), ... ],['label1', 'label2', ...],labeled = True)
    now my pager has another useful method go_to(page) to switch page
    
    myPager.go_to(3) #pager will show 3rd page if present
    """
    def __init__(self,initial_widget,initial_label='',labeled=False,frames=10,deleted_widgets=None,vertical=False):
        """
        initializes a PagerTouch
        params:
            in Fixed initialization:
                initial_widget is first widget/frame in this pager
                initial_label  is first label referred to first widget
                labeled        means you must call go_forward with a string representing page header/title
                frames         indicates number of frame for animation
                deleted_widgets is a call_back called when a widget is removed from pager
                vertical       if true pager will show pages vertically
            in Dynamic initialization:
                initial_widget is a list of widgets that will be shown in pager
                initial_label  is a list of strings attached to widget in pager according with widgets order
                labeled        means you must call go_forward with a string representing page header/title
                frames         indicates number of frame for animation
                deleted_widgets ... useless ...
                vertical       if true pager will show pages vertically
        """
        #calling hinerited constructor
        ScrolledWindow.__init__(self)
        threading.Thread.__init__(self)
        self.lock = threading.Lock()
        #initializing instance variables
        self.vertical = vertical
        self.widgets = []
        self.deleted_widgets = deleted_widgets
        self.frames = 1.0 / frames
        self.page_index = 0
        self.layout = Layout()
        self.hiding = []
        self.rect = gdk.Rectangle()
        self.ha = self.get_hadjustment()
        #events
        self.set_events(gdk.ALL_EVENTS_MASK)
        self.resize_handler = self.connect_after('size_allocate' ,self._on_resize)
        self.connect('destroy_event',self.destroyer)
        #getting current allocation
        alloc = self.get_allocation()
        #configuring properties
        self.set_policy(POLICY_NEVER , POLICY_NEVER)
        if vertical:
            self.layout.set_size(800,800*200)
            self.ha = self.get_vadjustment()
        else:
            self.layout.set_size(800*200,800)                   
        self.add(self.layout)
        #setting behaveour          
        if labeled:
            self._add_widget = self._add_widget_labeled
            self._remove_widgets = self._remove_widgets_labeled
        #placing new widget to layout in correct position
        if type(initial_widget) == list:
            self.go_forward = self._fixed_forward
            self.go_backward = self._fixed_backward
            if type(initial_label) == list:
                a = 0
                while a < len(initial_widget):
                    self._add_widget(initial_widget[a], initial_label[a])
                    a += 1
            else:
                for w in initial_widget:
                    self._add_widget(w)
        else:
#            self.layout.put(initial_widget,0,0)
            self._add_widget(initial_widget,initial_label)
        #init threads
        threads_init()
        self.start()

    def rebuild(self,reinit,relabel=''):
        while len(self.widgets) > 0:
            self.hiding.append(self.widgets.pop())
        self._remove_widgets()
        self.page_index = 0
        self.ha.set_value(0)
        self._add_widget(reinit,relabel)
        unlock(self)
    
    def _add_widget(self,widget,label=''):
        # add a widget to layout
        """
        for internal use only
        """
        #getting current allocation
        alloc = self.get_allocation()
        #placing new widget to layout in correct position
        widget.set_size_request(alloc.width , alloc.height)
        self.widgets.append(widget)
        if self.vertical:
            self.layout.put(widget,0,alloc.height * self.page_index)
        else:
            self.layout.put(widget,alloc.width * self.page_index,0)
        widget.show_all()
        
    def _add_widget_labeled(self,widget,label):
        """
        for internal use only
        """
        #create Vertical box containg widget and label
        vb = VBox()
        #adding new label on top with minimal space
        vb.pack_start(Label(label),False,False)
        #then add new widget
        vb.add(widget)
        #getting current allocation
        alloc = self.get_allocation()
        #update current page index
        #placing new widget to layout in correct position
        vb.set_size_request(alloc.width , alloc.height)
        if self.vertical:
            self.layout.put(vb,0,alloc.height * self.page_index)
        else:
            self.layout.put(vb,alloc.width * self.page_index,0)
        self.widgets.append(vb)
        vb.show_all()

    def destroyer(self,e):
        """
        force destruction
        """
        print 'pager destroyed'
        #ensure thread exit from loop
        self.live = False
        unlock(self)
        ScrolledWindow.destroy(self)
        
        
    def _on_resize(self,object, alloc):
        """
        for internal use only
        """
        #inhibit event propagation
        if (alloc.width != self.rect.width) or (alloc.height != self.rect.height):
            self.rect = alloc
            #move and resize all widget in pager
            if self.vertical:
                for a in range(len(self.widgets)):
                    w = self.widgets[a]
                    self.layout.move(w,0,a * alloc.height)
                    w.set_size_request(alloc.width,alloc.height)
                self.ha.set_value(self.page_index * alloc.height)
            else:
                for a in range(len(self.widgets)):
                    w = self.widgets[a]
                    self.layout.move(w,a * alloc.width ,0)
                    w.set_size_request(alloc.width,alloc.height)
                self.ha.set_value(self.page_index * alloc.width)
#            unlock(self)
            
                   
    def go_forward(self,widget,label=None):
        """
        go right to next widget
        params:
            widget  widget to show on next page
            label   new page header
        if FixedPager returns True if went forward, False otherwise
        """
        if widget.get_parent():
            return
        #set page index
        self.page_index += 1
        try:
            self.hiding.remove(widget)
        except:
            pass
        #adding widget
        self._add_widget(widget,label)
        #release motion thread
        unlock(self)
         
    def _fixed_forward(self):
        """
        internal use only
        """
        #check if more pages are loaded
        if self.page_index < (len(self.widgets) - 1):
            #go to next page
            self.page_index += 1
            #make motion
            unlock(self)
            return True
        else:
            return False
        
    def go_backward(self):
        """
        go to previous page
        if Dynamic returns previous show widget
        if Fixed returns if went backward
        """
        #tell motion thread to go left
        if self.page_index > 0:
            #remove old widget
            w = self.widgets.pop()
            #update page index
            self.page_index -= 1
            #append deleting widget to delete queue
            self.hiding.append(w)
            #run motion thread
            unlock(self)
            return w
        else:
            #return removed widget
            return self.widgets[0]

    def _fixed_backward(self):
        """
        internal use only
        """
        #tell motion thread to go left
        if self.page_index > 0:
            #update page index
            self.page_index -= 1
            #run motion thread
            unlock(self)
            return True
        return False

    def go_to(self,page):
        """
        go to requested page identified by number
        """
        #setting page where i'm going to
        page = min(page, len(self.widgets))
        self.page_index = page
        #go motion
        unlock(self)

    def _remove_widgets_labeled(self):
        """
        for internal use only
        """
        #only if labeled
        for hb in self.hiding:
            #removing upper label
            children = hb.get_children()
            w = children[0] #the upper label
            w.hide()
            hb.remove(w)
            w.destroy()
            del w
            #removing user widget
            w = children[1] #user inserted widget
            w.hide()
            hb.remove(w)
            #remove VBox
            hb.hide()
            self.layout.remove(hb)
            hb.destroy()
            del hb
    
    def _remove_widgets(self):
        """
        for internal use only
        """
        for w in self.hiding:
            #removing user widget
            w.hide()
            self.layout.remove(w)
    
    def trans_function(self,x):
        """
        transition function.
        You can substitute it with another to perform custom transition
        use a math function in which f(0 = 0 and f(1) = 1
        """
        return 1 + math.sin((3+x) * math.pi / 2)
        
    def run(self):
        """
        for internal use only
        """
        self.live = True
        self.lock.acquire_lock()
        while self.live:
            alloc = self.get_allocation()
            #getting current position
            ha = self.ha.get_value()
            #getting final position
            if self.vertical:
                to_go = self.page_index * alloc.height
            else:
                to_go = self.page_index * alloc.width
            #acquiring motion stuff
            diff = ha - to_go
            frame = 1.0
            index = self.page_index
            #motion loop
            while frame > 0.0:
                #verifying double motion 
                if index != self.page_index:
                    #reacquiring motion stuff
                    index = self.page_index
                    frame = 1.0
                    if self.vertical:
                        to_go = self.page_index * alloc.height
                    else:
                        to_go = self.page_index * alloc.width
                    ha = self.ha.get_value()
                    diff = ha - to_go
                #dec frame remaining
                frame -= self.frames
                #adjust frames
                if frame <0:
                    frame = 0
                threads_enter()
                #set animation
                self.ha.set_value(to_go + (diff * frame * self.trans_function(frame)))
                threads_leave()
                #free processor for a bit
                threading._sleep(0.03)
            #remove widget after motion loop
            if len(self.hiding) > 0:
                self._remove_widgets()
                #call deleted callback
                if self.deleted_widgets:
                    self.deleted_widgets(self.hiding)
                self.hiding = []
            #wait for new motion
            lock(self)

class HiddenTouch(Layout,threading.Thread):
    """
    HiddenTouch is a hidden widget that appears and disappears when you want
    simply calling animate_show() and animate_hide() or toggle his presence by animate_toggle()
    it have to be added to a VBox or a HBox and it will sets automatically to show itself horizontally r vertically 
    """
    def __init__(self,widget,space,frames = 6,window = None, position=POS_TOP):
        """
        Constructor method
        params:
            widget     child widget to show
            spsace     width or height when it is visible
            frames     number of frames for animation
        """
        #inherited contructors
        threading.Thread.__init__(self)
        Layout.__init__(self)
        #connecting signals
        self.resize_handler_horizontal = self.connect('size_allocate' , self._resize)
        self.resize_handler_vertical = self.connect('size_allocate' , self._vertical_resize)
        self.connect('parent-set' , self._on_parent)
        self.connect('destroy',self.destroy)
        #setting class variables
        self.vertical = False
        self.space = space
        self.widget = widget
        self.frames = 1.0 / frames
        self.lock = threading.Lock()
        self.hidden = True
        self.old_alloc = gdk.Rectangle(0,0)
        #setting properties
        self.set_size(0,0)
        self.size = gdk.Rectangle()
        #paint graphics
        self.put(widget,0,0)
        #attach to window
        if window:
            attach_to_window(window, self, position, True)
        #threadings
        threads_init()
        self.start()
                
    def _on_parent(self,wid,old):
        #will be vertical is its parent is an HBox
        self.vertical = isinstance(self.get_parent(), HBox)
        #setting behaveur
        if self.vertical:
            #setting animation functions
            self.__show = self._vertical_show
            self.__hide = self._vertical_hide
            #turn on / off signal handlers
            self.handler_block(self.resize_handler_horizontal)
            self.handler_unblock(self.resize_handler_vertical)
            self.resize_handler = self.resize_handler_vertical
        else:
            #setting animation functions
            self.__show = self._show
            self.__hide = self._hide
            #turn on / off signal handlers
            self.handler_block(self.resize_handler_vertical)
            self.handler_unblock(self.resize_handler_horizontal)
            self.resize_handler = self.resize_handler_horizontal
                    
    def _vertical_resize(self,o,alloc):
        #optimize resize events
        #do someting only if size is really modified
        if self.old_alloc.height != alloc.height:
            #refresh old allocation
            self.old_alloc = alloc
            #set graphic
            if self.hidden:
                self.set_size_request(0,alloc.height)
                self.widget.set_size_request(0,0)
            else:
                self.set_size_request(self.space,alloc.height)
                self.widget.set_size_request(self.space,alloc.height)
    
    def _resize(self,o,alloc):
        #optimize resize events
        #do someting only if size is really modified
        if self.old_alloc.width!= alloc.width:
            #refresh old allocation
            self.old_alloc = alloc
            #set graphic
            if self.hidden:
                self.set_size_request(0,0)
                self.widget.set_size_request(alloc.width,self.space)
            else:
                self.set_size_request(alloc.width,self.space)
                self.widget.set_size_request(alloc.width,self.space)
                
    def destroy(self,o):
        """
        destroyer
        """
        self.live = False
        unlock(self)
        self.remove(self.widget)
        Layout.destroy(self)
        
    def trans_function(self,x):
        """
        transition function.
        You can substitute it with another to perform custom transition
        use a math function in which f(0 = 0 and f(1) = 1
        """
        return 1 + math.sin((3+x) * math.pi / 2)
    
    def _hide(self,alloc,frame):
        threads_enter()
        #set animation
        self.set_size_request(alloc.width,int(self.space * self.trans_function(frame)))
        threads_leave()

    def _vertical_hide(self,alloc,frame):
        threads_enter()
        #set animation
        self.set_size_request(int(self.space * self.trans_function(frame)),alloc.height)
        threads_leave()

    def _show(self,alloc,frame):
        threads_enter()
        #set animation
        self.set_size_request(alloc.width,int(self.space * (1 - self.trans_function(frame))))
        threads_leave()

    def _vertical_show(self,alloc,frame):
        threads_enter()
        #set animation
        self.set_size_request(int(self.space * (1 - self.trans_function(frame))),alloc.height)
        threads_leave()
    
    def _animation(self,animate_function):
        #getting_allocation
        alloc = self.get_allocation()
        self.handler_block(self.resize_handler)
        if self.vertical:
            self.widget.set_size_request(self.space, alloc.height)
        else:
            self.widget.set_size_request(alloc.width,self.space)
        self.show()
        self.widget.show()
        #acquiring motion stuff
        frame = 1.0
        diff = self.space / self.frames
        #motion loop hiding
        while frame > 0.0:
            #dec frame remaining
            frame -= self.frames
            #adjust frames
            if frame <0:
                frame = 0
            animate_function(alloc,frame)
            #free processor for a bit
            threading._sleep(0.05)
        #resizing components
        if self.vertical:
            self._vertical_resize(None, self.get_allocation())
        else:
            self._resize(None, self.get_allocation())
        self.handler_unblock(self.resize_handler)
            
    def animate_show(self):
        """
        show widget
        """
        if self.hidden:
            self.hidden = False
            unlock(self)
         
    def animate_hide(self):
        """
        hide widget
        """
        if not self.hidden:
            self.hidden = True
            unlock(self)
        
    def animate_toggle(self):
        """
        toggle widget
        """
        self.hidden = not self.hidden
        unlock(self)
    
    def run(self):
        """
        for internal use only
        """
        self.live = True
        #locking thread
        lock(self)
        lock(self)
        #main loop
        while self.live:
            #choose an action and execute it
            if self.hidden:
                self._animation(self.__hide)
            else:
                self._animation(self.__show)
            #wait for new motion
            lock(self)
            
            
class HButtonedPagerTouch(HBox):
    """
    A horizontal fixed PagerTouch with buttons on sides to go forward and backward
    """
    def __init__(self,widgets,labels='',labeled=False,frames=10):
        """
        Constructor horizontal
        params:
            widgets    widget list to render
            labels     label list 
            labeled    if True will be added a label in the top to each frame
            frames     number of animation frames
        """
        #inhetired constructor
        HBox.__init__(self)
        #initialize pager
        self.pager = PagerTouch(widgets,labels,labeled,frames,False)
        #creating buttons
        self.left_button = Button()
        self.left_button.set_image(image_new_from_stock(STOCK_GO_BACK,1))
        self.right_button = Button()
        self.right_button.set_image(image_new_from_stock(STOCK_GO_FORWARD,1))
        #adding buttons
        self.pack_start(self.left_button,False,False)
        self.add(self.pager)
        self.pack_start(self.right_button,False,False)
        #reconnect functions
        self.go_forward = self.pager.go_forward
        self.go_backward = self.pager.go_backward        
        self.go_to = self.pager.go_to
        #connect buttons to actions
        self.left_button.connect('clicked' , self._on_left_click)
        self.right_button.connect('clicked', self._on_right_click)
        
    def _on_left_click(self,o):
        self.go_backward()
        
    def _on_right_click(self,o):
        self.go_forward()

class VButtonedPagerTouch(VBox):
    """
    A vertical fixed PagerTouch with buttons on sides to go forward and backward    
    """
    def __init__(self,widgets,labels='',labeled=False,frames=10):
        #inhetired constructor
        VBox.__init__(self)
        #create pager
        self.pager = PagerTouch(widgets,labels,labeled,frames,vertical=True)
        #create buttons
        self.up_button = Button()
        self.up_button.set_image(image_new_from_stock(STOCK_GO_UP,1))
        self.down_button = Button()
        self.down_button.set_image(image_new_from_stock(STOCK_GO_DOWN,1))
        #adding buttons
        self.pack_start(self.up_button,False,False)
        self.add(self.pager)
        self.pack_start(self.down_button,False,False)
        #remap functions
        self.go_forward = self.pager.go_forward
        self.go_backward = self.pager.go_backward        
        self.go_to = self.pager.go_to
        #connect button's actions
        self.up_button.connect('clicked' , self._on_up_click)
        self.down_button.connect('clicked', self._on_down_click)
        
    def _on_up_click(self,o):
        self.go_backward()
        
    def _on_down_click(self,o):
        self.go_forward()

class ToolBarTouch(HiddenTouch):
    """
    It is a toolbar inside an hiden widget
    It shows a number of buttons within a pager in which they are disposed to
    Number of pages will be the minimum number of pages that could be used for
    """
    def __init__(self,size,button_per_page,frames=5,buttons=[],window=None,position=POS_LEFT):
        """
        Constructor
        params:
            size                appearing widget size
            button_per_page     amount of buttons will be placed in a page
            frames              number of frames in animation
            buttons             button list containing buttons will appears
            window              gtk.Window where toolbar will attached to
            postition           posistion in window where toolbar will be attached to
                                it can be one of follow (POS_LEFT , POS_RIGHT, POS_TOP, POS_BOTTOM)
        """
        #instanziate instance variables
        self.pages = []
        self.button_count = 0
        self.button_per_pages = button_per_page
        #remember window son if any
        #if toolbar will be left or right (horizontal)
        if position == POS_LEFT or position == POS_RIGHT:
            #define button box will be a VBox
            self.button_box = VBox
            #box which will contain this toolbar and the actuale main window component
            #will be an HBox
            main_box = HBox
            #so pager on left / right side will be a vertical button pager
            pager = VButtonedPagerTouch
        else:
            #else viceversa
            self.button_box = HBox
            main_box = VBox
            pager = HButtonedPagerTouch
        #add all buttons
        for b in buttons:
            self._add_button(b)
        #creating new parent container (main_box means HBox or VBox)
        self.father = main_box()
        #creating pager for buttons
        self.buttoned_pager = pager(self.pages)
        #calling inherited constructor
        HiddenTouch.__init__(self,self.buttoned_pager,size,frames,window,position)
        #placing myself where requested
        
    def _add_button(self,button):
        """
        internal use only
        """
        #if button per page exceded
        if (self.button_count %  self.button_per_pages) == 0:
            #a new page will be created and appended to pager
            self.pages.append(self.button_box())
        #then add button
        self.pages[-1].add(button)
        #increase counter
        self.button_count +=1
        
#    def add_button(self,button):
#        self._add_widget(self.pages[-1])
#        self._add_button(button)
        

class MenuTouch(PagerTouch):
    """
    MenuTouch is the easiest way to implements a full animated, finger touch compliant
    menu-like widget
    usage:
        first you have to build a menu definition as a group of tuple or lists containing
        3 items:
            an image  (can be a string representing a stock icon or a string representing
                       icon file name or a gdk.Pixbuf containig image or None if no image is required)
            a string,
            an action or a submenu tuple like this actial one.
    Example:
        menudef = ((STOCK_FILE , 'file' ,(
                    ('open.jpg' , 'open', open_func),
                    ('close.png' , 'close' , close_func)
                    )),
                   (None, 'item', (
                       STOCK_BOLD , 'make bold' , bold
                    )
                    ....
                  )
        myMenu = MenuTouch(menudef)
                    
    """
    def __init__(self,menudef):
        """
        Constructor
        params:
            menudef     menu definition
        """
        #creating instance variables
        self.path = []
        self.temp = Frame()
        #generating menu tree
        self.funcs = self._genmenu(menudef)
        #selecting main menu
        self.path.append(self.funcs)
        #inherited create
        PagerTouch.__init__(self,self.path[-1][0])
        #free Frame mem
        self.temp.destroy()
        del self.temp
        
    def _go_submenu(self,index):
        #selecting object where we want to go
        obj = self.path[-1][1][index[0]]
        #this object can be a tuple/list or a function
        #if it is a tuple/list
        if type(obj) == tuple or type(obj) == list:
            #append it to path
            self.path.append(obj)
            #and go forward
            self.go_forward(self.path[-1][0])
        #else call it
        else:
            obj()        
        
    def _exit_submenu(self,w):
        #if i'm not showning main menu
        if len(self.path) > 1:
            #extract last menu 
            self.path.pop()
            #go backward
            self.go_backward()
        
    def _genmenu(self,menu):
        #generate a menu built by TreeViewTouch and function list
        funcs = list()
        store = ListStore(Pixbuf,str)
        for i in menu:
            image = i[0]
            if type(image) == str:
                if image.startswith('gtk-'):
                    image = self.temp.render_icon(image,2)
                else:
                    image = gdk.pixbuf_new_from_file(image)
            if type(i[2]) == tuple:
                m = self._genmenu(i[2])
                funcs.append(m)
            else:
                funcs.append(i[2])
            store.append((image,i[1]))
        return TreeViewTouch(store,left=self._go_submenu,right=self._exit_submenu),funcs
    
    
class NotifyerTouch(HiddenTouch):
    """
    It is a notifier object that allows you sending messages to user for a determinated duration
    """
    def __init__(self,window,position=POS_BOTTOM,space=40,frames=6,time=1):
        """
        Constructor
        params:
            window     gtk.Window where Notifyer will be attached to.
            position   position in window where notifyer will be attached to.
            space      space notifyer will appaers up
            frames     number of frame in animation
            time       duration in seconds (it can be a fracion)
        """
        #inherited constructor
        self.pager = PagerTouch(Frame(),deleted_widgets=self._del_widget,vertical=position in (POS_BOTTOM,POS_TOP))
        HiddenTouch.__init__(self, self.pager, space, frames, window, position)
        #setting instance variables
        self.position = position
        self.waiter = Waiter(self.animate_hide,delay=time)
        #connect destruction
        window.connect('destroy',self.destroy)
    
    def _del_widget(self,widgets):
        #destroy all widgets
        for w in widgets:
            w.destroy()
            del w
    
    def notify(self,widget):
        #defaults
        if type(widget) == str:
            widget = Label(widget)
            if self.position == POS_LEFT:
                widget.set_angle(90)
        #clear pager if notifier is hidden
        if self.hidden:
            self.pager.rebuild(widget)
            self.animate_show()
        else:
            self.pager.go_forward(widget)
        #call delayed function by defaults
        self.waiter()
            
    def destroy(self):
        #destrutctor
        if self.ht:
            self.ht.destroy()
        self.live = False


