/*
 * booster_gtkmm.cc (c) Openismus Gmbh 2007
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#include "booster_gtkmm.h"
#include "config.h"
#include <gtkmm.h>
#include <iostream>

#include <maemo-launcher/booster_api.h>

static void debug(const gchar* message)
{
#ifdef DEBUG
	std::cout << message << std::endl;
#endif
}
	

static booster_state_t
booster_gtkmm_preinit(int *argc, char ***argv)
{
	debug("booster_gtkmm_preinit");
#ifdef DEBUG
	Glib::Timer timer;
#endif
	Gtk::Main::init_gtkmm_internals();
#ifdef DEBUG
	long unsigned int elapsed;
	timer.elapsed(elapsed);
	std::cout << "init_internals took " << elapsed << " microseconds" << std::endl;
#endif
	
	// Return 0 state
	return 0;
}

static void
booster_gtkmm_init(const char *progfilename, const booster_state_t state)
{
	debug("booster_gtkmm_init");
}

static void
booster_gtkmm_reload(booster_state_t state)
{
	debug("booster_gtkmm_relod");
}


// Note: The name of this structure has to be booster_<booster_name>_api

booster_api_t booster_gtkmm_api = {
  0,
  booster_gtkmm_preinit,
  booster_gtkmm_init,
  booster_gtkmm_reload,
};
