/* GtkamlSAXParser.c generated by valac, the Vala compiler
 * generated from GtkamlSAXParser.vala, do not modify */

/* GtkamlSAXParser.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <config.h>


#define GTKAML_TYPE_SAX_PARSER (gtkaml_sax_parser_get_type ())
#define GTKAML_SAX_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParser))
#define GTKAML_SAX_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserClass))
#define GTKAML_IS_SAX_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_SAX_PARSER))
#define GTKAML_IS_SAX_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_SAX_PARSER))
#define GTKAML_SAX_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserClass))

typedef struct _GtkamlSAXParser GtkamlSAXParser;
typedef struct _GtkamlSAXParserClass GtkamlSAXParserClass;
typedef struct _GtkamlSAXParserPrivate GtkamlSAXParserPrivate;

#define GTKAML_TYPE_CLASS_DEFINITION (gtkaml_class_definition_get_type ())
#define GTKAML_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinition))
#define GTKAML_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))
#define GTKAML_IS_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_IS_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))

typedef struct _GtkamlClassDefinition GtkamlClassDefinition;
typedef struct _GtkamlClassDefinitionClass GtkamlClassDefinitionClass;

#define GTKAML_TYPE_ROOT_CLASS_DEFINITION (gtkaml_root_class_definition_get_type ())
#define GTKAML_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinition))
#define GTKAML_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))
#define GTKAML_IS_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_IS_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_ROOT_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))

typedef struct _GtkamlRootClassDefinition GtkamlRootClassDefinition;
typedef struct _GtkamlRootClassDefinitionClass GtkamlRootClassDefinitionClass;

#define GTKAML_TYPE_STATE_STACK (gtkaml_state_stack_get_type ())
#define GTKAML_STATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_STATE_STACK, GtkamlStateStack))
#define GTKAML_STATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_STATE_STACK, GtkamlStateStackClass))
#define GTKAML_IS_STATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_STATE_STACK))
#define GTKAML_IS_STATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_STATE_STACK))
#define GTKAML_STATE_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_STATE_STACK, GtkamlStateStackClass))

typedef struct _GtkamlStateStack GtkamlStateStack;
typedef struct _GtkamlStateStackClass GtkamlStateStackClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GTKAML_TYPE_STATE_ID (gtkaml_state_id_get_type ())

#define GTKAML_TYPE_ATTRIBUTE (gtkaml_attribute_get_type ())
#define GTKAML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttribute))
#define GTKAML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))
#define GTKAML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))

typedef struct _GtkamlAttribute GtkamlAttribute;
typedef struct _GtkamlAttributeClass GtkamlAttributeClass;

#define GTKAML_TYPE_STATE (gtkaml_state_get_type ())
#define GTKAML_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_STATE, GtkamlState))
#define GTKAML_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_STATE, GtkamlStateClass))
#define GTKAML_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_STATE))
#define GTKAML_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_STATE))
#define GTKAML_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_STATE, GtkamlStateClass))

typedef struct _GtkamlState GtkamlState;
typedef struct _GtkamlStateClass GtkamlStateClass;

#define GTKAML_TYPE_XML_ATTRIBUTE (gtkaml_xml_attribute_get_type ())
#define GTKAML_XML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttribute))
#define GTKAML_XML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttributeClass))
#define GTKAML_IS_XML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_XML_ATTRIBUTE))
#define GTKAML_IS_XML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_XML_ATTRIBUTE))
#define GTKAML_XML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_XML_ATTRIBUTE, GtkamlXmlAttributeClass))

typedef struct _GtkamlXmlAttribute GtkamlXmlAttribute;
typedef struct _GtkamlXmlAttributeClass GtkamlXmlAttributeClass;

#define TYPE_XML_NAMESPACE (xml_namespace_get_type ())
#define XML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XML_NAMESPACE, XmlNamespace))
#define XML_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XML_NAMESPACE, XmlNamespaceClass))
#define IS_XML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XML_NAMESPACE))
#define IS_XML_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XML_NAMESPACE))
#define XML_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XML_NAMESPACE, XmlNamespaceClass))

typedef struct _XmlNamespace XmlNamespace;
typedef struct _XmlNamespaceClass XmlNamespaceClass;
typedef struct _XmlNamespacePrivate XmlNamespacePrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))

#define GTKAML_TYPE_COMPLEX_ATTRIBUTE (gtkaml_complex_attribute_get_type ())
#define GTKAML_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttribute))
#define GTKAML_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))
#define GTKAML_IS_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_IS_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_COMPLEX_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))

typedef struct _GtkamlComplexAttribute GtkamlComplexAttribute;
typedef struct _GtkamlComplexAttributeClass GtkamlComplexAttributeClass;

#define GTKAML_TYPE_SIMPLE_ATTRIBUTE (gtkaml_simple_attribute_get_type ())
#define GTKAML_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttribute))
#define GTKAML_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))
#define GTKAML_IS_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_IS_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_SIMPLE_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))

typedef struct _GtkamlSimpleAttribute GtkamlSimpleAttribute;
typedef struct _GtkamlSimpleAttributeClass GtkamlSimpleAttributeClass;

#define TYPE_DEFINITION_SCOPE (definition_scope_get_type ())
typedef struct _GtkamlXmlAttributePrivate GtkamlXmlAttributePrivate;

#define GTKAML_TYPE_REFERENCE_CLASS_DEFINITION (gtkaml_reference_class_definition_get_type ())
#define GTKAML_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinition))
#define GTKAML_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_REFERENCE_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))

typedef struct _GtkamlReferenceClassDefinition GtkamlReferenceClassDefinition;
typedef struct _GtkamlReferenceClassDefinitionClass GtkamlReferenceClassDefinitionClass;

struct _GtkamlSAXParser {
	GObject parent_instance;
	GtkamlSAXParserPrivate * priv;
	void* xmlCtxt;
	char* gtkaml_prefix;
};

struct _GtkamlSAXParserClass {
	GObjectClass parent_class;
	GtkamlRootClassDefinition* (*parse) (GtkamlSAXParser* self);
};

struct _GtkamlSAXParserPrivate {
	ValaCodeContext* _context;
	ValaSourceFile* _source_file;
	GtkamlStateStack* _states;
	ValaMap* generated_identifiers_counter;
	ValaMap* _prefixes_namespaces;
	GtkamlRootClassDefinition* _root_class_definition;
};

typedef enum  {
	GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE = 0,
	GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE,
	GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE
} GtkamlStateId;

struct _XmlNamespace {
	GObject parent_instance;
	XmlNamespacePrivate * priv;
	char* prefix;
	char* URI;
};

struct _XmlNamespaceClass {
	GObjectClass parent_class;
};

typedef enum  {
	DEFINITION_SCOPE_MAIN_CLASS = 0,
	DEFINITION_SCOPE_PUBLIC,
	DEFINITION_SCOPE_PRIVATE,
	DEFINITION_SCOPE_CONSTRUCTOR
} DefinitionScope;

struct _GtkamlXmlAttribute {
	GObject parent_instance;
	GtkamlXmlAttributePrivate * priv;
	char* localname;
	char* prefix;
	char* URI;
	char* value;
};

struct _GtkamlXmlAttributeClass {
	GObjectClass parent_class;
};


static gpointer gtkaml_sax_parser_parent_class = NULL;

GType gtkaml_sax_parser_get_type (void);
GType gtkaml_class_definition_get_type (void);
GType gtkaml_root_class_definition_get_type (void);
GType gtkaml_state_stack_get_type (void);
#define GTKAML_SAX_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserPrivate))
enum  {
	GTKAML_SAX_PARSER_DUMMY_PROPERTY,
	GTKAML_SAX_PARSER_CONTEXT,
	GTKAML_SAX_PARSER_SOURCE_FILE
};
static void gtkaml_sax_parser_set_context (GtkamlSAXParser* self, ValaCodeContext* value);
static void gtkaml_sax_parser_set_source_file (GtkamlSAXParser* self, ValaSourceFile* value);
GtkamlSAXParser* gtkaml_sax_parser_new (ValaCodeContext* context, ValaSourceFile* source_file);
GtkamlSAXParser* gtkaml_sax_parser_construct (GType object_type, ValaCodeContext* context, ValaSourceFile* source_file);
ValaSourceFile* gtkaml_sax_parser_get_source_file (GtkamlSAXParser* self);
GType gtkaml_state_id_get_type (void);
GType gtkaml_attribute_get_type (void);
GtkamlState* gtkaml_state_new (GtkamlStateId state_id, GtkamlClassDefinition* class_definition, GtkamlAttribute* attribute, const char* attribute_name);
GtkamlState* gtkaml_state_construct (GType object_type, GtkamlStateId state_id, GtkamlClassDefinition* class_definition, GtkamlAttribute* attribute, const char* attribute_name);
GType gtkaml_state_get_type (void);
static GtkamlStateStack* gtkaml_sax_parser_get_states (GtkamlSAXParser* self);
void gtkaml_state_stack_push (GtkamlStateStack* self, GtkamlState* element);
void gtkaml_sax_parser_start_parsing (GtkamlSAXParser* self, const char* contents, gulong length);
static GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_class_definition (GtkamlSAXParser* self);
GtkamlRootClassDefinition* gtkaml_sax_parser_parse (GtkamlSAXParser* self);
static GtkamlRootClassDefinition* gtkaml_sax_parser_real_parse (GtkamlSAXParser* self);
void gtkaml_sax_parser_stop_parsing (GtkamlSAXParser* self);
gint gtkaml_sax_parser_column_number (GtkamlSAXParser* self);
gint gtkaml_sax_parser_line_number (GtkamlSAXParser* self);
GType gtkaml_xml_attribute_get_type (void);
static ValaList* gtkaml_sax_parser_parse_attributes (GtkamlSAXParser* self, char** attributes, gint nb_attributes);
GtkamlState* gtkaml_state_stack_peek (GtkamlStateStack* self, gint backtrack);
ValaSourceReference* gtkaml_sax_parser_create_source_reference (GtkamlSAXParser* self);
GtkamlStateId gtkaml_state_get_state_id (GtkamlState* self);
GType xml_namespace_get_type (void);
static ValaList* gtkaml_sax_parser_parse_namespaces (GtkamlSAXParser* self, char** namespaces, gint nb_namespaces);
static ValaMap* gtkaml_sax_parser_get_prefixes_namespaces (GtkamlSAXParser* self);
static ValaClass* gtkaml_sax_parser_lookup_class (GtkamlSAXParser* self, const char* xmlNamespace, const char* name);
static char* gtkaml_sax_parser_prefix_to_namespace (GtkamlSAXParser* self, const char* prefix);
GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_definition (GtkamlSAXParser* self, ValaClass* clazz, ValaList* attrs, const char* prefix);
static void gtkaml_sax_parser_set_root_class_definition (GtkamlSAXParser* self, GtkamlRootClassDefinition* value);
GtkamlClassDefinition* gtkaml_sax_parser_get_child_for_container (GtkamlSAXParser* self, ValaClass* clazz, GtkamlClassDefinition* container_definition, ValaList* attrs, const char* prefix);
GtkamlClassDefinition* gtkaml_state_get_class_definition (GtkamlState* self);
GtkamlAttribute* gtkaml_state_get_attribute (GtkamlState* self);
const char* gtkaml_state_get_attribute_name (GtkamlState* self);
static char* gtkaml_sax_parser_strip_attribute_hyphens (GtkamlSAXParser* self, const char* attrname);
GtkamlComplexAttribute* gtkaml_complex_attribute_new (const char* name, GtkamlClassDefinition* complex_type);
GtkamlComplexAttribute* gtkaml_complex_attribute_construct (GType object_type, const char* name, GtkamlClassDefinition* complex_type);
GType gtkaml_complex_attribute_get_type (void);
void gtkaml_state_set_attribute (GtkamlState* self, GtkamlAttribute* value);
void gtkaml_class_definition_add_attribute (GtkamlClassDefinition* self, GtkamlAttribute* attr);
void gtkaml_sax_parser_start_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI, gint nb_namespaces, char** namespaces, gint nb_attributes, gint nb_defaulted, char** attributes);
static void gtkaml_sax_parser_parse_attribute_content_as_text (GtkamlSAXParser* self, GtkamlState* state, const char* content);
void gtkaml_sax_parser_characters (GtkamlSAXParser* self, const char* data, gint len);
GtkamlState* gtkaml_state_stack_pop (GtkamlStateStack* self);
char* gtkaml_class_definition_get_base_full_name (GtkamlClassDefinition* self);
void gtkaml_sax_parser_end_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI);
gint gtkaml_root_class_definition_get_original_first_code_line (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_original_first_code_line (GtkamlRootClassDefinition* self, gint value);
ValaList* gtkaml_root_class_definition_get_code (GtkamlRootClassDefinition* self);
void gtkaml_sax_parser_cdata_block (GtkamlSAXParser* self, const char* cdata, gint len);
const char* gtkaml_class_definition_get_preconstruct_code (GtkamlClassDefinition* self);
const char* gtkaml_class_definition_get_identifier (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_preconstruct_code (GtkamlClassDefinition* self, const char* value);
const char* gtkaml_class_definition_get_construct_code (GtkamlClassDefinition* self);
void gtkaml_class_definition_set_construct_code (GtkamlClassDefinition* self, const char* value);
GtkamlSimpleAttribute* gtkaml_simple_attribute_new (const char* name, const char* value);
GtkamlSimpleAttribute* gtkaml_simple_attribute_construct (GType object_type, const char* name, const char* value);
GType gtkaml_simple_attribute_get_type (void);
const char* gtkaml_simple_attribute_get_value (GtkamlSimpleAttribute* self);
void gtkaml_simple_attribute_set_value (GtkamlSimpleAttribute* self, const char* value);
const char* gtkaml_attribute_get_name (GtkamlAttribute* self);
ValaCodeContext* gtkaml_sax_parser_get_context (GtkamlSAXParser* self);
GType definition_scope_get_type (void);
GtkamlRootClassDefinition* gtkaml_root_class_definition_new (ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
GtkamlRootClassDefinition* gtkaml_root_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
void gtkaml_root_class_definition_set_prefixes_namespaces (GtkamlRootClassDefinition* self, ValaMap* value);
const char* gtkaml_root_class_definition_get_target_name (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_target_name (GtkamlRootClassDefinition* self, const char* value);
void gtkaml_root_class_definition_set_target_namespace (GtkamlRootClassDefinition* self, const char* value);
void gtkaml_root_class_definition_set_implements (GtkamlRootClassDefinition* self, const char* value);
GtkamlClassDefinition* gtkaml_class_definition_new (ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
GtkamlClassDefinition* gtkaml_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_new (ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container);
GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container);
GType gtkaml_reference_class_definition_get_type (void);
void gtkaml_class_definition_set_identifier (GtkamlClassDefinition* self, const char* value);
void gtkaml_class_definition_add_child (GtkamlClassDefinition* self, GtkamlClassDefinition* child);
GtkamlXmlAttribute* gtkaml_xml_attribute_new (void);
GtkamlXmlAttribute* gtkaml_xml_attribute_construct (GType object_type);
XmlNamespace* xml_namespace_new (void);
XmlNamespace* xml_namespace_construct (GType object_type);
static void gtkaml_sax_parser_set_states (GtkamlSAXParser* self, GtkamlStateStack* value);
static void gtkaml_sax_parser_set_prefixes_namespaces (GtkamlSAXParser* self, ValaMap* value);
GtkamlStateStack* gtkaml_state_stack_new (void);
GtkamlStateStack* gtkaml_state_stack_construct (GType object_type);
static GObject * gtkaml_sax_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gtkaml_sax_parser_finalize (GObject* obj);
static void gtkaml_sax_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gtkaml_sax_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GtkamlSAXParser* gtkaml_sax_parser_construct (GType object_type, ValaCodeContext* context, ValaSourceFile* source_file) {
	GtkamlSAXParser * self;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (source_file != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_sax_parser_set_context (self, context);
	gtkaml_sax_parser_set_source_file (self, source_file);
	return self;
}


GtkamlSAXParser* gtkaml_sax_parser_new (ValaCodeContext* context, ValaSourceFile* source_file) {
	return gtkaml_sax_parser_construct (GTKAML_TYPE_SAX_PARSER, context, source_file);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkamlRootClassDefinition* gtkaml_sax_parser_real_parse (GtkamlSAXParser* self) {
	GtkamlRootClassDefinition* result;
	GError * _inner_error_;
	char* contents;
	gulong length = 0UL;
	GtkamlState* initial_state;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	contents = NULL;
	{
		char* _tmp2_;
		gboolean _tmp1_;
		char* _tmp0_ = NULL;
		_tmp1_ = g_file_get_contents (vala_source_file_get_filename (self->priv->_source_file), &_tmp0_, &length, &_inner_error_);
		contents = (_tmp2_ = _tmp0_, _g_free0 (contents), _tmp2_);
		_tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			vala_report_error (NULL, e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	initial_state = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE, NULL, NULL, NULL);
	gtkaml_state_stack_push (self->priv->_states, initial_state);
	gtkaml_sax_parser_start_parsing (self, contents, length);
	result = _g_object_ref0 (self->priv->_root_class_definition);
	_g_free0 (contents);
	_g_object_unref0 (initial_state);
	return result;
}


GtkamlRootClassDefinition* gtkaml_sax_parser_parse (GtkamlSAXParser* self) {
	return GTKAML_SAX_PARSER_GET_CLASS (self)->parse (self);
}


void gtkaml_sax_parser_start_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI, gint nb_namespaces, char** namespaces, gint nb_attributes, gint nb_defaulted, char** attributes) {
	ValaList* attrs;
	GtkamlState* state;
	ValaSourceReference* source_reference;
	g_return_if_fail (self != NULL);
	g_return_if_fail (localname != NULL);
	g_return_if_fail (URI != NULL);
	attrs = gtkaml_sax_parser_parse_attributes (self, attributes, nb_attributes);
	state = gtkaml_state_stack_peek (self->priv->_states, 0);
	source_reference = gtkaml_sax_parser_create_source_reference (self);
	switch (gtkaml_state_get_state_id (state)) {
		case GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE:
		{
			{
				ValaList* nss;
				char* _tmp6_;
				ValaClass* _tmp7_;
				ValaClass* clazz;
				GtkamlRootClassDefinition* _tmp9_;
				GtkamlState* _tmp10_;
				nss = gtkaml_sax_parser_parse_namespaces (self, namespaces, nb_namespaces);
				{
					ValaIterator* _ns_it;
					_ns_it = vala_iterable_iterator ((ValaIterable*) nss);
					while (TRUE) {
						XmlNamespace* ns;
						gboolean _tmp0_ = FALSE;
						if (!vala_iterator_next (_ns_it)) {
							break;
						}
						ns = (XmlNamespace*) vala_iterator_get (_ns_it);
						if (NULL == ns->prefix) {
							_tmp0_ = TRUE;
						} else {
							gboolean _tmp1_ = FALSE;
							if (NULL != ns->prefix) {
								_tmp1_ = _vala_strcmp0 (ns->prefix, self->gtkaml_prefix) != 0;
							} else {
								_tmp1_ = FALSE;
							}
							_tmp0_ = _tmp1_;
						}
						if (_tmp0_) {
							char** _tmp3_;
							gint uri_definition_size;
							gint uri_definition_length1;
							char** _tmp2_;
							char** uri_definition;
							ValaUnresolvedSymbol* _tmp4_;
							ValaUsingDirective* _tmp5_;
							ValaUsingDirective* namespace_reference;
							uri_definition = (_tmp3_ = _tmp2_ = g_strsplit_set (ns->URI, ":", 0), uri_definition_length1 = _vala_array_length (_tmp2_), uri_definition_size = uri_definition_length1, _tmp3_);
							namespace_reference = (_tmp5_ = vala_using_directive_new ((ValaSymbol*) (_tmp4_ = vala_unresolved_symbol_new (NULL, "GLib", NULL)), source_reference), _vala_code_node_unref0 (_tmp4_), _tmp5_);
							vala_source_file_add_using_directive (self->priv->_source_file, namespace_reference);
							if (NULL == ns->prefix) {
								vala_map_set (self->priv->_prefixes_namespaces, "", uri_definition[0]);
							} else {
								vala_map_set (self->priv->_prefixes_namespaces, ns->prefix, uri_definition[0]);
							}
							uri_definition = (_vala_array_free (uri_definition, uri_definition_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (namespace_reference);
						}
						_g_object_unref0 (ns);
					}
					_vala_collection_object_unref0 (_ns_it);
				}
				clazz = (_tmp7_ = gtkaml_sax_parser_lookup_class (self, _tmp6_ = gtkaml_sax_parser_prefix_to_namespace (self, prefix), localname), _g_free0 (_tmp6_), _tmp7_);
				if (clazz == NULL) {
					char* _tmp8_;
					vala_report_error (source_reference, _tmp8_ = g_strdup_printf ("%s not a class", localname));
					_g_free0 (_tmp8_);
					gtkaml_sax_parser_stop_parsing (self);
					_vala_collection_object_unref0 (nss);
					_vala_code_node_unref0 (clazz);
					_vala_collection_object_unref0 (attrs);
					_g_object_unref0 (state);
					_vala_source_reference_unref0 (source_reference);
					return;
				}
				gtkaml_sax_parser_set_root_class_definition (self, _tmp9_ = gtkaml_sax_parser_get_root_definition (self, clazz, attrs, prefix));
				_g_object_unref0 (_tmp9_);
				gtkaml_state_stack_push (self->priv->_states, _tmp10_ = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE, (GtkamlClassDefinition*) self->priv->_root_class_definition, NULL, NULL));
				_g_object_unref0 (_tmp10_);
				_vala_collection_object_unref0 (nss);
				_vala_code_node_unref0 (clazz);
				break;
			}
		}
		case GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE:
		{
			{
				char* _tmp11_;
				ValaClass* _tmp12_;
				ValaClass* clazz;
				char* fqan;
				clazz = (_tmp12_ = gtkaml_sax_parser_lookup_class (self, _tmp11_ = gtkaml_sax_parser_prefix_to_namespace (self, prefix), localname), _g_free0 (_tmp11_), _tmp12_);
				fqan = NULL;
				if (clazz != NULL) {
					GtkamlClassDefinition* class_definition;
					GtkamlState* _tmp13_;
					class_definition = gtkaml_sax_parser_get_child_for_container (self, clazz, gtkaml_state_get_class_definition (state), attrs, prefix);
					gtkaml_state_stack_push (self->priv->_states, _tmp13_ = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE, class_definition, NULL, NULL));
					_g_object_unref0 (_tmp13_);
					_g_object_unref0 (class_definition);
				} else {
					GtkamlClassDefinition* attribute_parent_class_definition;
					GtkamlState* _tmp18_;
					attribute_parent_class_definition = _g_object_ref0 (gtkaml_state_get_class_definition (state));
					if (prefix != NULL) {
						char* _tmp15_;
						char* _tmp14_;
						fqan = (_tmp15_ = g_strconcat (_tmp14_ = g_strconcat (prefix, ".", NULL), localname, NULL), _g_free0 (fqan), _tmp15_);
						_g_free0 (_tmp14_);
					} else {
						char* _tmp16_;
						fqan = (_tmp16_ = g_strdup (localname), _g_free0 (fqan), _tmp16_);
					}
					if (vala_collection_get_size ((ValaCollection*) attrs) > 0) {
						char* _tmp17_;
						vala_report_error (source_reference, _tmp17_ = g_strdup_printf ("No class %s found.", fqan));
						_g_free0 (_tmp17_);
					}
					gtkaml_state_stack_push (self->priv->_states, _tmp18_ = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE, attribute_parent_class_definition, NULL, fqan));
					_g_object_unref0 (_tmp18_);
					_g_object_unref0 (attribute_parent_class_definition);
				}
				_vala_code_node_unref0 (clazz);
				_g_free0 (fqan);
				break;
			}
		}
		case GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE:
		{
			{
				char* _tmp20_;
				ValaClass* _tmp21_;
				ValaClass* clazz;
				GtkamlClassDefinition* attribute_value_definition;
				char* _tmp24_;
				GtkamlComplexAttribute* _tmp25_;
				GtkamlComplexAttribute* attr;
				GtkamlState* _tmp26_;
				if (gtkaml_state_get_attribute (state) != NULL) {
					char* _tmp19_;
					vala_report_error (source_reference, _tmp19_ = g_strdup_printf ("Incorrect attribute definition for %s", gtkaml_state_get_attribute_name (state)));
					_g_free0 (_tmp19_);
					gtkaml_sax_parser_stop_parsing (self);
					_vala_collection_object_unref0 (attrs);
					_g_object_unref0 (state);
					_vala_source_reference_unref0 (source_reference);
					return;
				}
				clazz = (_tmp21_ = gtkaml_sax_parser_lookup_class (self, _tmp20_ = gtkaml_sax_parser_prefix_to_namespace (self, prefix), localname), _g_free0 (_tmp20_), _tmp21_);
				attribute_value_definition = NULL;
				if (clazz != NULL) {
					GtkamlClassDefinition* _tmp22_;
					attribute_value_definition = (_tmp22_ = gtkaml_sax_parser_get_child_for_container (self, clazz, NULL, attrs, prefix), _g_object_unref0 (attribute_value_definition), _tmp22_);
				} else {
					char* _tmp23_;
					vala_report_error (source_reference, _tmp23_ = g_strdup_printf ("No class '%s' found", localname));
					_g_free0 (_tmp23_);
					gtkaml_sax_parser_stop_parsing (self);
					_vala_code_node_unref0 (clazz);
					_g_object_unref0 (attribute_value_definition);
					_vala_collection_object_unref0 (attrs);
					_g_object_unref0 (state);
					_vala_source_reference_unref0 (source_reference);
					return;
				}
				attr = (_tmp25_ = gtkaml_complex_attribute_new (_tmp24_ = gtkaml_sax_parser_strip_attribute_hyphens (self, gtkaml_state_get_attribute_name (state)), attribute_value_definition), _g_free0 (_tmp24_), _tmp25_);
				gtkaml_state_set_attribute (state, (GtkamlAttribute*) attr);
				gtkaml_class_definition_add_attribute (gtkaml_state_get_class_definition (state), (GtkamlAttribute*) attr);
				gtkaml_state_stack_push (self->priv->_states, _tmp26_ = gtkaml_state_new (GTKAML_STATE_ID_SAX_PARSER_CONTAINER_STATE, attribute_value_definition, NULL, NULL));
				_g_object_unref0 (_tmp26_);
				_vala_code_node_unref0 (clazz);
				_g_object_unref0 (attribute_value_definition);
				_g_object_unref0 (attr);
				break;
			}
		}
		default:
		{
			vala_report_error (source_reference, "Invalid Gtkaml SAX Parser state");
			gtkaml_sax_parser_stop_parsing (self);
			_vala_collection_object_unref0 (attrs);
			_g_object_unref0 (state);
			_vala_source_reference_unref0 (source_reference);
			return;
		}
	}
	_vala_collection_object_unref0 (attrs);
	_g_object_unref0 (state);
	_vala_source_reference_unref0 (source_reference);
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


void gtkaml_sax_parser_characters (GtkamlSAXParser* self, const char* data, gint len) {
	GtkamlState* state;
	char* value;
	char* stripped_value;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	state = gtkaml_state_stack_peek (self->priv->_states, 0);
	value = g_strndup (data, (gsize) len);
	stripped_value = string_strip (value);
	if (_vala_strcmp0 (stripped_value, "") != 0) {
		gtkaml_sax_parser_parse_attribute_content_as_text (self, state, value);
	}
	_g_object_unref0 (state);
	_g_free0 (value);
	_g_free0 (stripped_value);
}


void gtkaml_sax_parser_end_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI) {
	GtkamlState* last_state;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (localname != NULL);
	g_return_if_fail (URI != NULL);
	last_state = gtkaml_state_stack_pop (self->priv->_states);
	if (last_state != NULL) {
		_tmp3_ = gtkaml_state_get_state_id (last_state) == GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = gtkaml_state_get_attribute (last_state) == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char* _tmp4_;
		_tmp1_ = _vala_strcmp0 (gtkaml_state_get_attribute_name (last_state), _tmp4_ = g_strconcat (self->gtkaml_prefix, ".preconstruct", NULL)) != 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp5_;
		_tmp0_ = _vala_strcmp0 (gtkaml_state_get_attribute_name (last_state), _tmp5_ = g_strconcat (self->gtkaml_prefix, ".construct", NULL)) != 0;
		_g_free0 (_tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp8_;
		char* _tmp7_;
		ValaSourceReference* _tmp6_;
		vala_report_error (_tmp6_ = gtkaml_sax_parser_create_source_reference (self), _tmp8_ = g_strdup_printf ("%s is not well defined or is not an attribute of %s", gtkaml_state_get_attribute_name (last_state), _tmp7_ = gtkaml_class_definition_get_base_full_name (gtkaml_state_get_class_definition (last_state))));
		_g_free0 (_tmp8_);
		_g_free0 (_tmp7_);
		_vala_source_reference_unref0 (_tmp6_);
		gtkaml_sax_parser_stop_parsing (self);
	}
	_g_object_unref0 (last_state);
}


void gtkaml_sax_parser_cdata_block (GtkamlSAXParser* self, const char* cdata, gint len) {
	GtkamlState* state;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cdata != NULL);
	state = gtkaml_state_stack_peek (self->priv->_states, 0);
	if (gtkaml_state_get_state_id (state) != GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE) {
		GtkamlState* previous_state;
		previous_state = gtkaml_state_stack_peek (self->priv->_states, 1);
		if (gtkaml_state_get_state_id (previous_state) == GTKAML_STATE_ID_SAX_PARSER_INITIAL_STATE) {
			GtkamlClassDefinition* _tmp0_;
			GtkamlRootClassDefinition* root_class;
			char* _tmp1_;
			root_class = _g_object_ref0 ((_tmp0_ = gtkaml_state_get_class_definition (state), GTKAML_IS_ROOT_CLASS_DEFINITION (_tmp0_) ? ((GtkamlRootClassDefinition*) _tmp0_) : NULL));
			if (gtkaml_root_class_definition_get_original_first_code_line (root_class) < 0) {
				gtkaml_root_class_definition_set_original_first_code_line (root_class, gtkaml_sax_parser_line_number (self));
			}
			vala_collection_add ((ValaCollection*) gtkaml_root_class_definition_get_code (root_class), _tmp1_ = g_strndup (cdata, (gsize) len));
			_g_free0 (_tmp1_);
			_g_object_unref0 (root_class);
		} else {
			char* _tmp2_;
			gtkaml_sax_parser_parse_attribute_content_as_text (self, state, _tmp2_ = g_strndup (cdata, (gsize) len));
			_g_free0 (_tmp2_);
		}
		_g_object_unref0 (previous_state);
	}
	_g_object_unref0 (state);
}


static void gtkaml_sax_parser_parse_attribute_content_as_text (GtkamlSAXParser* self, GtkamlState* state, const char* content) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (content != NULL);
	if (gtkaml_state_get_state_id (state) == GTKAML_STATE_ID_SAX_PARSER_ATTRIBUTE_STATE) {
		char* _tmp0_;
		gboolean _tmp1_;
		if ((_tmp1_ = _vala_strcmp0 (gtkaml_state_get_attribute_name (state), _tmp0_ = g_strconcat (self->gtkaml_prefix, ".preconstruct", NULL)) == 0, _g_free0 (_tmp0_), _tmp1_)) {
			if (gtkaml_class_definition_get_preconstruct_code (gtkaml_state_get_class_definition (state)) != NULL) {
				char* _tmp3_;
				ValaSourceReference* _tmp2_;
				vala_report_error (_tmp2_ = gtkaml_sax_parser_create_source_reference (self), _tmp3_ = g_strdup_printf ("A preconstruct attribute already exists for %s", gtkaml_class_definition_get_identifier (gtkaml_state_get_class_definition (state))));
				_g_free0 (_tmp3_);
				_vala_source_reference_unref0 (_tmp2_);
				gtkaml_sax_parser_stop_parsing (self);
				return;
			}
			gtkaml_class_definition_set_preconstruct_code (gtkaml_state_get_class_definition (state), content);
		} else {
			char* _tmp4_;
			gboolean _tmp5_;
			if ((_tmp5_ = _vala_strcmp0 (gtkaml_state_get_attribute_name (state), _tmp4_ = g_strconcat (self->gtkaml_prefix, ".construct", NULL)) == 0, _g_free0 (_tmp4_), _tmp5_)) {
				if (gtkaml_class_definition_get_construct_code (gtkaml_state_get_class_definition (state)) != NULL) {
					char* _tmp7_;
					ValaSourceReference* _tmp6_;
					vala_report_error (_tmp6_ = gtkaml_sax_parser_create_source_reference (self), _tmp7_ = g_strdup_printf ("A construct attribute already exists for %s", gtkaml_class_definition_get_identifier (gtkaml_state_get_class_definition (state))));
					_g_free0 (_tmp7_);
					_vala_source_reference_unref0 (_tmp6_);
					gtkaml_sax_parser_stop_parsing (self);
					return;
				}
				gtkaml_class_definition_set_construct_code (gtkaml_state_get_class_definition (state), content);
			} else {
				if (gtkaml_state_get_attribute (state) == NULL) {
					GtkamlSimpleAttribute* _tmp9_;
					char* _tmp8_;
					gtkaml_state_set_attribute (state, (GtkamlAttribute*) (_tmp9_ = gtkaml_simple_attribute_new (_tmp8_ = gtkaml_sax_parser_strip_attribute_hyphens (self, gtkaml_state_get_attribute_name (state)), content)));
					_g_object_unref0 (_tmp9_);
					_g_free0 (_tmp8_);
					gtkaml_class_definition_add_attribute (gtkaml_state_get_class_definition (state), gtkaml_state_get_attribute (state));
				} else {
					if (GTKAML_IS_SIMPLE_ATTRIBUTE (gtkaml_state_get_attribute (state))) {
						char* _tmp12_;
						char* _tmp11_;
						GtkamlAttribute* _tmp10_;
						gtkaml_simple_attribute_set_value ((_tmp10_ = gtkaml_state_get_attribute (state), GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp10_) ? ((GtkamlSimpleAttribute*) _tmp10_) : NULL), _tmp12_ = g_strconcat (gtkaml_simple_attribute_get_value ((_tmp10_ = gtkaml_state_get_attribute (state), GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp10_) ? ((GtkamlSimpleAttribute*) _tmp10_) : NULL)), _tmp11_ = g_strconcat ("\n", content, NULL), NULL));
						_g_free0 (_tmp12_);
						_g_free0 (_tmp11_);
					} else {
						char* _tmp14_;
						ValaSourceReference* _tmp13_;
						vala_report_error (_tmp13_ = gtkaml_sax_parser_create_source_reference (self), _tmp14_ = g_strdup_printf ("Cannot mix a complex attribute definition with simple values like this: attribute %s", gtkaml_attribute_get_name (gtkaml_state_get_attribute (state))));
						_g_free0 (_tmp14_);
						_vala_source_reference_unref0 (_tmp13_);
						gtkaml_sax_parser_stop_parsing (self);
						return;
					}
				}
			}
		}
	} else {
		char* _tmp16_;
		ValaSourceReference* _tmp15_;
		vala_report_error (_tmp15_ = gtkaml_sax_parser_create_source_reference (self), _tmp16_ = g_strdup_printf ("Invalid non-whitespace text found: '%s'", content));
		_g_free0 (_tmp16_);
		_vala_source_reference_unref0 (_tmp15_);
		gtkaml_sax_parser_stop_parsing (self);
		return;
	}
}


static char* gtkaml_sax_parser_prefix_to_namespace (GtkamlSAXParser* self, const char* prefix) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (prefix == NULL) {
		result = (char*) vala_map_get (self->priv->_prefixes_namespaces, "");
		return result;
	}
	result = (char*) vala_map_get (self->priv->_prefixes_namespaces, prefix);
	return result;
}


ValaSourceReference* gtkaml_sax_parser_create_source_reference (GtkamlSAXParser* self) {
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = vala_source_reference_new (self->priv->_source_file, gtkaml_sax_parser_line_number (self), gtkaml_sax_parser_column_number (self), gtkaml_sax_parser_line_number (self), gtkaml_sax_parser_column_number (self));
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaClass* gtkaml_sax_parser_lookup_class (GtkamlSAXParser* self, const char* xmlNamespace, const char* name) {
	ValaClass* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _ns_it;
		_ns_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_namespace_get_namespaces (vala_code_context_get_root (self->priv->_context)))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaNamespace* ns;
			if (!vala_iterator_next (_ns_it)) {
				break;
			}
			ns = (ValaNamespace*) vala_iterator_get (_ns_it);
			if (_vala_strcmp0 (xmlNamespace, vala_symbol_get_name ((ValaSymbol*) ns)) == 0) {
				ValaSymbol* s;
				s = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name);
				if (VALA_IS_CLASS (s)) {
					ValaSymbol* _tmp2_;
					result = _vala_code_node_ref0 ((_tmp2_ = s, VALA_IS_CLASS (_tmp2_) ? ((ValaClass*) _tmp2_) : NULL));
					_vala_code_node_unref0 (s);
					_vala_code_node_unref0 (ns);
					_vala_collection_object_unref0 (_ns_it);
					return result;
				}
				_vala_code_node_unref0 (s);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_collection_object_unref0 (_ns_it);
	}
	result = NULL;
	return result;
}


static char* gtkaml_sax_parser_strip_attribute_hyphens (GtkamlSAXParser* self, const char* attrname) {
	char* result;
	char** _tmp1_;
	gint tokens_size;
	gint tokens_length1;
	char** _tmp0_;
	char** tokens;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attrname != NULL, NULL);
	tokens = (_tmp1_ = _tmp0_ = g_strsplit (attrname, "-", 0), tokens_length1 = _vala_array_length (_tmp0_), tokens_size = tokens_length1, _tmp1_);
	result = g_strjoinv ("_", tokens);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_definition (GtkamlSAXParser* self, ValaClass* clazz, ValaList* attrs, const char* prefix) {
	GtkamlRootClassDefinition* result;
	char* _tmp1_;
	ValaSourceReference* _tmp0_;
	GtkamlRootClassDefinition* _tmp2_;
	GtkamlRootClassDefinition* root_class_definition;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (clazz != NULL, NULL);
	g_return_val_if_fail (attrs != NULL, NULL);
	root_class_definition = (_tmp2_ = gtkaml_root_class_definition_new (_tmp0_ = gtkaml_sax_parser_create_source_reference (self), "this", _tmp1_ = gtkaml_sax_parser_prefix_to_namespace (self, prefix), clazz, DEFINITION_SCOPE_MAIN_CLASS, NULL), _g_free0 (_tmp1_), _vala_source_reference_unref0 (_tmp0_), _tmp2_);
	gtkaml_root_class_definition_set_prefixes_namespaces (root_class_definition, self->priv->_prefixes_namespaces);
	{
		ValaIterator* _attr_it;
		_attr_it = vala_iterable_iterator ((ValaIterable*) attrs);
		while (TRUE) {
			GtkamlXmlAttribute* attr;
			if (!vala_iterator_next (_attr_it)) {
				break;
			}
			attr = (GtkamlXmlAttribute*) vala_iterator_get (_attr_it);
			if (attr->prefix != NULL) {
				if (_vala_strcmp0 (attr->prefix, self->gtkaml_prefix) == 0) {
					GQuark _tmp16_;
					const char* _tmp15_;
					static GQuark _tmp16__label0 = 0;
					static GQuark _tmp16__label1 = 0;
					static GQuark _tmp16__label2 = 0;
					static GQuark _tmp16__label3 = 0;
					static GQuark _tmp16__label4 = 0;
					static GQuark _tmp16__label5 = 0;
					static GQuark _tmp16__label6 = 0;
					_tmp15_ = attr->localname;
					_tmp16_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
					if ((_tmp16_ == ((0 != _tmp16__label0) ? _tmp16__label0 : (_tmp16__label0 = g_quark_from_static_string ("public")))) || (_tmp16_ == ((0 != _tmp16__label1) ? _tmp16__label1 : (_tmp16__label1 = g_quark_from_static_string ("name")))))
					do {
						if (gtkaml_root_class_definition_get_target_name (root_class_definition) != NULL) {
							char* _tmp4_;
							ValaSourceReference* _tmp3_;
							vala_report_error (_tmp3_ = gtkaml_sax_parser_create_source_reference (self), _tmp4_ = g_strdup_printf ("A name for the class already exists ('%s')", gtkaml_root_class_definition_get_target_name (root_class_definition)));
							_g_free0 (_tmp4_);
							_vala_source_reference_unref0 (_tmp3_);
							gtkaml_sax_parser_stop_parsing (self);
						}
						gtkaml_root_class_definition_set_target_name (root_class_definition, attr->value);
						break;
					} while (0); else if (_tmp16_ == ((0 != _tmp16__label2) ? _tmp16__label2 : (_tmp16__label2 = g_quark_from_static_string ("namespace"))))
					do {
						gtkaml_root_class_definition_set_target_namespace (root_class_definition, attr->value);
						break;
					} while (0); else if (_tmp16_ == ((0 != _tmp16__label3) ? _tmp16__label3 : (_tmp16__label3 = g_quark_from_static_string ("private"))))
					do {
						ValaSourceReference* _tmp5_;
						vala_report_error (_tmp5_ = gtkaml_sax_parser_create_source_reference (self), "'private' not allowed on root tag.");
						_vala_source_reference_unref0 (_tmp5_);
						gtkaml_sax_parser_stop_parsing (self);
						break;
					} while (0); else if (_tmp16_ == ((0 != _tmp16__label4) ? _tmp16__label4 : (_tmp16__label4 = g_quark_from_static_string ("construct"))))
					do {
						if (gtkaml_class_definition_get_construct_code ((GtkamlClassDefinition*) root_class_definition) != NULL) {
							ValaSourceReference* _tmp6_;
							vala_report_error (_tmp6_ = gtkaml_sax_parser_create_source_reference (self), "A construct attribute already exists for the root class");
							_vala_source_reference_unref0 (_tmp6_);
							gtkaml_sax_parser_stop_parsing (self);
						}
						gtkaml_class_definition_set_construct_code ((GtkamlClassDefinition*) root_class_definition, attr->value);
						break;
					} while (0); else if (_tmp16_ == ((0 != _tmp16__label5) ? _tmp16__label5 : (_tmp16__label5 = g_quark_from_static_string ("preconstruct"))))
					do {
						if (gtkaml_class_definition_get_preconstruct_code ((GtkamlClassDefinition*) root_class_definition) != NULL) {
							ValaSourceReference* _tmp7_;
							vala_report_error (_tmp7_ = gtkaml_sax_parser_create_source_reference (self), "A preconstruct attribute already exists for the root class");
							_vala_source_reference_unref0 (_tmp7_);
							gtkaml_sax_parser_stop_parsing (self);
						}
						gtkaml_class_definition_set_preconstruct_code ((GtkamlClassDefinition*) root_class_definition, attr->value);
						break;
					} while (0); else if (_tmp16_ == ((0 != _tmp16__label6) ? _tmp16__label6 : (_tmp16__label6 = g_quark_from_static_string ("implements"))))
					do {
						char** _tmp9_;
						gint implementsv_size;
						gint implementsv_length1;
						char** _tmp8_;
						char** implementsv;
						char* _tmp12_;
						implementsv = (_tmp9_ = _tmp8_ = g_strsplit (attr->value, ",", 0), implementsv_length1 = _vala_array_length (_tmp8_), implementsv_size = implementsv_length1, _tmp9_);
						{
							gint i;
							i = 0;
							{
								gboolean _tmp10_;
								_tmp10_ = TRUE;
								while (TRUE) {
									char* _tmp11_;
									if (!_tmp10_) {
										i++;
									}
									_tmp10_ = FALSE;
									if (!(implementsv[i] != NULL)) {
										break;
									}
									implementsv[i] = (_tmp11_ = string_strip (implementsv[i]), _g_free0 (implementsv[i]), _tmp11_);
								}
							}
						}
						gtkaml_root_class_definition_set_implements (root_class_definition, _tmp12_ = g_strjoinv (", ", implementsv));
						_g_free0 (_tmp12_);
						implementsv = (_vala_array_free (implementsv, implementsv_length1, (GDestroyNotify) g_free), NULL);
						break;
					} while (0); else
					do {
						char* _tmp14_;
						ValaSourceReference* _tmp13_;
						vala_report_warning (_tmp13_ = gtkaml_sax_parser_create_source_reference (self), _tmp14_ = g_strdup_printf ("Unknown gtkaml attribute '%s'.", attr->localname));
						_g_free0 (_tmp14_);
						_vala_source_reference_unref0 (_tmp13_);
						break;
					} while (0);
				} else {
					char* _tmp18_;
					ValaSourceReference* _tmp17_;
					vala_report_error (_tmp17_ = gtkaml_sax_parser_create_source_reference (self), _tmp18_ = g_strdup_printf ("'%s' is the only allowed prefix for attributes. Other attributes must be left unprefixed", self->gtkaml_prefix));
					_g_free0 (_tmp18_);
					_vala_source_reference_unref0 (_tmp17_);
					gtkaml_sax_parser_stop_parsing (self);
				}
			} else {
				char* _tmp19_;
				GtkamlSimpleAttribute* _tmp20_;
				GtkamlSimpleAttribute* simple_attribute;
				simple_attribute = (_tmp20_ = gtkaml_simple_attribute_new (_tmp19_ = gtkaml_sax_parser_strip_attribute_hyphens (self, attr->localname), attr->value), _g_free0 (_tmp19_), _tmp20_);
				gtkaml_class_definition_add_attribute ((GtkamlClassDefinition*) root_class_definition, (GtkamlAttribute*) simple_attribute);
				_g_object_unref0 (simple_attribute);
			}
			_g_object_unref0 (attr);
		}
		_vala_collection_object_unref0 (_attr_it);
	}
	if (gtkaml_root_class_definition_get_target_name (root_class_definition) == NULL) {
		char* _tmp22_;
		ValaSourceReference* _tmp21_;
		vala_report_error (_tmp21_ = gtkaml_sax_parser_create_source_reference (self), _tmp22_ = g_strdup_printf ("No class name specified: use %s:name for this", self->gtkaml_prefix));
		_g_free0 (_tmp22_);
		_vala_source_reference_unref0 (_tmp21_);
	}
	result = root_class_definition;
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


GtkamlClassDefinition* gtkaml_sax_parser_get_child_for_container (GtkamlSAXParser* self, ValaClass* clazz, GtkamlClassDefinition* container_definition, ValaList* attrs, const char* prefix) {
	GtkamlClassDefinition* result;
	char* identifier;
	DefinitionScope identifier_scope;
	char* reference;
	char* construct_code;
	char* preconstruct_code;
	GtkamlClassDefinition* parent_container;
	gboolean _tmp14_ = FALSE;
	GtkamlClassDefinition* class_definition;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (clazz != NULL, NULL);
	g_return_val_if_fail (attrs != NULL, NULL);
	identifier = NULL;
	identifier_scope = DEFINITION_SCOPE_CONSTRUCTOR;
	reference = NULL;
	construct_code = NULL;
	preconstruct_code = NULL;
	parent_container = _g_object_ref0 (container_definition);
	{
		ValaIterator* _attr_it;
		_attr_it = vala_iterable_iterator ((ValaIterable*) attrs);
		while (TRUE) {
			GtkamlXmlAttribute* attr;
			gboolean _tmp0_ = FALSE;
			if (!vala_iterator_next (_attr_it)) {
				break;
			}
			attr = (GtkamlXmlAttribute*) vala_iterator_get (_attr_it);
			if (attr->prefix != NULL) {
				_tmp0_ = _vala_strcmp0 (attr->prefix, self->gtkaml_prefix) == 0;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gboolean _tmp1_ = FALSE;
				if (_vala_strcmp0 (attr->localname, "public") == 0) {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = _vala_strcmp0 (attr->localname, "private") == 0;
				}
				if (_tmp1_) {
					char* _tmp4_;
					if (identifier != NULL) {
						char* _tmp3_;
						ValaSourceReference* _tmp2_;
						vala_report_error (_tmp2_ = gtkaml_sax_parser_create_source_reference (self), _tmp3_ = g_strdup_printf ("Cannot have multiple identifier names:%s", attr->localname));
						_g_free0 (_tmp3_);
						_vala_source_reference_unref0 (_tmp2_);
						gtkaml_sax_parser_stop_parsing (self);
						_g_object_unref0 (attr);
						break;
					}
					identifier = (_tmp4_ = g_strdup (attr->value), _g_free0 (identifier), _tmp4_);
					if (_vala_strcmp0 (attr->localname, "public") == 0) {
						identifier_scope = DEFINITION_SCOPE_PUBLIC;
					} else {
						identifier_scope = DEFINITION_SCOPE_PRIVATE;
					}
				} else {
					if (_vala_strcmp0 (attr->localname, "existing") == 0) {
						char* _tmp5_;
						reference = (_tmp5_ = g_strdup (attr->value), _g_free0 (reference), _tmp5_);
					} else {
						if (_vala_strcmp0 (attr->localname, "construct") == 0) {
							char* _tmp6_;
							construct_code = (_tmp6_ = g_strdup (attr->value), _g_free0 (construct_code), _tmp6_);
						} else {
							if (_vala_strcmp0 (attr->localname, "preconstruct") == 0) {
								char* _tmp7_;
								preconstruct_code = (_tmp7_ = g_strdup (attr->value), _g_free0 (preconstruct_code), _tmp7_);
							} else {
								if (_vala_strcmp0 (attr->localname, "standalone") == 0) {
									if (_vala_strcmp0 (attr->value, "true") == 0) {
										GtkamlClassDefinition* _tmp8_;
										parent_container = (_tmp8_ = NULL, _g_object_unref0 (parent_container), _tmp8_);
									} else {
										ValaSourceReference* _tmp9_;
										vala_report_error (_tmp9_ = gtkaml_sax_parser_create_source_reference (self), "Invalid 'standalone' value");
										_vala_source_reference_unref0 (_tmp9_);
										gtkaml_sax_parser_stop_parsing (self);
									}
								} else {
									char* _tmp11_;
									ValaSourceReference* _tmp10_;
									vala_report_error (_tmp10_ = gtkaml_sax_parser_create_source_reference (self), _tmp11_ = g_strdup_printf ("Unkown gtkaml attribute '%s'", attr->localname));
									_g_free0 (_tmp11_);
									_vala_source_reference_unref0 (_tmp10_);
									gtkaml_sax_parser_stop_parsing (self);
								}
							}
						}
					}
				}
			} else {
				if (attr->prefix != NULL) {
					char* _tmp13_;
					ValaSourceReference* _tmp12_;
					vala_report_error (_tmp12_ = gtkaml_sax_parser_create_source_reference (self), _tmp13_ = g_strdup_printf ("%s is the only allowed prefix for attributes. Other attributes must be left unprefixed", self->gtkaml_prefix));
					_g_free0 (_tmp13_);
					_vala_source_reference_unref0 (_tmp12_);
					gtkaml_sax_parser_stop_parsing (self);
				}
			}
			_g_object_unref0 (attr);
		}
		_vala_collection_object_unref0 (_attr_it);
	}
	if (identifier != NULL) {
		_tmp14_ = reference != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaSourceReference* _tmp15_;
		vala_report_error (_tmp15_ = gtkaml_sax_parser_create_source_reference (self), "Cannot specify both existing and a new identifier name");
		_vala_source_reference_unref0 (_tmp15_);
		gtkaml_sax_parser_stop_parsing (self);
	}
	class_definition = NULL;
	if (reference == NULL) {
		gint counter;
		GtkamlClassDefinition* _tmp21_;
		char* _tmp20_;
		ValaSourceReference* _tmp19_;
		counter = 0;
		if (identifier == NULL) {
			char* _tmp16_;
			char* _tmp17_;
			char* _tmp18_;
			identifier = (_tmp16_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) clazz), (gssize) g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) clazz), -1)), _g_free0 (identifier), _tmp16_);
			if (vala_map_contains (self->priv->generated_identifiers_counter, identifier)) {
				counter = GPOINTER_TO_INT (vala_map_get (self->priv->generated_identifiers_counter, identifier));
			}
			identifier = (_tmp17_ = g_strdup_printf ("_%s%d", identifier, counter), _g_free0 (identifier), _tmp17_);
			counter++;
			vala_map_set (self->priv->generated_identifiers_counter, _tmp18_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) clazz), (gssize) g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) clazz), -1)), GINT_TO_POINTER (counter));
			_g_free0 (_tmp18_);
		}
		class_definition = (_tmp21_ = gtkaml_class_definition_new (_tmp19_ = gtkaml_sax_parser_create_source_reference (self), identifier, _tmp20_ = gtkaml_sax_parser_prefix_to_namespace (self, prefix), clazz, identifier_scope, parent_container), _g_object_unref0 (class_definition), _tmp21_);
		_g_free0 (_tmp20_);
		_vala_source_reference_unref0 (_tmp19_);
		gtkaml_class_definition_set_construct_code (class_definition, construct_code);
		gtkaml_class_definition_set_preconstruct_code (class_definition, preconstruct_code);
	} else {
		gboolean _tmp22_ = FALSE;
		GtkamlClassDefinition* _tmp26_;
		char* _tmp25_;
		ValaSourceReference* _tmp24_;
		char* reference_stripped;
		if (construct_code != NULL) {
			_tmp22_ = TRUE;
		} else {
			_tmp22_ = preconstruct_code != NULL;
		}
		if (_tmp22_) {
			ValaSourceReference* _tmp23_;
			vala_report_error (_tmp23_ = gtkaml_sax_parser_create_source_reference (self), "Cannot specify 'construct' or 'preconstruct' code for references");
			_vala_source_reference_unref0 (_tmp23_);
			gtkaml_sax_parser_stop_parsing (self);
		}
		class_definition = (_tmp26_ = (GtkamlClassDefinition*) gtkaml_reference_class_definition_new (_tmp24_ = gtkaml_sax_parser_create_source_reference (self), reference, _tmp25_ = gtkaml_sax_parser_prefix_to_namespace (self, prefix), clazz, parent_container), _g_object_unref0 (class_definition), _tmp26_);
		_g_free0 (_tmp25_);
		_vala_source_reference_unref0 (_tmp24_);
		reference_stripped = string_strip (reference);
		if (g_str_has_prefix (reference_stripped, "{")) {
			if (g_str_has_suffix (reference_stripped, "}")) {
				char* _tmp27_;
				gtkaml_class_definition_set_identifier (class_definition, _tmp27_ = string_substring (reference_stripped, (glong) 1, g_utf8_strlen (reference_stripped, -1) - 2));
				_g_free0 (_tmp27_);
			} else {
				ValaSourceReference* _tmp28_;
				vala_report_error (_tmp28_ = gtkaml_sax_parser_create_source_reference (self), "'existing' attribute not properly ended");
				_vala_source_reference_unref0 (_tmp28_);
			}
		} else {
			char* _tmp30_;
			char* _tmp29_;
			gtkaml_class_definition_set_identifier (class_definition, _tmp30_ = g_strdup_printf ("(%s as %s)", reference, _tmp29_ = gtkaml_class_definition_get_base_full_name (class_definition)));
			_g_free0 (_tmp30_);
			_g_free0 (_tmp29_);
		}
		_g_free0 (reference_stripped);
	}
	if (container_definition != NULL) {
		gtkaml_class_definition_add_child (container_definition, class_definition);
	}
	{
		ValaIterator* _attr_it;
		_attr_it = vala_iterable_iterator ((ValaIterable*) attrs);
		while (TRUE) {
			GtkamlXmlAttribute* attr;
			if (!vala_iterator_next (_attr_it)) {
				break;
			}
			attr = (GtkamlXmlAttribute*) vala_iterator_get (_attr_it);
			if (attr->prefix == NULL) {
				char* _tmp31_;
				GtkamlSimpleAttribute* _tmp32_;
				GtkamlSimpleAttribute* simple_attribute;
				simple_attribute = (_tmp32_ = gtkaml_simple_attribute_new (_tmp31_ = gtkaml_sax_parser_strip_attribute_hyphens (self, attr->localname), attr->value), _g_free0 (_tmp31_), _tmp32_);
				gtkaml_class_definition_add_attribute (class_definition, (GtkamlAttribute*) simple_attribute);
				_g_object_unref0 (simple_attribute);
			}
			_g_object_unref0 (attr);
		}
		_vala_collection_object_unref0 (_attr_it);
	}
	result = class_definition;
	_g_free0 (identifier);
	_g_free0 (reference);
	_g_free0 (construct_code);
	_g_free0 (preconstruct_code);
	_g_object_unref0 (parent_container);
	return result;
}


static ValaList* gtkaml_sax_parser_parse_attributes (GtkamlSAXParser* self, char** attributes, gint nb_attributes) {
	ValaList* result;
	gint walker;
	char* end;
	ValaArrayList* attribute_list;
	g_return_val_if_fail (self != NULL, NULL);
	walker = 0;
	end = NULL;
	attribute_list = vala_array_list_new (GTKAML_TYPE_XML_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkamlXmlAttribute* attr;
				char* _tmp1_;
				char* _tmp2_;
				char* _tmp3_;
				char* _tmp4_;
				char* _tmp5_;
				char* _tmp6_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < nb_attributes)) {
					break;
				}
				attr = gtkaml_xml_attribute_new ();
				attr->localname = (_tmp1_ = g_strdup (attributes[walker]), _g_free0 (attr->localname), _tmp1_);
				attr->prefix = (_tmp2_ = g_strdup (attributes[walker + 1]), _g_free0 (attr->prefix), _tmp2_);
				attr->URI = (_tmp3_ = g_strdup (attributes[walker + 2]), _g_free0 (attr->URI), _tmp3_);
				attr->value = (_tmp4_ = g_strdup (attributes[walker + 3]), _g_free0 (attr->value), _tmp4_);
				end = (_tmp5_ = g_strdup (attributes[walker + 4]), _g_free0 (end), _tmp5_);
				attr->value = (_tmp6_ = g_strndup (attr->value, (gsize) (g_utf8_strlen (attr->value, -1) - g_utf8_strlen (end, -1))), _g_free0 (attr->value), _tmp6_);
				vala_collection_add ((ValaCollection*) attribute_list, attr);
				walker = walker + 5;
				_g_object_unref0 (attr);
			}
		}
	}
	result = (ValaList*) attribute_list;
	_g_free0 (end);
	return result;
}


static ValaList* gtkaml_sax_parser_parse_namespaces (GtkamlSAXParser* self, char** namespaces, gint nb_namespaces) {
	ValaList* result;
	gint walker;
	ValaArrayList* namespace_list;
	g_return_val_if_fail (self != NULL, NULL);
	walker = 0;
	namespace_list = vala_array_list_new (TYPE_XML_NAMESPACE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				XmlNamespace* ns;
				char* _tmp1_;
				char* _tmp2_;
				gboolean _tmp3_ = FALSE;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < nb_namespaces)) {
					break;
				}
				ns = xml_namespace_new ();
				ns->prefix = (_tmp1_ = g_strdup (namespaces[walker]), _g_free0 (ns->prefix), _tmp1_);
				ns->URI = (_tmp2_ = g_strdup (namespaces[walker + 1]), _g_free0 (ns->URI), _tmp2_);
				if (ns->URI != NULL) {
					_tmp3_ = g_str_has_prefix (ns->URI, "http://gtkaml.org/");
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					if (ns->prefix != NULL) {
						char* _tmp4_;
						char* version;
						self->gtkaml_prefix = (_tmp4_ = g_strdup (ns->prefix), _g_free0 (self->gtkaml_prefix), _tmp4_);
						version = string_substring (ns->URI, g_utf8_strlen ("http://gtkaml.org/", -1), g_utf8_strlen (ns->URI, -1) - g_utf8_strlen ("http://gtkaml.org/", -1));
						if (_vala_strcmp0 (version, PACKAGE_VERSION) > 0) {
							char* _tmp6_;
							ValaSourceReference* _tmp5_;
							vala_report_warning (_tmp5_ = gtkaml_sax_parser_create_source_reference (self), _tmp6_ = g_strdup_printf ("Source file version (%s) newer than gtkaml compiler version (%s)", version, PACKAGE_VERSION));
							_g_free0 (_tmp6_);
							_vala_source_reference_unref0 (_tmp5_);
						}
						_g_free0 (version);
					} else {
						ValaSourceReference* _tmp7_;
						vala_report_error (_tmp7_ = gtkaml_sax_parser_create_source_reference (self), "You cannot use the gtkaml namespace as default namespace");
						_vala_source_reference_unref0 (_tmp7_);
					}
				}
				vala_collection_add ((ValaCollection*) namespace_list, ns);
				walker = walker + 2;
				_g_object_unref0 (ns);
			}
		}
	}
	result = (ValaList*) namespace_list;
	return result;
}


ValaCodeContext* gtkaml_sax_parser_get_context (GtkamlSAXParser* self) {
	ValaCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_context;
	return result;
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static void gtkaml_sax_parser_set_context (GtkamlSAXParser* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_context = (_tmp0_ = _vala_code_context_ref0 (value), _vala_code_context_unref0 (self->priv->_context), _tmp0_);
	g_object_notify ((GObject *) self, "context");
}


ValaSourceFile* gtkaml_sax_parser_get_source_file (GtkamlSAXParser* self) {
	ValaSourceFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_file;
	return result;
}


static void gtkaml_sax_parser_set_source_file (GtkamlSAXParser* self, ValaSourceFile* value) {
	g_return_if_fail (self != NULL);
	self->priv->_source_file = value;
	g_object_notify ((GObject *) self, "source-file");
}


static GtkamlStateStack* gtkaml_sax_parser_get_states (GtkamlSAXParser* self) {
	GtkamlStateStack* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_states;
	return result;
}


static void gtkaml_sax_parser_set_states (GtkamlSAXParser* self, GtkamlStateStack* value) {
	GtkamlStateStack* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_states = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_states), _tmp0_);
}


static ValaMap* gtkaml_sax_parser_get_prefixes_namespaces (GtkamlSAXParser* self) {
	ValaMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_prefixes_namespaces;
	return result;
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


static void gtkaml_sax_parser_set_prefixes_namespaces (GtkamlSAXParser* self, ValaMap* value) {
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_prefixes_namespaces = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_prefixes_namespaces), _tmp0_);
}


static GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_class_definition (GtkamlSAXParser* self) {
	GtkamlRootClassDefinition* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_root_class_definition;
	return result;
}


static void gtkaml_sax_parser_set_root_class_definition (GtkamlSAXParser* self, GtkamlRootClassDefinition* value) {
	GtkamlRootClassDefinition* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_root_class_definition = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_root_class_definition), _tmp0_);
}


static GObject * gtkaml_sax_parser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GtkamlSAXParser * self;
	parent_class = G_OBJECT_CLASS (gtkaml_sax_parser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTKAML_SAX_PARSER (obj);
	{
		GtkamlStateStack* _tmp0_;
		ValaHashMap* _tmp1_;
		gtkaml_sax_parser_set_states (self, _tmp0_ = gtkaml_state_stack_new ());
		_g_object_unref0 (_tmp0_);
		gtkaml_sax_parser_set_prefixes_namespaces (self, (ValaMap*) (_tmp1_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal)));
		_vala_collection_object_unref0 (_tmp1_);
		gtkaml_sax_parser_set_root_class_definition (self, NULL);
	}
	return obj;
}


static void gtkaml_sax_parser_class_init (GtkamlSAXParserClass * klass) {
	gtkaml_sax_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlSAXParserPrivate));
	GTKAML_SAX_PARSER_CLASS (klass)->parse = gtkaml_sax_parser_real_parse;
	G_OBJECT_CLASS (klass)->get_property = gtkaml_sax_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_sax_parser_set_property;
	G_OBJECT_CLASS (klass)->constructor = gtkaml_sax_parser_constructor;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_sax_parser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_SAX_PARSER_CONTEXT, vala_param_spec_code_context ("context", "context", "context", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_SAX_PARSER_SOURCE_FILE, vala_param_spec_source_file ("source-file", "source-file", "source-file", VALA_TYPE_SOURCE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gtkaml_sax_parser_instance_init (GtkamlSAXParser * self) {
	self->priv = GTKAML_SAX_PARSER_GET_PRIVATE (self);
	self->priv->generated_identifiers_counter = (ValaMap*) vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	self->gtkaml_prefix = g_strdup ("gtkaml");
}


static void gtkaml_sax_parser_finalize (GObject* obj) {
	GtkamlSAXParser * self;
	self = GTKAML_SAX_PARSER (obj);
	_vala_code_context_unref0 (self->priv->_context);
	_g_object_unref0 (self->priv->_states);
	_vala_collection_object_unref0 (self->priv->generated_identifiers_counter);
	_vala_collection_object_unref0 (self->priv->_prefixes_namespaces);
	_g_object_unref0 (self->priv->_root_class_definition);
	_g_free0 (self->gtkaml_prefix);
	G_OBJECT_CLASS (gtkaml_sax_parser_parent_class)->finalize (obj);
}


GType gtkaml_sax_parser_get_type (void) {
	static GType gtkaml_sax_parser_type_id = 0;
	if (gtkaml_sax_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlSAXParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_sax_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlSAXParser), 0, (GInstanceInitFunc) gtkaml_sax_parser_instance_init, NULL };
		gtkaml_sax_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlSAXParser", &g_define_type_info, 0);
	}
	return gtkaml_sax_parser_type_id;
}


static void gtkaml_sax_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlSAXParser * self;
	self = GTKAML_SAX_PARSER (object);
	switch (property_id) {
		case GTKAML_SAX_PARSER_CONTEXT:
		vala_value_set_code_context (value, gtkaml_sax_parser_get_context (self));
		break;
		case GTKAML_SAX_PARSER_SOURCE_FILE:
		vala_value_set_source_file (value, gtkaml_sax_parser_get_source_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_sax_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlSAXParser * self;
	self = GTKAML_SAX_PARSER (object);
	switch (property_id) {
		case GTKAML_SAX_PARSER_CONTEXT:
		gtkaml_sax_parser_set_context (self, vala_value_get_code_context (value));
		break;
		case GTKAML_SAX_PARSER_SOURCE_FILE:
		gtkaml_sax_parser_set_source_file (self, vala_value_get_source_file (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




