/* GtkamlCompiler.c generated by valac, the Vala compiler
 * generated from GtkamlCompiler.vala, do not modify */

/* valacompiler.vala
 * 
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * Adapted for Gtkaml:
 *	Vlad Grecescu <b100dian@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valacodegen.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define GTKAML_TYPE_COMPILER (gtkaml_compiler_get_type ())
#define GTKAML_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_COMPILER, GtkamlCompiler))
#define GTKAML_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_COMPILER, GtkamlCompilerClass))
#define GTKAML_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_COMPILER))
#define GTKAML_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_COMPILER))
#define GTKAML_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_COMPILER, GtkamlCompilerClass))

typedef struct _GtkamlCompiler GtkamlCompiler;
typedef struct _GtkamlCompilerClass GtkamlCompilerClass;
typedef struct _GtkamlCompilerPrivate GtkamlCompilerPrivate;

#define GTKAML_TYPE_CODE_CONTEXT (gtkaml_code_context_get_type ())
#define GTKAML_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CODE_CONTEXT, GtkamlCodeContext))
#define GTKAML_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CODE_CONTEXT, GtkamlCodeContextClass))
#define GTKAML_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CODE_CONTEXT))
#define GTKAML_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CODE_CONTEXT))
#define GTKAML_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CODE_CONTEXT, GtkamlCodeContextClass))

typedef struct _GtkamlCodeContext GtkamlCodeContext;
typedef struct _GtkamlCodeContextClass GtkamlCodeContextClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define GTKAML_TYPE_PARSER (gtkaml_parser_get_type ())
#define GTKAML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_PARSER, GtkamlParser))
#define GTKAML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_PARSER, GtkamlParserClass))
#define GTKAML_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_PARSER))
#define GTKAML_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_PARSER))
#define GTKAML_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_PARSER, GtkamlParserClass))

typedef struct _GtkamlParser GtkamlParser;
typedef struct _GtkamlParserClass GtkamlParserClass;
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _gtkaml_compiler_unref0(var) ((var == NULL) ? NULL : (var = (gtkaml_compiler_unref (var), NULL)))
typedef struct _GtkamlParamSpecCompiler GtkamlParamSpecCompiler;

struct _GtkamlCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkamlCompilerPrivate * priv;
};

struct _GtkamlCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (GtkamlCompiler *self);
};

struct _GtkamlCompilerPrivate {
	GtkamlCodeContext* context;
};

struct _GtkamlParamSpecCompiler {
	GParamSpec parent_instance;
};


static char* gtkaml_compiler_basedir;
static char* gtkaml_compiler_basedir = NULL;
static char* gtkaml_compiler_directory;
static char* gtkaml_compiler_directory = NULL;
static gboolean gtkaml_compiler_version;
static gboolean gtkaml_compiler_version = FALSE;
static char** gtkaml_compiler_sources;
static char** gtkaml_compiler_sources = NULL;
static char** gtkaml_compiler_vapi_directories;
static char** gtkaml_compiler_vapi_directories = NULL;
static char** gtkaml_compiler_gir_directories;
static char** gtkaml_compiler_gir_directories = NULL;
static char* gtkaml_compiler_vapi_filename;
static char* gtkaml_compiler_vapi_filename = NULL;
static char* gtkaml_compiler_library;
static char* gtkaml_compiler_library = NULL;
static char* gtkaml_compiler_gir;
static char* gtkaml_compiler_gir = NULL;
static char** gtkaml_compiler_packages;
static char** gtkaml_compiler_packages = NULL;
static char* gtkaml_compiler_target_glib;
static char* gtkaml_compiler_target_glib = NULL;
static char** gtkaml_compiler_implicits_directories;
static char** gtkaml_compiler_implicits_directories = NULL;
static gboolean gtkaml_compiler_ccode_only;
static gboolean gtkaml_compiler_ccode_only = FALSE;
static char* gtkaml_compiler_header_filename;
static char* gtkaml_compiler_header_filename = NULL;
static gboolean gtkaml_compiler_use_header;
static gboolean gtkaml_compiler_use_header = FALSE;
static char* gtkaml_compiler_internal_header_filename;
static char* gtkaml_compiler_internal_header_filename = NULL;
static char* gtkaml_compiler_internal_vapi_filename;
static char* gtkaml_compiler_internal_vapi_filename = NULL;
static char* gtkaml_compiler_includedir;
static char* gtkaml_compiler_includedir = NULL;
static gboolean gtkaml_compiler_compile_only;
static gboolean gtkaml_compiler_compile_only = FALSE;
static char* gtkaml_compiler_output;
static char* gtkaml_compiler_output = NULL;
static gboolean gtkaml_compiler_debug;
static gboolean gtkaml_compiler_debug = FALSE;
static gboolean gtkaml_compiler_thread;
static gboolean gtkaml_compiler_thread = FALSE;
static gboolean gtkaml_compiler_disable_assert;
static gboolean gtkaml_compiler_disable_assert = FALSE;
static gboolean gtkaml_compiler_enable_checking;
static gboolean gtkaml_compiler_enable_checking = FALSE;
static gboolean gtkaml_compiler_deprecated;
static gboolean gtkaml_compiler_deprecated = FALSE;
static gboolean gtkaml_compiler_experimental;
static gboolean gtkaml_compiler_experimental = FALSE;
static gboolean gtkaml_compiler_experimental_non_null;
static gboolean gtkaml_compiler_experimental_non_null = FALSE;
static gboolean gtkaml_compiler_disable_dbus_transformation;
static gboolean gtkaml_compiler_disable_dbus_transformation = FALSE;
static gboolean gtkaml_compiler_disable_warnings;
static gboolean gtkaml_compiler_disable_warnings = FALSE;
static char* gtkaml_compiler_cc_command;
static char* gtkaml_compiler_cc_command = NULL;
static char** gtkaml_compiler_cc_options;
static char** gtkaml_compiler_cc_options = NULL;
static char* gtkaml_compiler_dump_tree;
static char* gtkaml_compiler_dump_tree = NULL;
static gboolean gtkaml_compiler_save_temps;
static gboolean gtkaml_compiler_save_temps = FALSE;
static char** gtkaml_compiler_defines;
static char** gtkaml_compiler_defines = NULL;
static gboolean gtkaml_compiler_quiet_mode;
static gboolean gtkaml_compiler_quiet_mode = FALSE;
static gboolean gtkaml_compiler_verbose_mode;
static gboolean gtkaml_compiler_verbose_mode = FALSE;
static char* gtkaml_compiler_profile;
static char* gtkaml_compiler_profile = NULL;
static char* gtkaml_compiler_entry_point;
static char* gtkaml_compiler_entry_point = NULL;
static gpointer gtkaml_compiler_parent_class = NULL;

gpointer gtkaml_compiler_ref (gpointer instance);
void gtkaml_compiler_unref (gpointer instance);
GParamSpec* gtkaml_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gtkaml_value_set_compiler (GValue* value, gpointer v_object);
gpointer gtkaml_value_get_compiler (const GValue* value);
GType gtkaml_compiler_get_type (void);
GType gtkaml_code_context_get_type (void);
#define GTKAML_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_COMPILER, GtkamlCompilerPrivate))
enum  {
	GTKAML_COMPILER_DUMMY_PROPERTY
};
void gtkaml_code_context_remove_generated_files (GtkamlCodeContext* self);
static gint gtkaml_compiler_quit (GtkamlCompiler* self);
static gboolean gtkaml_compiler_add_gir (GtkamlCompiler* self, GtkamlCodeContext* context, const char* gir);
static gboolean gtkaml_compiler_add_package (GtkamlCompiler* self, GtkamlCodeContext* context, const char* pkg);
GtkamlCodeContext* gtkaml_code_context_new (void);
GtkamlCodeContext* gtkaml_code_context_construct (GType object_type);
static char* gtkaml_compiler_realpath (const char* name);
GtkamlParser* gtkaml_parser_new (void);
GtkamlParser* gtkaml_parser_construct (GType object_type);
GType gtkaml_parser_get_type (void);
void gtkaml_parser_parse (GtkamlParser* self, GtkamlCodeContext* context, char** implicits_directories, int implicits_directories_length1);
static gint gtkaml_compiler_run (GtkamlCompiler* self);
static gboolean gtkaml_compiler_ends_with_dir_separator (const char* s);
GtkamlCompiler* gtkaml_compiler_new (void);
GtkamlCompiler* gtkaml_compiler_construct (GType object_type);
static gint gtkaml_compiler_main (char** args, int args_length1);
static void gtkaml_compiler_finalize (GtkamlCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GOptionEntry GTKAML_COMPILER_options[] = {{"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &gtkaml_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &gtkaml_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &gtkaml_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &gtkaml_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &gtkaml_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_version, "Display version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &gtkaml_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &gtkaml_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &gtkaml_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_thread, "Enable multithreading support", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &gtkaml_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &gtkaml_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_disable_warnings, "Disable warnings", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"disable-dbus-transformation", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_disable_dbus_transformation, "Disable transformation of D-Bus member names", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &gtkaml_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &gtkaml_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &gtkaml_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkaml_compiler_save_temps, "Keep temporary files", NULL}, {"implicitsdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &gtkaml_compiler_implicits_directories, "Look for implicit add and creation methods and their parameters in DIRECTORY", "DIRECTORY..."}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &gtkaml_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &gtkaml_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &gtkaml_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &gtkaml_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &gtkaml_compiler_sources, NULL, "FILE..."}, {NULL}};


static gint gtkaml_compiler_quit (GtkamlCompiler* self) {
	gint result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	gtkaml_code_context_remove_generated_files (self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) == 0) {
		_tmp0_ = vala_report_get_warnings (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) == 0) {
		if (!gtkaml_compiler_quiet_mode) {
			fprintf (stdout, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)));
		}
		result = 0;
		return result;
	} else {
		if (!gtkaml_compiler_quiet_mode) {
			fprintf (stdout, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)), vala_report_get_warnings (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)));
		}
		result = 1;
		return result;
	}
}


static gboolean gtkaml_compiler_add_gir (GtkamlCompiler* self, GtkamlCodeContext* context, const char* gir) {
	gboolean result;
	char* gir_path;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (gir != NULL, FALSE);
	gir_path = vala_code_context_get_gir_path ((ValaCodeContext*) context, gir, gtkaml_compiler_gir_directories, _vala_array_length (gtkaml_compiler_gir_directories));
	if (gir_path == NULL) {
		result = FALSE;
		_g_free0 (gir_path);
		return result;
	}
	vala_code_context_add_source_file ((ValaCodeContext*) context, _tmp0_ = vala_source_file_new ((ValaCodeContext*) context, gir_path, TRUE, NULL));
	_vala_source_file_unref0 (_tmp0_);
	result = TRUE;
	_g_free0 (gir_path);
	return result;
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean gtkaml_compiler_add_package (GtkamlCompiler* self, GtkamlCodeContext* context, const char* pkg) {
	gboolean result;
	GError * _inner_error_;
	char* package_path;
	ValaSourceFile* _tmp0_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp3_;
	char* deps_filename;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_inner_error_ = NULL;
	if (vala_code_context_has_package ((ValaCodeContext*) context, pkg)) {
		result = TRUE;
		return result;
	}
	package_path = vala_code_context_get_package_path ((ValaCodeContext*) context, pkg, gtkaml_compiler_vapi_directories, _vala_array_length (gtkaml_compiler_vapi_directories));
	if (package_path == NULL) {
		result = FALSE;
		_g_free0 (package_path);
		return result;
	}
	vala_code_context_add_package ((ValaCodeContext*) context, pkg);
	vala_code_context_add_source_file ((ValaCodeContext*) context, _tmp0_ = vala_source_file_new ((ValaCodeContext*) context, package_path, TRUE, NULL));
	_vala_source_file_unref0 (_tmp0_);
	deps_filename = (_tmp3_ = g_build_filename (_tmp1_ = g_path_get_dirname (package_path), _tmp2_ = g_strdup_printf ("%s.deps", pkg), NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	if (g_file_test (deps_filename, G_FILE_TEST_EXISTS)) {
		{
			char* deps_content;
			gulong deps_len = 0UL;
			char* _tmp6_;
			gboolean _tmp5_;
			char* _tmp4_ = NULL;
			deps_content = NULL;
			_tmp5_ = g_file_get_contents (deps_filename, &_tmp4_, &deps_len, &_inner_error_);
			deps_content = (_tmp6_ = _tmp4_, _g_free0 (deps_content), _tmp6_);
			_tmp5_;
			if (_inner_error_ != NULL) {
				_g_free0 (deps_content);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				goto __finally0;
			}
			{
				char** _tmp7_;
				char** dep_collection;
				int dep_collection_length1;
				int dep_it;
				dep_collection = _tmp7_ = g_strsplit (deps_content, "\n", 0);
				dep_collection_length1 = _vala_array_length (_tmp7_);
				for (dep_it = 0; dep_it < _vala_array_length (_tmp7_); dep_it = dep_it + 1) {
					char* dep;
					dep = g_strdup (dep_collection[dep_it]);
					{
						char* _tmp8_;
						dep = (_tmp8_ = string_strip (dep), _g_free0 (dep), _tmp8_);
						if (_vala_strcmp0 (dep, "") != 0) {
							if (!gtkaml_compiler_add_package (self, context, dep)) {
								char* _tmp9_;
								vala_report_error (NULL, _tmp9_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", dep, pkg));
								_g_free0 (_tmp9_);
							}
						}
						_g_free0 (dep);
					}
				}
				dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (deps_content);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp10_;
				vala_report_error (NULL, _tmp10_ = g_strdup_printf ("Unable to read dependency file: %s", e->message));
				_g_free0 (_tmp10_);
				_g_error_free0 (e);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (package_path);
			_g_free0 (deps_filename);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (package_path);
	_g_free0 (deps_filename);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static gint gtkaml_compiler_run (GtkamlCompiler* self) {
	gint result;
	GtkamlCodeContext* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaCCodeGenerator* _tmp13_;
	char** _tmp27_;
	GtkamlParser* parser;
	ValaGenieParser* genie_parser;
	ValaGirParser* gir_parser;
	ValaSymbolResolver* resolver;
	ValaSemanticAnalyzer* analyzer;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	ValaFlowAnalyzer* flow_analyzer;
	gboolean _tmp31_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	self->priv->context = (_tmp0_ = gtkaml_code_context_new (), _vala_code_context_unref0 (self->priv->context), _tmp0_);
	vala_code_context_push ((ValaCodeContext*) self->priv->context);
	if (!gtkaml_compiler_ccode_only) {
		_tmp2_ = !gtkaml_compiler_compile_only;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = gtkaml_compiler_output == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (g_utf8_strrchr (gtkaml_compiler_sources[0], (gssize) (-1), (gunichar) '.') != NULL) {
			glong dot;
			char* _tmp4_;
			char* _tmp3_;
			dot = g_utf8_pointer_to_offset (gtkaml_compiler_sources[0], g_utf8_strrchr (gtkaml_compiler_sources[0], (gssize) (-1), (gunichar) '.'));
			gtkaml_compiler_output = (_tmp4_ = g_path_get_basename (_tmp3_ = string_substring (gtkaml_compiler_sources[0], (glong) 0, dot)), _g_free0 (gtkaml_compiler_output), _tmp4_);
			_g_free0 (_tmp3_);
		}
	}
	vala_code_context_set_assert ((ValaCodeContext*) self->priv->context, !gtkaml_compiler_disable_assert);
	vala_code_context_set_checking ((ValaCodeContext*) self->priv->context, gtkaml_compiler_enable_checking);
	vala_code_context_set_deprecated ((ValaCodeContext*) self->priv->context, gtkaml_compiler_deprecated);
	vala_code_context_set_experimental ((ValaCodeContext*) self->priv->context, gtkaml_compiler_experimental);
	if (gtkaml_compiler_experimental) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = gtkaml_compiler_experimental_non_null;
	}
	vala_code_context_set_experimental_non_null ((ValaCodeContext*) self->priv->context, _tmp5_);
	vala_code_context_set_dbus_transformation ((ValaCodeContext*) self->priv->context, !gtkaml_compiler_disable_dbus_transformation);
	vala_report_set_enable_warnings (vala_code_context_get_report ((ValaCodeContext*) self->priv->context), !gtkaml_compiler_disable_warnings);
	vala_report_set_verbose_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context), !gtkaml_compiler_quiet_mode);
	vala_code_context_set_verbose_mode ((ValaCodeContext*) self->priv->context, gtkaml_compiler_verbose_mode);
	vala_code_context_set_ccode_only ((ValaCodeContext*) self->priv->context, gtkaml_compiler_ccode_only);
	vala_code_context_set_compile_only ((ValaCodeContext*) self->priv->context, gtkaml_compiler_compile_only);
	vala_code_context_set_header_filename ((ValaCodeContext*) self->priv->context, gtkaml_compiler_header_filename);
	vala_code_context_set_use_header ((ValaCodeContext*) self->priv->context, gtkaml_compiler_use_header);
	vala_code_context_set_internal_header_filename ((ValaCodeContext*) self->priv->context, gtkaml_compiler_internal_header_filename);
	vala_code_context_set_includedir ((ValaCodeContext*) self->priv->context, gtkaml_compiler_includedir);
	vala_code_context_set_output ((ValaCodeContext*) self->priv->context, gtkaml_compiler_output);
	if (gtkaml_compiler_basedir == NULL) {
		char* _tmp6_;
		vala_code_context_set_basedir ((ValaCodeContext*) self->priv->context, _tmp6_ = gtkaml_compiler_realpath ("."));
		_g_free0 (_tmp6_);
	} else {
		char* _tmp7_;
		vala_code_context_set_basedir ((ValaCodeContext*) self->priv->context, _tmp7_ = gtkaml_compiler_realpath (gtkaml_compiler_basedir));
		_g_free0 (_tmp7_);
	}
	if (gtkaml_compiler_directory != NULL) {
		char* _tmp8_;
		vala_code_context_set_directory ((ValaCodeContext*) self->priv->context, _tmp8_ = gtkaml_compiler_realpath (gtkaml_compiler_directory));
		_g_free0 (_tmp8_);
	} else {
		vala_code_context_set_directory ((ValaCodeContext*) self->priv->context, vala_code_context_get_basedir ((ValaCodeContext*) self->priv->context));
	}
	vala_code_context_set_debug ((ValaCodeContext*) self->priv->context, gtkaml_compiler_debug);
	vala_code_context_set_thread ((ValaCodeContext*) self->priv->context, gtkaml_compiler_thread);
	vala_code_context_set_save_temps ((ValaCodeContext*) self->priv->context, gtkaml_compiler_save_temps);
	if (_vala_strcmp0 (gtkaml_compiler_profile, "posix") == 0) {
		vala_code_context_set_profile ((ValaCodeContext*) self->priv->context, VALA_PROFILE_POSIX);
		vala_code_context_add_define ((ValaCodeContext*) self->priv->context, "POSIX");
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (_vala_strcmp0 (gtkaml_compiler_profile, "gobject-2.0") == 0) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = _vala_strcmp0 (gtkaml_compiler_profile, "gobject") == 0;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = gtkaml_compiler_profile == NULL;
		}
		if (_tmp9_) {
			vala_code_context_set_profile ((ValaCodeContext*) self->priv->context, VALA_PROFILE_GOBJECT);
			vala_code_context_add_define ((ValaCodeContext*) self->priv->context, "GOBJECT");
			vala_code_context_add_define ((ValaCodeContext*) self->priv->context, "VALA_0_7_6_NEW_METHODS");
		} else {
			char* _tmp11_;
			vala_report_error (NULL, _tmp11_ = g_strdup_printf ("Unknown profile %s", gtkaml_compiler_profile));
			_g_free0 (_tmp11_);
		}
	}
	vala_code_context_set_entry_point_name ((ValaCodeContext*) self->priv->context, gtkaml_compiler_entry_point);
	if (gtkaml_compiler_defines != NULL) {
		{
			char** define_collection;
			int define_collection_length1;
			int define_it;
			define_collection = gtkaml_compiler_defines;
			define_collection_length1 = _vala_array_length (gtkaml_compiler_defines);
			for (define_it = 0; define_it < _vala_array_length (gtkaml_compiler_defines); define_it = define_it + 1) {
				char* define;
				define = g_strdup (define_collection[define_it]);
				{
					vala_code_context_add_define ((ValaCodeContext*) self->priv->context, define);
					_g_free0 (define);
				}
			}
		}
	}
	if (vala_code_context_get_profile ((ValaCodeContext*) self->priv->context) == VALA_PROFILE_POSIX) {
		if (!gtkaml_compiler_add_package (self, self->priv->context, "posix")) {
			vala_report_error (NULL, "posix not found in specified Vala API directories");
		}
	} else {
		if (vala_code_context_get_profile ((ValaCodeContext*) self->priv->context) == VALA_PROFILE_GOBJECT) {
			gint glib_major;
			gint glib_minor;
			gboolean _tmp12_ = FALSE;
			glib_major = 2;
			glib_minor = 12;
			if (gtkaml_compiler_target_glib != NULL) {
				_tmp12_ = sscanf (gtkaml_compiler_target_glib, "%d.%d", &glib_major, &glib_minor) != 2;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				vala_report_error (NULL, "Invalid format for --target-glib");
			}
			vala_code_context_set_target_glib_major ((ValaCodeContext*) self->priv->context, glib_major);
			vala_code_context_set_target_glib_minor ((ValaCodeContext*) self->priv->context, glib_minor);
			if (vala_code_context_get_target_glib_major ((ValaCodeContext*) self->priv->context) != 2) {
				vala_report_error (NULL, "This version of valac only supports GLib 2");
			}
			if (!gtkaml_compiler_add_package (self, self->priv->context, "glib-2.0")) {
				vala_report_error (NULL, "glib-2.0 not found in specified Vala API directories");
			}
			if (!gtkaml_compiler_add_package (self, self->priv->context, "gobject-2.0")) {
				vala_report_error (NULL, "gobject-2.0 not found in specified Vala API directories");
			}
		}
	}
	vala_code_context_set_codegen ((ValaCodeContext*) self->priv->context, (ValaCodeGenerator*) (_tmp13_ = vala_ccode_generator_new ()));
	_vala_code_visitor_unref0 (_tmp13_);
	if (gtkaml_compiler_packages != NULL) {
		char** _tmp16_;
		{
			char** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = gtkaml_compiler_packages;
			package_collection_length1 = _vala_array_length (gtkaml_compiler_packages);
			for (package_it = 0; package_it < _vala_array_length (gtkaml_compiler_packages); package_it = package_it + 1) {
				char* package;
				package = g_strdup (package_collection[package_it]);
				{
					gboolean _tmp14_ = FALSE;
					if (!gtkaml_compiler_add_package (self, self->priv->context, package)) {
						_tmp14_ = !gtkaml_compiler_add_gir (self, self->priv->context, package);
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						char* _tmp15_;
						vala_report_error (NULL, _tmp15_ = g_strdup_printf ("%s not found in specified Vala API directories or GObject-Introspection GIR directories", package));
						_g_free0 (_tmp15_);
					}
					_g_free0 (package);
				}
			}
		}
		gtkaml_compiler_packages = (_tmp16_ = NULL, gtkaml_compiler_packages = (_vala_array_free (gtkaml_compiler_packages, _vala_array_length (gtkaml_compiler_packages), (GDestroyNotify) g_free), NULL), _tmp16_);
	}
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) > 0) {
		result = gtkaml_compiler_quit (self);
		return result;
	}
	{
		char** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = gtkaml_compiler_sources;
		source_collection_length1 = _vala_array_length (gtkaml_compiler_sources);
		for (source_it = 0; source_it < _vala_array_length (gtkaml_compiler_sources); source_it = source_it + 1) {
			char* source;
			source = g_strdup (source_collection[source_it]);
			{
				if (g_file_test (source, G_FILE_TEST_EXISTS)) {
					char* rpath;
					gboolean _tmp17_ = FALSE;
					rpath = gtkaml_compiler_realpath (source);
					if (g_str_has_suffix (source, ".vala")) {
						_tmp17_ = TRUE;
					} else {
						_tmp17_ = g_str_has_suffix (source, ".gs");
					}
					if (_tmp17_) {
						ValaSourceFile* source_file;
						source_file = vala_source_file_new ((ValaCodeContext*) self->priv->context, rpath, FALSE, NULL);
						if (vala_code_context_get_profile ((ValaCodeContext*) self->priv->context) == VALA_PROFILE_POSIX) {
							ValaUnresolvedSymbol* _tmp18_;
							ValaUsingDirective* _tmp19_;
							ValaUsingDirective* ns_ref;
							ns_ref = (_tmp19_ = vala_using_directive_new ((ValaSymbol*) (_tmp18_ = vala_unresolved_symbol_new (NULL, "Posix", NULL)), NULL), _vala_code_node_unref0 (_tmp18_), _tmp19_);
							vala_source_file_add_using_directive (source_file, ns_ref);
							vala_namespace_add_using_directive (vala_code_context_get_root ((ValaCodeContext*) self->priv->context), ns_ref);
							_vala_code_node_unref0 (ns_ref);
						} else {
							if (vala_code_context_get_profile ((ValaCodeContext*) self->priv->context) == VALA_PROFILE_GOBJECT) {
								ValaUnresolvedSymbol* _tmp20_;
								ValaUsingDirective* _tmp21_;
								ValaUsingDirective* ns_ref;
								ns_ref = (_tmp21_ = vala_using_directive_new ((ValaSymbol*) (_tmp20_ = vala_unresolved_symbol_new (NULL, "GLib", NULL)), NULL), _vala_code_node_unref0 (_tmp20_), _tmp21_);
								vala_source_file_add_using_directive (source_file, ns_ref);
								vala_namespace_add_using_directive (vala_code_context_get_root ((ValaCodeContext*) self->priv->context), ns_ref);
								_vala_code_node_unref0 (ns_ref);
							}
						}
						vala_code_context_add_source_file ((ValaCodeContext*) self->priv->context, source_file);
						_vala_source_file_unref0 (source_file);
					} else {
						gboolean _tmp22_ = FALSE;
						if (g_str_has_suffix (source, ".vapi")) {
							_tmp22_ = TRUE;
						} else {
							_tmp22_ = g_str_has_suffix (source, ".gir");
						}
						if (_tmp22_) {
							ValaSourceFile* _tmp23_;
							vala_code_context_add_source_file ((ValaCodeContext*) self->priv->context, _tmp23_ = vala_source_file_new ((ValaCodeContext*) self->priv->context, rpath, TRUE, NULL));
							_vala_source_file_unref0 (_tmp23_);
						} else {
							if (g_str_has_suffix (source, ".gtkaml")) {
								ValaSourceFile* _tmp24_;
								vala_code_context_add_source_file ((ValaCodeContext*) self->priv->context, _tmp24_ = vala_source_file_new ((ValaCodeContext*) self->priv->context, rpath, FALSE, NULL));
								_vala_source_file_unref0 (_tmp24_);
							} else {
								if (g_str_has_suffix (source, ".c")) {
									vala_code_context_add_c_source_file ((ValaCodeContext*) self->priv->context, rpath);
								} else {
									char* _tmp25_;
									vala_report_error (NULL, _tmp25_ = g_strdup_printf ("%s is not a supported source file type. Only .vala, .vapi, .gs, and .c files are supported.", source));
									_g_free0 (_tmp25_);
								}
							}
						}
					}
					_g_free0 (rpath);
				} else {
					char* _tmp26_;
					vala_report_error (NULL, _tmp26_ = g_strdup_printf ("%s not found", source));
					_g_free0 (_tmp26_);
				}
				_g_free0 (source);
			}
		}
	}
	gtkaml_compiler_sources = (_tmp27_ = NULL, gtkaml_compiler_sources = (_vala_array_free (gtkaml_compiler_sources, _vala_array_length (gtkaml_compiler_sources), (GDestroyNotify) g_free), NULL), _tmp27_);
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) > 0) {
		result = gtkaml_compiler_quit (self);
		return result;
	}
	parser = gtkaml_parser_new ();
	gtkaml_parser_parse (parser, self->priv->context, gtkaml_compiler_implicits_directories, _vala_array_length (gtkaml_compiler_implicits_directories));
	genie_parser = vala_genie_parser_new ();
	vala_genie_parser_parse (genie_parser, (ValaCodeContext*) self->priv->context);
	gir_parser = vala_gir_parser_new ();
	vala_gir_parser_parse (gir_parser, (ValaCodeContext*) self->priv->context);
	if (vala_gir_parser_get_package_names != NULL) {
		{
			gint _tmp28_;
			char** pkg_collection;
			int pkg_collection_length1;
			int pkg_it;
			pkg_collection = vala_gir_parser_get_package_names (gir_parser, &_tmp28_);
			pkg_collection_length1 = _tmp28_;
			for (pkg_it = 0; pkg_it < _tmp28_; pkg_it = pkg_it + 1) {
				char* pkg;
				pkg = g_strdup (pkg_collection[pkg_it]);
				{
					vala_code_context_add_package ((ValaCodeContext*) self->priv->context, pkg);
					_g_free0 (pkg);
				}
			}
			pkg_collection = (_vala_array_free (pkg_collection, pkg_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) > 0) {
		result = gtkaml_compiler_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (gir_parser);
		return result;
	}
	resolver = vala_symbol_resolver_new ();
	vala_symbol_resolver_resolve (resolver, (ValaCodeContext*) self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) > 0) {
		result = gtkaml_compiler_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (resolver);
		return result;
	}
	analyzer = vala_semantic_analyzer_new ();
	vala_semantic_analyzer_analyze (analyzer, (ValaCodeContext*) self->priv->context);
	if (!gtkaml_compiler_ccode_only) {
		_tmp30_ = !gtkaml_compiler_compile_only;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		_tmp29_ = gtkaml_compiler_library == NULL;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		if (vala_code_context_get_entry_point ((ValaCodeContext*) self->priv->context) == NULL) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	if (gtkaml_compiler_dump_tree != NULL) {
		ValaCodeWriter* code_writer;
		code_writer = vala_code_writer_new (TRUE, FALSE);
		vala_code_writer_write_file (code_writer, (ValaCodeContext*) self->priv->context, gtkaml_compiler_dump_tree);
		_vala_code_visitor_unref0 (code_writer);
	}
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) > 0) {
		result = gtkaml_compiler_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (analyzer);
		return result;
	}
	flow_analyzer = vala_flow_analyzer_new ();
	vala_flow_analyzer_analyze (flow_analyzer, (ValaCodeContext*) self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) > 0) {
		result = gtkaml_compiler_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (analyzer);
		_vala_code_visitor_unref0 (flow_analyzer);
		return result;
	}
	vala_code_generator_emit (vala_code_context_get_codegen ((ValaCodeContext*) self->priv->context), (ValaCodeContext*) self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report ((ValaCodeContext*) self->priv->context)) > 0) {
		result = gtkaml_compiler_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (analyzer);
		_vala_code_visitor_unref0 (flow_analyzer);
		return result;
	}
	if (gtkaml_compiler_vapi_filename == NULL) {
		_tmp31_ = gtkaml_compiler_library != NULL;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		char* _tmp32_;
		gtkaml_compiler_vapi_filename = (_tmp32_ = g_strdup_printf ("%s.vapi", gtkaml_compiler_library), _g_free0 (gtkaml_compiler_vapi_filename), _tmp32_);
	}
	if (gtkaml_compiler_vapi_filename != NULL) {
		ValaCodeWriter* interface_writer;
		gboolean _tmp33_ = FALSE;
		interface_writer = vala_code_writer_new (FALSE, FALSE);
		if (gtkaml_compiler_directory != NULL) {
			_tmp33_ = !g_path_is_absolute (gtkaml_compiler_vapi_filename);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			char* _tmp34_;
			gtkaml_compiler_vapi_filename = (_tmp34_ = g_strdup_printf ("%s%c%s", vala_code_context_get_directory ((ValaCodeContext*) self->priv->context), (gint) G_DIR_SEPARATOR, gtkaml_compiler_vapi_filename), _g_free0 (gtkaml_compiler_vapi_filename), _tmp34_);
		}
		vala_code_writer_write_file (interface_writer, (ValaCodeContext*) self->priv->context, gtkaml_compiler_vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	if (gtkaml_compiler_library != NULL) {
		char* _tmp43_;
		if (gtkaml_compiler_gir != NULL) {
			char* _tmp42_;
			if (vala_code_context_get_profile ((ValaCodeContext*) self->priv->context) == VALA_PROFILE_GOBJECT) {
				glong gir_len;
				const char* last_hyphen;
				gboolean _tmp35_ = FALSE;
				gir_len = g_utf8_strlen (gtkaml_compiler_gir, -1);
				last_hyphen = g_utf8_strrchr (gtkaml_compiler_gir, (gssize) gir_len, (gunichar) '-');
				if (last_hyphen == NULL) {
					_tmp35_ = TRUE;
				} else {
					_tmp35_ = !g_str_has_suffix (gtkaml_compiler_gir, ".gir");
				}
				if (_tmp35_) {
					char* _tmp36_;
					vala_report_error (NULL, _tmp36_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", gtkaml_compiler_gir));
					_g_free0 (_tmp36_);
				} else {
					glong offset;
					char* gir_namespace;
					char* gir_version;
					gboolean _tmp37_ = FALSE;
					gboolean _tmp38_ = FALSE;
					gboolean _tmp39_ = FALSE;
					offset = g_utf8_pointer_to_offset (gtkaml_compiler_gir, last_hyphen);
					gir_namespace = string_substring (gtkaml_compiler_gir, (glong) 0, offset);
					gir_version = string_substring (gtkaml_compiler_gir, offset + 1, (gir_len - offset) - 5);
					g_strcanon (gir_version, "0123456789.", '?');
					if (_vala_strcmp0 (gir_namespace, "") == 0) {
						_tmp39_ = TRUE;
					} else {
						_tmp39_ = _vala_strcmp0 (gir_version, "") == 0;
					}
					if (_tmp39_) {
						_tmp38_ = TRUE;
					} else {
						_tmp38_ = !g_unichar_isdigit (g_utf8_get_char (g_utf8_offset_to_pointer (gir_version, 0)));
					}
					if (_tmp38_) {
						_tmp37_ = TRUE;
					} else {
						_tmp37_ = string_contains (gir_version, "?");
					}
					if (_tmp37_) {
						char* _tmp40_;
						vala_report_error (NULL, _tmp40_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", gtkaml_compiler_gir));
						_g_free0 (_tmp40_);
					} else {
						ValaGIRWriter* gir_writer;
						char* gir_directory;
						gir_writer = vala_gir_writer_new ();
						gir_directory = g_strdup (".");
						if (gtkaml_compiler_directory != NULL) {
							char* _tmp41_;
							gir_directory = (_tmp41_ = g_strdup (vala_code_context_get_directory ((ValaCodeContext*) self->priv->context)), _g_free0 (gir_directory), _tmp41_);
						}
						vala_gir_writer_write_file (gir_writer, (ValaCodeContext*) self->priv->context, gir_directory, gir_namespace, gir_version, gtkaml_compiler_library);
						_vala_code_visitor_unref0 (gir_writer);
						_g_free0 (gir_directory);
					}
					_g_free0 (gir_namespace);
					_g_free0 (gir_version);
				}
			}
			gtkaml_compiler_gir = (_tmp42_ = NULL, _g_free0 (gtkaml_compiler_gir), _tmp42_);
		}
		gtkaml_compiler_library = (_tmp43_ = NULL, _g_free0 (gtkaml_compiler_library), _tmp43_);
	}
	if (gtkaml_compiler_internal_vapi_filename != NULL) {
		gboolean _tmp44_ = FALSE;
		ValaCodeWriter* interface_writer;
		char* vapi_filename;
		gboolean _tmp45_ = FALSE;
		char* _tmp47_;
		if (gtkaml_compiler_internal_header_filename == NULL) {
			_tmp44_ = TRUE;
		} else {
			_tmp44_ = gtkaml_compiler_header_filename == NULL;
		}
		if (_tmp44_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --internal-header");
			result = gtkaml_compiler_quit (self);
			_vala_code_visitor_unref0 (parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (resolver);
			_vala_code_visitor_unref0 (analyzer);
			_vala_code_visitor_unref0 (flow_analyzer);
			return result;
		}
		interface_writer = vala_code_writer_new (FALSE, TRUE);
		vala_code_writer_set_cheader_override (interface_writer, gtkaml_compiler_header_filename, gtkaml_compiler_internal_header_filename);
		vapi_filename = g_strdup (gtkaml_compiler_internal_vapi_filename);
		if (gtkaml_compiler_directory != NULL) {
			_tmp45_ = !g_path_is_absolute (vapi_filename);
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			char* _tmp46_;
			vapi_filename = (_tmp46_ = g_strdup_printf ("%s%c%s", vala_code_context_get_directory ((ValaCodeContext*) self->priv->context), (gint) G_DIR_SEPARATOR, vapi_filename), _g_free0 (vapi_filename), _tmp46_);
		}
		vala_code_writer_write_file (interface_writer, (ValaCodeContext*) self->priv->context, vapi_filename);
		gtkaml_compiler_internal_vapi_filename = (_tmp47_ = NULL, _g_free0 (gtkaml_compiler_internal_vapi_filename), _tmp47_);
		_vala_code_visitor_unref0 (interface_writer);
		_g_free0 (vapi_filename);
	}
	if (!gtkaml_compiler_ccode_only) {
		ValaCCodeCompiler* ccompiler;
		gboolean _tmp48_ = FALSE;
		ccompiler = vala_ccode_compiler_new ();
		if (gtkaml_compiler_cc_command == NULL) {
			_tmp48_ = g_getenv ("CC") != NULL;
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			char* _tmp49_;
			gtkaml_compiler_cc_command = (_tmp49_ = g_strdup (g_getenv ("CC")), _g_free0 (gtkaml_compiler_cc_command), _tmp49_);
		}
		if (gtkaml_compiler_cc_options == NULL) {
			gint _tmp51__length1;
			char** _tmp51_;
			char** _tmp50_ = NULL;
			vala_ccode_compiler_compile (ccompiler, (ValaCodeContext*) self->priv->context, gtkaml_compiler_cc_command, (_tmp51_ = (_tmp50_ = g_new0 (char*, 0 + 1), _tmp50_), _tmp51__length1 = 0, _tmp51_), 0);
			_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
		} else {
			vala_ccode_compiler_compile (ccompiler, (ValaCodeContext*) self->priv->context, gtkaml_compiler_cc_command, gtkaml_compiler_cc_options, _vala_array_length (gtkaml_compiler_cc_options));
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = gtkaml_compiler_quit (self);
	_vala_code_visitor_unref0 (parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (resolver);
	_vala_code_visitor_unref0 (analyzer);
	_vala_code_visitor_unref0 (flow_analyzer);
	return result;
}


static gboolean gtkaml_compiler_ends_with_dir_separator (const char* s) {
	gboolean result;
	g_return_val_if_fail (s != NULL, FALSE);
	result = G_IS_DIR_SEPARATOR (g_utf8_get_char (g_utf8_offset_to_pointer (s, g_utf8_strlen (s, -1) - 1)));
	return result;
}


static char* gtkaml_compiler_realpath (const char* name) {
	char* result;
	char* rpath;
	const char* start;
	const char* end;
	glong root_len;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	rpath = NULL;
	start = NULL;
	end = NULL;
	if (!g_path_is_absolute (name)) {
		char* _tmp0_;
		rpath = (_tmp0_ = g_get_current_dir (), _g_free0 (rpath), _tmp0_);
		start = end = name;
	} else {
		char* _tmp1_;
		start = end = g_path_skip_root (name);
		rpath = (_tmp1_ = string_substring (name, (glong) 0, g_utf8_pointer_to_offset (name, start)), _g_free0 (rpath), _tmp1_);
	}
	root_len = g_utf8_pointer_to_offset (rpath, g_path_skip_root (rpath));
	{
		gboolean _tmp2_;
		_tmp2_ = TRUE;
		while (TRUE) {
			glong len;
			if (!_tmp2_) {
				start = end;
			}
			_tmp2_ = FALSE;
			if (!(g_utf8_get_char (start) != 0)) {
				break;
			}
			while (TRUE) {
				if (!G_IS_DIR_SEPARATOR (g_utf8_get_char (start))) {
					break;
				}
				start = g_utf8_next_char (start);
			}
			len = (glong) 0;
			{
				gboolean _tmp3_;
				end = start;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_ = FALSE;
					if (!_tmp3_) {
						end = g_utf8_next_char (end);
					}
					_tmp3_ = FALSE;
					if (g_utf8_get_char (end) != 0) {
						_tmp4_ = !G_IS_DIR_SEPARATOR (g_utf8_get_char (end));
					} else {
						_tmp4_ = FALSE;
					}
					if (!_tmp4_) {
						break;
					}
					len++;
				}
			}
			if (len == 0) {
				break;
			} else {
				gboolean _tmp5_ = FALSE;
				if (len == 1) {
					_tmp5_ = g_utf8_get_char (start) == '.';
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
				} else {
					gboolean _tmp6_ = FALSE;
					if (len == 2) {
						_tmp6_ = g_str_has_prefix (start, "..");
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						if (g_utf8_strlen (rpath, -1) > root_len) {
							{
								gboolean _tmp7_;
								_tmp7_ = TRUE;
								while (TRUE) {
									char* _tmp8_;
									if (!_tmp7_) {
										if (!(!gtkaml_compiler_ends_with_dir_separator (rpath))) {
											break;
										}
									}
									_tmp7_ = FALSE;
									rpath = (_tmp8_ = string_substring (rpath, (glong) 0, g_utf8_strlen (rpath, -1) - 1), _g_free0 (rpath), _tmp8_);
								}
							}
						}
					} else {
						char* _tmp11_;
						char* _tmp10_;
						if (!gtkaml_compiler_ends_with_dir_separator (rpath)) {
							char* _tmp9_;
							rpath = (_tmp9_ = g_strconcat (rpath, G_DIR_SEPARATOR_S, NULL), _g_free0 (rpath), _tmp9_);
						}
						rpath = (_tmp11_ = g_strconcat (rpath, _tmp10_ = string_substring (start, (glong) 0, len), NULL), _g_free0 (rpath), _tmp11_);
						_g_free0 (_tmp10_);
					}
				}
			}
		}
	}
	if (g_utf8_strlen (rpath, -1) > root_len) {
		_tmp12_ = gtkaml_compiler_ends_with_dir_separator (rpath);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		char* _tmp13_;
		rpath = (_tmp13_ = string_substring (rpath, (glong) 0, g_utf8_strlen (rpath, -1) - 1), _g_free0 (rpath), _tmp13_);
	}
	if (G_DIR_SEPARATOR != '/') {
		char** _tmp15_;
		gint components_size;
		gint components_length1;
		char** _tmp14_;
		char** components;
		char* _tmp16_;
		components = (_tmp15_ = _tmp14_ = g_strsplit (rpath, "\\", 0), components_length1 = _vala_array_length (_tmp14_), components_size = components_length1, _tmp15_);
		rpath = (_tmp16_ = g_strjoinv ("/", components), _g_free0 (rpath), _tmp16_);
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}


static gint gtkaml_compiler_main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	GtkamlCompiler* compiler;
	_inner_error_ = NULL;
	{
		GOptionContext* opt_context;
		opt_context = g_option_context_new ("- Vala Gtkaml Compiler");
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, GTKAML_COMPILER_options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			goto __finally1;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (gtkaml_compiler_version) {
		fprintf (stdout, "Gtkaml %s (based on Vala 0.7.8)\n", PACKAGE_VERSION);
		result = 0;
		return result;
	}
	if (gtkaml_compiler_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	compiler = gtkaml_compiler_new ();
	result = gtkaml_compiler_run (compiler);
	_gtkaml_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gtkaml_compiler_main (argv, argc);
}


GtkamlCompiler* gtkaml_compiler_construct (GType object_type) {
	GtkamlCompiler* self;
	self = (GtkamlCompiler*) g_type_create_instance (object_type);
	return self;
}


GtkamlCompiler* gtkaml_compiler_new (void) {
	return gtkaml_compiler_construct (GTKAML_TYPE_COMPILER);
}


static void gtkaml_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gtkaml_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gtkaml_compiler_unref (value->data[0].v_pointer);
	}
}


static void gtkaml_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkaml_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gtkaml_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gtkaml_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GtkamlCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkaml_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gtkaml_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GtkamlCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkaml_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gtkaml_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GtkamlParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKAML_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gtkaml_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKAML_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void gtkaml_value_set_compiler (GValue* value, gpointer v_object) {
	GtkamlCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKAML_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKAML_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkaml_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkaml_compiler_unref (old);
	}
}


static void gtkaml_compiler_class_init (GtkamlCompilerClass * klass) {
	gtkaml_compiler_parent_class = g_type_class_peek_parent (klass);
	GTKAML_COMPILER_CLASS (klass)->finalize = gtkaml_compiler_finalize;
	g_type_class_add_private (klass, sizeof (GtkamlCompilerPrivate));
}


static void gtkaml_compiler_instance_init (GtkamlCompiler * self) {
	self->priv = GTKAML_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gtkaml_compiler_finalize (GtkamlCompiler* obj) {
	GtkamlCompiler * self;
	self = GTKAML_COMPILER (obj);
	_vala_code_context_unref0 (self->priv->context);
}


GType gtkaml_compiler_get_type (void) {
	static GType gtkaml_compiler_type_id = 0;
	if (gtkaml_compiler_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { gtkaml_value_compiler_init, gtkaml_value_compiler_free_value, gtkaml_value_compiler_copy_value, gtkaml_value_compiler_peek_pointer, "p", gtkaml_value_compiler_collect_value, "p", gtkaml_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlCompiler), 0, (GInstanceInitFunc) gtkaml_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		gtkaml_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkamlCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return gtkaml_compiler_type_id;
}


gpointer gtkaml_compiler_ref (gpointer instance) {
	GtkamlCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gtkaml_compiler_unref (gpointer instance) {
	GtkamlCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKAML_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




