/* GtkamlCodeGenerator.c generated by valac, the Vala compiler
 * generated from GtkamlCodeGenerator.vala, do not modify */

/* GtkamlCodeGenerator.vala
 *
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>


#define GTKAML_TYPE_CODE_GENERATOR (gtkaml_code_generator_get_type ())
#define GTKAML_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGenerator))
#define GTKAML_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorClass))
#define GTKAML_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CODE_GENERATOR))
#define GTKAML_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CODE_GENERATOR))
#define GTKAML_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorClass))

typedef struct _GtkamlCodeGenerator GtkamlCodeGenerator;
typedef struct _GtkamlCodeGeneratorClass GtkamlCodeGeneratorClass;
typedef struct _GtkamlCodeGeneratorPrivate GtkamlCodeGeneratorPrivate;

#define GTKAML_TYPE_CODE_CONTEXT (gtkaml_code_context_get_type ())
#define GTKAML_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CODE_CONTEXT, GtkamlCodeContext))
#define GTKAML_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CODE_CONTEXT, GtkamlCodeContextClass))
#define GTKAML_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CODE_CONTEXT))
#define GTKAML_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CODE_CONTEXT))
#define GTKAML_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CODE_CONTEXT, GtkamlCodeContextClass))

typedef struct _GtkamlCodeContext GtkamlCodeContext;
typedef struct _GtkamlCodeContextClass GtkamlCodeContextClass;

#define GTKAML_TYPE_CLASS_DEFINITION (gtkaml_class_definition_get_type ())
#define GTKAML_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinition))
#define GTKAML_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))
#define GTKAML_IS_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_IS_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CLASS_DEFINITION))
#define GTKAML_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CLASS_DEFINITION, GtkamlClassDefinitionClass))

typedef struct _GtkamlClassDefinition GtkamlClassDefinition;
typedef struct _GtkamlClassDefinitionClass GtkamlClassDefinitionClass;

#define GTKAML_TYPE_ROOT_CLASS_DEFINITION (gtkaml_root_class_definition_get_type ())
#define GTKAML_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinition))
#define GTKAML_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))
#define GTKAML_IS_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_IS_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_ROOT_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))

typedef struct _GtkamlRootClassDefinition GtkamlRootClassDefinition;
typedef struct _GtkamlRootClassDefinitionClass GtkamlRootClassDefinitionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define GTKAML_TYPE_REFERENCE_CLASS_DEFINITION (gtkaml_reference_class_definition_get_type ())
#define GTKAML_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinition))
#define GTKAML_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_IS_REFERENCE_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION))
#define GTKAML_REFERENCE_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionClass))

typedef struct _GtkamlReferenceClassDefinition GtkamlReferenceClassDefinition;
typedef struct _GtkamlReferenceClassDefinitionClass GtkamlReferenceClassDefinitionClass;

#define GTKAML_TYPE_ATTRIBUTE (gtkaml_attribute_get_type ())
#define GTKAML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttribute))
#define GTKAML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))
#define GTKAML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))

typedef struct _GtkamlAttribute GtkamlAttribute;
typedef struct _GtkamlAttributeClass GtkamlAttributeClass;

#define GTKAML_TYPE_COMPLEX_ATTRIBUTE (gtkaml_complex_attribute_get_type ())
#define GTKAML_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttribute))
#define GTKAML_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))
#define GTKAML_IS_COMPLEX_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_IS_COMPLEX_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_COMPLEX_ATTRIBUTE))
#define GTKAML_COMPLEX_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_COMPLEX_ATTRIBUTE, GtkamlComplexAttributeClass))

typedef struct _GtkamlComplexAttribute GtkamlComplexAttribute;
typedef struct _GtkamlComplexAttributeClass GtkamlComplexAttributeClass;

#define GTKAML_TYPE_METHOD (gtkaml_method_get_type ())
#define GTKAML_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_METHOD, GtkamlMethod))
#define GTKAML_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_METHOD, GtkamlMethodClass))
#define GTKAML_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_METHOD))
#define GTKAML_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_METHOD))
#define GTKAML_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_METHOD, GtkamlMethodClass))

typedef struct _GtkamlMethod GtkamlMethod;
typedef struct _GtkamlMethodClass GtkamlMethodClass;

#define GTKAML_TYPE_CONSTRUCT_METHOD (gtkaml_construct_method_get_type ())
#define GTKAML_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethod))
#define GTKAML_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))
#define GTKAML_IS_CONSTRUCT_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_IS_CONSTRUCT_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_CONSTRUCT_METHOD))
#define GTKAML_CONSTRUCT_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_CONSTRUCT_METHOD, GtkamlConstructMethodClass))

typedef struct _GtkamlConstructMethod GtkamlConstructMethod;
typedef struct _GtkamlConstructMethodClass GtkamlConstructMethodClass;

#define GTKAML_TYPE_ADD_METHOD (gtkaml_add_method_get_type ())
#define GTKAML_ADD_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethod))
#define GTKAML_ADD_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethodClass))
#define GTKAML_IS_ADD_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ADD_METHOD))
#define GTKAML_IS_ADD_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ADD_METHOD))
#define GTKAML_ADD_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ADD_METHOD, GtkamlAddMethodClass))

typedef struct _GtkamlAddMethod GtkamlAddMethod;
typedef struct _GtkamlAddMethodClass GtkamlAddMethodClass;

#define TYPE_DEFINITION_SCOPE (definition_scope_get_type ())
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define GTKAML_TYPE_SIMPLE_ATTRIBUTE (gtkaml_simple_attribute_get_type ())
#define GTKAML_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttribute))
#define GTKAML_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))
#define GTKAML_IS_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_IS_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_SIMPLE_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))

typedef struct _GtkamlSimpleAttribute GtkamlSimpleAttribute;
typedef struct _GtkamlSimpleAttributeClass GtkamlSimpleAttributeClass;

struct _GtkamlCodeGenerator {
	GObject parent_instance;
	GtkamlCodeGeneratorPrivate * priv;
};

struct _GtkamlCodeGeneratorClass {
	GObjectClass parent_class;
};

struct _GtkamlCodeGeneratorPrivate {
	char* using_directives;
	char* class_start;
	char* members_declarations;
	char* code;
	char* construct_signals;
	char* constructors;
	char* construct_body_locals;
	char* construct_body;
	char* class_end;
	GtkamlCodeContext* _context;
	GtkamlRootClassDefinition* _root_class_definition;
};

typedef enum  {
	DEFINITION_SCOPE_MAIN_CLASS = 0,
	DEFINITION_SCOPE_PUBLIC,
	DEFINITION_SCOPE_PRIVATE,
	DEFINITION_SCOPE_CONSTRUCTOR
} DefinitionScope;


static gpointer gtkaml_code_generator_parent_class = NULL;

GType gtkaml_code_generator_get_type (void);
GType gtkaml_code_context_get_type (void);
GType gtkaml_class_definition_get_type (void);
GType gtkaml_root_class_definition_get_type (void);
#define GTKAML_CODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_CODE_GENERATOR, GtkamlCodeGeneratorPrivate))
enum  {
	GTKAML_CODE_GENERATOR_DUMMY_PROPERTY,
	GTKAML_CODE_GENERATOR_CONTEXT
};
static void gtkaml_code_generator_set_context (GtkamlCodeGenerator* self, GtkamlCodeContext* value);
GtkamlCodeGenerator* gtkaml_code_generator_new (GtkamlCodeContext* context);
GtkamlCodeGenerator* gtkaml_code_generator_construct (GType object_type, GtkamlCodeContext* context);
static gint gtkaml_code_generator_line_count (GtkamlCodeGenerator* self, const char* s);
static GtkamlRootClassDefinition* gtkaml_code_generator_get_root_class_definition (GtkamlCodeGenerator* self);
gint gtkaml_root_class_definition_get_original_first_code_line (GtkamlRootClassDefinition* self);
char* gtkaml_code_generator_yield (GtkamlCodeGenerator* self);
static void gtkaml_code_generator_set_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* value);
ValaMap* gtkaml_root_class_definition_get_prefixes_namespaces (GtkamlRootClassDefinition* self);
void gtkaml_code_generator_write_using (GtkamlCodeGenerator* self, const char* ns);
char* gtkaml_code_generator_prefix_to_namespace (GtkamlCodeGenerator* self, const char* prefix);
void gtkaml_code_generator_write_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* root_class_definition);
void gtkaml_code_generator_write_preconstruct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_root_constructor_parameters (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* class_definition);
void gtkaml_code_generator_write_complex_attributes (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_setters (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_generate_children (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_construct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
GType gtkaml_reference_class_definition_get_type (void);
void gtkaml_code_generator_write_add (GtkamlCodeGenerator* self, GtkamlClassDefinition* child_definition);
void gtkaml_code_generator_write_declaration (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_write_constructor (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
void gtkaml_code_generator_generate (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition);
ValaList* gtkaml_class_definition_get_children (GtkamlClassDefinition* self);
const char* gtkaml_class_definition_get_preconstruct_code (GtkamlClassDefinition* self);
void gtkaml_code_generator_write_construct_call (GtkamlCodeGenerator* self, const char* identifier, const char* identifier_type, const char* construct_type, const char* construct_code);
const char* gtkaml_class_definition_get_identifier (GtkamlClassDefinition* self);
char* gtkaml_class_definition_get_base_full_name (GtkamlClassDefinition* self);
const char* gtkaml_class_definition_get_construct_code (GtkamlClassDefinition* self);
GType gtkaml_attribute_get_type (void);
ValaList* gtkaml_class_definition_get_attrs (GtkamlClassDefinition* self);
GType gtkaml_complex_attribute_get_type (void);
GtkamlClassDefinition* gtkaml_complex_attribute_get_complex_type (GtkamlComplexAttribute* self);
GType gtkaml_method_get_type (void);
GType gtkaml_construct_method_get_type (void);
GtkamlConstructMethod* gtkaml_class_definition_get_construct_method (GtkamlClassDefinition* self);
ValaList* gtkaml_method_get_parameter_attributes (GtkamlMethod* self);
GType gtkaml_add_method_get_type (void);
GtkamlAddMethod* gtkaml_class_definition_get_add_method (GtkamlClassDefinition* self);
const char* gtkaml_root_class_definition_get_target_namespace (GtkamlRootClassDefinition* self);
const char* gtkaml_root_class_definition_get_target_name (GtkamlRootClassDefinition* self);
const char* gtkaml_class_definition_get_base_ns (GtkamlClassDefinition* self);
ValaClass* gtkaml_class_definition_get_base_type (GtkamlClassDefinition* self);
const char* gtkaml_root_class_definition_get_implements (GtkamlRootClassDefinition* self);
ValaList* gtkaml_root_class_definition_get_code (GtkamlRootClassDefinition* self);
void gtkaml_code_generator_add_code (GtkamlCodeGenerator* self, const char* value);
GType definition_scope_get_type (void);
DefinitionScope gtkaml_class_definition_get_definition_scope (GtkamlClassDefinition* self);
void gtkaml_code_generator_write_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* attr);
const char* gtkaml_method_get_name (GtkamlMethod* self);
char* gtkaml_code_generator_generate_literal (GtkamlCodeGenerator* self, GtkamlAttribute* attr);
GtkamlClassDefinition* gtkaml_class_definition_get_parent_container (GtkamlClassDefinition* self);
ValaSymbol* gtkaml_attribute_get_target_type (GtkamlAttribute* self);
void gtkaml_code_generator_write_signal_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* signal_attr);
ValaSourceReference* gtkaml_class_definition_get_source_reference (GtkamlClassDefinition* self);
const char* gtkaml_attribute_get_name (GtkamlAttribute* self);
GType gtkaml_simple_attribute_get_type (void);
const char* gtkaml_simple_attribute_get_value (GtkamlSimpleAttribute* self);
GtkamlCodeContext* gtkaml_code_generator_get_context (GtkamlCodeGenerator* self);
static void gtkaml_code_generator_finalize (GObject* obj);
static void gtkaml_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gtkaml_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



GtkamlCodeGenerator* gtkaml_code_generator_construct (GType object_type, GtkamlCodeContext* context) {
	GtkamlCodeGenerator * self;
	g_return_val_if_fail (context != NULL, NULL);
	self = (GtkamlCodeGenerator*) g_object_new (object_type, NULL);
	gtkaml_code_generator_set_context (self, context);
	return self;
}


GtkamlCodeGenerator* gtkaml_code_generator_new (GtkamlCodeContext* context) {
	return gtkaml_code_generator_construct (GTKAML_TYPE_CODE_GENERATOR, context);
}


char* gtkaml_code_generator_yield (GtkamlCodeGenerator* self) {
	char* result;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp4_;
	char* yielded;
	char* _tmp19_;
	char* _tmp18_;
	char* _tmp17_;
	char* _tmp16_;
	char* _tmp15_;
	char* _tmp14_;
	char* _tmp13_;
	char* _tmp12_;
	char* _tmp11_;
	char* _tmp10_;
	char* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	yielded = (_tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (self->priv->using_directives, "\n", NULL), self->priv->class_start, NULL), "\n", NULL), self->priv->members_declarations, NULL), "\n", NULL), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp4_);
	{
		gint i;
		i = gtkaml_code_generator_line_count (self, yielded) + 1;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				char* _tmp6_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				if (!(i < gtkaml_root_class_definition_get_original_first_code_line (self->priv->_root_class_definition))) {
					break;
				}
				yielded = (_tmp6_ = g_strconcat (yielded, "\n", NULL), _g_free0 (yielded), _tmp6_);
			}
		}
	}
	yielded = (_tmp19_ = g_strconcat (yielded, _tmp18_ = g_strconcat (_tmp17_ = g_strconcat (_tmp16_ = g_strconcat (_tmp15_ = g_strconcat (_tmp14_ = g_strconcat (_tmp13_ = g_strconcat (_tmp12_ = g_strconcat (_tmp11_ = g_strconcat (_tmp10_ = g_strconcat (_tmp9_ = g_strconcat (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (self->priv->code, "\n", NULL), self->priv->construct_signals, NULL), "\n", NULL), "\tconstruct {\n", NULL), self->priv->construct_body_locals, NULL), "\n", NULL), self->priv->constructors, NULL), "\n", NULL), self->priv->construct_body, NULL), "\n", NULL), "\t}\n", NULL), self->priv->class_end, NULL), NULL), _g_free0 (yielded), _tmp19_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp7_);
	result = yielded;
	return result;
}


void gtkaml_code_generator_generate (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	if (GTKAML_IS_ROOT_CLASS_DEFINITION (class_definition)) {
		GtkamlClassDefinition* _tmp0_;
		gtkaml_code_generator_set_root_class_definition (self, (_tmp0_ = class_definition, GTKAML_IS_ROOT_CLASS_DEFINITION (_tmp0_) ? ((GtkamlRootClassDefinition*) _tmp0_) : NULL));
		{
			ValaSet* _tmp1_;
			ValaIterator* _tmp2_;
			ValaIterator* _prefix_it;
			_prefix_it = (_tmp2_ = vala_iterable_iterator ((ValaIterable*) (_tmp1_ = vala_map_get_keys (gtkaml_root_class_definition_get_prefixes_namespaces (self->priv->_root_class_definition)))), _vala_collection_object_unref0 (_tmp1_), _tmp2_);
			while (TRUE) {
				char* prefix;
				char* _tmp3_;
				if (!vala_iterator_next (_prefix_it)) {
					break;
				}
				prefix = (char*) vala_iterator_get (_prefix_it);
				gtkaml_code_generator_write_using (self, _tmp3_ = gtkaml_code_generator_prefix_to_namespace (self, prefix));
				_g_free0 (_tmp3_);
				_g_free0 (prefix);
			}
			_vala_collection_object_unref0 (_prefix_it);
		}
		gtkaml_code_generator_write_root_class_definition (self, self->priv->_root_class_definition);
		gtkaml_code_generator_write_preconstruct (self, (GtkamlClassDefinition*) self->priv->_root_class_definition);
		gtkaml_code_generator_write_root_constructor_parameters (self, self->priv->_root_class_definition);
		gtkaml_code_generator_write_complex_attributes (self, (GtkamlClassDefinition*) self->priv->_root_class_definition);
		gtkaml_code_generator_write_setters (self, class_definition);
		gtkaml_code_generator_generate_children (self, class_definition);
		gtkaml_code_generator_write_construct (self, class_definition);
	} else {
		if (GTKAML_IS_REFERENCE_CLASS_DEFINITION (class_definition)) {
			gtkaml_code_generator_generate_children (self, class_definition);
			gtkaml_code_generator_write_setters (self, class_definition);
			gtkaml_code_generator_write_add (self, class_definition);
		} else {
			gtkaml_code_generator_write_declaration (self, class_definition);
			gtkaml_code_generator_write_complex_attributes (self, class_definition);
			gtkaml_code_generator_write_constructor (self, class_definition);
			gtkaml_code_generator_write_preconstruct (self, class_definition);
			gtkaml_code_generator_write_setters (self, class_definition);
			gtkaml_code_generator_generate_children (self, class_definition);
			gtkaml_code_generator_write_construct (self, class_definition);
			gtkaml_code_generator_write_add (self, class_definition);
		}
	}
}


static gint gtkaml_code_generator_line_count (GtkamlCodeGenerator* self, const char* s) {
	gint result;
	gint count;
	const char* current;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s != NULL, 0);
	count = 0;
	current = s;
	while (TRUE) {
		if (!(g_utf8_get_char (current) != 0)) {
			break;
		}
		if (g_utf8_get_char (current) == '\n') {
			count++;
		}
		current = g_utf8_next_char (current);
	}
	result = count;
	return result;
}


void gtkaml_code_generator_generate_children (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		ValaIterator* _child_it;
		_child_it = vala_iterable_iterator ((ValaIterable*) gtkaml_class_definition_get_children (class_definition));
		while (TRUE) {
			GtkamlClassDefinition* child;
			if (!vala_iterator_next (_child_it)) {
				break;
			}
			child = (GtkamlClassDefinition*) vala_iterator_get (_child_it);
			gtkaml_code_generator_generate (self, child);
			_g_object_unref0 (child);
		}
		_vala_collection_object_unref0 (_child_it);
	}
}


void gtkaml_code_generator_write_preconstruct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	if (gtkaml_class_definition_get_preconstruct_code (class_definition) != NULL) {
		char* _tmp0_;
		gtkaml_code_generator_write_construct_call (self, gtkaml_class_definition_get_identifier (class_definition), _tmp0_ = gtkaml_class_definition_get_base_full_name (class_definition), "preconstruct", gtkaml_class_definition_get_preconstruct_code (class_definition));
		_g_free0 (_tmp0_);
	}
}


void gtkaml_code_generator_write_construct (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	if (gtkaml_class_definition_get_construct_code (class_definition) != NULL) {
		char* _tmp0_;
		gtkaml_code_generator_write_construct_call (self, gtkaml_class_definition_get_identifier (class_definition), _tmp0_ = gtkaml_class_definition_get_base_full_name (class_definition), "construct", gtkaml_class_definition_get_construct_code (class_definition));
		_g_free0 (_tmp0_);
	}
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


void gtkaml_code_generator_write_construct_call (GtkamlCodeGenerator* self, const char* identifier, const char* identifier_type, const char* construct_type, const char* construct_code) {
	char* _tmp0_;
	char* _tmp1_;
	char* construct_signal;
	char* real_construct_code;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp11_;
	char* _tmp10_;
	char* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp12_;
	char* to_append;
	g_return_if_fail (self != NULL);
	g_return_if_fail (identifier != NULL);
	g_return_if_fail (identifier_type != NULL);
	g_return_if_fail (construct_type != NULL);
	g_return_if_fail (construct_code != NULL);
	construct_signal = (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (identifier, "_", NULL), construct_type, NULL), _g_free0 (_tmp0_), _tmp1_);
	real_construct_code = string_strip (construct_code);
	if (g_str_has_prefix (real_construct_code, "{")) {
		if (g_str_has_suffix (real_construct_code, "}")) {
			char* _tmp2_;
			real_construct_code = (_tmp2_ = string_substring (real_construct_code, (glong) 1, g_utf8_strlen (real_construct_code, -1) - 2), _g_free0 (real_construct_code), _tmp2_);
		} else {
			char* _tmp3_;
			vala_report_error (NULL, _tmp3_ = g_strdup_printf ("%s for %s not properly ended", construct_type, identifier));
			_g_free0 (_tmp3_);
		}
	} else {
		char* _tmp4_;
		real_construct_code = (_tmp4_ = g_strdup_printf (" (thiz, target) => { %s; }", construct_code), _g_free0 (real_construct_code), _tmp4_);
	}
	self->priv->construct_signals = (_tmp6_ = g_strconcat (self->priv->construct_signals, _tmp5_ = g_strdup_printf ("\tprivate signal void %s (%s target);\n", construct_signal, identifier_type), NULL), _g_free0 (self->priv->construct_signals), _tmp6_);
	_g_free0 (_tmp5_);
	to_append = (_tmp12_ = g_strconcat (_tmp11_ = g_strconcat (_tmp10_ = g_strconcat (_tmp9_ = g_strconcat (_tmp8_ = g_strconcat (_tmp7_ = g_strdup_printf ("\t\t%s += %s;\n", construct_signal, real_construct_code), "\t\t", NULL), construct_signal, NULL), " (", NULL), identifier, NULL), ");\n", NULL), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _g_free0 (_tmp7_), _tmp12_);
	if (_vala_strcmp0 (construct_type, "preconstruct") == 0) {
		char* _tmp13_;
		self->priv->constructors = (_tmp13_ = g_strconcat (self->priv->constructors, to_append, NULL), _g_free0 (self->priv->constructors), _tmp13_);
	} else {
		char* _tmp14_;
		self->priv->construct_body = (_tmp14_ = g_strconcat (self->priv->construct_body, to_append, NULL), _g_free0 (self->priv->construct_body), _tmp14_);
	}
	_g_free0 (construct_signal);
	_g_free0 (real_construct_code);
	_g_free0 (to_append);
}


void gtkaml_code_generator_write_complex_attributes (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	gboolean _tmp1_ = FALSE;
	gboolean first;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		ValaIterator* _attr_it;
		_attr_it = vala_iterable_iterator ((ValaIterable*) gtkaml_class_definition_get_attrs (class_definition));
		while (TRUE) {
			GtkamlAttribute* attr;
			if (!vala_iterator_next (_attr_it)) {
				break;
			}
			attr = (GtkamlAttribute*) vala_iterator_get (_attr_it);
			if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
				GtkamlAttribute* _tmp0_;
				gtkaml_code_generator_generate (self, gtkaml_complex_attribute_get_complex_type ((_tmp0_ = attr, GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp0_) ? ((GtkamlComplexAttribute*) _tmp0_) : NULL)));
			}
			_g_object_unref0 (attr);
		}
		_vala_collection_object_unref0 (_attr_it);
	}
	if (gtkaml_class_definition_get_construct_method (class_definition) != NULL) {
		_tmp1_ = gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			ValaIterator* _attr_it;
			_attr_it = vala_iterable_iterator ((ValaIterable*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)));
			while (TRUE) {
				GtkamlAttribute* attr;
				if (!vala_iterator_next (_attr_it)) {
					break;
				}
				attr = (GtkamlAttribute*) vala_iterator_get (_attr_it);
				if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
					GtkamlAttribute* _tmp2_;
					gtkaml_code_generator_generate (self, gtkaml_complex_attribute_get_complex_type ((_tmp2_ = attr, GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp2_) ? ((GtkamlComplexAttribute*) _tmp2_) : NULL)));
				}
				_g_object_unref0 (attr);
			}
			_vala_collection_object_unref0 (_attr_it);
		}
	}
	first = TRUE;
	if (gtkaml_class_definition_get_add_method (class_definition) != NULL) {
		_tmp3_ = gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (class_definition)) != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		{
			ValaIterator* _attr_it;
			_attr_it = vala_iterable_iterator ((ValaIterable*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (class_definition)));
			while (TRUE) {
				GtkamlAttribute* attr;
				gboolean _tmp4_ = FALSE;
				if (!vala_iterator_next (_attr_it)) {
					break;
				}
				attr = (GtkamlAttribute*) vala_iterator_get (_attr_it);
				if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
					_tmp4_ = !first;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GtkamlAttribute* _tmp5_;
					gtkaml_code_generator_generate (self, gtkaml_complex_attribute_get_complex_type ((_tmp5_ = attr, GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp5_) ? ((GtkamlComplexAttribute*) _tmp5_) : NULL)));
				}
				first = FALSE;
				_g_object_unref0 (attr);
			}
			_vala_collection_object_unref0 (_attr_it);
		}
	}
}


void gtkaml_code_generator_write_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* root_class_definition) {
	char* ns;
	char* name;
	char* base_ns;
	char* base_name;
	char* _tmp0_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp7_;
	char* _tmp10_;
	char* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_class_definition != NULL);
	ns = g_strdup (gtkaml_root_class_definition_get_target_namespace (root_class_definition));
	name = g_strdup (gtkaml_root_class_definition_get_target_name (root_class_definition));
	base_ns = g_strdup (gtkaml_class_definition_get_base_ns ((GtkamlClassDefinition*) root_class_definition));
	base_name = g_strdup (vala_symbol_get_name ((ValaSymbol*) gtkaml_class_definition_get_base_type ((GtkamlClassDefinition*) root_class_definition)));
	self->priv->class_start = (_tmp0_ = g_strconcat (self->priv->class_start, "public class ", NULL), _g_free0 (self->priv->class_start), _tmp0_);
	if (ns != NULL) {
		char* _tmp2_;
		char* _tmp1_;
		self->priv->class_start = (_tmp2_ = g_strconcat (self->priv->class_start, _tmp1_ = g_strconcat (ns, ".", NULL), NULL), _g_free0 (self->priv->class_start), _tmp2_);
		_g_free0 (_tmp1_);
	}
	self->priv->class_start = (_tmp4_ = g_strconcat (self->priv->class_start, _tmp3_ = g_strconcat (name, " : ", NULL), NULL), _g_free0 (self->priv->class_start), _tmp4_);
	_g_free0 (_tmp3_);
	if (base_ns != NULL) {
		char* _tmp6_;
		char* _tmp5_;
		self->priv->class_start = (_tmp6_ = g_strconcat (self->priv->class_start, _tmp5_ = g_strconcat (base_ns, ".", NULL), NULL), _g_free0 (self->priv->class_start), _tmp6_);
		_g_free0 (_tmp5_);
	}
	self->priv->class_start = (_tmp7_ = g_strconcat (self->priv->class_start, base_name, NULL), _g_free0 (self->priv->class_start), _tmp7_);
	if (gtkaml_root_class_definition_get_implements (root_class_definition) != NULL) {
		char* _tmp9_;
		char* _tmp8_;
		self->priv->class_start = (_tmp9_ = g_strconcat (self->priv->class_start, _tmp8_ = g_strconcat (", ", gtkaml_root_class_definition_get_implements (root_class_definition), NULL), NULL), _g_free0 (self->priv->class_start), _tmp9_);
		_g_free0 (_tmp8_);
	}
	self->priv->class_start = (_tmp10_ = g_strconcat (self->priv->class_start, "\n{\n", NULL), _g_free0 (self->priv->class_start), _tmp10_);
	self->priv->class_end = (_tmp11_ = g_strconcat (self->priv->class_end, "}\n", NULL), _g_free0 (self->priv->class_end), _tmp11_);
	{
		ValaIterator* _code_it;
		_code_it = vala_iterable_iterator ((ValaIterable*) gtkaml_root_class_definition_get_code (root_class_definition));
		while (TRUE) {
			char* code;
			if (!vala_iterator_next (_code_it)) {
				break;
			}
			code = (char*) vala_iterator_get (_code_it);
			gtkaml_code_generator_add_code (self, code);
			_g_free0 (code);
		}
		_vala_collection_object_unref0 (_code_it);
	}
	_g_free0 (ns);
	_g_free0 (name);
	_g_free0 (base_ns);
	_g_free0 (base_name);
}


void gtkaml_code_generator_write_declaration (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	switch (gtkaml_class_definition_get_definition_scope (class_definition)) {
		case DEFINITION_SCOPE_PUBLIC:
		{
			char* _tmp5_;
			char* _tmp4_;
			char* _tmp3_;
			char* _tmp2_;
			char* _tmp1_;
			char* _tmp0_;
			self->priv->members_declarations = (_tmp5_ = g_strconcat (self->priv->members_declarations, _tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("\tpublic ", _tmp0_ = gtkaml_class_definition_get_base_full_name (class_definition), NULL), " ", NULL), gtkaml_class_definition_get_identifier (class_definition), NULL), ";\n", NULL), NULL), _g_free0 (self->priv->members_declarations), _tmp5_);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
			_g_free0 (_tmp0_);
			break;
		}
		case DEFINITION_SCOPE_PRIVATE:
		{
			char* _tmp11_;
			char* _tmp10_;
			char* _tmp9_;
			char* _tmp8_;
			char* _tmp7_;
			char* _tmp6_;
			self->priv->members_declarations = (_tmp11_ = g_strconcat (self->priv->members_declarations, _tmp10_ = g_strconcat (_tmp9_ = g_strconcat (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat ("\tprivate ", _tmp6_ = gtkaml_class_definition_get_base_full_name (class_definition), NULL), " ", NULL), gtkaml_class_definition_get_identifier (class_definition), NULL), ";\n", NULL), NULL), _g_free0 (self->priv->members_declarations), _tmp11_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp6_);
			break;
		}
		case DEFINITION_SCOPE_CONSTRUCTOR:
		{
			char* _tmp17_;
			char* _tmp16_;
			char* _tmp15_;
			char* _tmp14_;
			char* _tmp13_;
			char* _tmp12_;
			self->priv->construct_body_locals = (_tmp17_ = g_strconcat (self->priv->construct_body_locals, _tmp16_ = g_strconcat (_tmp15_ = g_strconcat (_tmp14_ = g_strconcat (_tmp13_ = g_strconcat ("\t\t", _tmp12_ = gtkaml_class_definition_get_base_full_name (class_definition), NULL), " ", NULL), gtkaml_class_definition_get_identifier (class_definition), NULL), ";\n", NULL), NULL), _g_free0 (self->priv->construct_body_locals), _tmp17_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp12_);
			break;
		}
	}
}


void gtkaml_code_generator_write_root_constructor_parameters (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		ValaIterator* _attr_it;
		_attr_it = vala_iterable_iterator ((ValaIterable*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method ((GtkamlClassDefinition*) class_definition)));
		while (TRUE) {
			GtkamlAttribute* attr;
			if (!vala_iterator_next (_attr_it)) {
				break;
			}
			attr = (GtkamlAttribute*) vala_iterator_get (_attr_it);
			gtkaml_code_generator_write_setter (self, (GtkamlClassDefinition*) class_definition, attr);
			_g_object_unref0 (attr);
		}
		_vala_collection_object_unref0 (_attr_it);
	}
}


void gtkaml_code_generator_write_constructor (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	char* construct_name;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	gint i;
	char* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	construct_name = g_strdup (gtkaml_method_get_name ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)));
	if (_vala_strcmp0 (construct_name, ".new") != 0) {
		char* _tmp0_;
		construct_name = (_tmp0_ = g_strconcat (".", construct_name, NULL), _g_free0 (construct_name), _tmp0_);
	} else {
		char* _tmp1_;
		construct_name = (_tmp1_ = g_strdup (""), _g_free0 (construct_name), _tmp1_);
	}
	self->priv->constructors = (_tmp8_ = g_strconcat (self->priv->constructors, _tmp7_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat ("\t\t", gtkaml_class_definition_get_identifier (class_definition), NULL), " = new ", NULL), _tmp4_ = gtkaml_class_definition_get_base_full_name (class_definition), NULL), construct_name, NULL), " (", NULL), NULL), _g_free0 (self->priv->constructors), _tmp8_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	i = 0;
	{
		gboolean _tmp9_;
		_tmp9_ = TRUE;
		while (TRUE) {
			GtkamlAttribute* attr;
			char* _tmp12_;
			char* _tmp11_;
			char* _tmp10_;
			if (!_tmp9_) {
				i++;
			}
			_tmp9_ = FALSE;
			if (!(i < (vala_collection_get_size ((ValaCollection*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition))) - 1))) {
				break;
			}
			attr = (GtkamlAttribute*) vala_list_get (gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)), i);
			self->priv->constructors = (_tmp12_ = g_strconcat (self->priv->constructors, _tmp11_ = g_strconcat (_tmp10_ = gtkaml_code_generator_generate_literal (self, attr), ", ", NULL), NULL), _g_free0 (self->priv->constructors), _tmp12_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp10_);
			_g_object_unref0 (attr);
		}
	}
	if (i < vala_collection_get_size ((ValaCollection*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)))) {
		char* _tmp15_;
		char* _tmp14_;
		GtkamlAttribute* _tmp13_;
		self->priv->constructors = (_tmp15_ = g_strconcat (self->priv->constructors, _tmp14_ = gtkaml_code_generator_generate_literal (self, _tmp13_ = (GtkamlAttribute*) vala_list_get (gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_construct_method (class_definition)), i)), NULL), _g_free0 (self->priv->constructors), _tmp15_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (_tmp13_);
	}
	self->priv->constructors = (_tmp16_ = g_strconcat (self->priv->constructors, ");\n", NULL), _g_free0 (self->priv->constructors), _tmp16_);
	_g_free0 (construct_name);
}


void gtkaml_code_generator_write_add (GtkamlCodeGenerator* self, GtkamlClassDefinition* child_definition) {
	char* method_name;
	char* _tmp2_;
	char* _tmp1_;
	gint i;
	char* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child_definition != NULL);
	if (gtkaml_class_definition_get_parent_container (child_definition) == NULL) {
		return;
	}
	method_name = g_strdup (gtkaml_method_get_name ((GtkamlMethod*) gtkaml_class_definition_get_add_method (child_definition)));
	if (_vala_strcmp0 (method_name, "add_with_properties") == 0) {
		char* _tmp0_;
		method_name = (_tmp0_ = g_strdup ("add"), _g_free0 (method_name), _tmp0_);
	}
	self->priv->construct_body = (_tmp2_ = g_strconcat (self->priv->construct_body, _tmp1_ = g_strdup_printf ("\t\t%s.%s (", gtkaml_class_definition_get_identifier (gtkaml_class_definition_get_parent_container (child_definition)), method_name), NULL), _g_free0 (self->priv->construct_body), _tmp2_);
	_g_free0 (_tmp1_);
	i = 0;
	{
		gboolean _tmp3_;
		_tmp3_ = TRUE;
		while (TRUE) {
			GtkamlAttribute* attr;
			char* _tmp6_;
			char* _tmp5_;
			char* _tmp4_;
			if (!_tmp3_) {
				i++;
			}
			_tmp3_ = FALSE;
			if (!(i < (vala_collection_get_size ((ValaCollection*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (child_definition))) - 1))) {
				break;
			}
			attr = (GtkamlAttribute*) vala_list_get (gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (child_definition)), i);
			self->priv->construct_body = (_tmp6_ = g_strconcat (self->priv->construct_body, _tmp5_ = g_strconcat (_tmp4_ = gtkaml_code_generator_generate_literal (self, attr), ", ", NULL), NULL), _g_free0 (self->priv->construct_body), _tmp6_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp4_);
			_g_object_unref0 (attr);
		}
	}
	if (i < vala_collection_get_size ((ValaCollection*) gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (child_definition)))) {
		char* _tmp9_;
		char* _tmp8_;
		GtkamlAttribute* _tmp7_;
		self->priv->construct_body = (_tmp9_ = g_strconcat (self->priv->construct_body, _tmp8_ = gtkaml_code_generator_generate_literal (self, _tmp7_ = (GtkamlAttribute*) vala_list_get (gtkaml_method_get_parameter_attributes ((GtkamlMethod*) gtkaml_class_definition_get_add_method (child_definition)), i)), NULL), _g_free0 (self->priv->construct_body), _tmp9_);
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp7_);
	}
	self->priv->construct_body = (_tmp10_ = g_strconcat (self->priv->construct_body, ");\n", NULL), _g_free0 (self->priv->construct_body), _tmp10_);
	_g_free0 (method_name);
}


void gtkaml_code_generator_write_setters (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		ValaIterator* _attr_it;
		_attr_it = vala_iterable_iterator ((ValaIterable*) gtkaml_class_definition_get_attrs (class_definition));
		while (TRUE) {
			GtkamlAttribute* attr;
			if (!vala_iterator_next (_attr_it)) {
				break;
			}
			attr = (GtkamlAttribute*) vala_iterator_get (_attr_it);
			if (VALA_IS_FIELD (gtkaml_attribute_get_target_type (attr))) {
				gtkaml_code_generator_write_setter (self, class_definition, attr);
			} else {
				if (VALA_IS_PROPERTY (gtkaml_attribute_get_target_type (attr))) {
					gtkaml_code_generator_write_setter (self, class_definition, attr);
				} else {
					if (VALA_IS_SIGNAL (gtkaml_attribute_get_target_type (attr))) {
						gtkaml_code_generator_write_signal_setter (self, class_definition, attr);
					} else {
						char* _tmp0_;
						vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), _tmp0_ = g_strdup_printf ("Unknown attribute type %s", gtkaml_attribute_get_name (attr)));
						_g_free0 (_tmp0_);
						_g_object_unref0 (attr);
						_vala_collection_object_unref0 (_attr_it);
						return;
					}
				}
			}
			_g_object_unref0 (attr);
		}
		_vala_collection_object_unref0 (_attr_it);
	}
}


char* gtkaml_code_generator_prefix_to_namespace (GtkamlCodeGenerator* self, const char* prefix) {
	char* result;
	const char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = NULL;
	if (prefix == NULL) {
		_tmp0_ = "";
	} else {
		_tmp0_ = prefix;
	}
	result = (char*) vala_map_get (gtkaml_root_class_definition_get_prefixes_namespaces (self->priv->_root_class_definition), _tmp0_);
	return result;
}


void gtkaml_code_generator_write_using (GtkamlCodeGenerator* self, const char* ns) {
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	self->priv->using_directives = (_tmp1_ = g_strconcat (self->priv->using_directives, _tmp0_ = g_strdup_printf ("using %s;\n", ns), NULL), _g_free0 (self->priv->using_directives), _tmp1_);
	_g_free0 (_tmp0_);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


char* gtkaml_code_generator_generate_literal (GtkamlCodeGenerator* self, GtkamlAttribute* attr) {
	char* result;
	char* literal;
	ValaDataType* type;
	GtkamlAttribute* _tmp1_;
	char* value;
	char* stripped_value;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	literal = NULL;
	type = NULL;
	if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
		GtkamlAttribute* _tmp0_;
		result = g_strdup (gtkaml_class_definition_get_identifier (gtkaml_complex_attribute_get_complex_type ((_tmp0_ = attr, GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp0_) ? ((GtkamlComplexAttribute*) _tmp0_) : NULL))));
		_g_free0 (literal);
		_vala_code_node_unref0 (type);
		return result;
	}
	value = g_strdup (gtkaml_simple_attribute_get_value ((_tmp1_ = attr, GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp1_) ? ((GtkamlSimpleAttribute*) _tmp1_) : NULL)));
	if (VALA_IS_FIELD (gtkaml_attribute_get_target_type (attr))) {
		ValaDataType* _tmp3_;
		ValaSymbol* _tmp2_;
		type = (_tmp3_ = _vala_code_node_ref0 (vala_field_get_field_type ((_tmp2_ = gtkaml_attribute_get_target_type (attr), VALA_IS_FIELD (_tmp2_) ? ((ValaField*) _tmp2_) : NULL))), _vala_code_node_unref0 (type), _tmp3_);
	} else {
		if (VALA_IS_PROPERTY (gtkaml_attribute_get_target_type (attr))) {
			ValaDataType* _tmp5_;
			ValaSymbol* _tmp4_;
			type = (_tmp5_ = _vala_code_node_ref0 (vala_property_get_property_type ((_tmp4_ = gtkaml_attribute_get_target_type (attr), VALA_IS_PROPERTY (_tmp4_) ? ((ValaProperty*) _tmp4_) : NULL))), _vala_code_node_unref0 (type), _tmp5_);
		} else {
			if (VALA_IS_FORMAL_PARAMETER (gtkaml_attribute_get_target_type (attr))) {
				ValaDataType* _tmp7_;
				ValaSymbol* _tmp6_;
				type = (_tmp7_ = _vala_code_node_ref0 (vala_formal_parameter_get_parameter_type ((_tmp6_ = gtkaml_attribute_get_target_type (attr), VALA_IS_FORMAL_PARAMETER (_tmp6_) ? ((ValaFormalParameter*) _tmp6_) : NULL))), _vala_code_node_unref0 (type), _tmp7_);
			} else {
				char* _tmp8_;
				vala_report_error (NULL, _tmp8_ = g_strdup_printf ("The attribute %s with value %s is not Field, Property or FormalParameter", gtkaml_attribute_get_name (attr), value));
				_g_free0 (_tmp8_);
				result = g_strdup ("<Invalid value>");
				_g_free0 (literal);
				_vala_code_node_unref0 (type);
				_g_free0 (value);
				return result;
			}
		}
	}
	stripped_value = string_strip (value);
	if (g_str_has_prefix (stripped_value, "{")) {
		if (g_str_has_suffix (stripped_value, "}")) {
			char* _tmp9_;
			literal = (_tmp9_ = string_substring (stripped_value, (glong) 1, g_utf8_strlen (stripped_value, -1) - 2), _g_free0 (literal), _tmp9_);
		} else {
			char* _tmp10_;
			vala_report_error (NULL, _tmp10_ = g_strdup_printf ("Attribute %s not properly ended", gtkaml_attribute_get_name (attr)));
			_g_free0 (_tmp10_);
			result = g_strdup ("<Invalid value>");
			_g_free0 (literal);
			_vala_code_node_unref0 (type);
			_g_free0 (value);
			_g_free0 (stripped_value);
			return result;
		}
	} else {
		if (VALA_IS_UNRESOLVED_TYPE (type)) {
			ValaDataType* _tmp11_;
			ValaUnresolvedType* utype;
			utype = _vala_code_node_ref0 ((_tmp11_ = type, VALA_IS_UNRESOLVED_TYPE (_tmp11_) ? ((ValaUnresolvedType*) _tmp11_) : NULL));
			if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) vala_unresolved_type_get_unresolved_symbol (utype)), "string") == 0) {
				char* _tmp14_;
				char* _tmp13_;
				char* _tmp12_;
				literal = (_tmp14_ = g_strconcat (_tmp13_ = g_strconcat ("\"", _tmp12_ = g_strescape (value, ""), NULL), "\"", NULL), _g_free0 (literal), _tmp14_);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp12_);
			} else {
				if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) vala_unresolved_type_get_unresolved_symbol (utype)), "bool") == 0) {
					gboolean _tmp15_ = FALSE;
					char* _tmp17_;
					if (_vala_strcmp0 (stripped_value, "true") != 0) {
						_tmp15_ = _vala_strcmp0 (stripped_value, "false") != 0;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						char* _tmp16_;
						vala_report_error (NULL, _tmp16_ = g_strdup_printf ("'%s' is not a boolean literal", value));
						_g_free0 (_tmp16_);
						result = g_strdup ("<Invalid value>");
						_vala_code_node_unref0 (utype);
						_g_free0 (literal);
						_vala_code_node_unref0 (type);
						_g_free0 (value);
						_g_free0 (stripped_value);
						return result;
					}
					literal = (_tmp17_ = g_strdup (stripped_value), _g_free0 (literal), _tmp17_);
				} else {
					char* _tmp18_;
					literal = (_tmp18_ = g_strdup (stripped_value), _g_free0 (literal), _tmp18_);
				}
			}
			_vala_code_node_unref0 (utype);
		} else {
			char* _tmp19_;
			vala_report_error (NULL, _tmp19_ = g_strdup_printf ("Don't know any literal of type '%s'\n", vala_symbol_get_name (gtkaml_attribute_get_target_type (attr))));
			_g_free0 (_tmp19_);
			result = stripped_value;
			_g_free0 (literal);
			_vala_code_node_unref0 (type);
			_g_free0 (value);
			return result;
		}
	}
	result = literal;
	_vala_code_node_unref0 (type);
	_g_free0 (value);
	_g_free0 (stripped_value);
	return result;
}


void gtkaml_code_generator_write_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* attr) {
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	g_return_if_fail (attr != NULL);
	self->priv->construct_body = (_tmp2_ = g_strconcat (self->priv->construct_body, _tmp1_ = g_strdup_printf ("\t\t%s.%s = %s;\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (attr), _tmp0_ = gtkaml_code_generator_generate_literal (self, attr)), NULL), _g_free0 (self->priv->construct_body), _tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gtkaml_code_generator_write_signal_setter (GtkamlCodeGenerator* self, GtkamlClassDefinition* class_definition, GtkamlAttribute* signal_attr) {
	GtkamlAttribute* _tmp1_;
	GtkamlSimpleAttribute* simple_attribute;
	ValaSymbol* _tmp2_;
	ValaSignal* the_signal;
	char* parameters_joined;
	char* body;
	ValaList* parameters;
	char** _tmp7_;
	gint parameter_names_size;
	gint parameter_names_length1;
	char** parameter_names;
	gint i;
	char* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	g_return_if_fail (signal_attr != NULL);
	if (!GTKAML_IS_SIMPLE_ATTRIBUTE (signal_attr)) {
		char* _tmp0_;
		vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), _tmp0_ = g_strdup_printf ("Cannot set the signal '%s' to this value.", gtkaml_attribute_get_name (signal_attr)));
		_g_free0 (_tmp0_);
		return;
	}
	simple_attribute = _g_object_ref0 ((_tmp1_ = signal_attr, GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp1_) ? ((GtkamlSimpleAttribute*) _tmp1_) : NULL));
	the_signal = _vala_code_node_ref0 ((_tmp2_ = gtkaml_attribute_get_target_type ((GtkamlAttribute*) simple_attribute), VALA_IS_SIGNAL (_tmp2_) ? ((ValaSignal*) _tmp2_) : NULL));
	parameters_joined = g_strdup ("");
	body = string_strip (gtkaml_simple_attribute_get_value (simple_attribute));
	if (g_str_has_prefix (body, "{")) {
		if (g_str_has_suffix (body, "}")) {
			char* _tmp3_;
			char* _tmp5_;
			char* _tmp4_;
			parameters_joined = (_tmp3_ = string_substring (body, (glong) 1, g_utf8_strlen (body, -1) - 2), _g_free0 (parameters_joined), _tmp3_);
			self->priv->construct_body = (_tmp5_ = g_strconcat (self->priv->construct_body, _tmp4_ = g_strdup_printf ("\t\t%s.%s += %s;\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (signal_attr), parameters_joined), NULL), _g_free0 (self->priv->construct_body), _tmp5_);
			_g_free0 (_tmp4_);
			_g_object_unref0 (simple_attribute);
			_vala_code_node_unref0 (the_signal);
			_g_free0 (parameters_joined);
			_g_free0 (body);
			return;
		} else {
			char* _tmp6_;
			vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), _tmp6_ = g_strdup_printf ("Signal %s not properly ended", gtkaml_attribute_get_name (signal_attr)));
			_g_free0 (_tmp6_);
			_g_object_unref0 (simple_attribute);
			_vala_code_node_unref0 (the_signal);
			_g_free0 (parameters_joined);
			_g_free0 (body);
			return;
		}
	}
	parameters = vala_signal_get_parameters (the_signal);
	parameter_names = (_tmp7_ = g_new0 (char*, 0 + 1), parameter_names_length1 = 0, parameter_names_size = parameter_names_length1, _tmp7_);
	i = 0;
	parameters_joined = (_tmp8_ = g_strdup ("target"), _g_free0 (parameters_joined), _tmp8_);
	if (vala_collection_get_size ((ValaCollection*) parameters) > 0) {
		gint _tmp9_;
		char* _tmp13_;
		char* *_tmp12_;
		char* _tmp16_;
		char* _tmp15_;
		char* _tmp14_;
		char* _tmp18_;
		char* _tmp17_;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) parameters) + 1;
		parameter_names = g_renew (char*, parameter_names, vala_collection_get_size ((ValaCollection*) parameters) + 1);
		(_tmp9_ > parameter_names_length1) ? memset (parameter_names + parameter_names_length1, 0, sizeof (char*) * (_tmp9_ - parameter_names_length1)) : NULL;
		parameter_names_length1 = _tmp9_;
		{
			ValaIterator* _p_it;
			_p_it = vala_iterable_iterator ((ValaIterable*) parameters);
			while (TRUE) {
				ValaFormalParameter* p;
				char* _tmp11_;
				char* *_tmp10_;
				if (!vala_iterator_next (_p_it)) {
					break;
				}
				p = (ValaFormalParameter*) vala_iterator_get (_p_it);
				_tmp10_ = &parameter_names[i++];
				(*_tmp10_) = (_tmp11_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) p)), _g_free0 ((*_tmp10_)), _tmp11_);
				_vala_code_node_unref0 (p);
			}
			_vala_collection_object_unref0 (_p_it);
		}
		_tmp12_ = &parameter_names[vala_collection_get_size ((ValaCollection*) parameters)];
		(*_tmp12_) = (_tmp13_ = NULL, _g_free0 ((*_tmp12_)), _tmp13_);
		parameters_joined = (_tmp16_ = g_strconcat (parameters_joined, _tmp15_ = g_strconcat (", ", _tmp14_ = g_strjoinv (",", parameter_names), NULL), NULL), _g_free0 (parameters_joined), _tmp16_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp14_);
		self->priv->construct_body = (_tmp18_ = g_strconcat (self->priv->construct_body, _tmp17_ = g_strdup_printf ("\t\t%s.%s += (%s) => { %s; };\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (signal_attr), parameters_joined, gtkaml_simple_attribute_get_value (simple_attribute)), NULL), _g_free0 (self->priv->construct_body), _tmp18_);
		_g_free0 (_tmp17_);
	} else {
		char* _tmp20_;
		char* _tmp19_;
		self->priv->construct_body = (_tmp20_ = g_strconcat (self->priv->construct_body, _tmp19_ = g_strdup_printf ("\t\t%s.%s += %s => { %s; };\n", gtkaml_class_definition_get_identifier (class_definition), gtkaml_attribute_get_name (signal_attr), parameters_joined, gtkaml_simple_attribute_get_value (simple_attribute)), NULL), _g_free0 (self->priv->construct_body), _tmp20_);
		_g_free0 (_tmp19_);
	}
	_g_object_unref0 (simple_attribute);
	_vala_code_node_unref0 (the_signal);
	_g_free0 (parameters_joined);
	_g_free0 (body);
	_vala_collection_object_unref0 (parameters);
	parameter_names = (_vala_array_free (parameter_names, parameter_names_length1, (GDestroyNotify) g_free), NULL);
}


void gtkaml_code_generator_add_code (GtkamlCodeGenerator* self, const char* value) {
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	self->priv->code = (_tmp1_ = g_strconcat (self->priv->code, _tmp0_ = g_strconcat (value, "\n", NULL), NULL), _g_free0 (self->priv->code), _tmp1_);
	_g_free0 (_tmp0_);
}


GtkamlCodeContext* gtkaml_code_generator_get_context (GtkamlCodeGenerator* self) {
	GtkamlCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_context;
	return result;
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static void gtkaml_code_generator_set_context (GtkamlCodeGenerator* self, GtkamlCodeContext* value) {
	GtkamlCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_context = (_tmp0_ = _vala_code_context_ref0 (value), _vala_code_context_unref0 (self->priv->_context), _tmp0_);
	g_object_notify ((GObject *) self, "context");
}


static GtkamlRootClassDefinition* gtkaml_code_generator_get_root_class_definition (GtkamlCodeGenerator* self) {
	GtkamlRootClassDefinition* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_root_class_definition;
	return result;
}


static void gtkaml_code_generator_set_root_class_definition (GtkamlCodeGenerator* self, GtkamlRootClassDefinition* value) {
	GtkamlRootClassDefinition* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_root_class_definition = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_root_class_definition), _tmp0_);
}


static void gtkaml_code_generator_class_init (GtkamlCodeGeneratorClass * klass) {
	gtkaml_code_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_code_generator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_code_generator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_code_generator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_CODE_GENERATOR_CONTEXT, vala_param_spec_code_context ("context", "context", "context", GTKAML_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gtkaml_code_generator_instance_init (GtkamlCodeGenerator * self) {
	self->priv = GTKAML_CODE_GENERATOR_GET_PRIVATE (self);
	self->priv->using_directives = g_strdup ("");
	self->priv->class_start = g_strdup ("");
	self->priv->members_declarations = g_strdup ("");
	self->priv->code = g_strdup ("");
	self->priv->construct_signals = g_strdup ("");
	self->priv->constructors = g_strdup ("");
	self->priv->construct_body_locals = g_strdup ("");
	self->priv->construct_body = g_strdup ("");
	self->priv->class_end = g_strdup ("");
}


static void gtkaml_code_generator_finalize (GObject* obj) {
	GtkamlCodeGenerator * self;
	self = GTKAML_CODE_GENERATOR (obj);
	_g_free0 (self->priv->using_directives);
	_g_free0 (self->priv->class_start);
	_g_free0 (self->priv->members_declarations);
	_g_free0 (self->priv->code);
	_g_free0 (self->priv->construct_signals);
	_g_free0 (self->priv->constructors);
	_g_free0 (self->priv->construct_body_locals);
	_g_free0 (self->priv->construct_body);
	_g_free0 (self->priv->class_end);
	_vala_code_context_unref0 (self->priv->_context);
	_g_object_unref0 (self->priv->_root_class_definition);
	G_OBJECT_CLASS (gtkaml_code_generator_parent_class)->finalize (obj);
}


GType gtkaml_code_generator_get_type (void) {
	static GType gtkaml_code_generator_type_id = 0;
	if (gtkaml_code_generator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlCodeGenerator), 0, (GInstanceInitFunc) gtkaml_code_generator_instance_init, NULL };
		gtkaml_code_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlCodeGenerator", &g_define_type_info, 0);
	}
	return gtkaml_code_generator_type_id;
}


static void gtkaml_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlCodeGenerator * self;
	self = GTKAML_CODE_GENERATOR (object);
	switch (property_id) {
		case GTKAML_CODE_GENERATOR_CONTEXT:
		vala_value_set_code_context (value, gtkaml_code_generator_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlCodeGenerator * self;
	self = GTKAML_CODE_GENERATOR (object);
	switch (property_id) {
		case GTKAML_CODE_GENERATOR_CONTEXT:
		gtkaml_code_generator_set_context (self, vala_value_get_code_context (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




