// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/ringbuffer.h>
#include <gstreamermm/private/ringbuffer_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gst/audio/audio-enumtypes.h>


static void RingBuffer_Fill_gstreamermm_callback(GstRingBuffer* rbuf, guint8* data, guint len, gpointer user_data)
{
  Gst::RingBuffer::SlotFill* the_slot = static_cast<Gst::RingBuffer::SlotFill*>(user_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    (*the_slot)(data, len);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

namespace Gst
{

RingBufferSpec::RingBufferSpec(const GstRingBufferSpec* castitem)
{
  if (castitem)
    copy_fields_from(*castitem);
  else
  {
    GstRingBufferSpec empty;
    copy_fields_from(empty);
  }
}

void RingBufferSpec::copy_fields_from(const GstRingBufferSpec& spec)
{
  caps = Glib::wrap(spec.caps);

  type = (Gst::BufferFormatType)(spec.type);
  format = (Gst::BufferFormat)(spec.format);
  sign = spec.sign;
  bigend = spec.bigend;
  width = spec.width;
  depth = spec.depth;
  rate = spec.rate;
  channels = spec.channels;
  latency_time = spec.latency_time;
  buffer_time = spec.buffer_time;
  segsize = spec.segsize;
  segtotal = spec.segtotal;
  bytes_per_sample = spec.bytes_per_sample;
  seglatency = spec.seglatency;

  memcpy(silence_sample, spec.silence_sample, sizeof(silence_sample));
}

void RingBufferSpec::copy_fields_to(GstRingBufferSpec& spec) const
{
  if (caps)
    spec.caps = caps->gobj();

  spec.type = (GstBufferFormatType)(type);
  spec.format = (GstBufferFormat)(format);
  spec.sign = sign;
  spec.bigend = bigend;
  spec.width = width;
  spec.depth = depth;
  spec.rate = rate;
  spec.channels = channels;
  spec.latency_time = latency_time;
  spec.buffer_time = buffer_time;
  spec.segsize = segsize;
  spec.segtotal = segtotal;
  spec.bytes_per_sample = bytes_per_sample;
  spec.seglatency = seglatency;

  memcpy(spec.silence_sample, silence_sample, sizeof(spec.silence_sample));
}

void RingBuffer::set_fill_slot(const SlotFill& slot)
{
  if (_slot_set())
    delete this->slot;

  this->slot = new SlotFill(slot);
  _slot_set(true);

  gst_ring_buffer_set_callback(gobj(), &RingBuffer_Fill_gstreamermm_callback,
    this->slot);
}

bool RingBuffer::_slot_set(bool mark_set) const
{
  static bool slot_set = false;

  if (mark_set)
    slot_set = true;

  return slot_set;
}

bool RingBuffer::acquire(const Gst::RingBufferSpec& spec)
{
  GstRingBufferSpec gst_spec;
  spec.copy_fields_to(gst_spec);
  return gst_ring_buffer_acquire(gobj(), &gst_spec);
}

bool RingBuffer::parse_caps(Gst::RingBufferSpec& spec, const Glib::RefPtr<Gst::Caps>& caps)
{
  GstRingBufferSpec gst_spec;
  spec.copy_fields_to(gst_spec);
  gboolean const result = gst_ring_buffer_parse_caps(&gst_spec, caps->gobj());
  spec.copy_fields_from(gst_spec);
  return result;
}

RingBuffer::~RingBuffer()
{
    // Delete task's slot upon destruction
  if (_slot_set())
    delete slot;
}

} // namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::RingBufferSegState>::value_type()
{
  return gst_ring_buffer_seg_state_get_type();
}

// static
GType Glib::Value<Gst::RingBufferState>::value_type()
{
  return gst_ring_buffer_state_get_type();
}

// static
GType Glib::Value<Gst::BufferFormat>::value_type()
{
  return gst_buffer_format_get_type();
}

// static
GType Glib::Value<Gst::BufferFormatType>::value_type()
{
  return gst_buffer_format_type_get_type();
}


namespace Gst
{


} // namespace Gst


namespace Glib
{

Glib::RefPtr<Gst::RingBuffer> wrap(GstRingBuffer* object, bool take_copy)
{
  return Glib::RefPtr<Gst::RingBuffer>( dynamic_cast<Gst::RingBuffer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& RingBuffer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &RingBuffer_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_ring_buffer_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void RingBuffer_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* RingBuffer_Class::wrap_new(GObject* object)
{
  return new RingBuffer((GstRingBuffer*)object);
}


/* The implementation: */

GstRingBuffer* RingBuffer::gobj_copy()
{
  reference();
  return gobj();
}

RingBuffer::RingBuffer(const Glib::ConstructParams& construct_params)
:
  Gst::Object(construct_params)
{

}

RingBuffer::RingBuffer(GstRingBuffer* castitem)
:
  Gst::Object((GstObject*)(castitem))
{}


RingBuffer::CppClassType RingBuffer::ringbuffer_class_; // initialize static member

GType RingBuffer::get_type()
{
  return ringbuffer_class_.init().get_type();
}

GType RingBuffer::get_base_type()
{
  return gst_ring_buffer_get_type();
}

bool RingBuffer::release()
{
  return gst_ring_buffer_release(gobj());
}

bool RingBuffer::is_acquired() const
{
  return gst_ring_buffer_is_acquired(const_cast<GstRingBuffer*>(gobj()));
}

bool RingBuffer::activate(bool active)
{
  return gst_ring_buffer_activate(gobj(), static_cast<int>(active));
}

bool RingBuffer::is_active() const
{
  return gst_ring_buffer_is_active(const_cast<GstRingBuffer*>(gobj()));
}

bool RingBuffer::start()
{
  return gst_ring_buffer_start(gobj());
}

bool RingBuffer::pause()
{
  return gst_ring_buffer_pause(gobj());
}

bool RingBuffer::stop()
{
  return gst_ring_buffer_stop(gobj());
}

guint RingBuffer::get_delay() const
{
  return gst_ring_buffer_delay(const_cast<GstRingBuffer*>(gobj()));
}

guint64 RingBuffer::get_samples_done() const
{
  return gst_ring_buffer_samples_done(const_cast<GstRingBuffer*>(gobj()));
}

void RingBuffer::set_sample(guint64 sample)
{
gst_ring_buffer_set_sample(gobj(), sample); 
}

guint RingBuffer::commit(guint64 sample, guchar* data, guint len)
{
  return gst_ring_buffer_commit(gobj(), sample, data, len);
}

guint RingBuffer::commit(guint64& sample, guchar* data, int in_samples, int out_samples, int& accum)
{
  return gst_ring_buffer_commit_full(gobj(), &sample, data, in_samples, out_samples, &accum);
}

bool RingBuffer::convert(Gst::Format src_fmt, gint64 src_val, Gst::Format dest_fmt, gint64& dest_val) const
{
  return gst_ring_buffer_convert(const_cast<GstRingBuffer*>(gobj()), ((GstFormat)(src_fmt)), src_val, ((GstFormat)(dest_fmt)), &dest_val);
}

bool RingBuffer::prepare_read(int& segment, guint8*& readptr, int& len)
{
  return gst_ring_buffer_prepare_read(gobj(), &segment, &readptr, &len);
}

guint RingBuffer::read(guint64 sample, guchar* data, guint len)
{
  return gst_ring_buffer_read(gobj(), sample, data, len);
}

void RingBuffer::clear(int segment)
{
gst_ring_buffer_clear(gobj(), segment); 
}

void RingBuffer::clear_all()
{
gst_ring_buffer_clear_all(gobj()); 
}

void RingBuffer::advance(guint advance)
{
gst_ring_buffer_advance(gobj(), advance); 
}

bool RingBuffer::close_device()
{
  return gst_ring_buffer_close_device(gobj());
}

bool RingBuffer::open_device()
{
  return gst_ring_buffer_open_device(gobj());
}

bool RingBuffer::device_is_open() const
{
  return gst_ring_buffer_device_is_open(const_cast<GstRingBuffer*>(gobj()));
}

void RingBuffer::set_may_start(bool allowed)
{
gst_ring_buffer_may_start(gobj(), static_cast<int>(allowed)); 
}

void RingBuffer::set_flushing(bool flushing)
{
gst_ring_buffer_set_flushing(gobj(), static_cast<int>(flushing)); 
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


