#ifndef _WINDOW_H
#define _WINDOW_H

#include <QMainWindow>
#include <QListView>
#include <QStyledItemDelegate>
#include <QLabel>
#include <QLineEdit>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QDialog>
#include <QSettings>
#include "googlereader.h"

class FeedsWindow : public QMainWindow {
	Q_OBJECT

	public:
		FeedsWindow(QWidget *parent = 0);
		virtual ~FeedsWindow();

	private slots:
		void showUpdated(bool);
		void showSettings();
		void sync();
		void feedsUpdated();
		void feedSelected(const QModelIndex &);
		void refreshModel();
		void loginFailed(QString);
		void about();

	private:
		QListView *list;
		GoogleReader *reader;
		QAction *show_all;
		QAction *show_updated;
		QSettings *settings;
};

class FeedListModel : public QAbstractListModel {
	Q_OBJECT

	public:
		FeedListModel(QObject *parent = 0, QList<Feed *>list = QList<Feed *>(), bool updated = false)
			: QAbstractListModel(parent) {
			feed_list = list;
			show_updated = updated;
		}

		int rowCount(const QModelIndex &model = QModelIndex()) const;

		QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;

	public slots:
		void showUpdated(bool);

	private:
		QList<Feed *> feed_list;
		bool show_updated;
};

class FeedListDelegate : public QStyledItemDelegate {
	Q_OBJECT

	public:
		FeedListDelegate(QObject *parent = 0) 
			: QStyledItemDelegate(parent) {};
			   
		void paint(QPainter *painter, const QStyleOptionViewItem &option,
			const QModelIndex &index) const;
};

class SettingsDialog : public QDialog {
	Q_OBJECT

	public:
		SettingsDialog(QWidget *parent = 0, QSettings *s = 0);
		
	public slots:
		void accept();

	private:
		QLabel *loginLabel;
		QLineEdit *loginEdit;
		QLabel *passwdLabel;
		QLineEdit *passwdEdit;
		QDialogButtonBox *buttonBox;
		QPushButton *saveButton;
		QPushButton *cancelButton;
		QSettings *settings;
};

#endif

