#ifndef _QTMAIN_H
#define _QTMAIN_H

#include <QObject>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QDomDocument>
#include <QBuffer>
#include <QDateTime>

class GoogleReader;
class Entry;

class Feed : public QObject {
	Q_OBJECT

	public:
		bool subscription_updated;
		
		QString id;
		QString title;
		QString sortid;
		QString firstitemmsec;
		QString cat_id;
		QString cat_label;
	
		int unread;
		uint newestitem;
		
		QString continuation;

		QDateTime lastUpdated;

		GoogleReader *reader;

		int special;

		void updateSubscription(Feed *feed);

		Feed(GoogleReader *gr = NULL) : QObject() {
			unread = 0;
			reader = gr;
			special = 0;
		}

		void fetch(bool);
		void addEntry(Entry *);
		void delEntry(Entry *);
		void signalUpdated(); // TODO: Clean this up...
		QList<Entry *> getEntries();
		int getEntriesSize() { return entries.size(); }
		void markRead();
		void updateUnread(int);

	signals:
		void updateFeedComplete();
		void allReadChanged();

	private:
		QHash<QString, Entry *> entries;
		QBuffer buffer;
};
    
Q_DECLARE_METATYPE(Feed *)

#define ENTRY_FLAG_READ		0x00000001
#define ENTRY_FLAG_STARRED	0x00000002
#define ENTRY_FLAG_LOCKED	0x00000004
#define ENTRY_FLAG_SHARED	0x00000008

class Entry : public QObject {
	Q_OBJECT

	public:
		QString id;
		QString title;
		QString author;
		QDateTime published;
		qulonglong crawled;
		QUrl link;
		QString source;
		QString content;
		unsigned int flags;
		Feed *feed;

		Entry(Feed *f = NULL) : QObject() {
			feed = f;
			flags = 0;
		}
	
		Entry(Entry &e) : QObject() {
			id = e.id;
			title = e.title;
			author = e.author;
			published = e.published;
			link = e.link;
			source = e.source;
			content = e.content;
			flags = e.flags;
			feed = e.feed;
		}

		void markRead(bool);
		void markStar(bool);
		void markShared(bool);

	private:
		QBuffer postread;
		QBuffer poststar;
		QBuffer postshared;
};

Q_DECLARE_METATYPE(Entry *)

class GoogleReader: public QObject {
	Q_OBJECT

	public:
		GoogleReader();
		void updateSubscriptions();
		void updateUnread();
		QList<Feed *> getFeeds();
		QNetworkAccessManager *getManager() {
			return &manager;
		}
		void getToken();
		
		QUrl edittag_url;
		QUrl markallread_url;
		QByteArray token;
		QNetworkAccessManager manager;
		QDateTime lastUpdated;
		QHash<QString, Feed *> feeds;

		void setLogin(QString l) { login = l; }
		void setPasswd(QString p) { passwd = p; }
		void logOut() { 
			SID = NULL; 
			token = NULL;
			updateSubscriptionsPending = false;
			updateUnreadPending = false;
			SIDPending = false;
		}

	private slots:
		void downloadFinished(QNetworkReply *reply);

	private:
		char *SID;
		QBuffer buffer;
		bool updateSubscriptionsPending;
		bool updateUnreadPending;
		bool SIDPending;

		void getSID();
		void parseSubscriptions(QDomDocument dom);
		void parseUnread(QDomDocument dom);
		void parseFeed(QDomDocument dom);

		QUrl login_url;
		QUrl subscriptions_url;
		QUrl unread_url;
		QUrl token_url;

		QString login;
		QString passwd;

	signals:
		void updateSubscriptionsComplete();
		void updateUnreadComplete();
		void allReadChanged();
		void loginFailed(QString);
};

#endif

