//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef TEMPLATESWINDOW_H
#define TEMPLATESWINDOW_H

#include <QDialog>
#include <QModelIndex>
#include "template.h"

namespace Ui {
    class TemplatesWindow;
}

class TemplatesWindow : public QDialog
{
    Q_OBJECT

public:
    explicit TemplatesWindow(QWidget *parent = 0, bool select=false);
    ~TemplatesWindow();

    Template GetSelectedTemplate();

private:
    Ui::TemplatesWindow *ui;

    QList<Template*> m_List;
    void PopulateTemplateList();
    Template m_SelectedTemplate;

private slots:
    void AddSlot();
    void EditSlot();
    void RemoveSlot();
    void OkSlot();
    void TemplateDoubleClickSlot(QModelIndex index);
};

#endif // TEMPLATESWINDOW_H
