//    GroupSMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "contactswindow.h"
#include "ui_contactswindow.h"
#include <QPushButton>
#include <QSettings>
#include <QFile>
#include <QCheckBox>
#include "commonstatic.h"

ContactsWindow::ContactsWindow(QWidget *parent, Group* group) :
    QDialog(parent),
    ui(new Ui::ContactsWindow)
{
    ui->setupUi(this);

    m_Group = group;
    m_Timer = NULL;

#ifdef Q_OS_SYMBIAN
    QAction* softKey = new QAction( tr("Back"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(reject()));
    addAction(softKey);
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5NonComposited, true);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    ui->txtCerca->grabKeyboard();
    connect(ui->txtCerca, SIGNAL(textChanged(QString)), this, SLOT(CercaSlot()));
    connect(ui->btnClear, SIGNAL(clicked()), this, SLOT(ClearSlot()));
    connect(ui->btnOK, SIGNAL(clicked()), this, SLOT(OkSlot()));

    connect(ui->tblContacts, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(ContactDoubleClick(QModelIndex)));
    m_DataModel = NULL;
}

ContactsWindow::~ContactsWindow()
{
    delete ui;
    if (m_DataModel){
        delete m_DataModel;
        m_DataModel = NULL;
    }
}

void ContactsWindow::FillContactsList()
{
    if (m_DataModel){
        delete m_DataModel;
        m_DataModel = NULL;
    }

    foreach(Contact* c, CommonStatic::ContactsCache){
        if (!m_Group->Contains(c->Number))
            m_Contacts.append(c);
    }

    m_DataModel = new ContactsDataModel(this, &m_Contacts);
    m_DataModel->selectAll(false);
    ui->tblContacts->setModel(m_DataModel);
    ui->tblContacts->verticalHeader()->setDefaultSectionSize(60);
    ui->tblContacts->verticalHeader()->setDefaultAlignment(Qt::AlignVCenter | Qt::AlignLeft);
    ui->tblContacts->resizeColumnToContents(0);
    ui->tblContacts->resizeColumnToContents(1);

    setWindowTitle(tr("Address book (%1)").arg(m_Contacts.count()));
    resizeEvent(NULL);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

QList<Contact*> ContactsWindow::GetSelectedContacts()
{
    return m_Selected;
}

void ContactsWindow::Init()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    m_Timer = new QTimer(this);
    m_Timer->setInterval(100);
    m_Timer->setSingleShot(true);
    connect(m_Timer, SIGNAL(timeout()), this, SLOT(TimerSlot()));
    m_Timer->start();

    ui->txtCerca->setFocus();
}

void ContactsWindow::TimerSlot()
{
    delete m_Timer;
    m_Timer = NULL;

    FillContactsList();
}

void ContactsWindow::CercaSlot()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

    int count = m_DataModel->search(ui->tblContacts, ui->txtCerca->text());
    setWindowTitle(tr("Address book (%1)").arg(count));

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void ContactsWindow::ClearSlot()
{
    ui->txtCerca->clear();
}

void ContactsWindow::OkSlot()
{
    m_Selected.clear();

    foreach (Contact* c, m_DataModel->getSelected())
        m_Selected.append(c);

    accept();
}

void ContactsWindow::ContactDoubleClick(QModelIndex index)
{
    m_DataModel->toggleSelect(index);
}

void ContactsWindow::resizeEvent (QResizeEvent*)
{
    int w = ui->tblContacts->width();
    w = w - ui->tblContacts->columnWidth(0) - ui->tblContacts->columnWidth(1) - 8;
    ui->tblContacts->setColumnWidth(2, w / 2);
    ui->tblContacts->setColumnWidth(3, w / 2);
}
