//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef GROUP_H
#define GROUP_H
#include <QString>
#include <QList>

class GroupContact
{
public:
    int Id;
    QString Number;
};


class Group
{
public:
    Group();

    int Id;
    QString Name;
    QList<GroupContact*> ContactsId;

    bool IsValid();

    bool SaveToDb();
    bool LoadFromDb();
    bool Delete();

    bool Contains(QString number);
    void Remove(QString number);
    int RemoveInvalidNumbers();

    static bool Exists(QString Name);
    static QList<Group*> GetGroupList();
};

#endif // GROUP_H
