//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "commonstatic.h"
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
    #include <QLabel>
    #include <QVBoxLayout>
#endif
#include <QHash>
#include <QDesktopServices>
#include <QLabel>
#include <QVBoxLayout>
#include "contactsloader.h"

QMessageBox::StandardButton CommonStatic::ConfirmMessage(QWidget* parent, QString title, QString message)
{
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Question);
    if (title.isEmpty())
        title = QObject::tr("Confirm");
    msgBox.setWindowTitle(title);
    msgBox.setText(message);
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    return (QMessageBox::StandardButton)msgBox.exec();
}


void CommonStatic::ErrorMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));
    box->setTimeout(-1);

    QLabel* text = new QLabel(box);
    text->setMinimumHeight(100);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
#endif
}

void CommonStatic::InfoMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));

    QLabel* text = new QLabel(box);
    text->setMinimumHeight(100);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(message);
    msgBox.exec();
#endif
}

QString CommonStatic::GetHomeFolder()
{
    return QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
}

QString CommonStatic::GetSettingsFolder()
{
    return QString("%1/.groupsms").arg(CommonStatic::GetHomeFolder());
}

QList<Contact*> CommonStatic::ContactsCache;
QHash<QString, Contact*> CommonStatic::ContactsCacheNumbers;
QHash<int, Contact*> CommonStatic::ContactsCacheIds;
void CommonStatic::LoadContactsCache()
{
    ContactsLoader loader;
    loader.run();
}

Contact* CommonStatic::GetContact(int id)
{
    return ContactsCacheIds.value(id, NULL);
}

Contact* CommonStatic::GetContact(QString number)
{
    if (ContactsCacheNumbers.contains(number))
        return ContactsCacheNumbers[number];
    return NULL;
}

bool CommonStatic::IsMouseOver(QWidget* w)
{
    QPoint mousePos = QCursor::pos();
    QPoint widgetPos = w->mapToGlobal(QPoint(0,0));

    if (mousePos.x() >= widgetPos.x() && mousePos.x() <= widgetPos.x() + w->size().width() &&
        mousePos.y() >= widgetPos.y() && mousePos.y() <= widgetPos.y() + w->size().height())
        return true;
    return false;
}


bool CommonStatic::ExecuteQuery(QString sql, QSqlQuery* query)
{
    QSqlQuery* qry = query != NULL ? query : new QSqlQuery();
    if (!qry->prepare(sql))
        return false;
    if (!qry->exec())
        return false;
    return true;
}
