//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "editgroupwindow.h"
#include "ui_editgroupwindow.h"
#include "commonstatic.h"

EditGroupWindow::EditGroupWindow(QWidget *parent, Group* group) :
    QDialog(parent),
    ui(new Ui::EditGroupWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5NonComposited, true);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    m_Group = group;
    if (m_Group->IsValid())
        setWindowTitle(tr("Edit group"));
    else
        setWindowTitle(tr("New group"));
    connect(ui->btnSave, SIGNAL(clicked()), this, SLOT(SaveSlot()));

    if (m_Group->IsValid()){
        ui->txtName->setText(m_Group->Name);
    }

    ui->txtName->setFocus();
}

EditGroupWindow::~EditGroupWindow()
{
    delete ui;
}

void EditGroupWindow::SaveSlot()
{
    if (ui->txtName->text().isEmpty()){
        CommonStatic::ErrorMessage(this, tr("Enter a group name"));
        return;
    }

    ui->txtName->setText(ui->txtName->text().trimmed());
    if (!m_Group->IsValid() && Group::Exists(ui->txtName->text())){
        CommonStatic::ErrorMessage(this, tr("A group named '%1' exists.").arg(ui->txtName->text()));
        return;
    }
    m_Group->Name = ui->txtName->text();
    accept();
}
