//    GroupSMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "contactswindow.h"
#include "ui_contactswindow.h"
#include <QPushButton>
#include <QSettings>
#include <QFile>
#include <QCheckBox>
#include "commonstatic.h"

ContactsWindow::ContactsWindow(QWidget *parent, Group* group) :
    QDialog(parent),
    ui(new Ui::ContactsWindow)
{
    ui->setupUi(this);

    m_Group = group;
    m_Timer = NULL;

#ifdef Q_OS_SYMBIAN
    QAction* softKey = new QAction( tr("Back"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(reject()));
    addAction(softKey);
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5NonComposited, true);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    ui->txtCerca->grabKeyboard();
    connect(ui->txtCerca, SIGNAL(textChanged(QString)), this, SLOT(CercaSlot()));
    connect(ui->btnClear, SIGNAL(clicked()), this, SLOT(ClearSlot()));
    connect(ui->btnOK, SIGNAL(clicked()), this, SLOT(OkSlot()));
}

ContactsWindow::~ContactsWindow()
{
    delete ui;
}

void ContactsWindow::FillContactsList()
{
    m_Contacts = CommonStatic::ContactsCache;

    connect(ui->tblContacts, SIGNAL(cellDoubleClicked(int,int)), this, SLOT(ContactDoubleClicked(int, int)));
    ui->tblContacts->setSortingEnabled(false);
    ui->tblContacts->setColumnCount(4);
    ui->tblContacts->setRowCount(m_Contacts.count());

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

    QPixmap* cImage = new QPixmap(":/images/contacts.png");
    int i = 0;
    int count = 0;
    foreach (Contact* c, m_Contacts){
        if (!m_Group->Contains(c->Number)){
            AddContactToList(c, count, i, cImage);
            count++;
        }
        i++;
    }
    delete cImage;

    ui->tblContacts->setRowCount(count);
    ui->tblContacts->sortItems(2, Qt::AscendingOrder);
    ui->tblContacts->resizeColumnToContents(0);
    ui->tblContacts->resizeColumnToContents(1);

    setWindowTitle(tr("Address book (%1)").arg(count));
    resizeEvent(NULL);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void ContactsWindow::AddContactToList(Contact* c, int row, int index, QPixmap* defaultImage)
{    
    ui->tblContacts->setRowHeight(row, 60);
    QCheckBox* chk = new QCheckBox(ui->tblContacts);
    chk->setObjectName(QString("%1").arg(index));
    chk->setStyleSheet("border-style: none;");
    chk->setText("");
    ui->tblContacts->setCellWidget(row, 0, chk);

    QLabel* lbl = new QLabel(this);
    lbl->setAlignment(Qt::AlignCenter);
    lbl->setMaximumWidth(48);
    if (c->Thumbnail != NULL)
        lbl->setPixmap(QPixmap::fromImage(*c->Thumbnail).scaled(48, 48, Qt::KeepAspectRatio));
    else{
        QPixmap* cImage = defaultImage;
        lbl->setPixmap(cImage->scaled(48, 48, Qt::KeepAspectRatio));
    }
    ui->tblContacts->setCellWidget(row, 1, lbl);

    lbl = new QLabel(0);
    lbl->setText(c->Name);
    ui->tblContacts->setCellWidget(row, 2, lbl);

    QTableWidgetItem* item = new QTableWidgetItem(0);
    item->setText(c->Number);
    item->setTextAlignment(Qt::AlignHCenter | Qt::AlignRight);
    ui->tblContacts->setItem(row, 3, item);
}

QList<Contact*> ContactsWindow::GetSelectedContacts()
{
    return m_Selected;
}

void ContactsWindow::Init()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    m_Timer = new QTimer();
    m_Timer->setInterval(100);
    m_Timer->setSingleShot(true);
    connect(m_Timer, SIGNAL(timeout()), this, SLOT(TimerSlot()));
    m_Timer->start();

    ui->txtCerca->setFocus();
}

void ContactsWindow::TimerSlot()
{
    delete m_Timer;
    m_Timer = NULL;

    FillContactsList();
}

void ContactsWindow::CercaSlot()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    ui->txtCerca->setFocus();

    int count = 0;
    for (int i=0; i<ui->tblContacts->rowCount(); i++){
        QCheckBox* chk = (QCheckBox*)ui->tblContacts->cellWidget(i, 0);
        int index = chk->objectName().toInt();
        Contact* c = m_Contacts.at(index);
        if (c){
            QLabel* lbl = (QLabel*)ui->tblContacts->cellWidget(i, 2);
            if (lbl){
                QString text = c->Name;
                if (ui->txtCerca->text().isEmpty() || text.contains(ui->txtCerca->text(), Qt::CaseInsensitive)){
                    if (!ui->txtCerca->text().isEmpty())
                        text.replace(ui->txtCerca->text(), QString("<b>%1</b>").arg(ui->txtCerca->text()), Qt::CaseInsensitive);
                    lbl->setText(text);
                    ui->tblContacts->setRowHidden(i, false);
                    count++;
                }else
                    ui->tblContacts->setRowHidden(i, true);
            }
        }
    }

    setWindowTitle(tr("Address book (%1)").arg(count));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void ContactsWindow::ClearSlot()
{
    ui->txtCerca->clear();
}

void ContactsWindow::OkSlot()
{
    m_Selected.clear();

    for (int i=0; i<ui->tblContacts->rowCount(); i++){
        QCheckBox* chk = (QCheckBox*)ui->tblContacts->cellWidget(i, 0);
        if (chk && chk->isChecked()){
            int index = chk->objectName().toInt();
            Contact* c = m_Contacts.at(index);
            m_Selected.append(c);
        }
    }

    accept();
}

void ContactsWindow::ContactDoubleClicked(int row, int)
{
    QCheckBox* chk = (QCheckBox*)ui->tblContacts->cellWidget(row, 0);
    if (chk)
        chk->setChecked(!chk->isChecked());
}

void ContactsWindow::resizeEvent (QResizeEvent*)
{
    int w = ui->tblContacts->width();
    w = w - ui->tblContacts->columnWidth(0) - ui->tblContacts->columnWidth(1) - 8;
    ui->tblContacts->setColumnWidth(2, w / 2);
    ui->tblContacts->setColumnWidth(3, w / 2);
}
