//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "groupactionswindow.h"
#include "ui_groupactionswindow.h"
#include <QCheckBox>
#include <QLabel>
#include "contactswindow.h"
#include "editgroupwindow.h"
#include "commonstatic.h"

#ifdef Q_WS_MAEMO_5
#include "hildon-uri.h"
#endif

GroupActionsWindow::GroupActionsWindow(QWidget *parent, Group* group) :
    QDialog(parent),
    ui(new Ui::GroupActionsWindow)
{
    ui->setupUi(this);
    m_Group = group;

    setWindowTitle(m_Group->Name);

    connect(ui->tblContacts, SIGNAL(cellDoubleClicked(int,int)), this, SLOT(ContactDoubleClick(int, int)));
    connect(ui->btnAdd, SIGNAL(clicked()), this, SLOT(AddContactSlot()));
    connect(ui->btnRemove, SIGNAL(clicked()), this, SLOT(RemoveSlot()));
    connect(ui->btnSendSMS, SIGNAL(clicked()), this, SLOT(SendSlot()));
    connect(ui->btnEdit, SIGNAL(clicked()), this, SLOT(EditSlot()));

    ui->tblContacts->setColumnCount(4);
    ui->tblContacts->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding);

    PopulateContactsTable();
    SelectAllContacts();

    ui->frame->layout()->setSizeConstraint(QLayout::SetMinAndMaxSize);
}

GroupActionsWindow::~GroupActionsWindow()
{
    delete ui;
}


void GroupActionsWindow::PopulateContactsTable()
{    
    ui->tblContacts->setSortingEnabled(false);
    ui->tblContacts->setRowCount(m_Group->ContactsId.count());    

    int i = 0;
    QPixmap* defaultImage = new QPixmap(":/images/contacts.png");
    QTableWidgetItem* item;
    foreach(GroupContact* gc, m_Group->ContactsId){
        Contact* c = CommonStatic::GetContact(gc->Id);
        if (c){
            ui->tblContacts->setRowHeight(i, 60);
            QCheckBox* chk = new QCheckBox(ui->tblContacts);
            chk->setStyleSheet("border-style: none;");
            chk->setText("");
            chk->setObjectName(QString("%1").arg(c->Id));
            ui->tblContacts->setCellWidget(i, 0, chk);            

            QLabel* lbl = new QLabel(this);
            lbl->setAlignment(Qt::AlignCenter);
            lbl->setMaximumWidth(48);
            if (c->Thumbnail != NULL)
                lbl->setPixmap(QPixmap::fromImage(*c->Thumbnail).scaled(48, 48, Qt::KeepAspectRatio));
            else{
                QPixmap* cImage = defaultImage;
                lbl->setPixmap(cImage->scaled(48, 48, Qt::KeepAspectRatio));
            }
            ui->tblContacts->setCellWidget(i, 1, lbl);

            item = new QTableWidgetItem(0);
            item->setText(c->Name);
            ui->tblContacts->setItem(i, 2, item);

            item = new QTableWidgetItem(0);
            item->setText(gc->Number);
            ui->tblContacts->setItem(i, 3, item);

            i++;
        }
    }
    ui->tblContacts->sortItems(2, Qt::AscendingOrder);
    ui->tblContacts->setSortingEnabled(true);    
    ui->tblContacts->resizeColumnToContents(0);
    ui->tblContacts->resizeColumnToContents(1);
}

void GroupActionsWindow::AddContactSlot()
{
    ContactsWindow* frm = new ContactsWindow(this, m_Group);
    frm->Init();
    if (frm->exec() == QDialog::Accepted){
        foreach (Contact* c, frm->GetSelectedContacts()){
            GroupContact* gc = new GroupContact();
            gc->Id = c->Id;
            gc->Number = c->Number;
            m_Group->ContactsId.append(gc);
        }
        m_Group->SaveToDb();
        PopulateContactsTable();
        SelectAllContacts();
    }
    delete frm;
}

void GroupActionsWindow::RemoveSlot()
{
    QList<QString> toRemove = GetSelectedNumbers();
    if (toRemove.count() > 0){
        if (CommonStatic::ConfirmMessage(this,
                                         tr("Confirm remove"),
                                         QString(tr("Remove %1 contacts from group %2?"))
                                         .arg(toRemove.count())
                                         .arg(m_Group->Name)) == QMessageBox::Yes){
            foreach(QString number, toRemove){
                m_Group->Remove(number);
            }
            m_Group->SaveToDb();
            PopulateContactsTable();
            SelectAllContacts();
        }
    }
}

void GroupActionsWindow::SendSlot()
{
    QList<QString> toSend = GetSelectedNumbers();
    if (toSend.count() > 0){
        /*if (CommonStatic::ConfirmMessage(this,
                                         tr("Confirm send"),
                                         QString(tr("Send %1 SMS to contacts from group %2?"))
                                         .arg(toSend.count())
                                         .arg(m_Group->Name)) == QMessageBox::Yes){
        */
#ifdef Q_WS_MAEMO_5
            QString strTo;
            foreach (QString n, toSend){
                if (!strTo.isEmpty())
                    strTo.append(", ");
                strTo.append(n);
            }

            QUrl smsUrl((QString("sms:%1").arg(strTo)));
            smsUrl.addQueryItem("body", "");
            hildon_uri_open(smsUrl.toString().toStdString().c_str(),NULL,NULL);
#endif
        //}
    }
}

QList<QString> GroupActionsWindow::GetSelectedNumbers()
{
    QList<QString> res;
    for (int i=0; i<ui->tblContacts->rowCount(); i++){
        QCheckBox* chk = (QCheckBox*)ui->tblContacts->cellWidget(i, 0);
        if (chk->isChecked()){
            QTableWidgetItem* lbl = (QTableWidgetItem*)ui->tblContacts->item(i, 3);
            res.append(lbl->text());
        }
    }
    return res;
}

void GroupActionsWindow::SelectAllContacts()
{
    for (int i=0; i<ui->tblContacts->rowCount(); i++){
        QCheckBox* chk = (QCheckBox*)ui->tblContacts->cellWidget(i, 0);
        chk->setChecked(true);
    }
}

void GroupActionsWindow::EditSlot()
{
    EditGroupWindow* frm = new EditGroupWindow(this, m_Group);
    if (frm->exec() == QDialog::Accepted){
        m_Group->SaveToDb();
        setWindowTitle(m_Group->Name);
    }
    delete frm;
}

int GroupActionsWindow::exec()
{
    show();
    resizeEvent(NULL);
    return QDialog::exec();
}

void GroupActionsWindow::resizeEvent (QResizeEvent*)
{
    int w = ui->tblContacts->width();
    w = w - ui->tblContacts->columnWidth(0) - ui->tblContacts->columnWidth(1) - 8;
    ui->tblContacts->setColumnWidth(2, w / 2);
    ui->tblContacts->setColumnWidth(3, w / 2);
}

void GroupActionsWindow::ContactDoubleClick(int row, int)
{
    QCheckBox* chk = (QCheckBox*)ui->tblContacts->cellWidget(row, 0);
    chk->setChecked(!chk->isChecked());
}
