#include "unreadhandler.h"
#include <QtDebug>

UnreadHandler::UnreadHandler() : isCountElement(false), isIdElement(false), unread(0)
{
}

bool UnreadHandler::startDocument() {
    qDebug() << "start of the document";
    return true;
}

bool UnreadHandler::startElement(const QString &namespaceURI, const QString &localName, const QString &qName, const QXmlAttributes &atts) {
   // qDebug() << QString("startElement: %1").arg(qName);
    if (isIdElement && qName == "number" &&
        atts.value("name") == "count") {
        isCountElement = true;
    }
    return true;
}

bool UnreadHandler::endElement(const QString &namespaceURI, const QString &localName, const QString &qName) {
//    qDebug() << QString("endElement: %1").arg(qName);
    if (isIdElement && isCountElement) {
        int count = chars.toInt();
        qDebug() << QString("Count: %1").arg(count);
        if (count > 0) {
            unread = count;
            qDebug() << QString("New unread total: %1").arg(unread);
        }
        isCountElement = false;
        isIdElement = false;
    }
    return true;
}

bool UnreadHandler::characters(const QString &ch) {
    chars = ch;
    if (chars.endsWith("state/com.google/reading-list")) {
        qDebug() << QString("characters: %1").arg(chars);
        isIdElement = true;
    }
    return true;
}

bool UnreadHandler::endDocument() {
    qDebug() << QString("Number of unread items: %1").arg(unread);
    //emit receivedUnreadCount(unread);
    return true;
}


bool UnreadHandler::fatalError (const QXmlParseException & exception)
{
    qWarning() << "Fatal error on line" << exception.lineNumber()
               << ", column" << exception.columnNumber() << ":"
               << exception.message();

    return false;
}

int UnreadHandler::getUnreadCount() {
    return unread;
}
