#ifndef CENTRALWIDGET_H
#define CENTRALWIDGET_H

#include <QtGui>
#include <QtNetwork>
#include "qpushlabel.h"

class CentralWidget : public QWidget
{
Q_OBJECT
public:
    explicit CentralWidget(QWidget *parent = 0);
    void setupDesktop();
    void getSid();
    void getToken();
    long getUnixTime();
    void parseXml(QString xmlData);
    void setupSettingsDialog();
    bool x11Event ( XEvent * event );
    void changeEvent(QEvent *event);
    void readSettings();
public slots:
    void getUnreadCount();
    void sidReceived(QNetworkReply *reply);
    void tokenReceived(QNetworkReply *reply);
    void unreadCountReceived(QNetworkReply *reply);
    void updateUnreadCount(bool isActiveConnection);
    void openReader();
    void writeSettings();

private:
    QTimer *timer;
    QPushLabel *m_unreadLabel;
    QString sid;
    QString token;
    QNetworkCookie *cookie;
    QLineEdit *lneUserName;
    QLineEdit *lnePassword;
    QLineEdit *lneUrl;
    QLineEdit *lnePollTime;

    QString userName;
    QString password;
    QString openUrl;
    int m_unreadCount;
    int pollInMinutes;
};

#endif // CENTRALWIDGET_H
