#include "centralwidget.h"
#include <QtGui>
#include <QtNetwork>
#include <QtDebug>
#include <QtXml>
#include <QDesktopServices>

#include "unreadhandler.h"

#include <QX11Info>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xatom.h>

#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif

CentralWidget::CentralWidget(QWidget *parent) :
        QWidget(parent), pollInMinutes(30)
{
    readSettings();
    setupDesktop();
    QHBoxLayout *layout = new QHBoxLayout();    
    this->setLayout(layout);
    QPushLabel *icon = new QPushLabel(this);
    QPixmap *iconImage = new QPixmap(":/greader.png");
    icon->setPixmap(*iconImage);
    icon->show();
    layout->addWidget(icon);
    m_unreadLabel = new QPushLabel(this);
    m_unreadLabel->show();
    connect(m_unreadLabel, SIGNAL(pressed()), this, SLOT(openReader()));
    connect(icon, SIGNAL(pressed()), this, SLOT(openReader()));
    layout->addWidget(m_unreadLabel);
    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(getUnreadCount()));
    if (pollInMinutes > 0) {
        timer->start(pollInMinutes*60*1000);
    }
    getSid();
}

void CentralWidget::setupDesktop() {
    //setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_X11NetWmWindowTypeDialog);

    setWindowFlags(windowFlags() | Qt::Dialog);
    //        setAttribute(Qt::WA_Maemo5DesktopApplet);

    Atom window_type = XInternAtom (QX11Info::display(), "_NET_WM_WINDOW_TYPE", False);
    Atom hildonwinType = XInternAtom (QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", False);
    XChangeProperty(QX11Info::display(), winId(), window_type, XA_ATOM, 32,
                    PropModeReplace, (unsigned char *) &hildonwinType, 1);

    Atom appletId = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", False);
    Atom utf8String = XInternAtom(QX11Info::display(), "UTF8_STRING", False);
    char appletIdStr[] = "PLASMA_APPLET_THING";
    XChangeProperty(QX11Info::display(), winId(), appletId, utf8String, 8,
                    PropModeReplace, (unsigned char*)appletIdStr, strlen(appletIdStr));

    // the following adds a configure button to the widget, which will be send by some X event...
    Atom hildonAppletSettings = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", False);
    int value = 1;
    XChangeProperty(QX11Info::display(), winId(), hildonAppletSettings, XA_CARDINAL, 32,
                    PropModeReplace, (unsigned char*)&value, 1);

}

void CentralWidget::getSid() {
    QNetworkAccessManager *manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(sidReceived(QNetworkReply*)));
    QString url = "https://www.google.com/accounts/ClientLogin?service=reader&Email=" + userName + "&Passwd=" + password;
    manager->get(QNetworkRequest(QUrl(url)));
}

void CentralWidget::sidReceived(QNetworkReply *reply) {
    qDebug() << QString("Received reply!");
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    int indexSid = dataStr->indexOf(QString("SID=")) + 4;
    int indexLsid = dataStr->indexOf(QString("LSID=")) - 5;
    //qDebug() << *dataStr;
    sid = QString(dataStr->mid(indexSid, indexLsid));
    //sid = dataStr;
    //test->setText(sid);
    getToken();
}

void CentralWidget::getToken() {
    QNetworkAccessManager *manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(tokenReceived(QNetworkReply*)));
    QString url = "http://www.google.com/reader/api/0/token";
    cookie = new QNetworkCookie();
    cookie->setName(QString("SID").toAscii());
    cookie->setValue(sid.toAscii());
    cookie->setPath(QString("/"));
    cookie->setDomain(QString(".google.com"));
    cookie->setExpirationDate(QDateTime::currentDateTime().addDays(1));
    //qDebug() << *cookie;
    QList<QNetworkCookie> *cookieList = new QList<QNetworkCookie>();
    cookieList->append(*cookie);
    QNetworkCookieJar *jar = new QNetworkCookieJar();
    bool yes = jar->setCookiesFromUrl(*cookieList, QUrl(QString("http://www.google.com/")));
    //qDebug() << yes;
    manager->setCookieJar(jar);
    manager->get(QNetworkRequest(QUrl(url)));
}

void CentralWidget::tokenReceived(QNetworkReply *reply) {
    qDebug() << QString("Token Received reply!");
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
   // qDebug() << *dataStr;
    token = QString(*dataStr);
    getUnreadCount();
}

void CentralWidget::getUnreadCount() {
    bool networkUp = true;
#ifdef Q_WS_MAEMO_5
    networkUp = QMaemoInternetConnectivity::isConnected();
#endif
    qDebug() << networkUp;
    if (networkUp) {
        QNetworkAccessManager *manager = new QNetworkAccessManager(this);
        connect(manager, SIGNAL(finished(QNetworkReply*)),
                this, SLOT(unreadCountReceived(QNetworkReply*)));
        QString url = QString("http://www.google.com/reader/api/0/unread-count?allcomments=true&output=xml&ck=%1&client=scroll").arg(QString::number(getUnixTime()));
        QList<QNetworkCookie> *cookieList = new QList<QNetworkCookie>();
        cookieList->append(*cookie);
        QNetworkCookieJar *jar = new QNetworkCookieJar();
        bool yes = jar->setCookiesFromUrl(*cookieList, QUrl(QString("http://www.google.com/")));
        //qDebug() << url;
        manager->setCookieJar(jar);
        manager->get(QNetworkRequest(QUrl(url)));
    } else {
        updateUnreadCount(false);
    }
}

void CentralWidget::unreadCountReceived(QNetworkReply *reply) {
    qDebug() << QString("Unread count received reply!");
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    //qDebug() << *dataStr;
    parseXml(*dataStr);
}

void CentralWidget::updateUnreadCount(bool isActiveConnection) {
    if (isActiveConnection) {
        m_unreadLabel->setText(QString("Unread: %1").arg(m_unreadCount));
    } else {
        m_unreadLabel->setText(QString("Unread: (%1)").arg(m_unreadCount));
    }
}

long CentralWidget::getUnixTime() {
    uint x = 1194278852;
    return QDateTime::fromTime_t(x).toTime_t();
}

void CentralWidget::parseXml(QString xmlData) {
    QXmlSimpleReader reader;
    QXmlInputSource *source = new QXmlInputSource();
    source->setData(xmlData);
    UnreadHandler *handler = new UnreadHandler();
    reader.setContentHandler(handler);
    reader.setErrorHandler(handler);
    reader.parse(source);
    m_unreadCount = handler->getUnreadCount();
    updateUnreadCount(true);
}

void CentralWidget::openReader() {
    qDebug() << "trying to open the reader";
    QUrl url = QUrl(openUrl);
    qDebug() << url;
    QDesktopServices::openUrl(url);
}

void CentralWidget::setupSettingsDialog() {
    QDialog *settings = new QDialog(this);
    QVBoxLayout *settingsLayout = new QVBoxLayout();
    settings->setLayout(settingsLayout);
    lneUserName = new QLineEdit();
    lneUserName->setText(userName);
    lneUserName->setPlaceholderText(tr("Your Google Reader username"));
    settingsLayout->addWidget(lneUserName);
    lneUserName->show();
    lnePassword = new QLineEdit();
    lnePassword->setText(password);
    lnePassword->setPlaceholderText(tr("Your Google Reader password"));
    settingsLayout->addWidget(lnePassword);
    lnePassword->setEchoMode(QLineEdit::PasswordEchoOnEdit);
    lnePassword->show();
    lneUrl = new QLineEdit();
    lneUrl->setText(openUrl);
    lneUrl->setPlaceholderText(tr("Url to open your Google Reader account"));
    settingsLayout->addWidget(lneUrl);
    lneUrl->show();
    lnePollTime = new QLineEdit();
    lnePollTime->setText(QString::number(pollInMinutes));
    lnePollTime->setPlaceholderText(tr("Poll interval in minutes"));
    settingsLayout->addWidget(lnePollTime);
    lnePollTime->show();
    settings->show();
    connect(settings, SIGNAL(rejected()), this, SLOT(writeSettings()));
}

void CentralWidget::writeSettings() {
    userName = lneUserName->text();
    password = lnePassword->text();
    openUrl = lneUrl->text();
    pollInMinutes = lnePollTime->text().toInt();

    QSettings settings("greader", "greader");
    settings.setValue("username", userName);
    settings.setValue("password", password);
    settings.setValue("openUrl", openUrl);
    settings.setValue("polltime", pollInMinutes);

    timer->stop();
    if (pollInMinutes > 0) {
        timer->start(pollInMinutes * 60 * 1000);
    }
}

void CentralWidget::readSettings() {
    QSettings settings("greader", "greader");
    userName = settings.value("username").toString();
    password = settings.value("password").toString();
    openUrl = settings.value("openUrl").toString();
    pollInMinutes = settings.value("polltime").toInt();
}

//Filter show setting requests
bool CentralWidget::x11Event ( XEvent * event )
{
  static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);

  if (event->xclient.message_type == appletShowSettingAtom ) {

      //QMessageBox::information(0, "Setting Dialog example", "Here your settings", QMessageBox::Ok, QMessageBox::Ok);
      setupSettingsDialog();
      return true;
  }
  return false;
}

void CentralWidget::changeEvent(QEvent *event) {
    qDebug() << event->type();
    if (event->type() == QEvent::ApplicationActivate || event->type() == QEvent::ActivationChange) {
        qDebug() << "focus gained - update widget";
        getUnreadCount();
        timer->start(pollInMinutes * 60 * 1000);
    }
}
